#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include "defs.h"


/*
 * front-end to the more general 'access' facility.
 */


public int IsReadable( name )
  char  *name;
  {
    return( access( name, R_OK ) == 0 );
  }


public int IsExecutable( name )
  char  *name;
  {
    return( access( name, X_OK ) == 0 );
  }


public int Exists( name )
  char  *name;
  {
    if( !strcmp(name, "-")) return(TRUE);  /* standard output */ 
    else return( access( name, F_OK ) == 0 );
  }



public int IsWritable( name )
  char  *name;
  {
    char   dir[ 256 ];
    register char  *s, *q, *p;
    
    if( !strcmp(name, "-")) return(TRUE);  /* standard output */ 

    if( access( name, W_OK ) == 0 )
	return( TRUE );			/* file exists and is writeable */

    if( access( name, F_OK ) == 0 )	/* file exists but isn't writeable */
	return( FALSE );
					/* file doesn't exist, check dir. */
    p = name;
    for( s = p; *s != '\0'; s++ );
    while( s > p and *s != '/' ) s--;
    if( *s == '/' ) s++;
    q = dir;
    while( p < s )
	*q++ = *p++;
    *q++ = '.';
    *q = '\0';
    return( access( dir, W_OK ) == 0 );	/* return TRUE if dir. is writeable */
  }
