#!/bin/csh -f
#
# cifplot-color2:  pplot for standard magic-produced cif files in ostyle=1.0(pwell) 
#   JHU version, color, for output compatible with the HP560-C color printer.
#
#       usage: cifplot ciffile
#	   produces file ciffile.hpl

# add -V PSLM for large margins (e.g., HP-560C)

BINDIR/pplot -p LIBDIR/cpat.analog -k ${1:r}.ps -l allText,bbox ${1:r}.cif

# The following example shows how to lighten the entire output to correct for
# color gamma values on color printers if necessary.
#
# BINDIR/pplot -p LIBDIR/cpat.analog -k - -l allText,bbox ${1:r}.cif | \
# sed -e '/^%%Page:/ a\\
# {0.333 exp} dup dup currenttransfer setcolortransfer' > ${1:r}.ps

#
# These lines used to make a pcl-format file compatible with the HP560C color
# printer.  Ghostscript is set up on a Linux system with 
# gs as the input filter (":if" in /etc/printcap runs a shell script which
# runs "gs -sDEVICE=cdj550 -sOUTPUTFILE=- -sBitsPerPixel=32 -dDepletion=2 -")
# so one only needs to "lpr -Pcolorps filename" and the Linux box does the rest.
#
# {0.333 exp} dup dup currenttransfer setcolortransfer' ${1:r}.ps > /tmp/${1:r}.ps
# echo Creating HP-compatible \(.hpl\) file\; please wait.
# gs -sDEVICE=cdj550 -sOUTPUTFILE=${1:r}.hpl -sBitsPerPixel=32 -dDepletion=2 \
#	/tmp/${1:r}.ps
# rm /tmp/${1:r}.ps
# rm $1.ps
# echo Done writing ${1:r}.hpl
