#include "defs.h"
#include "types.h"
#include "exports.h"
#include "devices.h"

#define	PageSize( resolution, psize, margin )	\
	( resolution * ( psize - 2.0 * margin ) )

/*
 * Return a pointer to the device's record. Set the pageheight & pagewidth
 * parameters of the device found. Return 0 if device can't be found.  The
 * rationale for this is that only the back-end needs to change when we
 * generate output for some other device (i.e. bitmaps).
 */
public DevDef *GetDevice( devName )
  char  *devName;
  {
    DevDef  *dp;
    
		    	/* small table -> use linear search */
    for( dp = devTable; dp->name != 0; dp++ )
      {
	if( ! strcmp( dp->name, devName ) )
	    goto found;
      }
    return( 0 );

    found :
    dp->pageheight = PageSize( dp->resolution, dp->height, dp->ymargin );
    dp->pagewidth = PageSize( dp->resolution, dp->width, dp->xmargin );
    return( dp );
  }
