/*----------------------------------------------------------------------*/
/* devices.h 								*/
/* definition file for PostScript (and potentially other. . .) devices 	*/
/*----------------------------------------------------------------------*/

/*---------------------------------------------------------------*/
/* Note: New devices can be added here.  			 */
/* Options for each device are, in order:			 */
/*    Name (to be used from the pplot command line)		 */
/*    Page width (inches)					 */
/*    Page height (inches)					 */
/*    Device resolution (DPI) (not really necessary)		 */
/*    Side margin (inches)					 */
/*    Top/Bottom margin (inches)				 */
/*    (Next 2 entries are calculated internally --- set to zero) */
/*    Beginning and Ending routines (should be left as-is) 	 */
/*								 */
/* Last device should always be a string of zeros (NULL device). */
/*---------------------------------------------------------------*/

/*------------------------------------------------------------------*/
/* Current device types (all PostScript):			    */
/*   PS --- standard Postscript device				    */
/*   PSLM --- 0.75" Top/Bottom margin, especially		    */
/*		for the HP-560C printer.			    */
/*------------------------------------------------------------------*/

private DevDef devTable[] =
  {
    { "PS", 8.5, 11.0, 300.0, 0.5, 0.5, 0.0, 0.0, InitPS, EndPS },
    { "PSLM", 8.5, 11.0, 300.0, 0.5, 0.75, 0.0, 0.0, InitPS, EndPS },
    {  0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
  };

/*----------------------------------------------------------------------*/
