#include <stdio.h>
#include <sys/time.h>
#include <sys/resource.h>
#include "defs.h"


private	int		MINSBRK;		/* miminum call to sbrk */
private	int		PAGESIZE;		/* as defined by pagesize */

private	int		avail = 0;		/* bytes avaliable in heap */
private	char		*heap = NULL;		/* heap pointer */
private	struct rlimit	lim;
extern	char		*sbrk(), *malloc();



public void InitMem()
  {
    /* f_prealloc() is undefined */

    /* f_prealloc(); */				/* pre-initialize stdio */
    heap = malloc( 1 );
    avail = sbrk( 0 ) - heap;			/* reclaim malloc memory */
    PAGESIZE = getpagesize();
    MINSBRK = 8 * PAGESIZE;
    (void) getrlimit( RLIMIT_DATA, &lim );
  }



/*
 * return a pointer to a block of at least 'n' bytes.  The pointer returned 
 * is word aligned.  If no more memory is available return the constant NULL.
 */
public char *Malloc( n )
  int  n;
  {
    /* use unix malloc to avoid core dump under sun unix 3.2 */

    char *malloc();
    return(malloc(n));
  }


/*
 * Return TRUE if there are 'n' bytes available of memory, otherwise FALSE.
 */
public int MemAvail( n )
  int  n;
  {
    char  *tmp;
    
    tmp = Malloc( n );
    if( tmp != NULL )
      {
	avail += n;		/* add the memory just allocated to the heap */
	heap = tmp;
	return( TRUE );
      }
    else
	return( FALSE );
  }



/*
 * Define 2 routines, SaveMem and RestoreMem that allow for stack-like
 * allocation of the heap.  This simple model fits in well with the
 * application and provides very low overhead dynamic memory management.
 */

#define	MAXSAVELEVEL	10
private char		*memTbl[ MAXSAVELEVEL ];
private int		currLevel = 0;

public void SaveMem()
  {
    if( currLevel == MAXSAVELEVEL )
	Crash( "SaveMem exceeded %d levels\n", 2, MAXSAVELEVEL );
      
    memTbl[ currLevel ] = heap;
    currLevel++;
  }


public void RestoreMem()
  {
    if( currLevel == 0 )
	Crash( "RestoreMem below 0 level\n", 2 );

    currLevel--;
    avail = heap + avail - memTbl[ currLevel ];
    heap = memTbl[ currLevel ];
  }
