/*
 *  scansw - Generic switch scanner.
 *  scansw accepts as parameters:
 *   argc, argv:	Parameter list;  generated by UNIX and C.	
 *   swtab:		A table switch descriptors (as in scansw.h)
 *   synopsis:		A string with the program synopsis.
 *
 *  if all goes well the function returns a pointer to the 1st argument
 *  that isn't a switch, otherwise it returns -1.
 */

#include <stdio.h>
#include "scansw.h"

char **scansw( argc, argv, swtab, synopsis )
  int		argc;
  char		*argv[]; 
  SwitchTable	*swtab;
  char		*synopsis;
  {
    char	 **arg;
    int		 narg;
    SwitchTable  *sw;
    char	 *name;
    
    for( arg = &(argv[1]), narg = argc - 1; narg ; arg++, narg-- )
      {
	if( **arg == '-' )
	  {
	    name = &((*arg)[1]);
	    for( sw = swtab; sw->name ; sw++ )
	      {
		if( *(sw->name) == *name && CmpSwitch( sw->name, name ) )
		  {
		    if( sw->flag )
		      {
			if( --narg <= 0 )
			  {
			    swUsage( *argv, *arg, ":missing argument", swtab,
					 synopsis );
			    return( (char **) -1 );
			  }
			else
			    *(sw->arg) = *(++arg);
		      }
		    else
		      {
			*(sw->arg) = *arg;
		      }
		    goto found;
		  }
	      }
	    swUsage( *argv, *arg , "unknown switch", swtab, synopsis );
	    return( (char **) -1 );
	  }
	else
	  {
	    return( arg );
	  }
	found: ;
      }
    return( NULL );
  }


static int CmpSwitch( sw, name )
  char  *sw;
  char  *name;
  {
    register char *s, *n;
    
    s = sw;
    n = name;

    if (*s == 'P') return( 1 );        /* Kluge fix for printer option */
    do
      {
	if( *s != *n ) 
	    return( 0 );
	s++;
	n++;
      }
    while( (*s != '\0') || (*n != '\0') );
    return( 1 );
  }

swUsage( arg0, sw, msg, swtab, synopsis )
  char  *arg0;
  char  *sw;
  char  *msg;
  SwitchTable	*swtab;
  char  *synopsis;
  {
    char  *prog;
    
    for( prog = arg0; *prog; prog++ );
    while( *prog != '/' && prog > arg0 ) prog--;
    if( *prog == '/' ) prog++;
    fprintf( stderr, "%s %s\n", sw, msg );
    fprintf( stderr, "Usage: %s %s\n", prog, synopsis );

    while( swtab->name )
      {
	fprintf( stderr, "\t-%s%s\n", swtab->name, swtab->descr );
	swtab++;
      }
  }
