#include "stdio.h"
#include "defs.h"
#include "types.h"

		/* Temporary file manager */

public
#define	SPLITFILES		10	/* maximum files to split for sort */

public
#define	MAXMERGEFILES		10	/* max. files to merge at one time */

public
#define	TMPOUTFILE		( SPLITFILES + MAXMERGEFILES )

public
#define	VLINEFILE		( TMPOUTFILE + 1 )

public
#define	HLINEFILE		( VLINEFILE + 1 )

public
#define	RECTFILE		( HLINEFILE + 1 )

public
#define	LABELFILE		( RECTFILE + 1 )

public
#define	FILEBUFSIZE	( (int) ( BUFSIZ / sizeof( Edge ) ) * sizeof( Edge ) )

#define	MAXTMPFILES		( LABELFILE + 1 )

public typedef struct
  {
    char  name[ 25 ];
    int   fd;
    union
      {
	Edge  *e;
	char  *c;
      } buff, buffp;
    int   cnt;
    int   nElems;
  } TMPFile;


public	TMPFile	tmpFiles[ MAXTMPFILES ];


private	char	template[] = "/usr/tmp/pplotXXXXXX";

#define	GetFileExt( i )		( (i < 10) ? (i + '0') : (i - 10 + 'a') )


/*
 * Initialize the name of all the temporary files.
 */
InitTmpFiles()
  {
    int  i;

    (void) mktemp( template );
    for( i = 0; i < MAXTMPFILES; i++ )
      {
	tmpFiles[ i ].fd = -1;
	sprintf( tmpFiles[i].name, "%s.%c", template, (char) GetFileExt(i) );
      }
  }


/*
 * Return the name of the temporary output file.
 */
public char *GetPSfname()
  {
    static char fname[25];
    
    sprintf( fname, "%s.ps", template );
    return( fname );
  }


/*
 * Check if a temmporary file exists and if so delete it.
 */
public void RemoveTmpFiles()
  {
    TMPFile  *f, *fend;

    for( f = tmpFiles, fend = &tmpFiles[ MAXTMPFILES ]; f < fend; f++ )
      {
	if( Exists( f->name ) )
	    unlink( f->name );
      }
  }

