	/* Initialize 'tm' with the unit mtarix */
#define InitCtm( tm )							\
  {									\
    tm[ 0 ] = 1.0;							\
    tm[ 1 ] = 0.0;							\
    tm[ 2 ] = 0.0;							\
    tm[ 3 ] = 1.0;							\
    tm[ 4 ] = 0.0;							\
    tm[ 5 ] = 0.0;							\
  }									\


	/* Apply transformation 'tm' to point 'p1'.  Put result in 'p2' */
#define TransformPoint( p1, tm, p2 )					\
  {									\
    (p2).x = (p1).x * tm[ 0 ] + (p1).y * tm[ 2 ] + tm[ 4 ];		\
    (p2).y = (p1).x * tm[ 1 ] + (p1).y * tm[ 3 ] + tm[ 5 ];		\
  }									\


	/* Apply transformation 'tm' to bounding box 'b1' */
	/* put result in 'b2', making sure vertex are ordered */
#define TransformBBox( b1, tm, b2 )					\
  {									\
    Point  bot, top;							\
									\
    if( b1.minC.x > b1.maxC.x )						\
      {									\
	b2 = b1;							\
      }									\
    else								\
      {									\
	TransformPoint( b1.minC, tm, bot );				\
	TransformPoint( b1.maxC, tm, top );				\
	b2.minC.x = min( bot.x, top.x );				\
	b2.maxC.x = max( bot.x, top.x );				\
	b2.minC.y = min( bot.y, top.y );				\
	b2.maxC.y = max( bot.y, top.y );				\
      }									\
  }									\


	/* same as TransformPoint, but round result to an int */
#define TransformIPoint( p1, tm, p2 )					  \
  {									  \
    p2.x = (int)( (p1).x * tm[ 0 ] + (p1).y * tm[ 2 ] + tm[ 4 ] + 0.5 );  \
    p2.y = (int)( (p1).x * tm[ 1 ] + (p1).y * tm[ 3 ] + tm[ 5 ] + 0.5 );  \
  }									  \


	/* same as TransformBBox, but round result to an int */
#define TransformIBox( b1, tm, p1, p2 )					\
  {									\
    Point  bot, top;							\
									\
    if( b1.minC.x > b1.maxC.x )						\
      {									\
	p1.x = p2.x = p1.y = p2.y = 0;					\
      }									\
    else								\
      {									\
	TransformIPoint( b1.minC, tm, bot );				\
	TransformIPoint( b1.maxC, tm, top );				\
	p1.x = min( bot.x, top.x );					\
	p1.y = min( bot.y, top.y );					\
	p2.x = max( bot.x, top.x );					\
	p2.y = max( bot.y, top.y );					\
      }									\
  }									\


	/* Concatenate transformation matrices 'src1' and 'scr2' into 'dest' */
#define ConcatMatrix( src1, src2, dest )				\
  {									\
    dest[0] = src1[0] * src2[0] + src1[1] * src2[2];			\
    dest[2] = src1[2] * src2[0] + src1[3] * src2[2];			\
    dest[4] = src1[4] * src2[0] + src1[5] * src2[2] + src2[4];		\
    dest[1] = src1[0] * src2[1] + src1[1] * src2[3];			\
    dest[3] = src1[2] * src2[1] + src1[3] * src2[3];			\
    dest[5] = src1[4] * src2[1] + src1[5] * src2[3] + src2[5];		\
  }									\

