	/* minimum allocation of rectangles per layer per cell */
#define	RECTBUFF	16

typedef	float	Real;

typedef unsigned int Pattern[ 8 ];		/* bit-map Stipple Pattern */

typedef struct LayerRec
  {
    char		name[ 5 ];		/* cif layer name */
    int			num;			/* internal layer number */
    int			skip;			/* from command line */
    Pattern		pat;			/* layer's stipple-pattern */
    float		color[ 4 ];		/* RGB color components */	
    struct LayerRec	*next;			/* for layer list */
  } LayerRec, *Layer;


typedef struct				/* special layers in command line */
  {
    int		bbox;
    int		outline;
    int		pointName;
    int		symbolName;
  } SpecialLayers;


typedef  Real  Tmatrix[ 6 ] ;		/* Transformation Matrix */


typedef struct
  {
    Real  x;
    Real  y;
  } Point;


typedef struct
  {
    int   x;
    int   y;
  } IPoint;


typedef struct
  {
    Point  minC;
    Point  maxC;
  } BBox;


typedef struct
  {
    Point  bot;
    Point  top;
  } Rect;


typedef struct
  {
    IPoint  bot;
    IPoint  top;
  } IRect;


typedef struct CallRec
  {
    struct CellRec	*cell;		/* Cell called */
    Tmatrix		tm;		/* transformation to apply */
    struct CallRec	*next;		/* next call in tree */
  } CallRec, *Call;



typedef struct RectPool			/* rectangle allocation record */
  {
    Rect		rect[ RECTBUFF ];
    struct RectPool	*link;
  } RectPool, *RectLink;



typedef struct
  {
    RectLink	rects;			/* The actual rectangle list */
    int		nRects;			/* Number of rectangles */
  } LayerRects;


typedef struct LabelRec
  {
    Point		pos;		/* postion of the label */
    char		*lab;		/* label's text	*/
    struct LabelRec	*next;
  } LabelRec, *Label;


typedef struct CellRec
  {
    int			num;		/* cell number */
    int			inst;		/* TRUE if cell has been called */
    char		*name;		/* cell name (if any) */
    BBox		bBox;		/* cell's bounding box */
    BBox		bigBox;		/* bounding box including children */
    Label		labels;		/* list of labels */
    Call		calls;		/* list of calls */
    struct CellRec	*next;		/* for cell hash table */
    LayerRects		layers[ 1 ];	/* matrix of layers x rectangles, */
					/* actual number will be allocated */
  } CellRec, *Cell;


typedef struct DevDef		/* Device for which output is generated */
  {
    char	*name;			/* device name (any string) */
    Real	width;			/* page width (in inches) */
    Real	height;			/* page height (in inches) */
    Real	resolution;		/* resolution (in pixels/inch) */
    Real	xmargin;		/* margin from the edge (in inches) */
    Real	ymargin;
    Real	pageheight;		/* this 2 are calculated at runtime */
    Real	pagewidth;
    void	(*Init)();		/* Initialization procedure */
    void	(*End)();		/* Termination procedure */
  } DevDef;


#define	TOP	-1
#define	BOTTOM	1

typedef struct Edge		/* Horizontal Edge */
  {
    int    left;			/* left x coordinate */
    int    right;			/* right x coordinate */
    int    y;				/* y coordinate */
    int    dir;				/* direction (TOP or BOTTOM) */
  } Edge, *EdgeP;


typedef struct			/* Horizontal line */
  {
    int    y;
    int    left;
    int    right;
  } H_Line;


typedef struct			/* Vertical line */
  {
    int    x;
    int    top;
    int    bot;
  } V_Line;
