/*
 * lefInt.h --
 *
 * This file defines things that are used by internal LEF routines in
 * various files.
 *
 * rcsid $Header: /ufs/repository/magic/lef/lefInt.h,v 1.1.1.1 2000/03/29 18:35:23 rajit Exp $
 */

#define _LEF

/* Some constants for LEF and DEF files */

#define LEF_LINE_MAX 2048  /* Maximum length fixed by LEF/DEF specifications */
#define LEF_MAX_ERRORS 100 /* Max # errors to report; limits output if */
                           /* something is really wrong about the file */

/* Wrapper function names for LefGetInput().  LefNextLine returns a	*/
/* pointer to the next statement in the input.  LefComplete() reads	*/
/* additional input if necessary to complete a statement to the		*/
/* terminating semicolon character, and returns a pointer to the	*/
/* current statement in the input.  LefFreeInputBuffer() deallocates	*/
/* memory given to the input buffer.					*/

#define LefNextLine(f)		LefGetInput(f, FALSE)
#define LefComplete(f)		LefGetInput(f, TRUE)
#define LefFreeInputBuffer()	(void)LefGetInput(FALSE, FALSE)

/* Struture used for returning information from a route or geometry section */

typedef struct _linkedRect {
   Rect      area;
   TileType  type;
   struct _linkedRect *rect_next;
} linkedRect;

/* External declaration of global variables */
extern int lefCurrentLine;

/* Forward declarations */

int lefDefInitFunc(), lefDefPushFunc();
FILE *lefFileOpen();

char *LefGetInput();
bool LefParseEndStatement();
void LefSkipSection();
void LefEndStatement();
CellDef *lefFindCell();
char *LefNextToken();
char *LefLower();
linkedRect *LefReadGeometry();
void LefEstimate();

void LefError(char *, ...);	/* Variable argument procedure requires */
				/* parameter list.			*/
