Summary: Magic - a very capable VLSI layout tool
Name: magic
Version: 7.2.47
Release: 1.ejp.rh9
License: Copyright (C) 1985, 1990 Regents of the University of California
Group: Applications/Engineering
URL: http://bach.ece.jhu.edu/~tim/programs/magic/magic7_2.html
Source: http://bach.ece.jhu.edu/~tim/programs/magic/archive/magic-%{version}.tgz
BuildRoot: %{_tmppath}/%{name}-%{version}-root
Requires: XFree86 >= 4.3.0
BuildRequires: XFree86-devel >= 4.3.0, tcl, tk

# Change the options supplied to configure to build your desired version of Magic

%define ConfigureOptions --with-interpreter=tcl --with-x --with-opengl --prefix=/usr

%description
Magic is a venerable VLSI layout tool, written in the 1980's at Berkeley
by John Ousterhout, now famous primarily for writing the scripting interpreter
language Tcl. Due largely in part to its liberal Berkeley open-source license,
magic has remained popular with universities and small companies.
The open-source license has allowed VLSI engineers with a bent toward programming
to implement clever ideas and help magic stay abreast of fabrication technology.
However, it is the well thought-out core algorithms which lend to magic the greatest
part of its popularity. Magic is widely cited as being the easiest tool to use
for circuit layout, even for people who ultimately rely on commercial tools
for their product design flow.

Magic version 7.1 is the official current released version of the program,
a combined effort of the "Magic Development Team".

Tim Edwards is working on the development version 7.2, the main development
effort being the incorporation of the Tcl/Tk interpreter into the program.
For all downloads and other information, refer to the links of the URL above.

%prep
%setup

%build

cd ./scripts
./configure %{ConfigureOptions}
cd ..

# In "defs.mak", the prefix is set to the one defined in the configure options
# In RedHat 9, this would be "/usr"

make BUILDROOT="" tcl

%install
rm -rf %{buildroot}

# In "defs.mak", the prefix is changed to the build root directory
# by assigning the $BUILDROOT variable the value of %{buildroot}

make BUILDROOT=%{buildroot} install-tcl

# Add a tree of directories to %{buildroot}

install -d %{buildroot}/usr/share/applications
install -d %{buildroot}/usr/share/pixmaps

# Install the "magic.desktop" file which integrates the application
# into the RedHat 9 menu system provided that
# "/etc/X11/desktop-menu/applications.menu" is changed to include "Applications/Engineering"

install scripts/rpm/magic.desktop %{buildroot}/usr/share/applications/magic.desktop
install scripts/rpm/magic.png %{buildroot}/usr/share/pixmaps/magic.png

%clean
rm -rf %{buildroot}

%post

%postun

%files
%defattr(-, root, root)

/usr/bin/magic
/usr/bin/spice2sim
/usr/lib/magic
/usr/man/man1/ext2sim.1.gz
/usr/man/man1/ext2spice.1.gz
/usr/man/man1/extcheck.1.gz
/usr/man/man1/magic.1.gz
/usr/man/man1/magicusage.1.gz
/usr/man/man3/dqueue.3.gz
/usr/man/man3/extflat.3.gz
/usr/man/man3/geometry.3.gz
/usr/man/man3/hash.3.gz
/usr/man/man3/heap.3.gz
/usr/man/man3/libmalloc.3.gz
/usr/man/man3/list.3.gz
/usr/man/man3/magicutils.3.gz
/usr/man/man3/malloc.3.gz
/usr/man/man3/path.3.gz
/usr/man/man3/runstats.3.gz
/usr/man/man3/set.3.gz
/usr/man/man3/show.3.gz
/usr/man/man3/stack.3.gz
/usr/man/man3/string.3.gz
/usr/man/man5/cmap.5.gz
/usr/man/man5/displays.5.gz
/usr/man/man5/dlys.5.gz
/usr/man/man5/dstyle.5.gz
/usr/man/man5/ext.5.gz
/usr/man/man5/glyphs.5.gz
/usr/man/man5/magic.5.gz
/usr/man/man5/net.5.gz
/usr/man/man5/sim.5.gz
/usr/man/man8/prleak.8.gz
%doc READ_ME README.FIRST README.Tcl TODO

/usr/share/applications/magic.desktop
/usr/share/pixmaps/magic.png

%changelog
* Sun Aug 10 2003 Erwin J. Prinz <ejprinz@austin.rr.com>
- Fixed file list
* Sun Jul 27 2003 Erwin J. Prinz <ejprinz@austin.rr.com>
- Initial release
