/*
 * lefInt.h --
 *
 * This file defines things that are used by internal LEF routines in
 * various files.
 *
 * rcsid $Header: /ufs/repository/magic/lef/lefInt.h,v 1.1.1.1 2000/03/29 18:35:23 rajit Exp $
 */

#define _LEF

/* Some constants for LEF and DEF files */

#define LEF_LINE_MAX 2048  /* Maximum length fixed by LEF/DEF specifications */
#define LEF_MAX_ERRORS 100 /* Max # errors to report; limits output if */
                           /* something is really wrong about the file */

#define DEFAULT_WIDTH 3	   /* Default metal width for routes if undefined */
#define DEFAULT_SPACING 4  /* Default spacing between metal if undefined  */

/* Structure used to maintain default routing information for each	*/
/* routable layer type.							*/

typedef struct {
    int width;		/* width, in lambda */
    int  spacing;	/* minimum spacing rule, in lambda */
    int	 pitch;		/* route pitch, in lambda */
    bool hdirection;	/* horizontal direction preferred */
} lefRoute;

/* Structure used to maintain default generation information for each	*/
/* via or viarule (contact) type.  If "cell" is non-NULL, then the via	*/
/* is saved in a cell (pointed to by "cell"), and "area" describes the	*/
/* bounding box.  Otherwise, the via is formed by magic type "type"	*/
/* with a minimum area "area" for a single contact.			*/

typedef struct {
    Rect	area;		/* area of single contact, or cell bbox	*/
    CellDef	*cell;		/* cell for fixed via def, or NULL	*/
} lefVia;

/* Structure defining a route or via layer and matching it to a magic	*/
/* layer type.  This structure is saved in the LefInfo hash table.	*/
/* To allow multiple names to refer to the same structure, we keep a	*/
/* reference count of the number of times a hash table value points to	*/
/* this structure.							*/

typedef struct {
    TileType	 type;		/* magic tile type, or -1 for none */
    TileType	 obsType;	/* magic type to use if this is an obstruction */
    short	 refCnt;	/* reference count for memory deallocation */
    bool	 is_via;	/* is this a via or route layer */
    union {
	lefRoute route;		/* for route layers */
	lefVia	 via;		/* for contacts */
    } info;
} lefLayer;

/* Struture used for returning information from a route or geometry section */

typedef struct _linkedRect {
   Rect      area;
   TileType  type;
   struct _linkedRect *rect_next;
} linkedRect;

/* External declaration of global variables */
extern int lefCurrentLine;
extern HashTable LefInfo;

/* Forward declarations */

int lefDefInitFunc(), lefDefPushFunc();
FILE *lefFileOpen();

char *LefGetInput();
bool LefParseEndStatement();
void LefSkipSection();
void LefEndStatement();
CellDef *lefFindCell();
char *LefNextToken();
char *LefLower();
linkedRect *LefReadGeometry();
void LefEstimate();
Rect *LefReadRect();
TileType LefReadLayer();

void LefError(char *, ...);	/* Variable argument procedure requires */
				/* parameter list.			*/
