/*
 * textioInt.h --
 *
 * INTERNAL definitions for the textio module
 *
 *     ********************************************************************* 
 *     * Copyright (C) 1985, 1990 Regents of the University of California. * 
 *     * Permission to use, copy, modify, and distribute this              * 
 *     * software and its documentation for any purpose and without        * 
 *     * fee is hereby granted, provided that the above copyright          * 
 *     * notice appear in all copies.  The University of California        * 
 *     * makes no representations about the suitability of this            * 
 *     * software for any purpose.  It is provided "as is" without         * 
 *     * express or implied warranty.  Export of this software outside     * 
 *     * of the United States of America may require an export license.    * 
 *     *********************************************************************
 *
 *
 * rcsid $Header: /ufs/repository/magic/textio/textioInt.h,v 1.3 2001/08/23 13:48:57 tim Exp $
 */

#define _TEXTIOINT

#ifndef _MAGIC
	err = Need_to_include_misc/magic_header
#endif
#ifndef _TEXTIO
	err = Need_to_include_textio/textio_header
#endif
#ifndef _TXCOMMANDS
	err = Need_to_include_textio/txcommands_header
#endif

extern bool txHavePrompt;

typedef struct {
    fd_set tx_fdmask;		/* A mask of the file descriptors for this 
				 * device.
				 */
    void (*tx_inputProc)(); 	/* A procedure that fetches events and stores
				 * them in the input queue via TxAddEvent().
				 */
    ClientData tx_cdata;	/* Data to be passed back to caller. */
} txInputDevRec;

#define TX_PROMPT	'>'
#define TX_CMD_PROMPT	":"

/* all of the state associated with a tty terminal */
#if !defined(SYSV) && !defined(CYGWIN)
typedef struct {
    struct sgttyb tx_i_sgtty;
    struct tchars tx_i_tchars;
} txTermState;
#endif /* SYSV */

extern int TxGetInputEvent();

/* Routines with variable argument lists */

extern void txFprintfBasic(FILE *, ...);
