/*
 * textio.h --
 *
 * Routines in the textio module
 *
 *     ********************************************************************* 
 *     * Copyright (C) 1985, 1990 Regents of the University of California. * 
 *     * Permission to use, copy, modify, and distribute this              * 
 *     * software and its documentation for any purpose and without        * 
 *     * fee is hereby granted, provided that the above copyright          * 
 *     * notice appear in all copies.  The University of California        * 
 *     * makes no representations about the suitability of this            * 
 *     * software for any purpose.  It is provided "as is" without         * 
 *     * express or implied warranty.  Export of this software outside     * 
 *     * of the United States of America may require an export license.    * 
 *     *********************************************************************
 *
 * Needs:
 *	stdio.h
 *	magic.h
 *
 * rcsid $Header: /ufs/repository/magic/textio/textio.h,v 1.2 2001/01/12 22:13:26 jsolomon Exp $
 */

#define _TEXTIO

#ifndef _MAGIC
	err = Need_to_include_misc/magic_header
#endif

#ifdef MAGIC_WRAPPER
extern char *TxBuffer;
extern bool TxInputRedirect;
#endif

extern int TxCurButtons;

/* These should really be defined by the application, not hard-coded */
#define TX_LONG_CMD	':'	/* Way of invoking a long command. */
#define TX_LONG_CMD2	';'	/* Alternate way of invoking a long command. */

/* printing procedures */
extern bool TxPrintOn();  	/* enables TxPrintf output */
extern bool TxPrintOff();	/* disables TxPrintf output */
extern void TxFlush();
extern void TxFlushOut();
extern void TxFlushErr();
extern void TxVisChar();
extern void TxUseMore();
extern void TxStopMore();

/* printing procedures with variable arguments lists */
extern void TxError(char *, ...);
extern void TxPrintf(char *, ...);
extern char *TxPrintString(char *, ...);

/* input procedures */
extern char *TxGetLinePrompt();
extern char *TxGetLine();
extern int TxGetChar();
extern int TxDialog();

/* prompting procedures */
extern void TxSetPrompt();
extern void TxPrompt();
extern void TxPromptOnNewLine();
extern void TxUnPrompt();
extern void TxRestorePrompt();
extern void TxReprint();

/* terminal-state procedures */
extern void TxSetTerminal();
extern void TxResetTerminal();
extern char TxEOFChar;			/* The current EOF character */
extern char TxInterruptChar;		/* The current interrupt character */

/* command procedures */
extern void TxDispatch();

/* variables that tell if stdin and stdout are to a terminal */
extern bool TxStdinIsatty;
extern bool TxStdoutIsatty;
#define TxInteractive	(TxStdinIsatty && TxStdoutIsatty)

/* Misc procs */
void TxInit();
#ifdef USE_READLINE
void TxInitReadline();
#endif

#define   TX_MAX_OPEN_FILES       20
