/* doubleint.c --
 */

#include <stdio.h>
#include "misc/magic.h"
#include "textio/textio.h"
#include "ndoubleint.h"
#ifdef SYSV
#include <string.h>
#endif

#ifndef lint
static char rcsid[] = "$Header: /ufs/repository/magic/utils/ndoubleint.c,v 1.2 2001/01/12 22:13:32 jsolomon Exp $";
#endif /* lint */

DoubleInt DIMaxInt = 0x7fffffffffffffff ;
DoubleInt DIZero =  0 ;


/*
 * -------------------------------------------------------------------
 *
 * DoubleAdd --
 *
 * Add two double-precision integers
 *
 * Results:
 *	Returns the sum.
 *
 * Side Effects:
 *	None.
 *
 *-------------------------------------------------------------------
 */

DoubleInt
DoubleAdd(n1, n2)
    DoubleInt n1, n2;
{
    DoubleInt result;

    result = n1 + n2 ;
    return (result);
}


/*
 * -------------------------------------------------------------------
 *
 * DoubleMultI --
 *
 * Multiply a single-precision non-negative integer by a double-precision
 * one.
 *
 * Results:
 *	Returns the double-precision product.
 *
 * Side Effects:
 *	None.
 *
 *-------------------------------------------------------------------
 */

DoubleInt
DoubleMultI(d, s)
    DoubleInt d;
    unsigned long s;
{
	DoubleInt result;

	result = d * s ;
	return result ;
}


/*
 * -------------------------------------------------------------------
 *
 * DoubleMultII --
 *
 * Multiply two single-precision non-negative integers obtaining a
 * double precision result.
 *
 * Results:
 *	Returns the double-precision product.
 *
 * Side Effects:
 *	None.
 *
 *-------------------------------------------------------------------
 */

DoubleInt
DoubleMultII(s, t)
    unsigned long s;
    unsigned long t;
{
	DoubleInt result;

	result = s * t ;
	return result ;
}
    

/*
 * -------------------------------------------------------------------
 *
 * DoubleString --
 *
 * Convert a double-precision integer into a string.
 * Here we cheat and use floating-point, since it's not
 * speed critical.
 *
 * Results:
 *	None.
 *
 * Side Effects:
 *	Stores the result in the string 'str'.
 *
 *-------------------------------------------------------------------
 */

Void
DoubleString(d, str)
    DoubleInt d;
    register char *str;
{
    double dfloat, dtemp;

    (void) sprintf(str, "%ld", d);
}
    

/*
 * -------------------------------------------------------------------
 *
 * DoubleToDFloat --
 *
 * Convert a double-precision integer into an extended precision floating
 * point ("double").
 *
 * Results:
 *	Floating point equivalent of doubleint.
 *
 * Side Effects:
 *	None.
 *
 *-------------------------------------------------------------------
 */

double
DoubleToDFloat(d)
    DoubleInt d;
{
    double dfloat ;

    dfloat = (double) d ;
    return dfloat;
}

/*
 * -------------------------------------------------------------------
 *
 * DoubleInit --
 *
 *      Initialize this package.
 *
 * Results:
 *	None.
 *
 * Side Effects:
 *	Just does some assertion checking.
 *
 *-------------------------------------------------------------------
 */

void
DoubleInit()
{
    unsigned short *sArray;
    unsigned long sInt;

    /* Test to make sure the SHORT_X definitions match the byte-order on
     * this machine.
     */
    sInt = 1 + 65536*2;
    sArray = (unsigned short *) &sInt;
    if ( (sArray[SHORT_0] != 1) || (sArray[SHORT_1] != 2) )
    {
	TxError("The SHORT_X definitions in utils/doubleint.h are wrong!\n");
	TxError("   sArray = { %d, %d} != { 1, 2}\n", 
	    sArray[SHORT_0], sArray[SHORT_1]);
	TxError("Report this to whomever compiled Magic for your machine.\n");
	ASSERT(FALSE, "DoubleInit");
    }
    ASSERT(sizeof(short) == 2, "DoubleInit");
    ASSERT(sizeof(long) >= 4, "DoubleInit");
}
