/*
 * netmenu.h --
 *
 * Defines the interface provided by the netmenu module.
 * This module implements a menu-based system for editing
 * labels and netlists.
 *
 *     ********************************************************************* 
 *     * Copyright (C) 1985, 1990 Regents of the University of California. * 
 *     * Permission to use, copy, modify, and distribute this              * 
 *     * software and its documentation for any purpose and without        * 
 *     * fee is hereby granted, provided that the above copyright          * 
 *     * notice appear in all copies.  The University of California        * 
 *     * makes no representations about the suitability of this            * 
 *     * software for any purpose.  It is provided "as is" without         * 
 *     * express or implied warranty.  Export of this software outside     * 
 *     * of the United States of America may require an export license.    * 
 *     *********************************************************************
 *
 *
 * rcsid = "$Header: /ufs/repository/magic/netmenu/netmenu.h,v 1.1.1.1 2000/03/29 18:35:09 rajit Exp $";
 */

#ifndef _NETMENU_H
#define _NETMENU_H

#include "utils/magic.h"

/* data structures */

/* procedures */

extern void NMinit();
extern void NMUnsetCell();
extern int NMNewNetlist();
extern int NMWriteNetlist();
extern char *NMAddTerm();
extern int NMDeleteTerm();
extern int NMJoinNets();
extern int NMDeleteNet();
extern int NMEnumNets();
extern int NMEnumTerms();
extern char *NMNthNet();
extern char *NMTermInList();
extern int NMVerify();
extern bool NMHasList();
extern void NMFlushNetlist();
extern char *NMNetlistName();

#ifdef ROUTE_MODULE
extern void NMMeasureAll();
#endif

#endif /* _NETMENU_H */
