/* doubleint.h --
 *
 */

#define _DOUBLEINT

#ifndef _MAGIC
    err0 = Need_to_include_misc/magic_header;
#endif  /* _MAGIC */

typedef long DoubleInt;

/* WORDSIZE = #of bits in DoubleInt */
#define WORDSIZE	(8 * sizeof(int))

extern DoubleInt DIMaxInt;
extern DoubleInt DIZero;

/* Machine-specific word-order dependencies */

#ifdef	IS_LITTLE_ENDIAN
#	define	SHORT_0		0
#	define	SHORT_1		1
#	define	SHORT_2		2
#	define	SHORT_3		3
#endif

#ifdef	IS_BIG_ENDIAN
#	define	SHORT_0		1
#	define	SHORT_1		0
#	define	SHORT_2		3
#	define	SHORT_3		2
#endif

/* Error checking to maintain consistency of this file. */
#ifndef SHORT_0
    Error_1 = You_need_to_define_the_ENDIAN_constants_in_magic.h;
#endif

extern void DoubleInit();	/* Initialize this package. */
DoubleInt DoubleMultI();	/* multiply double by unsigned long */
DoubleInt DoubleMultII();	/* multiply unsigned long by unsigned long */
DoubleInt DoubleAdd();		/* add two doubles */
Void DoubleString();		/* convert double int to string */
double DoubleToDFloat();	/* convert double int  to double float */

/*
 * DOUBLE_CREATE --
 *
 * Set 'result' to be the double-precision integer corresponding
 * to 'n'
 */
#define	DOUBLE_CREATE(result, n) \
    if (1) { \
	result = ( long ) (n) ; \
    } else

/*
 * DOUBLE_ADD --
 *
 * Set 'result' to be the sum of the two DoubleInts n1 and n2.
 */
#define	DOUBLE_ADD(result, n1, n2) \
    if (1) { \
	result = (n1) + (n2) ; \
    } else

/*
 * DOUBLE_ADDI --
 *
 * Set 'result' to be the sum of the DoubleInts n1 and the unsigned long i.
 */
#define	DOUBLE_ADDI(result, n1, i) \
    if (1) { \
	result = (n1) + (long) (i);\
    } else
  
/*
 * DOUBLE_SUB --
 *
 * Set 'result' to be the difference of the two DoubleInts n1 and n2.
 * (NOTE: it is assumed that n2<=n1, since we are only doing positive 
 * arithmetic).
 */
#define	DOUBLE_SUB(result, n1, n2) \
    if (1) { \
	result = (n1) - (n2) ;\
    } else

/*
 * DOUBLE_SUBI --
 *
 * Set 'result' to be the difference of the DoubleInt n1 and the 
 * unsigned long i.
 * (NOTE: it is assumed that i<=n1, since we are only doing positive 
 * arithmetic).
 */
#define	DOUBLE_SUBI(result, n1, i) \
    if (1) { \
	result = (n1) - (i) ; \
    } else

/* comparisons */

/*
 * DOUBLE_GREATER --
 */
#define	DOUBLE_GREATER(n1, n2)	\
	( (n1) > (n2) )

/* 
 * DOUBLE_GE --
 */
#define	DOUBLE_GE(n1, n2)	\
	( (n1) >= (n2) )

/* 
 * DOUBLE_LESS --
 */
#define	DOUBLE_LESS(n1, n2)	\
	( (n1) < (n2) )

/* 
 * DOUBLE_LE --
 */
#define	DOUBLE_LE(n1, n2)	\
	( (n1) <= (n2) )

/*
 * DOUBLE_EQUAL --
 */
#define	DOUBLE_EQUAL(n1, n2)	\
	( (n1) == (n2) )

/*
 * DOUBLE_SHIFTRIGHT --
 *
 * Set 'result' to be doubleint n1/(2**e).
 * (NOTE:  e must be: 0<=e<=WORDSIZE-1)
 */
#define	DOUBLE_SHIFTRIGHT(result, n1, e) \
    if (1) { \
	(result) = (n1) >> (e); \
    } else

/*
 * DOUBLE_SHIFTLEFT --
 *
 * Set 'result' to be doubleint n1*(2**e).
 * (NOTE:  e must be: 0<=e<=WORDSIZE-1)
 */
#define	DOUBLE_SHIFTLEFT(result, n1, e) \
    if (1) { \
	(result) = (n1) << (e); \
    } else
