/***********************************************
 *   Process mask first
 */
    /* Modified by NP -- 9/28/2004 */
    planeNum =  DBPlane(type);
    typeResidueMask = *DBResidueMask(type);
    mask =  DBPlaneTypes[planeNum];
    connectMask = DBConnectTbl[type];
     for (t = TT_SPACE + 1; t < DBNumTypes; t++)
    {
	/* Process all tile types that stays on plane
	 * "planeNum". [except current one, as we want
	 *  to erase that type of tiles from layout].
	 */
	if (TTMaskHasType(&mask, t) && (t != type))
	{
	     if (DBIsContact(t))
	     {
	         /* While stretching non-contact material
	          * we would not process residue type of "t".
	          * Because that may remove mask of "type" from
	          * "mask" which would untouch that material in
	          * stretching path.
	          */
	         if(DBIsContact(type))
	         {
	             tmpmask = *DBResidueMask(t);
	             if(!TTMaskIsZero(&typeResidueMask) &&
	                !TTMaskIsZero(&tmpmask))
                        TTMaskAndMask3(&tmpmask, &typeResidueMask, &tmpmask);
	             /* If t is stacked type then we would not
	              * remove its residue mask from "mask".
	              */
	             if(!TTMaskIsZero(&tmpmask) && (t < DBNumUserLayers))
	                 TTMaskClearMask(&mask, &tmpmask);
	         }
	
                 /* If tile type "t" connects to tile "type"
                  * remove that type from mask. We would not
                  * like to erase that type of tiles.
                  */
                 if (TTMaskHasType(&connectMask, t))
                 {
                     /* In case of "type" is stacked type and
                      * both "t" and "type" is on same plane
                      * erase that tile. [ case : 3 stacked type selected]
                      */
                     if((type < DBNumUserLayers) &&
                        (DBPlane(type) != DBPlane(t)))
                          TTMaskClearType(&mask, t);
                 }
             }
         }
      }

    /* For stacked type tiles do not erase common residue
     * type of both contacts from layout.
     */

    if(type >= DBNumUserLayers)
    {
        t = (DBPlaneToResidue(type, planeNum));
        TTMaskClearType(&mask, t);
    }

/***********************************************
 *   Erase all tile types specified in the processed mask.
 */

    	
    /* New DBEraseMask() routine for stretching. */
    /* TODO : Placed here just for checking funtionality.
     * Once works properly shift to DBtconntact.c.
     */
    {
       /* Erase contacts first from mask . Because if you
        * erase one type of tile from contact first then you
        * can't remove that contact completely as its residue
        * type remains on other plane. And that will stay for ever !
        */

       if(DBIsContact(type))
       {
           for (t = TT_SPACE + 1; t < DBNumUserLayers; t++)
	       if (TTMaskHasType(&mask, t) && DBIsContact(t))
	           DBErase(EditCellUse->cu_def, &editArea, t);
       }

       for (t = TT_SPACE + 1; t < DBNumUserLayers; t++)
           if (TTMaskHasType(&mask, t) && !DBIsContact(t))
	        DBErase(EditCellUse->cu_def, &editArea, t);

        // No need to process - Not considered !
        /* Stacked contact types should be painted separately
        for (t = DBNumUserLayers; t < DBNumTypes; t++)
        {
	    if (TTMaskHasType(&mask, t))
            {
	        rmask = DBResidueMask(t);
    	        for (r = TT_SPACE + 1; r < DBNumUserLayers; r++)
   		    if (TTMaskHasType(rmask, r))
		        if (!TTMaskHasType(&mask, r))
			    DBErase(EditCellUse->cu_def, &editArea, r);
	    }
        }
        */
    }
/*
 *   Completed.
 ***********************************************/
