/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * 
 * strfcns.c, part of the stream_utils package by Jim Buchanan
 * 
 * You can contact me via email at:
 * 
 * jbuchana@iquest.net          (preferred)
 * c22jrb@dawg.delcoelect.com   (intermediate)
 * jrbuchan@mail.delcoelect.com (disliked, but it's gonna stay around)
 * 
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 
 *
 * Copyright (C) 1996, 1997, 1998 Jim Buchanan
 *
 * This is free software. You may freely copy it and freely distribute it.
 *
 * You must retain this copyright notice when doing so.
 *
 * Should you decide to distribute it in executable binary form, you must
 * provide the source code, or make it freely available. A pointer to an
 * anonymous ftp site or a web site which offers the source is adequate, but
 * not preferred.
 *
 * When making this software available to others, you may not attempt to limit
 * their redistribution of this software. They must receive it under the terms
 * of this license, as you do.
 *
 * You may include any of the programs, in their entirety, that make up this
 * software package, or the entire package, in any free software package you
 * develop. You must retain this copyright notice in those parts you include.
 *
 * You may include any of the programs, in their entirety, that make up this
 * software package, or the entire package, in a commercial software package or
 * distribution, so long as you include this copyright notice. You may not
 * attempt to limit redistribution of the portions of the finished product
 * which came from this software package.  They must receive it under the terms
 * of this license, as you do.
 *
 * You may, of course, control the distribution of the original portions of your
 * commercial package.
 *
 * Naturally this also means that you may include it on a CDROM (or other
 * media) archive which you distribute commercially. Where would we be without
 * those?
 *
 * You may use portions of this source code in any free software you develop.
 * In fact, it is encouraged. You must, however, retain this copyright notice.
 * You can use any reasonable free licensing scheme you want on your portions
 * of the code. The Free Software Foundation's General Public License would be
 * fine. If in doubt, ask me.
 *
 * If you are developing a commercial software package you may not use portions
 * of this source code smaller than that required to build an executable
 * program.  You may commercially distribute portions of this software package
 * as described above, but they must compromise an entire executable program,
 * or the source code required to build such an entity. If you are interested
 * in any commercial use of portions of this source code, contact me, I'm sure
 * we can arrange something.
 *
 * You may modify this software in any way and distribute it freely under the
 * same terms that you may use portions of it. You must retain this copyright
 * notice, and add your own notice describing the changes made. I'd surely like
 * to see the finished product, but you really don't even have to tell me about
 * it.
 *
 * You may not modify this software in any way other than the above mentioned
 * case of including part of it, down to the level of an individual program, in
 * another package and then distribute it commercially.  If you feel this need,
 * contact me, once again, I'm sure we can work things out.
 *
 * I reserve the right to use any portion of this software package, or future
 * upgrades to the package as a whole, in a commercial product of my own,
 * license it out to to others for commercial purposes, or to base future
 * commercial products on it.
 *
 * But I probably won't. Let's get real here. I wrote this for fun.
 *
 * Any future use of this software for commercial gains does not affect your
 * right to copy and freely distribute this version. This license ensures that
 * this version of the software package may be freely distributed and will
 * remain so.
 *
 * It does not guarantee that future versions will remain so. But they probably
 * will.
 *
 * There is no warranty provided with this free software. No fitness for any
 * purpose is claimed or implied. It might not work correctly. It might not
 * work at all. It might do something really unpleasant. The risk is yours.
 * You accept it by installing and running this software. Under no
 * circumstances are the author, any modifiers, or any distributors of this
 * software liable for any damages arising out of the use or inability to use
 * this software.
 *
 * Have a nice day.
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <unistd.h>
#include <string.h>
#include "strfcns.h"

char chop (char *in_string)
    {
    int last_loc;
    char last_char;

    last_loc = strlen (in_string) - 1;
    last_char = in_string[last_loc];

    in_string[last_loc] = '\0';

    return (last_char);

    }

void strlwr (char *in_string)
    {
    int ktr;

    ktr = 0;
    while ((in_string[ktr] = tolower(in_string[ktr])))
        ktr++;

    }

/* I changed this for stream utilities */
char *rmlead (char *string, char delim)
    {
    int ktr;
    int offset;

    offset = -1;
    while (string[++offset] == delim);

    ktr = -1;
    while (string[++ktr])
        {
        string[ktr] = string[ktr + offset];
        }

    return (string);

    }

char *rmtrail (char *string, char delim)
    {
    int ptr;

    ptr = strlen (string);

    while (string[--ptr] == delim);

    string[ptr + 1] = '\0';

    return (string);

    }

char *rmdouble (char *string, char delim)
    {
    int ptr;

    if (*string)
        {
        ptr = 0;
        while (string[++ptr])
            {
            if ((string[ptr] == delim) &&
                (string[ptr - 1] == delim))
                {
                rmlead (string + ptr, delim);
                }
            }
        }

    return (string);

    }

int charcount (char *string, char delim)
    {
    int ptr;
    int count;

    ptr = -1;
    count = 0;
    while (string[++ptr])
        if (string[ptr] == delim)
            count++;

    return (count);

    }

/* split will return a NULL pointer on some errors (such as out of memory or
   a null string for input), check and be careful! */
char **split (char *string, int *no_fields, char delim, int rem_mult)
    {
    char *local_string;
    char **local_mat;
    int start;
    int end;
    int field_no;

    local_string = strdup (string);

    if (local_string != NULL)
        {
        if (rem_mult)
            {
            rmlead (local_string, delim);
            rmtrail (local_string, delim);
            rmdouble (local_string, delim);
            }

        if (*local_string != '\0')
            {
            *no_fields = charcount (local_string, delim) + 1;

            local_mat = (char **) malloc (sizeof (char *) * *no_fields);

            if (local_mat)
                {
                start = 0;
                end = -1;
                field_no = -1;
                do
                    {
                    end++;
                    if ((local_string[end] == delim) ||
                        (local_string[end] == '\0'))
                        {
                        field_no++;
                        local_mat[field_no] = (char *) malloc (sizeof (char) * end - start + 1);
                        if (! local_mat[field_no])
                            {
                            return (NULL);
                            }
                        strncpy (local_mat[field_no], local_string + start, end - start);
                        local_mat[field_no][end - start] = '\0';
                        start = end + 1;
                        }
                    }
                while (local_string[end]);
                }
            }
        else
            {
            *no_fields = 0;
            local_mat = NULL;
            }

        free (local_string);

        }
    else
        {
        local_mat = NULL;
        }

    return (local_mat);

    }

/*
   numbers have '0'-'9', '.', 'e', 'E', '+', '-'
   'e' or 'E' cannot be the first char
   there must be numbers before and after 'e' or 'E'
   there must only be one 'e' or 'E'
   '+' and '-' must be first char or after 'e' or 'E'
   only one '.' on either side of the 'e' or 'E'
*/
int isnum (char *in_string)
    {
    char *local_string;
    char *e_string;

    local_string = strdup (in_string);
    if (! local_string)
        {
        fprintf (stderr, "***ERROR*** strfcns: Could not malloc in isnum()\n");
        exit (1);
        }
		
    strlwr (local_string);

    /* can only have one 'e' */
    if (charcount (local_string, 'e') > 1)
        {
        free (local_string);
        return (0);
        }

    /* 'e' can't be the first or last char */
    if ((*local_string == 'e') ||
        (local_string[strlen (local_string) - 1]) == 'e')
        {
        free (local_string);
        return (0);
        }

    /* find a possible 'e' */
    /* seperate the strings if so */
    e_string = strchr (local_string, 'e');
    if (e_string)
        {
        *e_string = '\0';
        e_string++;
        /* check the post e part */
        if (! li_non_sci (e_string))
            {
            free (local_string);
            return (0);
            }
        }

    /* check the pre e part */
    if (! li_non_sci (local_string))
        {
        free (local_string);
        return (0);
        }


    free (local_string);
    return (1);

    }

int li_non_sci (char *local_string)
    {
    char *cp;
    int length_string;
    int string_ktr;

    /* must only use proper chars */
    length_string = strlen (local_string);
    for (string_ktr = 0; string_ktr < length_string; string_ktr++)
        {
        if (! li_good_char (local_string[string_ktr]))
            {
            return (0);
            }
        }

    /* can't have more than one '.', '-'. '+' */
    if ((charcount (local_string, '.') > 1) ||
        (charcount (local_string, '-') > 1) ||
        (charcount (local_string, '+') > 1))
        {
        return (0);
        }

    /* '-' of '+' must be first char */
    cp = strchr (local_string, '-');
    if (cp)
        {
        if (cp != local_string)
            {
            return (0);
            }
        }
    cp = strchr (local_string, '+');
    if (cp)
        {
        if (cp != local_string)
            {
            return (0);
            }
        }

    return (1);

    }

int li_good_char (char in_char)
    {
    char ok[13] = {'1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '-', '+', '.'};
    int ktr;

    for (ktr = 0; ktr < 13; ktr++)
        {
        if (ok[ktr] == in_char)
            {
            return (1);
            }
        }

    return (0);

    }
