/*

  Copyright (c) 1992, 1993
        Regents of the University of California
  All rights reserved.

  Use and copying of this software and preparation of derivative works
  based upon this software are permitted.  However, any distribution of
  this software or derivative works must include the above copyright 
  notice.

  This software is made available AS IS, and neither the Electronics
  Research Laboratory or the Universify of California make any
  warranty about the software, its performance or its conformity to
  any specification.

  Author: Szu-Tsung Cheng, stcheng@ic.Berkeley.EDU
          10/92
          10/93

  $Header: /projects/development/hsv/CVSRepository/vl2mv/src/parser/vl_clock.c,v 1.1.1.1 2001/07/09 23:22:39 fabio Exp $


*/

#include "util.h"
#include "st.h"
#include "list.h"
#include "array.h"
#include "set.h"
#include "stack.h"
#include "graph.h"
#include "vl_defs.h"
#include "vl_types.h"
#include "vlr_int.h"
#include "vl_fg_defs.h"
#include "vl_fg_types.h"
#include "vl_flowgraph.h"
#include "vl_create.h"
#include "vl_write_util.h"
#include "verilog.h"

extern vl_desc *mod_list;
extern int dumpSMVPlus;


static lsList SRFSMnList=(lsList)0;
static int mrfsm_period ARGS((fg_node_info *user_data));
static void mrfsm_allocCtrlToken ARGS((FILE *file, fg_node_info *user_data));
static char *mrfsm_allocBranchInd ARGS((FILE *file, fg_node_info *src_data,
					char *label, st_table *terminal_set));
static char *mrfsm_allocPsPt ARGS((FILE *file, fg_node_info *ps_data,
				   fg_node_info *pt_data));
static char *mrfsm_transSnd ARGS((FILE *file, fg_node_info *src_data,
				  char *B, char *PtPs));
static char *mrfsm_transRcv ARGS((FILE *file, fg_node_info *src_data,
				  fg_node_info *dst_data,
				  char *B, char *PsPt));
static void mrfsm_label_entry ARGS((FILE *file, st_table *terminal_set,
				    char *label));


void register_vl2mv_synClock(char *cname, int edge, int pi, float rho)
{
    vl_synClock *synclock;
    char buf[MAXSTRLEN];

    if (edge > 1 || edge < 1 || pi < 0 || rho < 0.0) {
	sprintf(buf, "invalid VL2MVClock spec.: name=%s edge=%d pi=%d rho=%f",
		cname, edge, pi, rho);
	compile_error(buf);
    }

    synclock = (vl_synClock*)chk_malloc(sizeof(vl_synClock));
    synclock->name = vlStrdup(cname);
    synclock->edge = edge;
    synclock->pi   = pi;
    synclock->rho  = rho;

    if (mod_list)
	st_insert(mod_list->synclock_st, vlStrdup(cname), 
		  (char*)synclock);
}


void vl_genSRFSM(FILE *file, char *label, fg_node_info *src_data,
		 fg_node_info *dst_data, st_table *terminal_set)
{
    char *B, *PsPt, *PtPs, *snd, *rcv;

    mrfsm_allocCtrlToken(file, src_data);
    mrfsm_allocCtrlToken(file, dst_data);

    B    = mrfsm_allocBranchInd(file, src_data, label, terminal_set);
    PsPt = mrfsm_allocPsPt(file, src_data, dst_data);
    PtPs = mrfsm_allocPsPt(file, dst_data, src_data);

    snd = mrfsm_transSnd(file, src_data, B, PtPs);
    rcv = mrfsm_transRcv(file, src_data, dst_data, B, PsPt);
}

static int mrfsm_period(fg_node_info *user_data)
{
    vl_synClock *clock;

    if (st_lookup(mod_list->synclock_st, 
		  ((vl_event_control_stmt*)user_data->data)->event->
		      expr->u.name->name, (char**)&clock))
	return clock->pi;
    else 
	return 1;
}

static void mrfsm_allocCtrlToken(FILE *file, fg_node_info *user_data)
{
    if (!user_data->SRFSMnode) {
	user_data->SRFSMnode = (ctrlNetNode*)chk_malloc(sizeof(ctrlNetNode));
	user_data->SRFSMnode->N = NIL(char);
	user_data->SRFSMnode->B = lsCreate();
	
	
	user_data->SRFSMnode->Rcv = lsCreate();
	user_data->SRFSMnode->Snd = lsCreate();

	if (!SRFSMnList) SRFSMnList = lsCreate();
	lsNewEnd(SRFSMnList, (lsGeneric)user_data->SRFSMnode, 0);
    }

    if (user_data->SRFSMnode->N == NIL(char)) {
	user_data->SRFSMnode->N = vlStrdup(new_termname());
	fprintf(file, "%s %s %s %s;\n", SMV_VAR, user_data->SRFSMnode->N,
		SMV_COLON, SMV_BOOLEAN);
	fprintf(file, "%s %s( %s ) %s %d;\n", SMV_ASSIGN, SMV_INIT, 
		user_data->SRFSMnode->N, SMV_COL_ASSIGN, 0);
    }
}


static char *mrfsm_allocBranchInd(FILE *file, fg_node_info *src_data,
				  char *label, st_table *terminal_set)
{
    char *retval, *cond;

    retval = vlStrdup(new_termname());
    cond   = vlStrdup(new_termname());
    if (dumpSMVPlus) {
	fprintf(file, "%s %s %s %s;\n",
		SMV_VAR, retval, SMV_COLON, SMV_BOOLEAN);
	fprintf(file, "%s %s( %s ) %s %d;\n", SMV_ASSIGN, SMV_INIT, retval, 
		SMV_COL_ASSIGN, 0);

	fprintf(file, "%s %s %s %s;\n", 
		SMV_VAR, cond, SMV_COLON, SMV_BOOLEAN);
	fprintf(file, "%s %s %s ", SMV_ASSIGN, cond, SMV_COL_ASSIGN);
	mrfsm_label_entry(file, terminal_set, label);
	fprintf(file, ";\n");
    }
    lsNewEnd(src_data->SRFSMnode->B, (lsGeneric)cond, 0);
    lsNewEnd(src_data->SRFSMnode->B, (lsGeneric)retval, 0);
    return retval;
}


static char *mrfsm_allocPsPt(FILE *file, fg_node_info *ps_data,
			     fg_node_info *pt_data)
{
    char *retval;
    int ps, pt;
    int i, cnt;

    ps = mrfsm_period(ps_data);
    pt = mrfsm_period(pt_data);
    if ((pt % ps) == 0) return NIL(char);

    retval = vlStrdup(new_termname());
    if (dumpSMVPlus) {
	fprintf(file, "%s D.C.: %d # %d\n", SMV_COMMENT, ps, pt);
	fprintf(file, "%s %s %s %s %d%s%d %s %s;\n", 
		SMV_VAR, retval, SMV_COLON,
		SMV_ARRAY, min_bit_width(ps), SMV_RANGE, 0,
		SMV_OF, SMV_BOOLEAN);
	fprintf(file, "%s %s( %s ) %s %d;\n", SMV_ASSIGN, SMV_INIT, retval,
		SMV_COL_ASSIGN, 0);
	fprintf(file, "%s %s( %s ) %s\n\t%s\n", SMV_ASSIGN, SMV_TRANS, retval,
		SMV_COL_ASSIGN, SMV_CASE);
	for (i=0, cnt=0; i < lcm(ps,pt) / pt; i++, cnt = (cnt+pt) % ps) {
	    fprintf(file, "\t%s %s %d %s %d;\n", retval, SMV_EQUAL, cnt, 
		    SMV_COLON, (cnt+pt)%ps);
	}
	fprintf(file, "\t%d %s %d;\n\t%s;\n", 1, SMV_COLON, 0, SMV_ESAC);
    }

    return retval;
}


static char *mrfsm_transSnd(FILE *file, fg_node_info *src_data,
			    char *B, char *PtPs)
{
    char *retval;

    retval = vlStrdup(new_termname());
    if (dumpSMVPlus) {
	fprintf(file, "%s %s %s %s;\n", SMV_VAR,retval,SMV_COLON,SMV_BOOLEAN);
	fprintf(file, "%s %s %s %s\n", SMV_ASSIGN, retval, SMV_COL_ASSIGN,
		SMV_CASE);
	if (PtPs)
	    fprintf(file, "\t%s %s %d %s %s %s %d %s %s %s %d;\n", 
		    PtPs, SMV_GE, 0, SMV_AND, 
		    PtPs, SMV_LE, mrfsm_period(src_data)-1, SMV_AND,
		    B, SMV_COLON, 0);
	else 
	    fprintf(file, "\t%d %s %d;\n", 1, SMV_COLON, 0);
	fprintf(file, "\t%d %s %s;\n", 1, SMV_COLON, src_data->SRFSMnode->N);
	fprintf(file, "\t%s;\n", SMV_ESAC);
    }
    lsNewEnd(src_data->SRFSMnode->Snd, (lsGeneric)retval, 0);

    return retval;
}


static char *mrfsm_transRcv(FILE *file, fg_node_info *src_data,
			    fg_node_info *dst_data,
			    char *B, char *PsPt)
{
    char *retval;

    retval = vlStrdup(new_termname());
    if (dumpSMVPlus) {
	fprintf(file, "%s %s %s %s;\n", SMV_VAR,retval,SMV_COLON,SMV_BOOLEAN);
	fprintf(file, "%s %s %s %s\n", SMV_ASSIGN, retval, SMV_COL_ASSIGN,
		SMV_CASE);
	if (mrfsm_period(src_data) <= mrfsm_period(dst_data))
	    fprintf(file, "\t%d %s %s %s %s;\n", 1, SMV_COLON, 
		    src_data->SRFSMnode->N, SMV_AND, B);
	else
	    fprintf(file, "\t%s %s %d %s %s %s %d %s %s %s %s\n", 
		    PsPt, SMV_GE, 0, SMV_AND, 
		    PsPt, SMV_LE, mrfsm_period(dst_data), SMV_COLON,
		    src_data->SRFSMnode->N, SMV_AND, B);
	fprintf(file, "\t%d %s %d;\n\t%s;\n", 1, SMV_COLON, 0, SMV_ESAC);
    }
    lsNewEnd(dst_data->SRFSMnode->Rcv, (lsGeneric)retval, 0);

    return retval;
}


static void mrfsm_label_entry(FILE *file, st_table *terminal_set, char *label)
{
    st_generator *gen;
    vl_term *key;
    int val;
    int i, j;
    int ith_operand;
    int key_match;
    char *cp, token[MAXSTRLEN];

    
    ith_operand = 0;
    cp = label;
    for (i=1; i<=st_count(terminal_set); i++) {
	
	j=0;
	while (*cp == ' ' || *cp == '\t') cp++;
	while (*cp != ' ' && *cp != '\t') {token[j]=*cp; j++; cp++; }
	token[j]='\0';

	if (token[0] != '-') {
	    key_match = 0;
	    gen = st_init_gen(terminal_set);
	    while (st_gen(gen, (char**)&key, (char**)&val)) {
		if (key->flag & EdgeSignal) break;
		if (val == i) {
		    key_match = 1;
		} else if ((val-FG_MAGIC_UB_EDGE) == i) {
		    key_match = 1;
		}
		if (key_match) {
		    if (ith_operand != 0) fprintf(file, "%s", SMV_AND);
		    if (token[0] == '1') 
			fprintf(file, "%s", key->name->name);
		    else
			fprintf(file, "%s%s", SMV_NOT, key->name->name);
		    ith_operand++;
		    break;
		}
	    }
	    st_free_gen(gen);
	}
    }

    if (ith_operand == 0) fprintf(file, "%d", 1);
}


void mrfsm_collect_token_trans(FILE *file)
{
    lsGen gen, ngen;
    lsHandle handle, nhandle;
    char *rcv, *snd;
    char *cond, *b;
    char *R, *S;
    int i;
    ctrlNetNode *ctrlNode;

    for (gen=lsStart(SRFSMnList);
	 lsNext(gen, (lsGeneric*)&ctrlNode, &handle) != LS_NOMORE; ) {
	R = vlStrdup(new_termname());
	fprintf(file, "%s %s %s %s;\n", SMV_VAR, R, SMV_COLON, SMV_BOOLEAN);
	fprintf(file, "%s %s %s ", SMV_ASSIGN, R, SMV_COL_ASSIGN);
	for (ngen=lsStart(ctrlNode->Rcv), i=0;
	     lsNext(ngen, (lsGeneric*)&rcv, &handle) != LS_NOMORE; i++) {
	    if (i==0)
		fprintf(file, "%s", rcv);
	    else
		fprintf(file, " %s %s", SMV_OR, rcv);
	}
	lsFinish(ngen);
	fprintf(file, ";\n");

	S = vlStrdup(new_termname());
	fprintf(file, "%s %s %s %s;\n", SMV_VAR, S, SMV_COLON, SMV_BOOLEAN);
	fprintf(file, "%s %s %s ", SMV_ASSIGN, S, SMV_COL_ASSIGN);
	for (ngen=lsStart(ctrlNode->Snd), i=0;
	     lsNext(ngen, (lsGeneric*)&snd, &handle) != LS_NOMORE; i++) {
	    if (i==0)
		fprintf(file, "%s", snd);
	    else
		fprintf(file, " %s %s", SMV_AND, snd);
	}
	lsFinish(ngen);
	fprintf(file, ";\n");

	fprintf(file, "%s %s( %s ) %s %s\n", SMV_ASSIGN, SMV_TRANS, 
		ctrlNode->N, SMV_COL_ASSIGN, SMV_CASE);
	fprintf(file, "\t%s %s %d;\n", R, SMV_COLON, 1);
	fprintf(file, "\t%s%s %s %d;\n", SMV_NOT, S, SMV_COLON, 0);
	fprintf(file, "\t%d %s %s;\n\t%s;\n",
		1, SMV_COLON, ctrlNode->N, SMV_ESAC);

	for (ngen=lsStart(ctrlNode->B);
	     lsNext(ngen, (lsGeneric*)&cond, &nhandle) != LS_NOMORE; ) {
	    int retval = lsNext(ngen, (lsGeneric*)&b, &nhandle);
	    assert(retval != LS_NOMORE);
	    if (dumpSMVPlus) {
		fprintf(file, "%s %s( %s ) %s %s\n", SMV_ASSIGN, SMV_TRANS,
			b, SMV_COL_ASSIGN, SMV_CASE);
		fprintf(file, "\t%s %s %s;\n", R, SMV_COLON, cond);
		fprintf(file, "\t%d %s %s;\n", 1, SMV_COLON, b);
		fprintf(file, "\t%s;\n", SMV_ESAC);
	    }
	}
	lsFinish(ngen);
    }
    lsFinish(gen);

    lsDestroy(SRFSMnList, 0);
    SRFSMnList = (lsList)0;
}
