/*

  Copyright (c) 1992, 1993
        Regents of the University of California
  All rights reserved.

  Use and copying of this software and preparation of derivative works
  based upon this software are permitted.  However, any distribution of
  this software or derivative works must include the above copyright 
  notice.

  This software is made available AS IS, and neither the Electronics
  Research Laboratory or the Universify of California make any
  warranty about the software, its performance or its conformity to
  any specification.

  Author: Szu-Tsung Cheng, stcheng@ic.Berkeley.EDU
          10/92
          10/93

  $Header: /projects/development/hsv/CVSRepository/vl2mv/src/parser/vl_flowgraph.h,v 1.1.1.1 2001/07/09 23:22:42 fabio Exp $


*/

EXTERN graph_t *fg_new_graph ARGS(());


EXTERN edge_t *fg_new_always_block ARGS(());
EXTERN void fg_new_seq_block ARGS(());
EXTERN vertex_t *fg_new_ifelse_block ARGS((vertex_t**, vertex_t**, vertex_t**, vertex_t**, vertex_t**, vertex_t**, vertex_t**, vertex_t**));
EXTERN vertex_t *fg_new_case_block ARGS((vertex_t**, vertex_t**, vertex_t**, vertex_t**, vertex_t**, vertex_t**, vertex_t**, vertex_t**));
EXTERN edge_t *fg_new_case_tag_block ARGS((vertex_t*, vertex_t*, vertex_t*, vertex_t*));


EXTERN vertex_t *fg_new_pause_node ARGS(());
EXTERN vertex_t *fg_new_assign_node ARGS(());


EXTERN int fg_reduce_simple_branches_back_block ARGS((vertex_t*, vertex_t*, vertex_t*, vertex_t*));
EXTERN edge_t *fg_closeloop ARGS(());
EXTERN edge_t *fg_force_edge ARGS((vertex_t*, vertex_t*, vertex_t*, vertex_t*));


EXTERN fg_graph_info *fg_new_graph_info ARGS(());
EXTERN fg_graph_info *get_assoc_lc_name ARGS((char *loc, char *lc_name));
EXTERN fg_node_info *fg_new_node_info ARGS((int));
EXTERN fg_arc_info *fg_new_arc_info ARGS((int));
EXTERN void fg_update_node_info ARGS((vertex_t*, char*));
EXTERN void fg_update_arc_info ARGS((edge_t*, char*));


EXTERN void fg_clean_vertex_data ARGS((gGeneric));
EXTERN void fg_clean_edge_data ARGS((gGeneric));


EXTERN vl_term *fg_write_lc_in_LabelSet ARGS((FILE*, st_table*, int));
EXTERN vl_term *fg_write_if_priority_decoder ARGS((FILE*, vl_term*, vl_term*, vl_term*));
EXTERN vl_term *fg_write_case_priority_decoder ARGS((FILE*, vl_term*, vl_term*, vl_term*, vl_term*));
EXTERN void fg_if_collect_pause_rewrite_ctrl ARGS((FILE*, vertex_t*, vertex_t*, vl_term**));
EXTERN void fg_put_loc_context ARGS((FILE *file, st_table *pre_cond, char *lc_name));
EXTERN int fg_check_timer_consistency ARGS((FILE *file, graph_t *graph));
EXTERN void fg_set_fg ARGS((graph_t *graph));
EXTERN void fg_declare_smv_timers ARGS((FILE *file, graph_t *graph));


EXTERN st_table* fg_assign_temporal_context ARGS((vertex_t*));


EXTERN st_table* fg_graph_has_one_data_detector ARGS((graph_t*));
EXTERN int fg_new_fg_id ARGS(());
EXTERN void fg_set_fg_id ARGS((int id));
EXTERN int fg_fg_id ARGS(());
EXTERN void fg_associate_id_vars ARGS((int id, st_table *vars));
EXTERN void fg_loop_collect_pause ARGS((FILE *file, vertex_t *src,
					vertex_t *sink,
					vl_term **dom_sel));
EXTERN void fg_case_collect_pause_rewrite_ctrl ARGS((FILE *file,
						     vertex_t *src,
						     vertex_t *sink, 
						     vl_term **spacial_ctrl,
						     vl_term **temporal_ctrl));
EXTERN void fg_write_timer ARGS((FILE *file, graph_t *graph));
EXTERN vertex_t *fg_pseudo_sink ARGS(());
EXTERN int fg_check_cyclic ARGS(());
EXTERN void fg_clean_fg ARGS(());
EXTERN int fg_not_empty ARGS(());
EXTERN void fg_record_SrcSink ARGS((vertex_t **src, vertex_t **sink,
				    vertex_t **cmp_src, vertex_t **cmp_sink));
EXTERN void fg_restore_SrcSink ARGS((vertex_t *src, vertex_t *sink,
				     vertex_t *cmp_src, vertex_t *cmp_sink));
EXTERN vertex_t *fg_new_loop_block ARGS((vertex_t **old_srce,
					 vertex_t **old_sink,
					 vertex_t **new_src,
					 vertex_t **new_sink,
					 vertex_t **old_cmpsrc,
					 vertex_t **old_cmpsink,
					 vertex_t **new_cmpsrc,
					 vertex_t **new_cmpsink));
