/*

  Copyright (c) 1992, 1993
        Regents of the University of California
  All rights reserved.

  Use and copying of this software and preparation of derivative works
  based upon this software are permitted.  However, any distribution of
  this software or derivative works must include the above copyright 
  notice.

  This software is made available AS IS, and neither the Electronics
  Research Laboratory or the Universify of California make any
  warranty about the software, its performance or its conformity to
  any specification.

  Author: Szu-Tsung Cheng, stcheng@ic.Berkeley.EDU
          10/92
          10/93

  $Header: /projects/development/hsv/CVSRepository/vl2mv/src/parser/vl_nonblock.c,v 1.1.1.1 2001/07/09 23:22:40 fabio Exp $


*/

#include <stdio.h>
#include <math.h>
#include "util.h"
#include "array.h"
#include "list.h"
#include "st.h"
#include "set.h"
#include "graph.h"
#include "vl_types.h"
#include "vl_defs.h"
#include "vlr_int.h"
#include "vl_fg_defs.h"
#include "vl_create.h"
#include "vl_write.h"
#include "vl_write_util.h"
#include "vl_vardecl.h"
#include "vl_edgedetector.h"
#include "vl_nonblock.h"
#include "vl_fg_defs.h"
#include "vl_fg_types.h"
#include "vl_flowgraph.h"

extern int dumpSMVPlus;
extern int vlTimedSystem;
extern int set_notation;
extern int Use_Abstraction;
extern int Use_Macro;
extern FILE *lib_file;
extern int decomposeTable;
extern int deadlock_semantic;
extern int rst_ckt;
extern lsList ctrl_list, rst_ctrl_list;
extern int UninterpretedFunction;

static void write_nblock_set_connect ARGS((FILE *file,
					   vl_id_range *id_sym,
					   char *latch_name,
					   vl_term *ripple_ctrl,
					   vl_term *ripple_set,
					   vl_term *procedural_ctrl,
					   vl_term *procedural_term,
					   vl_term *result));

void put_nblock_scalar_simple_table(FILE *file, char *dc,
				    vl_id_range *id_sym,
				    int non_block_wire, 
				    char *latch_name,
				    vl_term *out_term,
				    int n_entries,
				    int lo, int hi,
				    lsList ripple,
				    vl_term *procedural_ctrl,
				    vl_term *procedural_term)
{
    int ith_var;
    vl_term *ctrl_term;
    lsGen lgen;
    lsHandle handle;
    syndrome_expr *se;
    int table_width;

    table_width = lsLength((!rst_ckt)?ctrl_list:rst_ctrl_list) + 
	lsLength((!rst_ckt)?id_sym->syndrome_expr_list:
		 id_sym->rst_syndrome_expr_list);
    if (table_width < decomposeTable) {
	
	
	if (vlTimedSystem && !rst_ckt) {
	    fprintf(file, ".names %s ", FG_LC_PS);
	} else 
	    fprintf(file, ".names ");
	for (lgen=lsStart((!rst_ckt)?ctrl_list:rst_ctrl_list), ith_var=0;
	     lsNext(lgen,(lsGeneric*)&ctrl_term,&handle)!=LS_NOMORE; 
	     ith_var++) {
	    if (!dc[ith_var]) 
		fprintf(file, "%s ", ctrl_term->name->name);
	}
	(void)lsFinish(lgen);
	for (lgen=lsStart((!rst_ckt)?
			  id_sym->syndrome_expr_list:
			  id_sym->rst_syndrome_expr_list);
	     lsNext(lgen,(lsGeneric*)&se,&handle)!=LS_NOMORE;) {
	    fprintf(file, "%s ", se->expr->name->name);
	}
	(void)lsFinish(lgen);
	if (!non_block_wire && !rst_ckt) fprintf(file, "%s ", latch_name);
	fprintf(file, "%s\n", out_term->name->name);
	
	
	if (set_notation && !(deadlock_semantic && non_block_wire)) {
	    if (non_block_wire || rst_ckt) 
		fprintf(file,"%s -\n",HSIS_DEFAULT);
	    else 
		fprintf(file, "%s %s%s\n", 
			HSIS_DEFAULT, HSIS_EQUAL, latch_name);
	}
	if ((id_sym->flags & MVar) && set_notation) {
	    put_nblock_mout_transition(file, non_block_wire, n_entries,
				       id_sym, lo, hi, lo, dc, 
				       latch_name);
	} else {
	    put_nblock_transition(file, non_block_wire, n_entries,
				  id_sym, lo, hi, lo, dc, ripple);
	}
    } else {
	
	vl_term *ripple_ctrl, *ripple_set, *ectrl;
	vl_term *new_set;
	lsList syndromeExprList, worklist, local_accumulator;
	syndrome_expr *se_next;
	int duplicate_item;
	
	ripple_ctrl = NIL(vl_term);
	ripple_set = NIL(vl_term);
	syndromeExprList = (!rst_ckt)?
	    id_sym->syndrome_expr_list:
	    id_sym->rst_syndrome_expr_list; 
	worklist = lsCopy(syndromeExprList, 0);
	
	for (lgen=lsStart(worklist);
	     lsNext(lgen,(lsGeneric*)&se,&handle)!=LS_NOMORE;) {
	    ectrl = write_entry_control(file, 
					(!rst_ckt)?ctrl_list:rst_ctrl_list,
					se->syndrome, se->pre_cond, se->fg_id);
	    
	    local_accumulator = lsCreate();
	    lsNewEnd(local_accumulator, (lsGeneric)se, 0);
	    if (lsLength(worklist) > 1) {
		duplicate_item = 1;
		while (lsNext(lgen, (lsGeneric*)&se_next, &handle)!=
		       LS_NOMORE
		       && duplicate_item) {
		    if (strcmp(se->syndrome, se_next->syndrome)) {
			duplicate_item = 0;
			lsPrev(lgen, (lsGeneric*)&se_next, &handle);
			lsPrev(lgen, (lsGeneric*)&se_next, &handle);
		    } else {
			lsNewEnd(local_accumulator, (lsGeneric)se_next, 0);
		    }
		}
	    }
	    new_set = write_nond_set(file, id_sym, local_accumulator);
	    ripple_ctrl = write_set_accumulate(file, id_sym,
					       ectrl, ripple_ctrl, 
					       new_set, &ripple_set);
	    
	    lsDestroy(local_accumulator, 0);
	    
	}
	
	write_nblock_set_connect(file, id_sym, latch_name,
				 ripple_ctrl, ripple_set,
				 procedural_ctrl, procedural_term,
				 out_term);
	lsFinish(lgen);
	lsDestroy(worklist, 0);
    }
}


void put_nblock_scalar_array_table(FILE *file,
				   char *dc,
				   vl_id_range *id_sym,
				   int non_block_wire, 
				   char *latch_name,
				   vl_term *out_term,
				   int n_entries,
				   int lo, int hi,
				   lsList ripple)
{
    int ith_var;
    vl_term *ctrl_term;
    lsGen lgen;
    lsHandle handle;
    syndrome_expr *se;
    int idx_lo, idx_hi, idx;
    
    idx_lo = vl_eval_expr(id_sym->range->left);
    if (id_sym->range->right) 
	idx_hi = vl_eval_expr(id_sym->range->right);
    else
	idx_hi = idx_lo;
    
    for (idx=idx_lo; idx<=idx_hi; idx++) {
	
	if (vlTimedSystem && !rst_ckt) {
	    fprintf(file, ".names %s ", FG_LC_PS);
	} else 
	    fprintf(file, ".names ");
	for (lgen=lsStart((!rst_ckt)?ctrl_list:rst_ctrl_list), ith_var=0;
	     lsNext(lgen,(lsGeneric*)&ctrl_term,&handle)!=
	     LS_NOMORE; 
	     ith_var++) {
	    if (!dc[ith_var]) 
		fprintf(file, "%s ", ctrl_term->name->name);
	}
	(void)lsFinish(lgen);
	for (lgen=lsStart((!rst_ckt)?
			  id_sym->syndrome_expr_list:
			  id_sym->rst_syndrome_expr_list);
	     lsNext(lgen,(lsGeneric*)&se,&handle)!=LS_NOMORE;) {
	    fprintf(file, "%s%s%d%s ", se->expr->name->name,
		    SEP_LARRAY, idx, SEP_RARRAY);
	}
	(void)lsFinish(lgen);
	if (!non_block_wire && !rst_ckt)
	    fprintf(file,"%s%s%d%s ", latch_name, SEP_LARRAY, idx, SEP_RARRAY);
	fprintf(file, "%s%s%d%s\n", out_term->name->name, 
		SEP_LARRAY, idx, SEP_RARRAY);
	
	
	if (set_notation && !(deadlock_semantic && non_block_wire)) {
	    if (non_block_wire || rst_ckt)
		fprintf (file, "%s -\n", HSIS_DEFAULT);
	    else
		fprintf(file, "%s %s %s%s%d%s\n", HSIS_DEFAULT,
			HSIS_EQUAL, latch_name, SEP_LARRAY, idx, SEP_RARRAY);
	}
	if ((id_sym->flags & MVar) && set_notation)
	    put_nblock_mout_transition(file, 
				       non_block_wire, n_entries,
				       id_sym, lo, hi, lo, dc, 
				       latch_name);
	else
	    put_nblock_transition(file, non_block_wire, n_entries,
				  id_sym, lo, hi, lo, dc, ripple);
    }
}


void put_nblock_vector_table(FILE *file,
			     char *dc,
			     vl_id_range *id_sym,
			     int non_block_wire, 
			     char *latch_name,
			     vl_term *out_term,
			     int n_entries,
			     int lo, int hi,
			     lsList *ripple,
			     vl_term *procedural_ctrl,
			     vl_term *procedural_term)
{
    int ith_var;
    vl_term *ctrl_term;
    lsGen lgen;
    lsHandle handle;
    syndrome_expr *se;
    lsGen rgen;
    lsHandle rhandle;
    lsList args;
    int l;
    char *equ;
    char buf[MAXSTRLEN];
    lsList old_ripple;
    int table_width;
    
    if (Use_Abstraction) {
	vl_term *tdecl_term;
	
	args = lsCreate();
	sprintf(buf, "%s", new_termname());
	lsNewEnd(args, (lsGeneric)(vlStrdup(buf)), 0);
	
	fprintf(file, "%s %s %s ", (Use_Macro)?".macro":".subckt",
		gen_lib_encode(LIBnblock,args), new_termname());
	for (lgen=lsStart((!rst_ckt)?ctrl_list:rst_ctrl_list), 
	     ith_var=0;
	     lsNext(lgen,(lsGeneric*)&ctrl_term,&handle)!=LS_NOMORE;
	     ith_var++) {
	    if (!dc[ith_var])
		fprintf(file, "c%d=%s ", 
			ith_var, ctrl_term->name->name);
	}
	(void)lsFinish(lgen);
	for (lgen=lsStart((!rst_ckt)?
			  id_sym->syndrome_expr_list:
			  id_sym->rst_syndrome_expr_list), ith_var=0;
	     lsNext(lgen,(lsGeneric*)&se,&handle)!=LS_NOMORE;
	     ith_var++) {
	    fprintf(file, "a%d=%s ", 
		    ith_var, se->expr->name->name);
	}
	(void)lsFinish(lgen);
	if (!non_block_wire && !rst_ckt)
	    fprintf(file, "%s=a ", latch_name);
	fprintf(file, "%s=o\n", out_term->name->name);
	
	file = lib_file;
	fprintf(file, ".model %s\n", gen_lib_encode(LIBnblock, args));
	fprintf(file, ".outputs o\n");
	tdecl_term = create_rename_term(out_term->name, vlStrdup("o"), lo, hi);
	write_var_decl(file, tdecl_term);
	vl_free_term(tdecl_term);
	fprintf(file, ".bundle o ");
	for (l=lo; l<=hi; l++) {
	    fprintf(file, "%s%s%d%s ", out_term->name->name,
		    SEP_LBITSELECT, l, SEP_RBITSELECT);
	}
	fprintf(file, "\n");
	if (!non_block_wire && !rst_ckt) fprintf(file, ".inputs a\n");
	for (lgen=lsStart((!rst_ckt)?ctrl_list:rst_ctrl_list), 
	     ith_var=0;
	     lsNext(lgen,(lsGeneric*)&ctrl_term,&handle)!=LS_NOMORE;
	     ith_var++) {
	    if (!dc[ith_var]) {
		fprintf(file, ".inputs c%d\n", ith_var);
		sprintf(buf, "c%d", ith_var);
		tdecl_term = create_rename_term(ctrl_term->name, vlStrdup(buf),
					      ctrl_term->lo, ctrl_term->hi);
		write_var_decl(file, tdecl_term);
		vl_free_term(tdecl_term);
		fprintf(file, ".bundle c%d ", ith_var);
		fprintf(file, "%s ", ctrl_term->name->name);
		fprintf(file, "\n");
	    }
	}
	(void)lsFinish(lgen);
	for (lgen=lsStart((!rst_ckt)?
			  id_sym->syndrome_expr_list:
			  id_sym->rst_syndrome_expr_list), ith_var=0;
	     lsNext(lgen,(lsGeneric*)&se,&handle)!=LS_NOMORE;
	     ith_var++) {
	    fprintf(file, ".inputs a%d\n", ith_var);
	    sprintf(buf, "a%d", ith_var);
	    tdecl_term = create_rename_term(se->expr->name, vlStrdup(buf),
					  lo, hi);
	    write_var_decl(file, tdecl_term);
	    vl_free_term(tdecl_term);
	    fprintf(file, ".bundle a%d ", ith_var);
	    for (l=lo; l<=hi; l++)
		fprintf(file, "%s%s%d%s ",
			se->expr->name->name, 
			SEP_LBITSELECT, l, SEP_RBITSELECT);
	    fprintf(file, "\n");
	}
	(void)lsFinish(lgen);
	
	lsDestroy(args, vl_chk_free);
    }
    
    if (set_notation) {
	
	
	table_width =
	    lsLength((!rst_ckt)?ctrl_list:rst_ctrl_list) + 
	    lsLength((!rst_ckt)?id_sym->syndrome_expr_list:
		                id_sym->rst_syndrome_expr_list);
	if (table_width < decomposeTable) {
	    
	    
	    if (vlTimedSystem && !rst_ckt) {
		fprintf(file, ".names %s ", FG_LC_PS);
	    } else 
		fprintf(file, ".names ");
	    for (lgen=lsStart((!rst_ckt)?ctrl_list:rst_ctrl_list), 
		 ith_var=0;
		 lsNext(lgen,(lsGeneric*)&ctrl_term,&handle)!=LS_NOMORE;
		 ith_var++) {
		if (!dc[ith_var])
		    fprintf(file, "%s ", ctrl_term->name->name);
	    }
	    (void)lsFinish(lgen);
	    
	    for (l=lo; l<=hi; l++) {
		for (lgen=lsStart((!rst_ckt)?
				  id_sym->syndrome_expr_list:
				  id_sym->rst_syndrome_expr_list);
		     lsNext(lgen,(lsGeneric*)&se,&handle)!=LS_NOMORE;) {
		    fprintf(file, "%s%s%d%s ", 
			    se->expr->name->name, 
			    SEP_LBITSELECT, l, SEP_RBITSELECT);
		}
		(void)lsFinish(lgen);
	    }
	    
	    for (l=lo; l<=hi; l++) {
		if (!non_block_wire && !rst_ckt)
		    fprintf(file, "%s%s%d%s ", 
			    latch_name,
			    SEP_LBITSELECT, l, SEP_RBITSELECT);
	    }
	    fprintf(file, "%s ", HSIS_ARROW);
	    for (l=lo; l<=hi; l++) {
		fprintf(file, "%s%s%d%s ", 
			out_term->name->name,
			SEP_LBITSELECT, l, SEP_RBITSELECT);
	    }
	    fprintf(file, "\n");
	    
	    
	    if (set_notation && !(deadlock_semantic && non_block_wire)) {
		if (non_block_wire || rst_ckt) {
		    fprintf(file, "%s ", HSIS_DEFAULT);
		    for (l=lo; l<=hi; l++) fprintf(file, "- ");
		    fprintf(file, "\n");
		} else {
		    fprintf(file, "%s ", HSIS_DEFAULT);
		    for (l=lo; l<=hi;l++) 
			fprintf(file, "%s%s%s%d%s ", HSIS_EQUAL, latch_name,
				SEP_LBITSELECT, l, SEP_RBITSELECT);
		    fprintf(file, "\n");
		}
	    }
	    put_nblock_mout_transition(file, non_block_wire, n_entries,
				       id_sym, lo, hi, l, dc, latch_name);
	} else {
	    
	    vl_term *ripple_ctrl, *ripple_set, *ectrl;
	    vl_term *new_set;
	    lsList syndromeExprList, worklist, local_accumulator;
	    syndrome_expr *se_next;
	    int duplicate_item;

	    ripple_ctrl = NIL(vl_term);
	    ripple_set = NIL(vl_term);
	    syndromeExprList = (!rst_ckt)?
  		                   id_sym->syndrome_expr_list:
			           id_sym->rst_syndrome_expr_list; 
	    worklist = lsCopy(syndromeExprList, 0);

	    for (lgen=lsStart(worklist);
		 lsNext(lgen,(lsGeneric*)&se,&handle)!=LS_NOMORE;) {
		ectrl = write_entry_control(file, 
					    (!rst_ckt)?ctrl_list:rst_ctrl_list,
					    se->syndrome, se->pre_cond, 
					    se->fg_id);

		local_accumulator = lsCreate();
		lsNewEnd(local_accumulator, (lsGeneric)se, 0);
		if (lsLength(worklist) > 1) {
		    duplicate_item = 1;
		    while (lsNext(lgen, (lsGeneric*)&se_next, &handle)!=
			       LS_NOMORE
			   && duplicate_item) {
			if (strcmp(se->syndrome, se_next->syndrome)) {
			    duplicate_item = 0;
			    lsPrev(lgen, (lsGeneric*)&se_next, &handle);
			    lsPrev(lgen, (lsGeneric*)&se_next, &handle);
			} else {
			    lsNewEnd(local_accumulator, (lsGeneric)se_next, 0);
			}
		    }
		}
		new_set = write_nond_set(file, id_sym, local_accumulator);
		ripple_ctrl = write_set_accumulate(file, id_sym,
						   ectrl, ripple_ctrl, 
						   new_set, &ripple_set);

		lsDestroy(local_accumulator, 0);
		
	    }

	    write_nblock_set_connect(file, id_sym, latch_name,
				     ripple_ctrl, ripple_set,
				     procedural_ctrl, procedural_term,
				     out_term);
	    lsFinish(lgen);
	    lsDestroy(worklist, 0);
	}
    } else {
	
	table_width =
	    lsLength((!rst_ckt)?ctrl_list:rst_ctrl_list) + 
	    lsLength((!rst_ckt)?id_sym->syndrome_expr_list:
		                id_sym->rst_syndrome_expr_list);
	if (table_width < decomposeTable) {
	    for (l=lo; l<=hi; l++) {
		
		
		fprintf(file, ".names ");
		for (lgen=lsStart((!rst_ckt)?ctrl_list:rst_ctrl_list), 
		     ith_var=0;
		     lsNext(lgen,(lsGeneric*)&ctrl_term,&handle)!=
		     LS_NOMORE;
		     ith_var++) {
		    if (!dc[ith_var])
			fprintf(file, "%s ", ctrl_term->name->name);
		}
		(void)lsFinish(lgen);
		
		if (*ripple) {
		  for (rgen=lsStart(*ripple); 
			 lsNext(rgen,(lsGeneric*)&equ,&rhandle)!=
			 LS_NOMORE;) {
			fprintf(file, "%s ", equ);
		    }
		    lsFinish(rgen);
		}
		
		for (lgen=lsStart((!rst_ckt)?
				  id_sym->syndrome_expr_list:
				  id_sym->rst_syndrome_expr_list);
		     lsNext(lgen,(lsGeneric*)&se,&handle)!=LS_NOMORE;) {
		    fprintf(file, "%s%s%d%s ", 
			    se->expr->name->name, 
			    SEP_LBITSELECT, l, SEP_RBITSELECT);
		}
		(void)lsFinish(lgen);
		if (!non_block_wire && !rst_ckt)
		    fprintf(file, "%s%s%d%s ", 
			    latch_name,
			    SEP_LBITSELECT, l, SEP_RBITSELECT);
		fprintf(file, "%s%s%d%s\n", 
			out_term->name->name,
			SEP_LBITSELECT, l, SEP_RBITSELECT);
		
		
		if (set_notation && !(deadlock_semantic && non_block_wire)) {
		    if (non_block_wire || rst_ckt)
			fprintf(file, "%s -\n", HSIS_DEFAULT);
		    else
			fprintf(file, "%s %s%s%s%d%s\n", HSIS_DEFAULT,
				HSIS_EQUAL, latch_name, 
				SEP_LBITSELECT, l, SEP_RBITSELECT);
		}
		put_nblock_transition(file, non_block_wire, n_entries,
				      id_sym, lo, hi, l, dc, *ripple);
		
		
		old_ripple = *ripple;
		if (l<hi) {
		    *ripple = lsCreate();
		    for (lgen=lsStart((!rst_ckt)?
				      id_sym->syndrome_expr_list:
				      id_sym->rst_syndrome_expr_list),
			 rgen = (old_ripple)?lsStart(old_ripple):(lsGen)0;
			 lsNext(lgen,(lsGeneric*)&se,&handle)!=LS_NOMORE;){
			char focus_out[MAXSTRLEN], focus_tmp[MAXSTRLEN];
			char tmp[MAXSTRLEN], intermediate[MAXSTRLEN];
			
			sprintf(focus_out, "%s%s%d%s", 
				se->expr->name->name,
				SEP_LBITSELECT, l, SEP_RBITSELECT);
			sprintf(focus_tmp, "%s%s%d%s",
				out_term->name->name,
				SEP_LBITSELECT, l, SEP_RBITSELECT);
			sprintf(tmp, "%s", new_termname());
			vl_write_bop(file, BxnorExpr, 
				     focus_out, focus_tmp, NIL(char), 
				     tmp, 1);
			if (rgen) {
			    lsNext(rgen,(lsGeneric*)&equ,&rhandle);
			    sprintf(intermediate, "%s", new_termname());
			    vl_write_bop(file, BandExpr,
					 tmp, equ, NIL(char), 
					 intermediate, 1);
			} else {
			    sprintf(intermediate, "%s", tmp);
			}
			lsNewEnd(*ripple,(lsGeneric)vlStrdup(intermediate),0);
		    }
		    lsFinish(lgen);
		}
		
		
		if (old_ripple) {
		    lsGen rgen;
		    lsHandle rhandle;
		    
		    for (rgen=lsStart(old_ripple);
			 lsNext(rgen,(lsGeneric*)&equ,&rhandle)!=
			 LS_NOMORE;)
			free(equ);
		    lsFinish(rgen);
		    lsDestroy(old_ripple,0);
		}
	    }
	} else {
	    
	    vl_term *ripple_ctrl, *ripple_set, *ectrl;
	    vl_term *new_set;
	    lsList syndromeExprList, worklist, local_accumulator;
	    syndrome_expr *se_next;
	    int duplicate_item;
	    
	    ripple_ctrl = NIL(vl_term);
	    ripple_set = NIL(vl_term);
	    syndromeExprList = (!rst_ckt)?
		id_sym->syndrome_expr_list:
		id_sym->rst_syndrome_expr_list; 
	    worklist = lsCopy(syndromeExprList, 0);
	    
	    for (lgen=lsStart(worklist);
		 lsNext(lgen,(lsGeneric*)&se,&handle)!=LS_NOMORE;) {
		ectrl = write_entry_control(file, 
					    (!rst_ckt)?ctrl_list:rst_ctrl_list,
					    se->syndrome, se->pre_cond, 
					    se->fg_id);
		
		local_accumulator = lsCreate();
		lsNewEnd(local_accumulator, (lsGeneric)se, 0);
		if (lsLength(worklist) > 1) {
		    duplicate_item = 1;
		    while (lsNext(lgen, (lsGeneric*)&se_next, &handle)!=
			   LS_NOMORE
			   && duplicate_item) {
			if (strcmp(se->syndrome, se_next->syndrome)) {
			    duplicate_item = 0;
			    lsPrev(lgen, (lsGeneric*)&se_next, &handle);
			    lsPrev(lgen, (lsGeneric*)&se_next, &handle);
			} else {
			    lsNewEnd(local_accumulator, (lsGeneric)se_next, 0);
			}
		    }
		}
		new_set = write_nond_set(file, id_sym, local_accumulator);
		ripple_ctrl = write_set_accumulate(file, id_sym,
						   ectrl, ripple_ctrl, 
						   new_set, &ripple_set);
		
		lsDestroy(local_accumulator, 0);
		
	    }
	    
	    write_nblock_set_connect(file, id_sym, latch_name,
				     ripple_ctrl, ripple_set,
				     procedural_ctrl, procedural_term,
				     out_term);
	    lsFinish(lgen);
	    lsDestroy(worklist, 0);
	}
    }
    
    if (Use_Abstraction) fprintf(file, ".end\n\n");
}



void decompose_nblock_transition(file, non_block_wire, n_entries, 
				 id_sym, idx_lo, idx_hi, cur, dc, ripple)
FILE *file;
int non_block_wire;
int n_entries;
vl_id_range *id_sym;
int idx_lo, idx_hi, cur;
char *dc;
lsList ripple;
{
    lsGen lgen;
    lsList comp;
    lsHandle handle;
    int lo, hi;
    int i, j, k;
    char *syndrome;
    syndrome_expr *se;
    lsList domain=(lsList)0;
    lsGen enum_gen;
    lsHandle enum_handle;
    vl_enumerator *enum_elt;

    for (lgen=lsStart((!rst_ckt)?
		      id_sym->syndrome_expr_list:
		      id_sym->rst_syndrome_expr_list), 
	 i=0;
	 lsNext(lgen,(lsGeneric*)&se,&handle)!=LS_NOMORE; i++) {
	if (!(id_sym->flags & MVar)) {
	    lo=0; hi=1;
	} else {
	    get_hilo(id_sym, &hi, &lo);
	}

	if (id_sym->id_type)
	    domain = id_sym->id_type->specifier->u.enum_type->domain_list;
	    
	if (!(id_sym->flags & MVar)) {

	    for (k=lo; k<=hi; k++) {
		put_entry(file, se->syndrome, dc, 1);

		if (ripple) {
		    for (j=0; j<i; j++) fprintf(file, "- ");
		    fprintf(file, "%d ", 1); j++;
		    for (; j<n_entries; j++) fprintf(file, "- ");
		}
		
		for (j=0; j<i; j++) fprintf(file, "- ");
		fprintf(file, "%d ", k); j++;
		for (; j<n_entries; j++) fprintf(file, "- ");
		fprintf(file, "%s%d\n", (non_block_wire||rst_ckt)?"":"- ", k);
	    }
	} else {
	    for (enum_gen=lsStart(domain);
		 lsNext(enum_gen,
			(lsGeneric*)&enum_elt,&enum_handle)!=LS_NOMORE;) {
		put_entry(file, se->syndrome, dc, 1);

		if (ripple) { 
		    for (j=0; j<i; j++) fprintf(file, "- ");
		    fprintf(file, "%d ", 1); j++;
		    for (; j<n_entries; j++) fprintf(file, "- ");
		}
		
		for (j=0; j<i; j++) fprintf(file, "- ");
		fprintf(file, "%s ", enum_elt->name); j++;
		for (; j<n_entries; j++) fprintf(file, "- ");
		fprintf(file, "%s%s\n", 
			(non_block_wire||rst_ckt)?"":"- ", enum_elt->name);
	    }
	    lsFinish(enum_gen);
	}
    }
    lsFinish(lgen);
    
    
    if (!set_notation && !(deadlock_semantic && non_block_wire)) {
	comp = put_guard_zero(file, (!rst_ckt)?id_sym->syndrome_expr_list:
			      id_sym->rst_syndrome_expr_list);
	if (!(id_sym->flags & MVar)) { 
	    for (lgen=lsStart(comp); 
		 lsNext(lgen,&syndrome,&handle)!=LS_NOMORE;) {
		if (!(id_sym->flags & MVar)) {
		    lo=0; hi=1;
		}
		for (k=lo; k<=hi; k++) {
		    put_entry(file, syndrome, dc, 1);
		    for (j=0; j<n_entries*((ripple)?2:1); j++) 
			fprintf(file, "- ");
		    if (non_block_wire || rst_ckt)
			fprintf(file, "%d\n", k);
		    else
			fprintf(file, "%d %d\n", k, k);
		}
	    }
	    lsFinish(lgen);
	} else { 
	    for (lgen=lsStart(comp); 
		 lsNext(lgen,&syndrome,&handle)!=LS_NOMORE;) {
		if (!(id_sym->flags & MVar)) {
		    lo=0; hi=1;
		}
		for (enum_gen=lsStart(domain);
		     lsNext(enum_gen,
			    (lsGeneric*)&enum_elt,&enum_handle)!=LS_NOMORE;) {
		    put_entry(file, syndrome, dc, 1);
		    for (j=0; j<n_entries*((ripple)?2:1); j++) 
			fprintf(file, "- ");
		    if (non_block_wire || rst_ckt)
			fprintf(file, "%s\n", enum_elt->name);
		    else
			fprintf(file, "%s %s\n", 
				enum_elt->name, enum_elt->name);
		}
		lsFinish(enum_gen);
	    }
	    lsFinish(lgen);
	}
    }

    idx_lo = idx_lo;
    idx_hi = idx_hi;
    cur = cur;
}


void decompose_nblock_mout_transition(file, non_block_wire, n_entries, id_sym,
				      idx_lo, idx_hi, cur, dc, latch_name)
FILE *file;
int non_block_wire;
int n_entries;
vl_id_range *id_sym;
int idx_lo, idx_hi, cur;
char *dc;
char *latch_name;
{
    lsGen lgen;
    lsList comp;
    lsHandle handle;
    int lo, hi;
    int i, j, k;
    char *syndrome;
    syndrome_expr *se;

    for (lgen=lsStart((!rst_ckt)?
		      id_sym->syndrome_expr_list:
		      id_sym->rst_syndrome_expr_list), 
	 i=0;
	 lsNext(lgen,(lsGeneric*)&se,&handle)!=LS_NOMORE; i++) {
	if (!(id_sym->flags & MVar)) {
	    lo=0; hi=1;
	} else {
	    get_hilo(id_sym, &hi, &lo);
	}

	put_entry(file, se->syndrome, dc, 1);
	    
	for (j=0; j<n_entries; j++) 
	    if (idx_lo == 0 && idx_hi == -1)
		fprintf(file, "- ");
	    else
		for (k=idx_lo; k<=idx_hi; k++) fprintf(file, "- ");
	if (!(non_block_wire||rst_ckt)) {
	    if (idx_lo == 0 && idx_hi == -1)
		fprintf(file, "- ");
	    else
		for (k=idx_lo; k<=idx_hi; k++)
		    fprintf(file, "- ");
	}
	if (id_sym->flags & MVar || (idx_lo==0 && idx_hi==-1)) {
	    fprintf(file, "%s%s\n", HSIS_EQUAL, se->expr->name->name);
	} else {
	    for (k=idx_lo; k<=idx_hi; k++) {
		fprintf(file, "%s%s%s%d%s ", HSIS_EQUAL,
			se->expr->name->name, 
			SEP_LBITSELECT, k, SEP_RBITSELECT);
	    }
	    fprintf(file, "\n");
	}
    }
    lsFinish(lgen);
    
    
    if (!set_notation && !(deadlock_semantic && non_block_wire)) {
	comp = put_guard_zero(file, (!rst_ckt)?id_sym->syndrome_expr_list:
			      id_sym->rst_syndrome_expr_list);
	for (lgen=lsStart(comp); 
	     lsNext(lgen,&syndrome,&handle)!=LS_NOMORE;) {

	    put_entry(file, syndrome, dc, 1);
	    for (j=0; j<n_entries; j++) 
		if (idx_lo == 0 && idx_hi == -1)
		    fprintf(file, "- ");
		else
		    for (k=idx_lo; k<=idx_hi; k++) fprintf(file, "- ");
	    if (!(non_block_wire || rst_ckt)) {
		if (idx_lo == 0 && idx_hi == -1)
		    fprintf(file, "- ");
		else
		    for (k=idx_lo; k<=idx_hi; k++)
			fprintf(file, "- ");
	    }
	    if (id_sym->flags & MVar || (idx_lo==0 && idx_hi==-1)) {
		if (!(non_block_wire || rst_ckt)) 
		    fprintf(file, "%s%s\n", HSIS_EQUAL, latch_name);
		else
		    fprintf(file, "-\n");
	    } else {
		if (!(non_block_wire || rst_ckt))
		    for (k=idx_lo; k<=idx_hi; k++) {
			fprintf(file, "%s%s%s%d%s ", HSIS_EQUAL, 
				latch_name, SEP_LBITSELECT, k, SEP_RBITSELECT);
		    }
		else
		    fprintf(file,"-");
		fprintf(file, "\n");
	    }
	}

	lsFinish(lgen);
    }

    
    cur = cur;
}


vl_term *write_entry_control(file, ctrl_list, syndrome, pre_cond, fg_id)
FILE *file;
lsList ctrl_list;
char *syndrome;
st_table *pre_cond;
int fg_id;
{
    lsGen gen;
    lsHandle handle;
    vl_term *ctrl_i;
    vl_term *retval;
    unsigned int i;
    int care_length, j, k;
    char lc_name[MAXSTRLEN];

    retval = new_term(NIL(vl_range), 0, -1);
    if (dumpSMVPlus) {
	
	lc_name[0]='\0';
	if (vlTimedSystem && !rst_ckt)
	    sprintf(lc_name, "%s%06x", FG_LC_PS, fg_id);
	fprintf(file, "%s %s %s\n\t%s\n", SMV_DEFINE,
		retval->name->name, SMV_COL_ASSIGN, SMV_CASE);
	fprintf(file, "\t");
	if (vlTimedSystem && !rst_ckt) {
	    fg_put_loc_context(file, pre_cond, lc_name);
	}
	for (gen=lsStart(ctrl_list), i=0, j=0;
	     lsNext(gen, (lsGeneric*)&ctrl_i, &handle) != LS_NOMORE;
	     i++) {
	    if (syndrome[i] != '-') {
		if (j==0) {
		    if (vlTimedSystem && !rst_ckt)
			fprintf(file, "%s", SMV_AND);
		    fprintf(file, "%s", ctrl_i->name->name);
		    j++;
		} else {
		    fprintf(file, "%s%s", SMV_AND, ctrl_i->name->name);
		}
	    }
	}
	lsFinish(gen);
	if (j==0 && !(vlTimedSystem && !rst_ckt)) {
	    fprintf(file, "%d %s %d;\n", 1, SMV_COLON, 1);
	} else {
	    fprintf(file, "%s %d;\n", SMV_COLON, 1);
	    fprintf(file, "\t%d %s %d;\n", 1, SMV_COLON, 0);
	}
	fprintf(file, "\t%s;\n", SMV_ESAC);
    } else {
	
	if (vlTimedSystem && !rst_ckt) 
	    fprintf(file, ".names %s%06x ", FG_LC_PS, fg_id);
	else 
	    fprintf(file, ".names ");
	care_length = 0;
	for (gen=lsStart(ctrl_list), i=0; 
	     lsNext(gen,(lsGeneric*)&ctrl_i,&handle)!=LS_NOMORE;
	     i++) {
	    if (syndrome[i] != '-') {
		fprintf(file, "%s ", ctrl_i->name->name);
		care_length++;
	    }
	}
	lsFinish(gen);
	fprintf(file, "%s\n", retval->name->name);

	
	if (set_notation) {
	    fprintf(file, "%s 0\n", HSIS_DEFAULT);
	    if (vlTimedSystem && !rst_ckt) 
		fg_put_loc_context(file, pre_cond, NIL(char));
	    fprintf(file, " ");
	    for (i=0; i<strlen(syndrome); i++) {
		if (syndrome[i] != '-') {
		    fprintf(file, "%c ", syndrome[i]);
		}
	    }
	    fprintf(file, "1\n");
	} else {
	    for (i=0, k=0; i<strlen(syndrome); i++) {
		if (syndrome[i] != '-') {
		    for (j=0; j<care_length; j++) {
			if (k==j) {
			    fprintf(file, "%c ", (syndrome[i]=='1')?'0':'1');
			} else {
			    fprintf(file, "- ");
			}
		    }
		    k++;
		    fprintf(file, "0\n");
		}
	    }
	    
	    for (i=0; i<strlen(syndrome); i++) {
		if (syndrome[i] != '-') {
		    fprintf(file, "%c ", syndrome[i]);
		}
	    }
	    fprintf(file, "1\n");
	}
    }

    return retval;
}


vl_term *write_nond_set(file, id_sym, list_syndrome)
FILE *file;
vl_id_range *id_sym;
lsList list_syndrome;
{
    syndrome_expr *se;
    lsGen gen;
    lsHandle handle;
    vl_term *retval;
    int hi, lo;
    int i, j, k;
    int bit_idx;
    lsGen ctrl_gen;
    lsHandle ctrl_handle;
    lsList ripple=(lsList)0, old_ripple=(lsList)0;
    lsGen old_gen;
    lsHandle old_handle;
    char *equ;

    get_hilo(id_sym, &hi, &lo);
    retval = typed_new_term(id_sym->id_type, id_sym->range, lo, hi);
    retval->flag |= (id_sym->flags & MVar)?MVar:0;
    retval->name->unintType = id_sym->unintType;
    write_var_decl(file, retval);
    
    if (dumpSMVPlus) {
	
	fprintf(file, "%s %s %s\n\t%s\n", SMV_ASSIGN,
		retval->name->name, SMV_COL_ASSIGN, SMV_CASE);
	for (gen=lsStart(list_syndrome);
	     lsNext(gen, (lsGeneric*)&se, &handle) != LS_NOMORE; ) {
	    fprintf(file, "\t%d %s %s;\n", 1, SMV_COLON,
		    se->expr->name->name);
	}
	lsFinish(gen);
	fprintf(file, "\t%s;\n", SMV_ESAC);
    } else {
	
	if (id_sym->flags & MVar || UninterpretedFunction) {
	    fprintf(file, ".names ");
	    for (gen=lsStart(list_syndrome); 
		 lsNext(gen, (lsGeneric*)&se, &handle) != LS_NOMORE; ) {
		fprintf(file, "%s ", se->expr->name->name);
	    }
	    lsFinish(gen);
	    fprintf(file, "%s\n", retval->name->name);
	
	    if (set_notation) {
		for (gen=lsStart(list_syndrome); 
		     lsNext(gen, (lsGeneric*)&se, &handle) != LS_NOMORE; ) {
		    for (i=0; i<lsLength(list_syndrome); i++) {
			fprintf(file, "- ");
		    }
		    fprintf(file, "%s%s\n", HSIS_EQUAL, se->expr->name->name);
		}
	    } else {
		lsList domain;
		lsGen enum_gen;
		lsHandle enum_handle;
		vl_enumerator *enum_elt;
		domain = id_sym->id_type->specifier->u.enum_type->domain_list;
		for (gen=lsStart(list_syndrome), i=0; 
		     lsNext(gen, (lsGeneric*)&se, &handle) != LS_NOMORE; i++) {
		    for (enum_gen=lsStart(domain);
			 lsNext(enum_gen,(lsGeneric*)&enum_elt,&enum_handle)!=
		             LS_NOMORE;) {
			for (k=0; k<lsLength(list_syndrome); k++) {
			    if (i==k) 
				fprintf(file, "%s ", enum_elt->name);
			    else
				fprintf(file, "- ");
			}
			fprintf(file, "%s\n", enum_elt->name);
		    }
		    lsFinish(enum_gen);
		}	
		lsFinish(gen);
	    }
	} else {
	    if (lo > hi) {
		
		fprintf(file, ".names ");
		for (gen=lsStart(list_syndrome); 
		     lsNext(gen, (lsGeneric*)&se, &handle) != LS_NOMORE; ) {
		    fprintf(file, "%s ", se->expr->name->name);
		}
		lsFinish(gen);
		fprintf(file, "%s\n", retval->name->name);
	    
		if (set_notation) {
		    for (gen=lsStart(list_syndrome); 
			 lsNext(gen, (lsGeneric*)&se, &handle) != 
		             LS_NOMORE; ) {
			for (i=0; i<lsLength(list_syndrome); i++) {
			    fprintf(file, "- ");
			}
			fprintf(file, "%s%s\n", 
				HSIS_EQUAL, se->expr->name->name);
		    }
		} else {
		    for (gen=lsStart(list_syndrome), i=0; 
			 lsNext(gen, (lsGeneric*)&se, &handle) != 
		             LS_NOMORE; i++) {
			for (j=0; j<=1; j++) {
			    for (k=0; k<lsLength(list_syndrome); k++) {
				if (i==k) 
				    fprintf(file, "%d ", j);
				else
				    fprintf(file, "- ");
			    }
			    fprintf(file, "%d\n", j);
			}
		    }	
		    lsFinish(gen);
		}
	    } else { 
		
		if (set_notation) {
		    
		    fprintf(file, ".names ");
		    for (bit_idx=lo; bit_idx<=hi; bit_idx++) {
			for (gen=lsStart(list_syndrome); 
			     lsNext(gen, (lsGeneric*)&se, &handle) != 
			         LS_NOMORE;) {
			    fprintf(file, "%s%s%d%s ", se->expr->name->name,
				    SEP_LBITSELECT, bit_idx, SEP_RBITSELECT);
			    
			    
			}
			lsFinish(gen);
		    }
		    fprintf(file, "%s ", HSIS_ARROW);
		    for (bit_idx=lo; bit_idx<=hi; bit_idx++) {
			fprintf(file, "%s%s%d%s ", retval->name->name,
				SEP_LBITSELECT, bit_idx, SEP_RBITSELECT);
		    }
		    fprintf(file, "\n");
		    
		    
		    for (gen=lsStart(list_syndrome); 
			 lsNext(gen, (lsGeneric*)&se, &handle)!=LS_NOMORE; ) {
			for (i=0; i<lsLength(list_syndrome); i++) {
			    for (bit_idx=lo; bit_idx<=hi; bit_idx++) 
				fprintf(file, "- ");
			}
			for (bit_idx=lo; bit_idx<=hi; bit_idx++) 
			    fprintf(file, "%s%s%s%d%s ", HSIS_EQUAL, 
				    se->expr->name->name,
				    SEP_LBITSELECT, bit_idx, SEP_RBITSELECT);
			fprintf(file, "\n");
		    }
		} else {
		    for (bit_idx=lo; bit_idx<=hi; bit_idx++) {
			if (bit_idx==lo) {
			    fprintf(file, ".names ");
			    for (gen=lsStart(list_syndrome); 
				 lsNext(gen, (lsGeneric*)&se, &handle) != 
				     LS_NOMORE;) {
				fprintf(file, "%s%s%d%s ", 
					se->expr->name->name,
					SEP_LBITSELECT,bit_idx,SEP_RBITSELECT);
			    }
			    lsFinish(gen);
			    fprintf(file, "%s%s%d%s\n", retval->name->name,
				    SEP_LBITSELECT, bit_idx, SEP_RBITSELECT);
			
			    for (gen=lsStart(list_syndrome), i=0; 
				 lsNext(gen,(lsGeneric*)&se,&handle) != 
				     LS_NOMORE; 
				 i++) {
				for (j=0; j<=1; j++) {
				    for (k=0; k<lsLength(list_syndrome); k++) {
					if (i==k) 
					    fprintf(file, "%d ", j);
					else
					    fprintf(file, "- ");
				    }
				    fprintf(file, "%d\n", j);
				}
			    }	
			    lsFinish(gen);
			} else {
			    fprintf(file, ".names ");
			    for (gen=lsStart(list_syndrome), 
				 ctrl_gen=lsStart(ripple); 
				 lsNext(gen, (lsGeneric*)&se, &handle) != 
				     LS_NOMORE;) {
				lsNext(ctrl_gen,(lsGeneric*)&equ,&ctrl_handle);
				fprintf(file, "%s %s%s%d%s ", equ,
					se->expr->name->name,
					SEP_LBITSELECT,bit_idx,SEP_RBITSELECT);
			    }
			    lsFinish(gen);
			    fprintf(file, "%s%s%d%s\n", retval->name->name,
				    SEP_LBITSELECT, bit_idx, SEP_RBITSELECT);
			
			    for (gen=lsStart(list_syndrome), i=0; 
				 lsNext(gen,(lsGeneric*)&se,&handle) != 
				     LS_NOMORE; 
				 i++) {
				for (j=0; j<=1; j++) {
				    for (k=0; k<lsLength(list_syndrome); k++) {
					if (i==k) 
					    fprintf(file, "1 %d ", j);
					else
					    fprintf(file, "- - ");
				    }
				    fprintf(file, "%d\n", j);
				}
			    }	
			    lsFinish(gen);
			}
		    
			old_ripple = ripple;
			if (bit_idx < hi) {
			    ripple = lsCreate();
			    for (gen=lsStart(list_syndrome),
				 old_gen=(old_ripple)?
				             lsStart(old_ripple):(lsGen)0;
				 lsNext(gen,(lsGeneric*)&se, &handle)!=
				     LS_NOMORE;){
				char focus_out[MAXSTRLEN],focus_tmp[MAXSTRLEN];
				char tmp[MAXSTRLEN], intermediate[MAXSTRLEN];
				sprintf(focus_out, "%s%s%d%s", 
					se->expr->name->name, 
					SEP_LBITSELECT,bit_idx,SEP_RBITSELECT);
				sprintf(focus_tmp, "%s%s%d%s",
					retval->name->name,
					SEP_LBITSELECT,bit_idx,SEP_RBITSELECT);
				sprintf(tmp, "%s", new_termname());
				vl_write_bop(file, BxnorExpr,
					     focus_out, focus_tmp, NIL(char),
					     tmp, 1);
				if (old_gen) {
				    lsNext(old_gen,(lsGeneric*)&equ,
					   &old_handle);
				    sprintf(intermediate,"%s",new_termname());
				    vl_write_bop(file, BandExpr, tmp, equ, 
						 NIL(char), intermediate, 1);
				} else {
				    sprintf(intermediate,"%s",tmp);
				}
				lsNewEnd(ripple,
					 (lsGeneric)vlStrdup(intermediate),0);
			    }
			    lsFinish(gen);
			    lsFinish(old_gen);
			}
			
			if (old_ripple) {
			    for (gen=lsStart(old_ripple);
				 lsNext(gen,(lsGeneric*)&equ,&handle)!=
				     LS_NOMORE;)
				free(equ);
			    lsFinish(gen);
			    lsDestroy(old_ripple,0);
			}
		    }
		}
	    }
	}
    }

    return retval;
}


vl_term *write_set_accumulate(file, id_sym, local_ctrl, ripple_ctrl, 
			      local_set, ripple_set)
FILE *file;
vl_id_range *id_sym;
vl_term *local_ctrl;
vl_term *ripple_ctrl;
vl_term *local_set;
vl_term **ripple_set;
{
    vl_term *retval, *ripple_out_set;
    vl_term *zero=NIL(vl_term);
    int lo, hi;
    int bit_idx;
    int i;

    get_hilo(id_sym, &hi, &lo);
    retval = new_term(NIL(vl_range), 0, -1);
    ripple_out_set = typed_new_term(id_sym->id_type, id_sym->range, lo, hi);
    ripple_out_set->flag |= (id_sym->flags & MVar)?MVar:0;
    ripple_out_set->name->unintType = id_sym->unintType;
    write_var_decl(file, ripple_out_set);

    if (dumpSMVPlus) {

	
	
	
	if (!id_sym->id_type) {
	    zero = typed_new_term(id_sym->id_type, id_sym->range, lo, hi);
	    if (hi < lo) {
		fprintf(file, "%s %s %s %s;\n", SMV_WIRE, zero->name->name,
			SMV_COLON, SMV_BOOLEAN);
	    } else {
		fprintf(file, "%s %s %s %s %d%s%d %s %s;\n", SMV_WIRE,
			zero->name->name, SMV_COLON, 
			SMV_ARRAY, hi, SMV_RANGE, lo, SMV_OF, SMV_BOOLEAN);
	    }
	    fprintf(file, "%s %s %s %d;\n", SMV_ASSIGN,
		    zero->name->name, SMV_COL_ASSIGN, 0);
	}

	fprintf(file, "%s %s %s\n\t%s\n", SMV_ASSIGN,
		ripple_out_set->name->name, SMV_COL_ASSIGN, SMV_CASE);
	fprintf(file, "\t%s %s %s;\n", local_ctrl->name->name, SMV_COLON,
		local_set->name->name);
	if (ripple_ctrl)
	    fprintf(file, "\t%s %s %s;\n", ripple_ctrl->name->name, SMV_COLON,
		    (*ripple_set)->name->name);
	fprintf(file, "\t%d %s ", 1, SMV_COLON);
	if (!id_sym->id_type) {
	    fprintf(file, "%s", zero->name->name);
	} else {
	    smv_dc(file, id_sym->id_type, hi, lo);
	}
	fprintf(file, ";\n");
	fprintf(file, "\t%s;\n", SMV_ESAC);
	
	
	if (ripple_ctrl)
	    vl_write_bop(file, BorExpr, 
			 local_ctrl->name->name,
			 ripple_ctrl->name->name, 
			 NIL(char), retval->name->name, 1);
	else 
	    vl_write_bin_connect(file, local_ctrl, retval, 0);

    } else {

	
	if (id_sym->flags & MVar || UninterpretedFunction) {
	    if (set_notation) {
		if (ripple_ctrl) {
		    
		    
		    fprintf(file, ".names %s %s %s %s %s\n", 
			    local_ctrl->name->name, ripple_ctrl->name->name,
			    local_set->name->name, (*ripple_set)->name->name,
			    ripple_out_set->name->name);
		    fprintf(file, ".def -\n");
		    fprintf(file, "1 - - - %s%s\n",
			    HSIS_EQUAL,local_set->name->name);
		    fprintf(file, "- 1 - - %s%s\n",
			    HSIS_EQUAL, (*ripple_set)->name->name);
		
		    
		    vl_write_bop(file, BorExpr, 
				 local_ctrl->name->name,
				 ripple_ctrl->name->name, 
				 NIL(char), retval->name->name, 1);
		} else {
		    
		    
		    fprintf(file, ".names %s %s %s\n", 
			    local_ctrl->name->name, local_set->name->name, 
			    ripple_out_set->name->name);
		    fprintf(file, ".def -\n");
		    fprintf(file, "1 - %s%s\n",
			    HSIS_EQUAL,local_set->name->name);
		    
		    
		    vl_write_bin_connect(file, local_ctrl, retval, 0);
		}
	    } else {
		lsList domain;
		lsGen enum_gen;
		lsHandle enum_handle;
		vl_enumerator *enum_elt;

		domain = id_sym->id_type->specifier->u.enum_type->domain_list;
		if (ripple_ctrl) {
		    
		    
		    fprintf(file, ".names %s %s %s %s %s\n", 
			    local_ctrl->name->name, ripple_ctrl->name->name,
			    local_set->name->name, (*ripple_set)->name->name,
			    ripple_out_set->name->name);
		    for (enum_gen=lsStart(domain);
			 lsNext(enum_gen,(lsGeneric*)&enum_elt,&enum_handle)!=
		             LS_NOMORE;)
			fprintf(file, "1 - %s - %s\n",
				enum_elt->name, enum_elt->name);
		    lsFinish(enum_gen);
		    for (enum_gen=lsStart(domain);
			 lsNext(enum_gen,(lsGeneric*)&enum_elt,&enum_handle)!=
		             LS_NOMORE;)
			fprintf(file, "- 1 - %s %s\n", 
				enum_elt->name, enum_elt->name);
		    lsFinish(enum_gen);
		    fprintf(file, "0 0 - - -\n");
		
		    
		    vl_write_bop(file, BorExpr, 
				 local_ctrl->name->name,
				 ripple_ctrl->name->name, 
				 NIL(char), retval->name->name, 1);
		} else {
		    
		    
		    fprintf(file, ".names %s %s %s\n", 
			    local_ctrl->name->name,	local_set->name->name, 
			    ripple_out_set->name->name);
		    for (enum_gen=lsStart(domain);
			 lsNext(enum_gen,(lsGeneric*)&enum_elt,&enum_handle)!=
		             LS_NOMORE;)
			fprintf(file, "1 %s %s\n", 
				enum_elt->name, enum_elt->name);
		    lsFinish(enum_gen);
		    fprintf(file, "0 - -\n");
		
		    
		    vl_write_bin_connect(file, local_ctrl, retval, 0);
		}
	    }
	} else {
	    if (lo > hi) {
		
		if (set_notation) {
		    if (ripple_ctrl) {
			
			
			fprintf(file, ".names %s %s %s %s %s\n", 
				local_ctrl->name->name, 
				ripple_ctrl->name->name,
				local_set->name->name,
				(*ripple_set)->name->name,
				ripple_out_set->name->name);
			fprintf(file, ".def -\n");
			fprintf(file, "1 - - - %s%s\n",
				HSIS_EQUAL,local_set->name->name);
			fprintf(file, "- 1 - - %s%s\n",
				HSIS_EQUAL, (*ripple_set)->name->name);
		    
			
			vl_write_bop(file, BorExpr, 
				     local_ctrl->name->name,
				     ripple_ctrl->name->name, 
				     NIL(char), retval->name->name, 1);
		    } else {
			
			
			fprintf(file, ".names %s %s %s\n", 
				local_ctrl->name->name, local_set->name->name, 
				ripple_out_set->name->name);
			fprintf(file, ".def -\n");
			fprintf(file, "1 - %s%s\n",
				HSIS_EQUAL,local_set->name->name);
		    
			
			vl_write_bin_connect(file, local_ctrl, retval, 0);
		    }
		} else {
		    if (ripple_ctrl) {
			
			
			fprintf(file, ".names %s %s %s %s %s\n", 
				local_ctrl->name->name, 
				ripple_ctrl->name->name,
				local_set->name->name, 
				(*ripple_set)->name->name,
				ripple_out_set->name->name);
			for (i=0; i<=1; i++) 
			    fprintf(file, "1 - %d - %d\n", i, i);
			for (i=0; i<=1; i++) 
			    fprintf(file, "- 1 - %d %d\n", i, i);
			fprintf(file, "0 0 - - -\n");
		    
			
			vl_write_bop(file, BorExpr, 
				     local_ctrl->name->name,
				     ripple_ctrl->name->name, 
				     NIL(char), retval->name->name, 1);
		    } else {
			
			
			fprintf(file, ".names %s %s %s\n", 
				local_ctrl->name->name,	local_set->name->name, 
				ripple_out_set->name->name);
			for (i=0; i<=1; i++) fprintf(file, "1 %d %d\n", i, i);
			fprintf(file, "0 - -\n");
		    
			
			vl_write_bin_connect(file, local_ctrl, retval, 0);
		    }
		}
	    } else {
		
		if (set_notation) {
		    if (ripple_ctrl) {
			
			
			fprintf(file, ".names %s %s ", 
				local_ctrl->name->name, 
				ripple_ctrl->name->name);
			for (bit_idx=lo; bit_idx<=hi; bit_idx++)
			    fprintf(file, "%s%s%d%s %s%s%d%s ", 
				    local_set->name->name, 
				    SEP_LBITSELECT, bit_idx, SEP_RBITSELECT,
				    (*ripple_set)->name->name,
				    SEP_LBITSELECT, bit_idx, SEP_RBITSELECT);
			fprintf(file, "%s ", HSIS_ARROW);
			for (bit_idx=lo; bit_idx<=hi; bit_idx++)
			    fprintf(file, "%s%s%d%s ",
				    ripple_out_set->name->name,
				    SEP_LBITSELECT, bit_idx, SEP_RBITSELECT);
			fprintf(file, "\n");
			fprintf(file, ".def ");
			for (bit_idx=lo;bit_idx<=hi;bit_idx++) 
			    fprintf(file, "- ");
			fprintf(file, "\n");
			fprintf(file, "1 - ");
			for (bit_idx=lo;bit_idx<=hi;bit_idx++) 
			    fprintf(file, "- - ");
			for (bit_idx=lo; bit_idx<=hi; bit_idx++)
			    fprintf(file, "%s%s%s%d%s ",HSIS_EQUAL,
				    local_set->name->name,
				    SEP_LBITSELECT, bit_idx, SEP_RBITSELECT);
			fprintf(file, "\n");
			fprintf(file, "- 1 ");
			for (bit_idx=lo;bit_idx<=hi;bit_idx++) 
			    fprintf(file, "- - ");
			for (bit_idx=lo; bit_idx<=hi; bit_idx++) 
			    fprintf(file,"%s%s%s%d%s ",HSIS_EQUAL,
				    (*ripple_set)->name->name,
				    SEP_LBITSELECT, bit_idx, SEP_RBITSELECT);
			fprintf(file, "\n");
		    
			
			vl_write_bop(file, BorExpr, 
				     local_ctrl->name->name,
				     ripple_ctrl->name->name, 
				     NIL(char), retval->name->name, 1);
		    } else {
			
			
			fprintf(file, ".names %s ", local_ctrl->name->name);
			for (bit_idx=lo; bit_idx<=hi; bit_idx++)
			    fprintf(file, "%s%s%d%s ", 
				    local_set->name->name, 
				    SEP_LBITSELECT, bit_idx, SEP_RBITSELECT);
			fprintf(file, "%s ", HSIS_ARROW);
			for (bit_idx=lo; bit_idx<=hi; bit_idx++)
			    fprintf(file, "%s%s%d%s ",
				    ripple_out_set->name->name,
				    SEP_LBITSELECT, bit_idx, SEP_RBITSELECT);
			fprintf(file, "\n");
			fprintf(file, ".def ");
			for (bit_idx=lo;bit_idx<=hi;bit_idx++) 
			    fprintf(file, "- ");
			fprintf(file, "\n");
			fprintf(file, "1 ");
			for (bit_idx=lo;bit_idx<=hi;bit_idx++) 
			    fprintf(file, "- ");
			for (bit_idx=lo; bit_idx<=hi; bit_idx++)
			    fprintf(file, "%s%s%s%d%s ",HSIS_EQUAL,
				    local_set->name->name,
				    SEP_LBITSELECT, bit_idx, SEP_RBITSELECT);
			fprintf(file, "\n");
		    
			
			vl_write_bit_connect(file, local_ctrl->name->name, 
					     retval->name->name, 0);
		    }
		} else {
		    
		    if (ripple_ctrl) {
			char *(equ[2]);
			equ[0] = NIL(char);
			equ[1] = NIL(char);
			
			for (bit_idx=lo; bit_idx<=hi; bit_idx++) {
			    if (bit_idx==lo) {
				fprintf(file,".names %s %s %s%s%d%s %s%s%d%s %s%s%d%s\n", 
					local_ctrl->name->name,
					ripple_ctrl->name->name,
					local_set->name->name, 
					SEP_LBITSELECT,bit_idx,SEP_RBITSELECT,
					(*ripple_set)->name->name,
					SEP_LBITSELECT,bit_idx,SEP_RBITSELECT,
					ripple_out_set->name->name,
					SEP_LBITSELECT,bit_idx,SEP_RBITSELECT);
				for (i=0; i<=1; i++) 
				    fprintf(file, "1 - %d - %d\n", i, i);
				for (i=0; i<=1; i++) 
				    fprintf(file, "- 1 - %d %d\n", i, i);
				fprintf(file, "0 0 - - -\n");
			    } else {
				fprintf(file,".names %s %s %s %s%s%d%s %s %s%s%d%s %s%s%d%s\n", 
					local_ctrl->name->name,
					ripple_ctrl->name->name,
					equ[0], local_set->name->name, 
					SEP_LBITSELECT,bit_idx,SEP_RBITSELECT,
					equ[1], (*ripple_set)->name->name,
					SEP_LBITSELECT,bit_idx,SEP_RBITSELECT,
					ripple_out_set->name->name,
					SEP_LBITSELECT,bit_idx,SEP_RBITSELECT);
				for (i=0; i<=1; i++) 
				    fprintf(file, "1 - 1 %d - - %d\n", i, i);
				for (i=0; i<=1; i++) 
				    fprintf(file, "- 1 - - 1 %d %d\n", i, i);
				fprintf(file, "0 0 - - - - -\n");
			    }
			
			    if (bit_idx < hi) {
				char focus_out[MAXSTRLEN],focus_tmp[MAXSTRLEN];
				char tmp[MAXSTRLEN], intermediate[MAXSTRLEN];
				sprintf(focus_out, "%s%s%d%s",
					local_set->name->name, 
					SEP_LBITSELECT,bit_idx,SEP_RBITSELECT);
				sprintf(focus_tmp, "%s%s%d%s",
					ripple_out_set->name->name,
					SEP_LBITSELECT,bit_idx,SEP_RBITSELECT);
				sprintf(tmp, "%s", new_termname());
				vl_write_bop(file, BxnorExpr, 
					     focus_out, focus_tmp,
					     NIL(char), tmp, 1);

				if (equ[0]) {
				    sprintf(intermediate, "%s",new_termname());
				    vl_write_bop(file, BandExpr, tmp, equ[0], 
						 NIL(char), intermediate, 1);
				    vl_chk_free(equ[0]);
				} else {
				    sprintf(intermediate, "%s", tmp);
				}
				equ[0] = vlStrdup(intermediate);

				sprintf(focus_out, "%s%s%d%s",
					(*ripple_set)->name->name, 
					SEP_LBITSELECT,bit_idx,SEP_RBITSELECT);
				sprintf(focus_tmp, "%s%s%d%s",
					ripple_out_set->name->name,
					SEP_LBITSELECT,bit_idx,SEP_RBITSELECT);
				sprintf(tmp, "%s", new_termname());
				vl_write_bop(file, BxnorExpr, 
					     focus_out, focus_tmp,
					     NIL(char), tmp, 1);

				if (equ[1]) {
				    sprintf(intermediate, "%s",new_termname());
				    vl_write_bop(file, BandExpr, tmp, equ[1], 
						 NIL(char), intermediate, 1);
				    vl_chk_free(equ[1]);
				} else {
				    sprintf(intermediate, "%s", tmp);
				}
				equ[1] = vlStrdup(intermediate);
			    }
			}
			
			vl_write_bop(file, BorExpr, 
				     local_ctrl->name->name,
				     ripple_ctrl->name->name, 
				     NIL(char), retval->name->name, 1);
		    } else {
			
			for (bit_idx=lo; bit_idx<=hi; bit_idx++) {
			    fprintf(file, ".names %s %s%s%d%s %s%s%d%s\n", 
				    local_ctrl->name->name, 
				    local_set->name->name, 
				    SEP_LBITSELECT, bit_idx, SEP_RBITSELECT,
				    ripple_out_set->name->name,
				    SEP_LBITSELECT, bit_idx, SEP_RBITSELECT);
			    for (i=0; i<=1; i++) 
				fprintf(file, "1 %d %d\n", i, i);
			    fprintf(file, "0 - -\n");
			}		
			
			vl_write_bin_connect(file, local_ctrl, retval, 0);
		    }
		}
	    }
	}	

    }

    if (*ripple_set) vl_free_term(*ripple_set);
    *ripple_set = ripple_out_set;
    return retval;
}


static void write_nblock_set_connect(FILE *file,
				     vl_id_range *id_sym,
				     char *latch_name,
				     vl_term *ripple_ctrl,
				     vl_term *ripple_set, 
				     vl_term *procedural_ctrl,
				     vl_term *procedural_term,
				     vl_term *result)
{
    int hi, lo;
    int bit_idx;
    int i;

    get_hilo(id_sym, &hi, &lo);
    if (dumpSMVPlus) {
        
        if (procedural_ctrl) {
	    
	    fprintf(file, "%s %s %s\n\t%s\n", SMV_ASSIGN,
		    result->name->name, SMV_COL_ASSIGN, SMV_CASE);
	    fprintf(file, "\t%s %s %s;\n", ripple_ctrl->name->name,
		    SMV_COLON, ripple_set->name->name);
	    fprintf(file, "\t%s%s %s %s %s %s;\n", 
		    SMV_NOT, ripple_ctrl->name->name, 
		    SMV_AND, procedural_ctrl->name->name,
		    SMV_COLON, procedural_term->name->name);
	    if (id_sym->flags & RegVar)
	        fprintf(file, "\t%s%s %s %s%s %s %s;\n",
			SMV_NOT, ripple_ctrl->name->name, SMV_AND,
			SMV_NOT, procedural_ctrl->name->name,
			SMV_COLON, latch_name);

	    else if (!deadlock_semantic) {
	        fprintf(file, "\t%d %s", 1, SMV_COLON);
		smv_dc(file, id_sym->id_type, hi, lo);
		fprintf(file, ";\n");
	    }
	    fprintf(file, "\t%s;\n", SMV_ESAC);
	} else {
	    fprintf(file, "%s %s %s\n\t%s\n", SMV_ASSIGN,
		    result->name->name, SMV_COL_ASSIGN, SMV_CASE);
	    fprintf(file, "\t%s %s %s;\n", ripple_ctrl->name->name, 
		    SMV_COLON, ripple_set->name->name);
	    if (id_sym->flags & RegVar)
	        fprintf(file, "\t%d %s %s;\n", 1, SMV_COLON, latch_name);
	    else if (!deadlock_semantic) {
	        fprintf(file, "\t%d %s", 1, SMV_COLON);
		smv_dc(file, id_sym->id_type, hi, lo);
		fprintf(file, ";\n");
	    }
	    fprintf(file, "\t%s;\n", SMV_ESAC);
	}
	
	return;
    }

    
    
    if (id_sym->flags & MVar || UninterpretedFunction) {
	if (set_notation) {
	    if (procedural_ctrl) {
		
		fprintf(file, ".names %s %s %s %s %s %s\n", 
			ripple_ctrl->name->name, ripple_set->name->name, 
			procedural_ctrl->name->name,
			procedural_term->name->name,
			(id_sym->flags & RegVar) ? latch_name : "",
			result->name->name);
		fprintf(file, "1 - - - %s %s%s\n",
			(id_sym->flags & RegVar) ? "-" : "",
			HSIS_EQUAL, ripple_set->name->name);
		fprintf(file, "0 - 1 - %s %s%s\n",
			(id_sym->flags & RegVar) ? "-" : "",
			HSIS_EQUAL, procedural_term->name->name);
		if (id_sym->flags & RegVar)
		    fprintf(file,"0 - 0 - - %s%s\n",HSIS_EQUAL,latch_name);
		else if (!deadlock_semantic)
		    fprintf(file,"0 - 0 - -\n");
	    } else {
		fprintf(file, ".names %s %s %s %s\n", 
			ripple_ctrl->name->name, ripple_set->name->name, 
			(id_sym->flags & RegVar) ? latch_name : "",
			result->name->name);
		fprintf(file, "1 - %s %s%s\n",
			(id_sym->flags & RegVar) ? "-" : "",
			HSIS_EQUAL, ripple_set->name->name);
		if (id_sym->flags & RegVar)
		    fprintf(file, "0 - - %s%s\n", HSIS_EQUAL, latch_name);
		else if (!deadlock_semantic) 
		    fprintf(file, "0 - -\n");
	    }
	} else {
	    lsList domain;
	    lsGen enum_gen;
	    lsHandle enum_handle;
	    vl_enumerator *enum_elt;

	    if (procedural_ctrl) {
		
		domain = id_sym->id_type->specifier->u.enum_type->domain_list;
		fprintf(file, ".names %s %s %s %s %s %s\n", 
		    ripple_ctrl->name->name, ripple_set->name->name, 
		    procedural_ctrl->name->name, procedural_term->name->name,
		    (id_sym->flags & RegVar) ? latch_name : "",
		    result->name->name);

		
		for (enum_gen=lsStart(domain);
		     lsNext(enum_gen,(lsGeneric*)&enum_elt,&enum_handle)!=
		     LS_NOMORE;)
		    fprintf(file, "1 %s - - %s %s\n", enum_elt->name, 
			    (id_sym->flags & RegVar) ? "-":"",
			    enum_elt->name);
		lsFinish(enum_gen);
		for (enum_gen=lsStart(domain);
		     lsNext(enum_gen,(lsGeneric*)&enum_elt,&enum_handle)!=
		     LS_NOMORE;)
		    fprintf(file, "0 - 1 %s %s %s\n", enum_elt->name, 
			    (id_sym->flags & RegVar) ? "-":"",
			    enum_elt->name);
		lsFinish(enum_gen);
		if (id_sym->flags & RegVar) {
		    for (enum_gen=lsStart(domain);
			 lsNext(enum_gen,(lsGeneric*)&enum_elt,&enum_handle)!=
			 LS_NOMORE;)
			fprintf(file, "0 - 0 - %s %s\n",
				enum_elt->name, enum_elt->name);
		    lsFinish(enum_gen);
		} else if (!deadlock_semantic) 
		    fprintf(file, "0 - 0 - -\n");
	    } else {
		
		domain = id_sym->id_type->specifier->u.enum_type->domain_list;
		fprintf(file, ".names %s %s %s %s\n", 
			ripple_ctrl->name->name, ripple_set->name->name, 
			(id_sym->flags & RegVar) ? latch_name : "",
			result->name->name);

		
		for (enum_gen=lsStart(domain);
		     lsNext(enum_gen,(lsGeneric*)&enum_elt,&enum_handle)!=
		     LS_NOMORE;)
		    fprintf(file, "1 %s %s %s\n", enum_elt->name, 
			    (id_sym->flags & RegVar) ? "-":"",
			    enum_elt->name);
		lsFinish(enum_gen);
		if (id_sym->flags & RegVar) {
		    for (enum_gen=lsStart(domain);
			 lsNext(enum_gen,(lsGeneric*)&enum_elt,&enum_handle)!=
			 LS_NOMORE;)
			fprintf(file, "0 - %s %s\n",
				enum_elt->name, enum_elt->name);
		    lsFinish(enum_gen);
		} else if (!deadlock_semantic) 
		    fprintf(file, "0 - -\n");
	    }
	}
    } else {
	if (lo > hi) {
	    
	    if (set_notation) {
		if (procedural_ctrl) {
		    fprintf(file, ".names %s %s %s %s %s %s\n", 
			    ripple_ctrl->name->name, ripple_set->name->name, 
			    procedural_ctrl->name->name,
			    procedural_term->name->name,
			    (id_sym->flags & RegVar) ? latch_name:"",
			    result->name->name);
		    fprintf(file, "1 - - - %s %s%s\n", 
			    (id_sym->flags & RegVar) ? "-":"",
			    HSIS_EQUAL, ripple_set->name->name);
		    fprintf(file, "0 - 1 - %s %s%s\n", 
			    (id_sym->flags & RegVar) ? "-":"",
			    HSIS_EQUAL, procedural_term->name->name);
		    if (id_sym->flags & RegVar) 
			fprintf(file, "0 - 0 - - %s%s\n", 
				HSIS_EQUAL, latch_name);
		    else if (!deadlock_semantic) 
			fprintf(file, "0 - 0 - -\n");
		} else {
		    fprintf(file, ".names %s %s %s %s\n", 
			    ripple_ctrl->name->name, ripple_set->name->name, 
			    (id_sym->flags & RegVar) ? latch_name:"",
			    result->name->name);
		    fprintf(file, "1 - %s %s%s\n", 
			    (id_sym->flags & RegVar) ? "-":"",
			    HSIS_EQUAL, ripple_set->name->name);
		    if (id_sym->flags & RegVar) 
			fprintf(file, "0 - - %s%s\n", HSIS_EQUAL, latch_name);
		    else if (!deadlock_semantic) 
			fprintf(file, "0 - -\n");
		}
	    } else {
		if (procedural_ctrl) {
		    fprintf(file, ".names %s %s %s %s %s %s\n", 
			    ripple_ctrl->name->name, ripple_set->name->name, 
			    procedural_ctrl->name->name, 
			    procedural_term->name->name,
			    (id_sym->flags & RegVar) ? latch_name:"",
			    result->name->name);
		    for (i=0; i<=1; i++)
			fprintf(file, "1 %d - - %s %d\n", 
				i, (id_sym->flags & RegVar) ? "-":"", i);
		    for (i=0; i<=1; i++)
			fprintf(file, "0 - 1 %d %s %d\n", 
				i, (id_sym->flags & RegVar) ? "-":"", i);
		    if (id_sym->flags & RegVar) 
			for (i=0; i<=1; i++) 
			    fprintf(file, "0 - 0 - %d %d\n", i, i);
		    else if (!deadlock_semantic) fprintf(file, "0 - 0 - -\n");
		} else {
		    fprintf(file, ".names %s %s %s %s\n", 
			    ripple_ctrl->name->name, ripple_set->name->name, 
			    (id_sym->flags & RegVar) ? latch_name:"",
			    result->name->name);
		    for (i=0; i<=1; i++)
			fprintf(file, "1 %d %s %d\n", 
				i, (id_sym->flags & RegVar) ? "-":"", i);
		    if (id_sym->flags & RegVar) 
			for (i=0; i<=1; i++) fprintf(file, "0 - %d %d\n", i,i);
		    else if (!deadlock_semantic) fprintf(file, "0 - -\n");
		}
	    }
	} else {
	    
	    if (set_notation) {
		if (procedural_ctrl) {
		    
		    fprintf(file, ".names %s ", ripple_ctrl->name->name);
		    for (bit_idx=lo; bit_idx<=hi; bit_idx++) {
			fprintf(file, "%s%s%d%s ", ripple_set->name->name,
				SEP_LBITSELECT, bit_idx, SEP_RBITSELECT);
		    }
		    fprintf(file, "%s ", procedural_ctrl->name->name);
		    for (bit_idx=lo; bit_idx<=hi; bit_idx++) {
			fprintf(file, "%s%s%d%s ", procedural_term->name->name,
				SEP_LBITSELECT, bit_idx, SEP_RBITSELECT);
		    }
		    if (id_sym->flags & RegVar) {
			for (bit_idx=lo; bit_idx<=hi; bit_idx++)
			    fprintf(file, "%s%s%d%s ", latch_name, 
				    SEP_LBITSELECT, bit_idx, SEP_RBITSELECT);
		    }
		    fprintf(file, "%s ", HSIS_ARROW);
		    for (bit_idx=lo; bit_idx<=hi; bit_idx++) {
			fprintf(file, "%s%s%d%s ", result->name->name,
				SEP_LBITSELECT, bit_idx, SEP_RBITSELECT);
		    }
		    fprintf(file, "\n");
		    
		    if (!(id_sym->flags & RegVar) && !deadlock_semantic) {
			fprintf(file, "%s ", HSIS_DEFAULT);
			for (bit_idx=lo;bit_idx<=hi;bit_idx++) 
			    fprintf(file, "- ");
			fprintf(file, "\n");
		    }
		    
		    fprintf(file, "1 ");
		    for (bit_idx=lo; bit_idx<=hi; bit_idx++) {
			fprintf(file, "- ");
		    }
		    fprintf(file, "- ");
		    for (bit_idx=lo; bit_idx<=hi; bit_idx++) {
			fprintf(file, "- ");
		    }
		    if (id_sym->flags & RegVar) 
			for (bit_idx=lo; bit_idx<=hi; bit_idx++) {
			    fprintf(file, "- ");
			}
		    for (bit_idx=lo; bit_idx<=hi; bit_idx++) {
			fprintf(file, "%s%s%s%d%s ", HSIS_EQUAL, 
				ripple_set->name->name,
				SEP_LBITSELECT, bit_idx, SEP_RBITSELECT);
		    }
		    fprintf(file, "\n");

		    fprintf(file, "0 ");
		    for (bit_idx=lo; bit_idx<=hi; bit_idx++) {
			fprintf(file, "- ");
		    }
		    fprintf(file, "1 ");
		    for (bit_idx=lo; bit_idx<=hi; bit_idx++) {
			fprintf(file, "- ");
		    }
		    if (id_sym->flags & RegVar) 
			for (bit_idx=lo; bit_idx<=hi; bit_idx++) {
			    fprintf(file, "- ");
			}
		    for (bit_idx=lo; bit_idx<=hi; bit_idx++) {
			fprintf(file, "%s%s%s%d%s ", HSIS_EQUAL, 
				procedural_term->name->name,
				SEP_LBITSELECT, bit_idx, SEP_RBITSELECT);
		    }
		    fprintf(file, "\n");
		    
		    if (!deadlock_semantic) {
			if (id_sym->flags & RegVar) {
			    fprintf(file, "0 ");
			    for (bit_idx=lo; bit_idx<=hi; bit_idx++) {
				fprintf(file, "- ");
			    }
			    fprintf(file, "0 ");
			    for (bit_idx=lo; bit_idx<=hi; bit_idx++) {
				fprintf(file, "- ");
			    }
			    for (bit_idx=lo; bit_idx<=hi; bit_idx++) {
				fprintf(file, "- ");
			    }
			    for (bit_idx=lo; bit_idx<=hi; bit_idx++) {
				fprintf(file, "%s%s%s%d%s ", HSIS_EQUAL, 
					latch_name,
					SEP_LBITSELECT,bit_idx,SEP_RBITSELECT);
			    }
			    fprintf(file, "\n");
			}
		    }
		} else {
		    
		    fprintf(file, ".names %s ", ripple_ctrl->name->name);
		    for (bit_idx=lo; bit_idx<=hi; bit_idx++) {
			fprintf(file, "%s%s%d%s ", ripple_set->name->name,
				SEP_LBITSELECT, bit_idx, SEP_RBITSELECT);
		    }
		    if (id_sym->flags & RegVar) {
			for (bit_idx=lo; bit_idx<=hi; bit_idx++)
			    fprintf(file, "%s%s%d%s ",
				    latch_name, 
				    SEP_LBITSELECT, bit_idx, SEP_RBITSELECT);
		    } 
		    fprintf(file, "%s ", HSIS_ARROW);
		    for (bit_idx=lo; bit_idx<=hi; bit_idx++) {
			fprintf(file, "%s%s%d%s ", result->name->name,
				SEP_LBITSELECT, bit_idx, SEP_RBITSELECT);
		    }
		    fprintf(file, "\n");
		    
		    if (!(id_sym->flags & RegVar) && !deadlock_semantic) {
			fprintf(file, "%s ", HSIS_DEFAULT);
			for (bit_idx=lo;bit_idx<=hi;bit_idx++) 
			    fprintf(file, "- ");
			fprintf(file, "\n");
		    }
		    
		    fprintf(file, "1 ");
		    for (bit_idx=lo; bit_idx<=hi; bit_idx++) {
			fprintf(file, "- ");
		    }
		    if (id_sym->flags & RegVar) 
			for (bit_idx=lo; bit_idx<=hi; bit_idx++) {
			    fprintf(file, "- ");
			}
		    for (bit_idx=lo; bit_idx<=hi; bit_idx++) {
			fprintf(file, "%s%s%s%d%s ", HSIS_EQUAL, 
				ripple_set->name->name,
				SEP_LBITSELECT, bit_idx, SEP_RBITSELECT);
		    }
		    fprintf(file, "\n");
		    
		    if (!deadlock_semantic) {
			if (id_sym->flags & RegVar) {
			    fprintf(file, "0 ");
			    for (bit_idx=lo; bit_idx<=hi; bit_idx++) {
				fprintf(file, "- ");
			    }
			    for (bit_idx=lo; bit_idx<=hi; bit_idx++) {
				fprintf(file, "- ");
			    }
			    for (bit_idx=lo; bit_idx<=hi; bit_idx++) {
				fprintf(file, "%s%s%s%d%s ", HSIS_EQUAL, 
					latch_name,
					SEP_LBITSELECT,bit_idx,SEP_RBITSELECT);
			    }
			    fprintf(file, "\n");
			}
		    }
		}
	    } else {
		if (procedural_ctrl) {
		    if (id_sym->flags & RegVar) {
			for (bit_idx=lo; bit_idx<=hi; bit_idx++) {
			    fprintf(file, ".names %s %s%s%d%s %s %s%s%d%s %s%s%d%s %s%s%d%s\n",
				    ripple_ctrl->name->name,
				    ripple_set->name->name, 
				    SEP_LBITSELECT, bit_idx, SEP_RBITSELECT,
				    procedural_ctrl->name->name,
				    procedural_term->name->name,
				    SEP_LBITSELECT, bit_idx, SEP_RBITSELECT,
				    latch_name, 
				    SEP_LBITSELECT, bit_idx, SEP_RBITSELECT,
				    result->name->name,
				    SEP_LBITSELECT, bit_idx, SEP_RBITSELECT);
			    for (i=0; i<=1; i++) 
				fprintf(file, "1 %d - - - %d\n", i, i);
			    for (i=0; i<=1; i++) 
				fprintf(file, "0 - 1 %d - %d\n", i, i);
			    if (!deadlock_semantic)
				for (i=0; i<=1; i++)
				    fprintf(file, "0 - 0 - %d %d\n", i, i);
			}
		    } else {
			for (bit_idx=lo; bit_idx<=hi; bit_idx++) {
			    fprintf(file, 
				".names %s %s%s%d%s %s %s%s%d%s %s%s%d%s\n",
				ripple_ctrl->name->name,
				ripple_set->name->name, 
				SEP_LBITSELECT, bit_idx, SEP_RBITSELECT,
				procedural_ctrl->name->name,
				procedural_term->name->name,
				SEP_LBITSELECT, bit_idx, SEP_RBITSELECT,
				result->name->name,
				SEP_LBITSELECT, bit_idx, SEP_RBITSELECT);
			    for (i=0; i<=1; i++) 
				fprintf(file, "1 %d - - %d\n", i, i);
			    for (i=0; i<=1; i++) 
				fprintf(file, "0 - 1 %d %d\n", i, i);
			    if (!deadlock_semantic) 
				fprintf(file, "0 - - - -\n");
			}
		    }
		} else {
		    if (id_sym->flags & RegVar) {
			for (bit_idx=lo; bit_idx<=hi; bit_idx++) {
			    fprintf(file, 
				    ".names %s %s%s%d%s %s%s%d%s %s%s%d%s\n",
				    ripple_ctrl->name->name,
				    ripple_set->name->name, 
				    SEP_LBITSELECT, bit_idx, SEP_RBITSELECT,
				    latch_name, 
				    SEP_LBITSELECT, bit_idx, SEP_RBITSELECT,
				    result->name->name,
				    SEP_LBITSELECT, bit_idx, SEP_RBITSELECT);
			    for (i=0; i<=1; i++) 
				fprintf(file, "1 %d - %d\n", i, i);
			    if (!deadlock_semantic)
				for (i=0; i<=1; i++)
				    fprintf(file, "0 - %d %d\n", i, i);
			}
		    } else {
			for (bit_idx=lo; bit_idx<=hi; bit_idx++) {
			    fprintf(file, 
				    ".names %s %s%s%d%s %s%s%d%s\n",
				    ripple_ctrl->name->name,
				    ripple_set->name->name, 
				    SEP_LBITSELECT, bit_idx, SEP_RBITSELECT,
				    result->name->name,
				    SEP_LBITSELECT, bit_idx, SEP_RBITSELECT);
			    for (i=0; i<=1; i++) 
				fprintf(file, "1 %d %d\n", i, i);
			    if (!deadlock_semantic) fprintf(file, "0 - -\n");
			}
		    }
		}
	    }
	}
    }
}

