/*

  Copyright (c) 1992, 1993
        Regents of the University of California
  All rights reserved.

  Use and copying of this software and preparation of derivative works
  based upon this software are permitted.  However, any distribution of
  this software or derivative works must include the above copyright 
  notice.

  This software is made available AS IS, and neither the Electronics
  Research Laboratory or the Universify of California make any
  warranty about the software, its performance or its conformity to
  any specification.

  Author: Szu-Tsung Cheng, stcheng@ic.Berkeley.EDU
          10/92
          10/93

  $Header: /projects/development/hsv/CVSRepository/vl2mv/src/parser/vl_reset.c,v 1.1.1.1 2001/07/09 23:22:40 fabio Exp $


*/

#include <stdio.h>
#include <math.h>
#include "util.h"
#include "array.h"
#include "list.h"
#include "st.h"
#include "set.h"
#include "vl_types.h"
#include "vl_defs.h"
#include "vlr_int.h"
#include "vl_fg_defs.h"
#include "vl_create.h"
#include "vl_write.h"
#include "vl_write_util.h"
#include "vl_vardecl.h"

extern int dumpSMVPlus;
extern int set_notation;
extern int Use_Abstraction;
extern int smartEvent;
extern int UninterpretedFunction;
extern int vis_nond;
extern FILE *lib_file;

static void warn_uninit_vars ARGS((char *latch_name));

void reset_mvar_latch(FILE *file, int non_block_var, vl_id_range *id_sym,
		      int lo, int hi, char *lname)
{
    int dummy;
    int idx, idx_lo, idx_hi;
    lsList domain;
    lsGen enum_gen;
    lsHandle enum_handle;
    vl_enumerator *enum_elt;
    vl_id_range *comb_id_sym;
    char latch_name[MAXSTRLEN];

    if (st_lookup(vl_currentModule->combVar_st, lname, (char**)&comb_id_sym))
	return;
    
    domain = id_sym->id_type->specifier->u.enum_type->domain_list;
    if (!(id_sym->range)) { 
	if (non_block_var) sel_var(lname);
	strip_char(lname, SEP_SEL_VAR);
	sprintf(latch_name, lname);
	if (st_lookup(vl_currentModule->quasi_st,lname,(char**)&dummy)) {
	    strcat(latch_name, SEP_GATEPIN);
	    strcat(latch_name, PIN_PS);
	}
	
	if (dumpSMVPlus) {
	    
	    if (lsLength(id_sym->initial) > 0) {
		int i;
		vl_term *init_term;
		lsGen gen;
		lsHandle handle;

		fprintf(file, "%s %s( %s )%s",
			SMV_ASSIGN, SMV_INIT, latch_name, SMV_COL_ASSIGN);
		for (gen=lsStart(id_sym->initial), i=0; 
		     lsNext(gen, (lsGeneric*)&init_term, &handle)!=LS_NOMORE;
		     i++)
		    if (i==0)
			fprintf(file, "%s ", init_term->name->name);
		lsFinish(gen);
		fprintf(file, "\n");
	    } else {
		int i;
		fprintf(file, "%s %s( %s )%s%s", SMV_ASSIGN, SMV_INIT, 
			latch_name, SMV_COL_ASSIGN, SMV_LBRACE);
		for (enum_gen=lsStart(domain), i=0;
		     lsNext(enum_gen,(lsGeneric*)&enum_elt,&enum_handle)!=
		         LS_NOMORE; 
		     i++)
		    if (i==0)
			fprintf(file, "%s", enum_elt->name);
		    else
			fprintf(file, "%s%s", SMV_COMMA, enum_elt->name);
		lsFinish(enum_gen);
	    }
	} else {
	    
	    if (lsLength(id_sym->initial) > 0) {
		int i;
		vl_term *init_term;
		lsGen gen;
		lsHandle handle;

		fprintf(file, ".r ");
		for (gen=lsStart(id_sym->initial), i=0; 
		     lsNext(gen, (lsGeneric*)&init_term, &handle)!=LS_NOMORE;
		     i++)
		    fprintf(file, "%s ", init_term->name->name);
		lsFinish(gen);
		fprintf(file, "%s", latch_name);
	    } else
		fprintf(file, ".r %s", latch_name);
	    fprintf(file, "\n");
	    if (lsLength(id_sym->initial) == 0)
		if (vis_nond)
		    warn_uninit_vars(lname);
	    if (set_notation) {
		if (lsLength(id_sym->initial) > 0) {
		    int i;
		    vl_term *init_term;
		    for (i=0; i<lsLength(id_sym->initial); i++)
			fprintf(file, "- ");
		    lsLastItem(id_sym->initial, (lsGeneric*)&init_term, 0);
		    if (shift_Support)
		        fprintf(file, "( %s )\n", 
				init_term->name->name);
		    else
		        fprintf(file, "%s%s\n", 
				HSIS_EQUAL, init_term->name->name);
		} else {
		    fprintf(file, "-\n");
		}
	    } else {
		for (enum_gen=lsStart(domain);
		     lsNext(enum_gen,(lsGeneric*)&enum_elt,&enum_handle)!=
		         LS_NOMORE;)
		    if (lsLength(id_sym->initial) > 0)
			fprintf(file,"%s %s\n",enum_elt->name,enum_elt->name);
		    else
			fprintf(file, "%s\n", enum_elt->name);
		lsFinish(enum_gen);
	    }
	}
    } else { 
	idx_lo = vl_eval_expr(id_sym->range->left);
	if (id_sym->range->right)
	    idx_hi =
		vl_eval_expr(id_sym->range->right);
	else
	    idx_hi = idx_lo;
	
	for (idx=idx_lo; idx<=idx_hi; idx++) {
	    if (dumpSMVPlus) {
		vl_term *init_term;
		
		if (non_block_var) sel_var(lname);
		fprintf(file, "%s %s(%s %s%d%s)%s", SMV_ASSIGN, SMV_INIT,
			lname, SEP_LARRAY, idx, SEP_RARRAY, SMV_COL_ASSIGN);
		if (lsLength(id_sym->initial) > 0) {
		    lsLastItem(id_sym->initial, (lsGeneric*)&init_term, 0);
		    fprintf(file, "%s %s%d%s", init_term->name->name,
			    SEP_LARRAY, idx, SEP_RARRAY);
		} else {
		    smv_dc(file, id_sym->id_type, 0, -1);
		}
		fprintf(file, " ;\n");
	    } else {
		
		if (lsLength(id_sym->initial) > 0) {
		    int i;
		    vl_term *init_term;
		    lsGen gen;
		    lsHandle handle;
		    fprintf(file, ".r "); 
		    for (gen=lsStart(id_sym->initial), i=0;
			 lsNext(gen, (lsGeneric*)&init_term, &handle) != 
			     LS_NOMORE;
			 i++)
			fprintf(file, "%s%s%d%s ",
				init_term->name->name, 
				SEP_LARRAY, idx, SEP_RARRAY);
		    lsFinish(gen);
		    fprintf(file, "%s%s%d%s",
			    non_block_var?sel_var(lname):lname,
			    SEP_LARRAY, idx, SEP_RARRAY);
		} else {
		    fprintf(file, ".r %s%s%d%s",
			    non_block_var?
			    sel_var(lname):lname,
			    SEP_LARRAY, idx, SEP_RARRAY);
		}
		strip_char(lname,SEP_SEL_VAR);
		if (st_lookup(vl_currentModule->quasi_st,lname,(char**)&dummy))
		    fprintf(file, "%s%s", SEP_GATEPIN, PIN_PS);
		fprintf(file, "\n");
		if (lsLength(id_sym->initial) == 0)
		    if (vis_nond)
			warn_uninit_vars(lname);
		if (set_notation) {
		    if (lsLength(id_sym->initial)>0) {
			int i, j, k;
			vl_term *init_term;
			vl_enumerator *first_enum;
			lsGen gen;
			lsHandle handle;
			lsFirstItem(domain, (lsGeneric*)&first_enum, 0);
			fprintf(file, "%s %s\n", HSIS_DEFAULT,
				first_enum->name);
			for (gen=lsStart(id_sym->initial), j=0;
			     lsNext(gen, (lsGeneric*)&init_term, &handle) != 
			     LS_NOMORE; j++) {
			    for (enum_gen=lsEnd(domain), i=0;
				 lsPrev(enum_gen, (lsGeneric*)&enum_elt,
					&enum_handle) != LS_NOMORE &&
				 i < lsLength(domain)-1; i++) {
				for (k=0; k<j; k++)
				    fprintf(file, "%s ", first_enum->name);
				fprintf(file, "%s ", enum_elt->name);
				k++;
				for (; k<lsLength(id_sym->initial); k++)
				    fprintf(file, "- ");
				if (shift_Support)
				    fprintf(file, "( %s%s%d%s )\n", 
					init_term->name->name,
					SEP_LARRAY, idx, SEP_RARRAY);
				else
				    fprintf(file, "%s%s%s%d%s\n", 
					HSIS_EQUAL, init_term->name->name,
					SEP_LARRAY, idx, SEP_RARRAY);
			    }
			    lsFinish(enum_gen);
			}
			lsFinish(gen);
		    } else {
			fprintf(file, "-\n");
		    }
		} else {
		    for (enum_gen=lsStart(domain);
			 lsNext(enum_gen,
				(lsGeneric*)&enum_elt,&enum_handle)!=
			     LS_NOMORE;)
			if (lsLength(id_sym->initial) > 0) {
			    int i;
			    for (i=0; i<lsLength(id_sym->initial)-1; i++)
				fprintf(file, "- ");
			    fprintf(file, "%s %s\n",
				    enum_elt->name, enum_elt->name);
			} else 
			    fprintf(file, "%s\n", enum_elt->name);
		    lsFinish(enum_gen);
		}
	    }
	}
    }
    
    
    lo = lo;
    hi = hi;
}


void reset_bin_scalar_latch(FILE *file, int non_block_var,
			    vl_id_range *id_sym, char *lname)
{
    int dummy;
    int idx, idx_lo, idx_hi;
    vl_id_range *comb_id_sym;
    char latch_name[MAXSTRLEN];

    if (st_lookup(vl_currentModule->combVar_st, lname, (char**)&comb_id_sym))
	return;

    if (lsLength(id_sym->initial) == 0)
	if (vis_nond)
	    warn_uninit_vars(lname);
    if (!id_sym->range) { 
	if (non_block_var) sel_var(lname);
	strip_char(lname,SEP_SEL_VAR);
	sprintf(latch_name, "%s", lname);
	if (st_lookup(vl_currentModule->quasi_st,lname,(char**)&dummy)) {
	    strcat(latch_name,SEP_GATEPIN);
	    strcat(latch_name,PIN_PS);
	}

	if (lsLength(id_sym->initial)>0) {
	    if (dumpSMVPlus) {
		
		vl_term *init_term;
		lsLastItem(id_sym->initial, (lsGeneric*)&init_term, 0);
		fprintf(file, "%s %s( %s )%s%s ;\n", 
			SMV_ASSIGN, SMV_INIT, latch_name, SMV_COL_ASSIGN, 
			init_term->name->name);
	    } else {
		
		vl_term *init_term;
		lsLastItem(id_sym->initial, (lsGeneric*)&init_term, 0);
                if (shift_Support) {
                    fprintf(file, "i0=%s ", init_term->name->name);
                    fprintf(lib_file, ".inputs i0\n");
                    fprintf(lib_file, ".outputs o\n");
                    fprintf(lib_file, ".mv o %d\n", 2);
                    fprintf(lib_file, ".state o\n");
                    fprintf(lib_file, ".r o 0\n");
                } else {
                    fprintf(file, ".r %s %s\n0 0\n1 1\n",
                            init_term->name->name, latch_name);
                }
	    }
	} else if ((id_sym->flags & EventVar) && !smartEvent) {
	    if (dumpSMVPlus) 
		fprintf(file, "%s %s( %s%s%s )%s%d;\n",
			SMV_ASSIGN, SMV_INIT, latch_name,SEP_GATEPIN,PIN_EVENT,
			SMV_COL_ASSIGN, 0);
	    else 
		fprintf(file, ".r %s%s%s\n0\n", 
			latch_name,SEP_GATEPIN,PIN_EVENT);
	} else if ((id_sym->flags & EventVar) && smartEvent) {
	} else {
	    
	    if (dumpSMVPlus) 
		fprintf(file, "%s %s( %s )%s%s;\n",
			SMV_ASSIGN, SMV_INIT, latch_name, SMV_COL_ASSIGN,
			SMV_BIN_DC);
	    else {
              if (shift_Support) {
                    fprintf(lib_file, ".outputs o\n");
                    fprintf(lib_file, ".mv o %d\n", 2);
                    fprintf(lib_file, ".state o\n");
                    fprintf(lib_file, ".r o 0\n");
              } else {
                  fprintf(file, ".r %s\n0\n1\n", latch_name);
              }
            }
	}
    } else {  
	idx_lo = vl_eval_expr(id_sym->range->left);
	if (id_sym->range->right)
	    idx_hi =
		vl_eval_expr(id_sym->range->right);
	else
	    idx_hi = idx_lo;
	
	for (idx=idx_lo; idx<=idx_hi; idx++) {
	    if (dumpSMVPlus) {
		
		if (non_block_var) sel_var(lname);
		fprintf(file, "%s %s(%s %s%d%s)%s", SMV_ASSIGN, SMV_INIT,
			lname, SEP_LARRAY, idx, SEP_RARRAY, SMV_COL_ASSIGN);
		if (lsLength(id_sym->initial) > 0) {
		    int i;
		    vl_term *init_term;
		    lsGen gen;
		    lsHandle handle;
		    for (gen = lsStart(id_sym->initial), i=0; 
			 lsNext(gen, (lsGeneric*)&init_term, &handle) != 
			     LS_NOMORE; 
			 i++)
			if (i==0) {
			    fprintf(file, "%s%s%d%s ", 
				    init_term->name->name,
				    SEP_LARRAY, idx, SEP_RARRAY);
			} else {
			    fprintf(file, "%s %s%s%d%s ", SMV_OR, 
				    init_term->name->name,
				    SEP_LARRAY, idx, SEP_RARRAY);
			}
		    lsFinish(gen);
		} else
		    smv_dc(file, id_sym->id_type, 0, -1);
		fprintf(file, " ;\n");
	    } else{
		
		if (lsLength(id_sym->initial) > 0) {
		    vl_term *init_term;
		    lsGen gen;
		    lsHandle handle;
		    fprintf(file, ".r ");
		    for (gen=lsStart(id_sym->initial);
			 lsNext(gen, (lsGeneric*)&init_term, &handle) 
			     != LS_NOMORE; )
			fprintf(file, "%s%s%d%s ", 
				init_term->name->name,
				SEP_LARRAY, idx, SEP_RARRAY);
		    lsFinish(gen);
		    fprintf(file, "%s%s%d%s", 
			    non_block_var?sel_var(lname):lname,
			    SEP_LARRAY, idx, SEP_RARRAY);
		} else 
		    fprintf(file, ".r %s%s%d%s",
			    non_block_var?
			    sel_var(lname):lname,
			    SEP_LARRAY, idx, SEP_RARRAY);
		strip_char(lname,SEP_SEL_VAR);
		if (st_lookup(vl_currentModule->quasi_st,lname,(char**)&dummy))
		    fprintf(file, "%s%s", SEP_GATEPIN, PIN_PS);
		fprintf(file, "\n");
		if (lsLength(id_sym->initial) > 0) {
		    int i, j;
		    fprintf(file, "%s 0\n", HSIS_DEFAULT);
		    for (i=0; i<lsLength(id_sym->initial); i++) {
			for (j=0; j<lsLength(id_sym->initial); j++)
			    fprintf(file, "%c ", (i==j)?'1':'0');
			fprintf(file, "1\n");
		    }
		} else
		    fprintf(file, "0\n1\n");
	    }
	}
    }
}


void reset_bin_vector_latch(FILE *file, int non_block_var,
			    vl_id_range *id_sym,
			    int lo, int hi, char *lname)
{
    int i=0;
    int idx, idx_lo, idx_hi;
    vl_id_range *comb_id_sym;
    int dummy;
    extern int combinationalReduction;

    if (st_lookup(vl_currentModule->combVar_st, lname, (char**)&comb_id_sym))
	return;

    if (lsLength(id_sym->initial) == 0)
	if (vis_nond)
	    warn_uninit_vars(lname);

    if (id_sym->syndrome_expr_list)
	if (lsLength(id_sym->syndrome_expr_list) == 0)
	    if (id_sym->rst_syndrome_expr_list)
		if (lsLength(id_sym->rst_syndrome_expr_list) == 0)
		    if (combinationalReduction)
			return;

    if (Use_Abstraction || UninterpretedFunction) {
	if (!id_sym->range) { 
	    if (dumpSMVPlus) {
		
		if (lsLength(id_sym->initial)>0) {
		    if (non_block_var) sel_var(lname);
		    if (hi < lo) {
			
			int i;
			vl_term *init_term;
			lsGen gen;
			lsHandle handle;
			fprintf(file, "%s %s( %s )%s ", SMV_ASSIGN, 
				SMV_INIT, lname, SMV_COL_ASSIGN);
			for (gen=lsStart(id_sym->initial), i=0;
			     lsNext(gen, (lsGeneric*)&init_term, &handle)
			         != LS_NOMORE; i++) {
			    if (i==0)
				fprintf(file, "%s ", init_term->name->name);
			    else
				fprintf(file, "%s %s ", SMV_OR,
					init_term->name->name);
			}
			lsFinish(gen);
		    } else {
			
			int i;
			vl_term *init_term;
			lsGen gen;
			lsHandle handle;
			fprintf(file, "%s (%s%s%d;%s%s%d;%s%s%s%s%d) %s %s(%s[%s])%s ",
				SMV_FOR, 
			            SMV_INDEX, SMV_EQUAL, lo,
			            SMV_INDEX, SMV_LE, hi,
			            SMV_INDEX, SMV_EQUAL, SMV_INDEX,SMV_PLUS,1,
				SMV_ASSIGN, 
				SMV_INIT, lname, SMV_INDEX, SMV_COL_ASSIGN);
			for (gen=lsStart(id_sym->initial), i=0;
			     lsNext(gen, (lsGeneric*)&init_term, &handle)
			         != LS_NOMORE; i++) {
			    if (i==0)
				fprintf(file, "%s[%s] ", init_term->name->name,
					SMV_INDEX);
			    else
				fprintf(file, "%s %s[%s] ", SMV_OR,
					init_term->name->name, SMV_INDEX);
			}
			lsFinish(gen);
		    }
		    fprintf(file, " ;\n");
		} else {
		    
		}
	    } else {
		
		if (lsLength(id_sym->initial) > 0) {
		    int i;
		    vl_term *init_term;
		    lsGen gen;
		    lsHandle handle;
		    fprintf(file, ".r ");
		    for (gen=lsStart(id_sym->initial), i=0;
			     lsNext(gen, (lsGeneric*)&init_term, &handle)
			         != LS_NOMORE; i++) {
			fprintf(file, "%s ", init_term->name->name);
		    }
		    lsFinish(gen);
		    fprintf(file, "%s", non_block_var?sel_var(lname):lname);
		} else {
		    fprintf(file, ".r %s %s%d%s",
			    non_block_var?sel_var(lname):lname,
			    SEP_LBITSELECT, i, SEP_RBITSELECT);
		}
		strip_char(lname,SEP_SEL_VAR);
		if (st_lookup(vl_currentModule->quasi_st,lname,(char**)&dummy))
		    fprintf(file, "%s%s", SEP_GATEPIN, PIN_PS);
		fprintf(file, "\n");
		if (set_notation) {
		    if (lsLength(id_sym->initial) > 0) {
			int i, j;
			fprintf(file, "%s 0\n", HSIS_DEFAULT);
			for (i=0; i<lsLength(id_sym->initial); i++) {
			    for (j=0; j<lsLength(id_sym->initial); j++)
				fprintf(file, "%c ", (i==j)?'1':'-');
			    fprintf(file, "1\n");
			}
		    } else 
			fprintf(file, "-\n");
		} else {
		    if (lsLength(id_sym->initial)>0) {
			for (i=0; i<ipower(2,(hi-lo+1)); i++)
			    fprintf(file, "%d %d\n", i, i);
		    } else
			fprintf(file, "-\n");
		}
	    }
	} else {  
	    idx_lo = vl_eval_expr(id_sym->range->left);
	    if (id_sym->range->right)
		idx_hi = vl_eval_expr(id_sym->range->right);
	    else 
		idx_hi = idx_lo;
	    
	    for (idx=idx_lo; idx<=idx_hi; idx++) {
		if (dumpSMVPlus) {
		    
		    if (non_block_var) sel_var(lname);
		    fprintf(file, "%s %s(%s %s%d%s)%s", SMV_ASSIGN, SMV_INIT,
			    lname, SEP_LARRAY, idx, SEP_RARRAY, 
			    SMV_COL_ASSIGN);
		    if (lsLength(id_sym->initial) > 0) {
			int i;
			vl_term *init_term;
			lsGen gen;
			lsHandle handle;
			for (gen=lsStart(id_sym->initial), i=0;
			     lsNext(gen, (lsGeneric*)&init_term, &handle)
			     != LS_NOMORE; i++) {
			    if (i==0)
				fprintf(file, "%s ", init_term->name->name);
			    else
				fprintf(file, "%s %s ", SMV_OR,
					init_term->name->name);
			}
			lsFinish(gen);
		    } else
			smv_dc(file, id_sym->id_type, hi, lo);
		    fprintf(file, " ;\n");
		} else {
		    
		    if (lsLength(id_sym->initial) > 0) {
			int i;
			vl_term *init_term;
			lsGen gen;
			lsHandle handle;
			fprintf(file, ".r ");
			for (gen=lsStart(id_sym->initial), i=0;
			     lsNext(gen, (lsGeneric*)&init_term, &handle)
			     != LS_NOMORE; i++) {
			    fprintf(file, " %s%s%d%s", init_term->name->name,
				    SEP_LARRAY, idx, SEP_RARRAY);
			}
			lsFinish(gen);
			fprintf(file, " %s%s%d%s", 
				non_block_var?sel_var(lname):lname,
				SEP_LARRAY, idx, SEP_RARRAY);
		    } else 
			fprintf(file, ".r %s%s%d%s",
				non_block_var?
				sel_var(lname):lname,
				SEP_LARRAY, idx, SEP_RARRAY);
		    strip_char(lname,SEP_SEL_VAR);
		    if (st_lookup(vl_currentModule->quasi_st,
				  lname,(char**)&dummy))
			fprintf(file, "%s%s", SEP_GATEPIN, PIN_PS);
		    fprintf(file, "\n");
		    if (set_notation) {
			if (id_sym->initial)
			    if (shift_Support)
			        fprintf(file, "- ( %s%d%s )\n", 
				    SEP_LBITSELECT, idx, SEP_RBITSELECT);
			    else
			        fprintf(file, "- %s%s%d%s\n", HSIS_EQUAL, 
				    SEP_LBITSELECT, idx, SEP_RBITSELECT);
			else 
			    fprintf(file, "-\n");
		    } else {
			if (id_sym->initial)
			    for (i=0; i<ipower(2,(hi-lo+1)); i++)
				fprintf(file, "%d %d\n", i, i);
			else 
			    fprintf(file,"-\n");
		    }
		}
	    }
	}
    } else {
	for (i=lo; i<=hi; i++) {
	    if (!id_sym->range) { 
		if (dumpSMVPlus) {
		    
		    if (i==lo) {
			
			if (lsLength(id_sym->initial)>0) {
			    if (non_block_var) sel_var(lname);
			    if (hi < lo) {
				
				int i;
				vl_term *init_term;
				lsGen gen;
				lsHandle handle;
				fprintf(file, "%s %s( %s )%s", SMV_ASSIGN, 
					SMV_INIT, lname, SMV_COL_ASSIGN);
				for (gen=lsStart(id_sym->initial), i=0;
				     lsNext(gen,(lsGeneric*)&init_term,&handle)
				         != LS_NOMORE; i++) {
				    if (i==0)
					fprintf(file, "%s ",
						init_term->name->name);
				    else
					fprintf(file, "%s %s ", SMV_OR,
						init_term->name->name);
				}
				lsFinish(gen);
			    } else {
				
				int i;
				vl_term *init_term;
				lsGen gen;
				lsHandle handle;
				fprintf(file, "%s (%s%s%d;%s%s%d;%s%s%s%s%d) %s %s(%s [%s])%s", 
					SMV_FOR, 
					SMV_INDEX, SMV_EQUAL, lo,
					SMV_INDEX, SMV_LE, hi,
					SMV_INDEX, SMV_EQUAL, 
					    SMV_INDEX,SMV_PLUS,1,
					SMV_ASSIGN, 
					SMV_INIT, lname, SMV_INDEX, 
					SMV_COL_ASSIGN);
				for (gen=lsStart(id_sym->initial), i=0;
				     lsNext(gen,(lsGeneric*)&init_term,&handle)
				         != LS_NOMORE; i++) {
				    if (i==0)
					fprintf(file, "%s [%s] ", 
						init_term->name->name,
						SMV_INDEX);
				    else
					fprintf(file, "%s %s [%s] ", SMV_OR,
						init_term->name->name,
						SMV_INDEX);
				}
				lsFinish(gen);
			    }
			    fprintf(file, " ;\n");
			} else {
			    
			}
		    }
		} else {
		    
		    if (shift_Support) {
			vl_term *init_term;
			if (i!=lo) continue;
			if (lsLength(id_sym->initial) > 0) {
			    lsFirstItem(id_sym->initial, 
					(lsGeneric*)&init_term, 0);
			    fprintf(file, "i0=%s ", init_term->name->name);
			    fprintf(lib_file, ".inputs i0\n");
			} 
			fprintf(lib_file, ".outputs o\n");
                        fprintf(lib_file, ".mv o %d\n", ipower(2,hi-lo+1));
			fprintf(lib_file, ".state o\n");
			fprintf(lib_file, ".r o ");
		    } else if (lsLength(id_sym->initial) > 0) {
			int k;
			vl_term *init_term;
			lsGen gen;
			lsHandle handle;
			fprintf(file, ".r ");
			for (gen=lsStart(id_sym->initial), k=0;
			     lsNext(gen, (lsGeneric*)&init_term, &handle)
			         != LS_NOMORE; k++) {
			    fprintf(file, "%s%s%d%s ", init_term->name->name,
				    SEP_LBITSELECT, i, SEP_RBITSELECT);
			}
			lsFinish(gen);
			fprintf(file, "%s%s%d%s", 
				non_block_var?sel_var(lname):lname,
				SEP_LBITSELECT, i, SEP_RBITSELECT);

		    } else {
			fprintf(file, ".r %s%s%d%s",
				non_block_var?
				sel_var(lname):lname,
				SEP_LBITSELECT, i, SEP_RBITSELECT);
		    }
		    strip_char(lname,SEP_SEL_VAR);
		    if (st_lookup(vl_currentModule->quasi_st,
				  lname,(char**)&dummy))
			fprintf(file, "%s%s", SEP_GATEPIN, PIN_PS);
		    if (!shift_Support)
			fprintf(file, "\n");
		    if (set_notation) {
			if (shift_Support) {
			    if (lsLength(id_sym->initial) > 0) {
				fprintf(lib_file, "0\n");
			    } else {
				fprintf(lib_file, "-\n");
			    }
			} else if (lsLength(id_sym->initial) > 0) {
			    int i, j;
			    fprintf(file, "%s 0\n", HSIS_DEFAULT);
			    for (i=0; i<lsLength(id_sym->initial); i++) {
				for (j=0; j<lsLength(id_sym->initial); j++)
				    fprintf(file, "%c ", (i==j)?'1':'-');
				fprintf(file, "1\n");
			    }
			} else {
			    fprintf(file, "-\n");
			}
		    } else {
			if (lsLength(id_sym->initial) > 0) {
			    int i, j;
			    for (i=0; i<lsLength(id_sym->initial); i++) {
				for (j=0; j<lsLength(id_sym->initial); j++)
				    fprintf(file, "%c ", (i==j)?'1':'-');
				fprintf(file, "1\n");
			    }
			    for (i=0; i<lsLength(id_sym->initial); i++)
				fprintf(file, "0 ");
			    fprintf(file, "0\n");
			} else {
			    fprintf(file, "0\n1\n");
			}
		    }
		}
	    } else {  
		idx_lo = vl_eval_expr(id_sym->range->left);
		if (id_sym->range->right)
		    idx_hi = vl_eval_expr(id_sym->range->right);
		else 
		    idx_hi = idx_lo;
		
		for (idx=idx_lo; idx<=idx_hi; idx++) {
		    if (dumpSMVPlus) {
			
			if (i==lo) {
			    
			    
			    if (non_block_var) sel_var(lname);
			    if (hi <lo) {
			        
			        fprintf(file, "%s %s(%s %s%d%s)%s", 
					SMV_ASSIGN, SMV_INIT,
					lname, SEP_LARRAY, idx, SEP_RARRAY,
					SMV_COL_ASSIGN);
				if (lsLength(id_sym->initial) > 0) {
				    int i;
				    vl_term *init_term;
				    lsGen gen;
				    lsHandle handle;
				    for (gen=lsStart(id_sym->initial), i=0;
					 lsNext(gen,(lsGeneric*)&init_term,&handle)
				         != LS_NOMORE; i++) {
					if (i==0) 
					    fprintf(file, "%s ",
						    init_term->name->name);
					else
					    fprintf(file, "%s %s ", SMV_OR, 
						    init_term->name->name);
				    }
				    lsFinish(gen);
				} else 
				    smv_dc(file, id_sym->id_type, hi, lo);
				fprintf(file, " ;\n");
			    } else {
			        
				int i;
				vl_term *init_term;
				lsGen gen;
				lsHandle handle;
				fprintf(file, "%s (%s%s%d;%s%s%d;%s%s%s%s%d)\n\t%s %s(%s [%d][%s])%s", 
					SMV_FOR,
					SMV_INDEX, SMV_EQUAL, lo,
					SMV_INDEX, SMV_LE, hi,
					SMV_INDEX, SMV_EQUAL, SMV_INDEX,SMV_PLUS,1,
					SMV_ASSIGN, SMV_INIT, 
					lname, idx, SMV_INDEX,
					SMV_COL_ASSIGN);
				if (lsLength(id_sym->initial) > 0) {
				    for (gen=lsStart(id_sym->initial), i=0;
					 lsNext(gen,(lsGeneric*)&init_term,
						&handle)
					 != LS_NOMORE; i++) {
					if (i==0)
					    fprintf(file, "%s [%s] ",
						    init_term->name->name,
						    SMV_INDEX);
					else 
					    fprintf(file, "%s %s [%s] ",
						    SMV_OR,
						    init_term->name->name,
						    SMV_INDEX);
				    }
				    lsFinish(gen);
				} else { 
				    smv_dc(file, id_sym->id_type, hi, lo);
				}
				fprintf(file, " ;\n");
			    }
			}
		    } else {
			
			if (lsLength(id_sym->initial) > 0) {
			    int k;
			    vl_term *init_term;
			    lsGen gen;
			    lsHandle handle;
			    fprintf(file, ".r ");
			    for (gen=lsStart(id_sym->initial), k=0;
				 lsNext(gen,(lsGeneric*)&init_term,&handle)
				     != LS_NOMORE; k++) {
				fprintf(file, "%s%s%d%s%s%d%s ",
					init_term->name->name,
					SEP_LARRAY, idx, SEP_RARRAY,
					SEP_LBITSELECT, i, SEP_RBITSELECT);
			    }
			    lsFinish(gen);
			    fprintf(file, "%s%s%d%s%s%d%s",
				    non_block_var?sel_var(lname):lname,
				    SEP_LARRAY, idx, SEP_RARRAY,
				    SEP_LBITSELECT, i, SEP_RBITSELECT);
			} else 
			    fprintf(file, ".r %s%s%d%s%s%d%s",
				    non_block_var?
				    sel_var(lname):lname,
				    SEP_LARRAY, idx, SEP_RARRAY,
				    SEP_LBITSELECT, i, SEP_RBITSELECT);
			strip_char(lname,SEP_SEL_VAR);
			if (st_lookup(vl_currentModule->quasi_st,
				      lname,(char**)&dummy))
			    fprintf(file, "%s%s", SEP_GATEPIN, PIN_PS);
			fprintf(file, "\n");
			if (set_notation) {
			    if (lsLength(id_sym->initial) > 0) {
				int i, j;
				fprintf(file, "%s 0\n", HSIS_DEFAULT);
				for (i=0; i<lsLength(id_sym->initial); i++) {
				    for (j=0; j<lsLength(id_sym->initial); j++)
					fprintf(file, "%c ", (i==j)?'1':'-');
				    fprintf(file, "1\n");
				}
			    } else {
				fprintf(file, "-\n");
			    }
			} else {
			    if (lsLength(id_sym->initial) > 0) {
				int i, j;
				for (i=0; i<lsLength(id_sym->initial); i++) {
				    for (j=0; j<lsLength(id_sym->initial); j++)
					fprintf(file, "%c ", (i==j)?'1':'-');
				    fprintf(file, "1\n");
				}
				for (i=0; i<lsLength(id_sym->initial); i++)
				    fprintf(file, "0 ");
				fprintf(file, "0\n");
			    } else 
				fprintf(file,"0\n1\n");
			}
		    }
		}
	    }
	}
    }
}


static void warn_uninit_vars(char *latch_name)
{
    char buf[MAXSTRLEN];

    sprintf(buf, "'%s': variable '%s' is uninitialized", 
	    vl_currentModule->name->name, latch_name);
    yylineno = -1;
    fprintf(stderr, "%s, be careful\n", buf);
}
