/*

  Copyright (c) 1992, 1993
        Regents of the University of California
  All rights reserved.

  Use and copying of this software and preparation of derivative works
  based upon this software are permitted.  However, any distribution of
  this software or derivative works must include the above copyright 
  notice.

  This software is made available AS IS, and neither the Electronics
  Research Laboratory or the Universify of California make any
  warranty about the software, its performance or its conformity to
  any specification.

  Author: Szu-Tsung Cheng, stcheng@ic.Berkeley.EDU
          10/92
          10/93

  $Header: /projects/development/hsv/CVSRepository/vl2mv/src/parser/vl_types.h,v 1.3 2002/06/25 23:54:44 harikris Exp $


*/

#ifndef _VL_TYPES
#define _VL_TYPES

#define MAXINLEN 10            


typedef struct vl_id_range {
    short dummy_type;           
                                
    char * name;
    short flags;                
    struct vl_range *range;	
       
    lsList initial;             
    lsList syndrome_expr_list;  
    lsList rst_syndrome_expr_list; 
    st_table *symbolic_values;  
    void * mpg_master_exp;      
    struct vl_type *id_type;    
    struct vl_term *edge_trigger;
    st_table *sensitiveList;    
    char *unintType;            
} vl_id_range, *vl_id_rangePtr;


typedef struct vl_type {
    char *name;
    struct vl_type_specifier *specifier;
} vl_type, *vl_typePtr;


typedef struct vl_type_specifier {
    short typeform;             
    union {
	struct vl_enum_type *enum_type;
    } u;
} vl_type_specifier, *vl_type_specifierPtr;


typedef struct vl_enum_type {
    char *name;
    st_table *domain_st;
    lsList domain_list;
} vl_enum_type, *vl_enum_typePtr;

typedef struct vl_enumerator {
    char *name;
    int val;
} vl_enumerator, *vl_enumeratorPtr;


typedef struct vl_desc {
    char *filename;
    st_table *type_st;          
    lsList modules;		
    st_table *mp_st;		
    lsHandle handle;	        
    st_table *decl_st;          
                                
                                
    st_table *lib_st;           
    set_t *mp_undefined;        
    st_table *fg_vars_st;       
    st_table *mod_holes;        
                                
    st_table *synclock_st;      
} vl_desc, *vl_descPtr;



typedef struct vl_module {
    short type;			
    short unsigned flags;	
    vl_id_range *name;	        
    lsList ports;	        
    st_table *sig_st;		
    st_table *uninit_set;       
    st_table *param_st;         
    lsList param_list;          
    st_table *inst_st;          
    st_table *latch_st;         
    st_table *quasi_st;         
    st_table *func_st;          
    st_table *combVar_st;       
                                
    st_table *seqVar_st;        
                                
    lsList mod_items;		
    struct vl_event_expr *clk;  
    int syndrome_width;         
    int rst_syndrome_width;     
    lsList flow_graphs;         
                                
    st_table *task_st;          
    int dup_count;              
                                
    int visited;                
} vl_module, *vl_modulePtr;






typedef struct vl_primitive {
    short type;			
    short unsigned flags;	
    struct vl_id_range *name;	
    lsList ports;	        
    st_table *sig_st;		
    st_table *uninit_set;       
    lsList decls;		
    lsList entries;             
    lsHandle handle;            
} vl_primitive, *vl_primitivePtr;


typedef struct vl_port {
    short type;                 
    lsList port_exp;            
                                
    struct vl_id_range *id;     
} vl_port, *vl_portPtr;


typedef struct vl_port_connect {
    short type;                 
    struct vl_expr *expr;       
    struct vl_id_range *id;     
} vl_port_connect, *vl_port_connectPtr;


typedef struct vl_prim_entry {
    unsigned char inputs[MAXINLEN];	
    unsigned char state;	
    unsigned char next_state;	
    struct vl_prim_entry *next;	
} vl_prim_entry, *vl_prim_entryPtr;


typedef struct vl_decl {
    short type;			
    short unsigned flags;	
    struct vl_range *range;     
    lsList ids;	   	        
                                
                                
    lsHandle handle;		
} vl_decl, *vl_declPtr;


typedef struct vl_rangedecl {
    short type;			
    short unsigned flags;	
    int strength_pad;
    struct vl_range *range;	
    struct vl_delay *delay_pad;
    lsList ids;                 
    lsHandle handle;		
} vl_rangedecl, *vl_rangedeclPtr;


typedef struct vl_paramdecl {
    short type;			
    short unsigned flags;	
    lsList assigns;             
    lsHandle handle;		
} vl_paramdecl, *vl_paramdeclPtr;


typedef struct vl_netdecl {
    short type;			
    short unsigned flags;	
    int strength;		
                                
                                
    struct vl_range *range;	
    struct vl_delay *delay;	
    lsList ids;			
				
                                
    lsHandle handle;		
} vl_netdecl, *vl_netdeclPtr;


typedef struct vl_cont_assign {
    short type;			
    short unsigned flags;	
    int strength;		
    struct vl_delay *delay;	
    void *assigns;		
} vl_cont_assign, *vl_cont_assignPtr;


typedef struct vl_task {
    short type;			
    short unsigned flags;	
    struct vl_id_range *name;
    lsList decls;		
    lsList io_lst;             
    st_table *sig_st;           
    lsList stmts;		
    lsHandle handle;		
} vl_task, *vl_taskPtr;







typedef struct vl_function {
    short type;			
    short unsigned flags;	
    struct vl_id_range *name;
    lsList ports;               
                                
    st_table *sig_st;           
    st_table *uninit_set;       
    st_table *param_st;         
    lsList decls;		
    struct vl_range *range;	
    lsList stmts;		
    lsHandle handle;		

    lsList param_list;
    st_table *inst_st;
    st_table *latch_st;
    st_table *quasi_st;
    st_table *func_st;
    st_table *combVar_st;

    st_table *seqVar_st;

    lsList mod_items;
    struct vl_event_expr *clk;
    int syndrome_width;
    int rst_syndrome_width;
    lsList flow_graphs;

    st_table *task_st;
    int dup_count;

    int visited;
} vl_function, *vl_functionPtr;






typedef struct vl_gate_inst_list {
    short type;			
    short unsigned flags;	
    int strength;		
    struct vl_delay *delays;	
    lsList gates;	        
    lsHandle handle;		
} vl_gate_inst_list, *vl_gate_inst_listPtr;


typedef struct vl_gate_inst {
    struct vl_id_range *name;	
    lsList terms;               
    lsHandle handle;	        
} vl_gate_inst, *vl_gate_instPtr;


typedef struct vl_mod_prim_inst_list {
    short type;			
    short unsigned flags;	
    struct vl_id_range *name;	
    lsList mps;	                
    lsHandle handle;		
    int strength;		
    struct vl_delay *delays;	
                                
} vl_mod_prim_inst_list, *vl_mod_prim_inst_listPtr;


typedef struct vl_mod_prim_inst {
    struct vl_id_range *name;	
    lsList ports;	        
                                
				
				
    void *master;               
    lsHandle handle;	        
} vl_mod_prim_inst, vl_mod_prim_instPtr;


typedef struct vl_procstmt {
    short type;			
    short flags;
    void *stmt;			
    struct symbolic_var *pc;    
    char *fg_info;              
                                
                                
} vl_procstmt, *vl_procstmtPtr;




typedef struct vl_begin_end_stmt {
    short type;			
    short unsigned flags;	
    struct vl_id_range *name;	
    void *decls;		
    st_table *sig_st;           
    void *stmts;		
    lsHandle handle;            
} vl_begin_end_stmt, *vl_begin_end_stmtPtr;


typedef struct vl_if_else_stmt {
    short type;			
    short unsigned flags;	
    struct vl_expr *cond;	
    void *if_stmt;		
    void *else_stmt;		
    lsHandle handle;		
} vl_if_else_stmt;


typedef struct vl_case_stmt {
    short type;			
    short unsigned flags;	
    struct vl_expr *cond;	
    lsList case_items;          
    lsHandle handle;		
} vl_case_stmt;


typedef struct vl_forever_stmt {
    short type;			
    short unsigned flags;	
    void *stmt;			
    lsHandle handle;            
} vl_forever_stmt;


typedef struct vl_repeat_stmt {
    short type;			
    short unsigned flags;	
    struct vl_expr *count;	
    void *stmt;			
    void *pad1, *pad2;          
				
    lsHandle handle;            
} vl_repeat_stmt;


typedef struct vl_while_stmt {
    short type;			
    short unsigned flags;	
    struct vl_expr *cond;	
    void *stmt;			
    lsHandle handle;            
} vl_while_stmt;






typedef struct vl_for_stmt {
    short type;			
    short unsigned flags;	
    struct vl_bassign_stmt *init;  
    struct vl_expr *cond;	
    struct vl_bassign_stmt *end;	
    void *stmt;			
    lsHandle handle;            
} vl_for_stmt;



typedef struct vl_delay_control_stmt {
    short type;			
    short unsigned flags;	
    struct vl_delay *delay;	
    void *stmt;                 
    lsHandle handle;		
				
    char *fg_info;      
} vl_delay_control_stmt;



typedef struct vl_event_control_stmt {
    short type;			
    short unsigned flags;	
    struct vl_event_expr *event; 
    void *stmt;                 
    lsHandle handle;		
			        
    char *fg_info;      
} vl_event_control_stmt;





typedef struct vl_bassign_stmt {
    short type;			
				
				
    short unsigned flags;	
    struct vl_lval *lhs;
    void *control;		
    struct vl_expr *rhs;	
    int lineno;                 
    char *fg_info;              
                                
} vl_bassign_stmt, *vl_bassign_stmtPtr;


typedef struct vl_wait_stmt {
    short type;			
    short unsigned flags;	
    struct vl_expr *cond;	
    void *stmt;                 
    lsHandle handle;		
				
} vl_wait_stmt;


typedef struct vl_send_event_stmt {
    short type;                 
    struct vl_id_range *name;   
    char *fg_info;              
                                
} vl_send_event_stmt, vl_send_event_stmtPtr;


typedef struct vl_fork_join_stmt {
    short type;			
    short unsigned flags;	
    struct vl_id_range *name;	
    lsList decls;		
    st_table *sig_st;           
    lsList stmts;		
    lsHandle handle;		
} vl_fork_join_stmt, *vl_fork_join_stmtPtr;


typedef struct vl_task_enable_stmt {
    short type;			
    short unsigned flags;	
    struct vl_id_range *name;	
				
    lsList args;	        
    lsHandle handle;		
} vl_task_enable_stmt, *vl_task_enable_stmtPtr;


typedef struct vl_disable_stmt {
    short type;			
    short unsigned flags;	
    struct vl_id_range *name;	
    lsHandle handle;		
} vl_disable_stmt;


typedef struct vl_deassign_stmt {
    short type;			
    short unsigned flags;	
    struct vl_lval *lhs;	
    lsHandle handle;		
    char *fg_info;              
                                
} vl_deassign_stmt;



typedef struct vl_case_item {
    short type;			
    short unsigned flags;	
    lsList exprs;       
    void *stmt;
    lsHandle handle;	
    char *fg_info;      
} vl_case_item, *vl_case_itemPtr;


typedef struct vl_event_expr {
    short type;		        
 				
                                
    short unsigned flags;	
    struct vl_expr *expr;       
    lsList list;	        
} vl_event_expr, *vl_event_exprPtr;



typedef struct vl_lval {
    short type;			
    short unsigned flags;	
    struct vl_id_range *name;	
    struct vl_range *range;	
    lsList concat;	        
} vl_lval, *vl_lvalPtr;


typedef struct vl_expr {
    short type;			
    short unsigned flags;	
    union {
	int intval;		
	double realval;		
	struct vl_id_range *name;    
	char *string;		
	struct vl_id_range *idrng;   
	struct func_call {
	    struct vl_id_range *name;	
	                                
	    lsList args;    
        } func_call;
	struct bexpr {
	    unsigned int part1;
	    unsigned int part0;
	} bexpr;
	struct exprs {		
	    struct vl_expr *e1;
	    struct vl_expr *e2;
	    struct vl_expr *e3;
        } exprs;
	lsList expr_list;       
    } u;
    struct vl_term *term;       
    char *fg_info1, *fg_info2;  
                                
    char *fg_aux1, *fg_aux2;    
                                
} vl_expr, *vl_exprPtr;


typedef struct vl_range {
    struct vl_expr *left;	
    struct vl_expr *right;
} vl_range, *vl_rangePtr;


typedef struct vl_delay {
    vl_expr *delay1;		
    vl_expr *delay2;		
    vl_expr *delay3;		
} vl_delay, *vl_delayPtr;



typedef struct typestruct {
    short type;
} typestruct, *typestructPtr;


typedef struct vl_range_or_type {
    short  type;               
    vl_range *range;           
} vl_range_or_type, *vl_range_or_typePtr;

typedef struct vl_term {
    vl_id_range *name;
    unsigned short flag;       
    int hi, lo;                
                               
                               
			       
                               
    vl_type *term_type;        
                               
} vl_term, *vl_termPtr;

typedef struct blif_latch {
    vl_id_range *name;          
    short flags;                
    vl_term *inport, *outport;  
} blif_latch, *blif_latchPtr;

typedef struct var_info {
    vl_id_range *id;            
    vl_term *current_terminal;  
                                
    lsList cond_list;           
                                
                                
                                
    void *extra;                
	                        
	                        
} var_info, *var_infoPtr;

typedef struct syndrome_expr {
    char *syndrome;
    vl_term *expr;
    st_table *pre_cond;
    int fg_id;
} syndrome_expr, *syndrome_exprPtr;

typedef struct const_term {
    vl_expr *const_expr;
    vl_term *term;
} const_term, *const_termPtr;

typedef struct symbolic_var {
    char *name;
    set_t *values;
} symbolic_var, *symbolic_varPtr;

typedef struct lib_gate {
    short type;
    int op1Width, op2Width, op3width, resWidth;
} lib_gate, *lib_gatePtr;

typedef struct multi_concat {
    vl_expr *rep;
    lsList concat;
} multi_concat, *multi_concatPtr;

typedef struct vl_synClock {
    char *name;
    int edge;    
    int pi;      
    float rho;   
} vl_synClock, *vl_synClockPtr;

typedef struct ctrlNetNode {
    char   *N;
    lsList B;     
    
    
    lsList Rcv;  
    lsList Snd;  
} ctrlNetNode, *ctrlNetNodePtr;

EXTERN int data_width ARGS((vl_expr *expr));

#endif /* _VL_TYPES */
