/*

  Copyright (c) 1992, 1993
        Regents of the University of California
  All rights reserved.

  Use and copying of this software and preparation of derivative works
  based upon this software are permitted.  However, any distribution of
  this software or derivative works must include the above copyright 
  notice.

  This software is made available AS IS, and neither the Electronics
  Research Laboratory or the Universify of California make any
  warranty about the software, its performance or its conformity to
  any specification.

  Author: Szu-Tsung Cheng, stcheng@ic.Berkeley.EDU
          10/92
          10/93

  $Header: /projects/development/hsv/CVSRepository/vl2mv/src/parser/vl_vardecl.c,v 1.1.1.1 2001/07/09 23:22:40 fabio Exp $


*/

#include <stdio.h>
#include <math.h>
#include "util.h"
#include "array.h"
#include "list.h"
#include "st.h"
#include "set.h"
#include "vl_types.h"
#include "vl_defs.h"
#include "vlr_int.h"
#include "vl_fg_defs.h"
#include "vl_create.h"
#include "vl_write.h"
#include "vl_write_util.h"
#include "vl_vardecl.h"

extern int dumpSMVPlus;
extern int Use_Abstraction;
extern int UninterpretedFunction;


void write_var_decl(file, term)
FILE *file;
vl_term *term;
{
    if (term->flag & MVar)
	write_mvar_decl(file, term);
    else 
	write_int_decl(file, term);
}



void write_mvar_decl(file, term)
FILE *file;
vl_term *term;
{
    lsList domain;
    lsGen enum_gen;
    lsHandle enum_handle;
    vl_enumerator *enum_elt;
    
    if (!(term->flag & MVar)) return;

    domain = term->term_type->specifier->u.enum_type->domain_list;
    if (!term->name->range) {
	int i;

	if (dumpSMVPlus) 
	    
	    fprintf(file, "%s %s %s %s", 
		    SMV_VAR, term->name->name, SMV_COLON, SMV_LBRACE);
	else
	    
	    fprintf(file, ".mv %s %d ", term->name->name, lsLength(domain));
	for (enum_gen=lsStart(domain), i=0;
	     lsNext(enum_gen,(lsGeneric*)&enum_elt,&enum_handle)!=LS_NOMORE;
	     i++) {
	    if (dumpSMVPlus)
		
		if (i==0)
		    fprintf(file, "%s", enum_elt->name);
		else
		    fprintf(file, "%s%s", SMV_COMMA, enum_elt->name);
	    else
		
		fprintf(file, "%s ", enum_elt->name);
	}
	lsFinish(enum_gen);
	if (dumpSMVPlus)
	    fprintf(file, "%s;\n", SMV_RBRACE);
	else
	    fprintf(file, "\n");
    } else {
	int array_lo, array_hi, array_idx;
	array_lo = vl_eval_expr(term->name->range->left);
	if (term->name->range->right)
	    array_hi = vl_eval_expr(term->name->range->right);
	else
	    array_hi = array_lo;

	if (dumpSMVPlus) { 
	    int i;
	    fprintf(file, "%s %s %s %s %d%s%d %s %s",
		    SMV_VAR, term->name->name, SMV_COLON, 
		    SMV_ARRAY, array_lo, SMV_RANGE, array_hi, SMV_OF, 
		    SMV_LBRACE);
	    for (enum_gen=lsStart(domain), i=0;
		 lsNext(enum_gen,(lsGeneric*)&enum_elt,&enum_handle)!=
		     LS_NOMORE; 
		 i++) {
		if (i==0)
		    fprintf(file, "%s", enum_elt->name);
		else
		    fprintf(file, "%s%s", SMV_COMMA, enum_elt->name);
	    }
	    lsFinish(enum_gen);
	    fprintf(file, "%s;", SMV_RBRACE);
	} else { 
	    for (array_idx=array_lo; array_idx<=array_hi; array_idx++) {
		fprintf(file, ".mv %s%s%d%s %d ", 
			term->name->name, SEP_LARRAY, array_idx, SEP_RARRAY,
			lsLength(domain));
		for (enum_gen=lsStart(domain);
		     lsNext(enum_gen,(lsGeneric*)&enum_elt,&enum_handle)!=
		         LS_NOMORE;) {
		    fprintf(file, "%s ", enum_elt->name);
		}
		lsFinish(enum_gen);
		fprintf(file, "\n");
	    }
	}
    }
}



void write_int_decl(file, term)
FILE *file;
vl_term *term;
{
    int hi, lo;
    
    if (term->hi < term->lo) {
        
        if (dumpSMVPlus)  {
	    
	    if (term->name->range) {
	        int array_hi, array_lo;
		array_lo = vl_eval_expr(term->name->range->left);
		if (term->name->range->right)
		    array_hi = vl_eval_expr(term->name->range->right);
		else
		    array_hi = array_lo;
	        fprintf(file, "%s %s %s %s %d%s%d %s %s;\n",
			SMV_VAR, term->name->name, SMV_COLON, 
			SMV_ARRAY, array_lo, SMV_RANGE, array_hi, SMV_OF, 
			SMV_BOOLEAN);
	    } else {
	        fprintf(file, "%s %s %s %s;\n", SMV_VAR, 
			term->name->name, SMV_COLON, SMV_BOOLEAN);
	    }
	} else if (shift_Support) {
	    if (term->name->range) {
	        int array_hi, array_lo;

		array_lo = vl_eval_expr(term->name->range->left);
		if (term->name->range->right)
		    array_hi = vl_eval_expr(term->name->range->right);
		else
		    array_hi = array_lo;
		if (array_lo > array_hi) {
		    int t;
		    t = array_hi;
		    array_hi = array_lo;
		    array_lo = t;
		}

		fprintf(file, ".internal %s\n", term->name->name);
		fprintf(file, ".mv %s %d\n", term->name->name, 
			ipower(2,array_hi-array_lo+1));
		/*
		for (i=array_lo; i<=array_hi; i++)
		    fprintf(file, ".internal %s%s%d%s\n", term->name->name,
			    SEP_LBITSELECT, i, SEP_RBITSELECT);
		*/
	    } else {
		fprintf(file, ".internal %s\n", term->name->name);
		fprintf(file, ".mv %s 2\n", term->name->name);
	    }
	}
	return;
    }

    if (!Use_Abstraction && !dumpSMVPlus && !UninterpretedFunction
	&& !shift_Support) return;

    if (!term->name->range)  {
	
	hi = term->hi; lo = term->lo;
	if (dumpSMVPlus) 
	    fprintf(file, "%s %s %s %s %d%s%d %s %s;\n",
		    SMV_VAR, term->name->name, SMV_COLON, 
		    SMV_ARRAY, hi, SMV_RANGE, lo, SMV_OF, SMV_BOOLEAN);
	else if (shift_Support) {
	    /*
	    int i, t;
	    for (i=lo; i<=hi; i++) {
		fprintf(file, ".internal %s%s%d%s\n", term->name->name,
			SEP_LBITSELECT, i, SEP_RBITSELECT);
	    }
	    */
	    fprintf(file, ".internal %s\n", term->name->name);
	    fprintf(file, ".mv %s %d\n", term->name->name, ipower(2,hi-lo+1));
	} else { 
	    fprintf(file, ".mv %s %d", term->name->name, ipower(2,hi-lo+1));
	    if (term->name->unintType)
		fprintf(file, " %s %s %s", HSIS_TYPE, HSIS_EQUAL, 
			term->name->unintType);
	    fprintf(file, "\n");
	}
    } else {
	
	int array_hi, array_lo, array_idx, range;
	hi = term->hi; lo = term->lo;
	range = ipower(2,hi-lo+1);
	array_lo = vl_eval_expr(term->name->range->left);
	if (term->name->range->right)
	    array_hi = vl_eval_expr(term->name->range->right);
	else
	    array_hi = array_lo;
	if (dumpSMVPlus) { 
	    if (hi < lo)
	        fprintf(file, "%s %s %s %s %d%s%d %s %s;\n",
			SMV_VAR, term->name->name, SMV_COLON, 
			SMV_ARRAY, array_lo, SMV_RANGE, array_hi, SMV_OF, 
			SMV_BOOLEAN);
	    else
	        fprintf(file, "%s %s %s %s %d%s%d %s %s %d%s%d %s %s;\n",
			SMV_VAR, term->name->name, SMV_COLON, 
			SMV_ARRAY, array_lo, SMV_RANGE, array_hi, SMV_OF, 
			SMV_ARRAY, hi, SMV_RANGE, lo, SMV_OF, SMV_BOOLEAN);
	} else 
	    for (array_idx=array_lo; array_idx<=array_hi; array_idx++) {
		fprintf(file, ".mv %s%s%d%s %d\n", 
			term->name->name, SEP_LARRAY, array_idx, SEP_RARRAY,
			range); 
	    }
    }
}

