/*

  Copyright (c) 1992, 1993
        Regents of the University of California
  All rights reserved.

  Use and copying of this software and preparation of derivative works
  based upon this software are permitted.  However, any distribution of
  this software or derivative works must include the above copyright 
  notice.

  This software is made available AS IS, and neither the Electronics
  Research Laboratory or the Universify of California make any
  warranty about the software, its performance or its conformity to
  any specification.

  Author: Szu-Tsung Cheng, stcheng@ic.Berkeley.EDU
          10/92
          10/93

  $Header: /projects/development/hsv/CVSRepository/vl2mv/src/parser/vl_write_util.c,v 1.2 2001/07/09 23:48:41 rbloem Exp $


*/

#include <stdio.h>
#include <math.h>
#include "util.h"
#include "st.h"
#include "array.h"
#include "list.h"
#include "set.h"
#include "graph.h"
#include "vl_types.h"
#include "vl_defs.h"
#include "vlr_int.h"
#include "vl_fg_defs.h"
#include "vl_fg_types.h"
#include "vl_create.h"
#include "vl_write.h"
#include "vl_write_util.h"
#include "vl_vardecl.h"
#include "vl_edgedetector.h"
#include "vl_traverse.h"
#include "vl_mux.h"
#include "vl_flowgraph.h"
#include "verilog.h"

extern FILE *lib_file;
extern vl_desc *mod_list;
extern int Use_Abstraction;
extern int Use_SystemFunc;
extern int Use_Macro;
extern int implicitClocking;
extern int compatibleChecking;
extern int set_notation;
extern int debug_mode;
extern int decomposeTable;
extern int noBus;
extern int smartEvent;
extern int vlTimedSystem;
extern int Zconnection;
extern int implicitDeclare;
extern int smv_NSyntax;

extern int WarningLevel;

extern int rst_ckt, use_rst_ckt, mark_sel_var;
extern lsList ctrl_list, rst_ctrl_list;
extern st_table *sensitiveList;
extern int lhs_hi, lhs_lo;
extern int lhs_must_be_wire;
extern int dumpSMVPlus;
extern int Vlerrno;
extern int silent_err;
extern char *cntxt_event;

int deadlock_semantic = 0;
int UninterpretedFunction=0;
int arrayBoundNond=0;
int vis_nond=1;
int vis_nond_var=0;
int instantiateInputLatch = 0;

static char *nond_output();
static int isTautology ARGS((lsList syndrome_expr_list));
static void postprocess_vlr_rel ARGS((FILE *file, short type, char *carry,
				      vl_term *results, vl_term *out));
static void smv_barrel_shifter ARGS((FILE *file, vl_term *operand,
				     vl_term *amount, vl_term *result,
				     int lr));
static int evaluable_expr ARGS((vl_expr *expr));


void vl_mv_to_bin(vl_term *term)
{
    if (term->flag & MVar) {
	char buf[MAXSTRLEN];
	sprintf(buf, "enforced mv->binary encoding on '%s'", term->name->name);
	Translate_Warning(buf);

	term->flag &= !MVar;
	if (term->hi < 0) {
	    term->hi = MAXBITNUM-1;
	    term->lo = 0;
	} else {
	    int range, blen;

	    for (range = term->hi - term->lo + 1, blen = -1;
		 range>0; range >>= 1) 
		blen++;
	    if (blen>0)
		if ((1<<(blen-1)) < term->hi-term->lo+1)
		    blen++;
	    term->lo = 0;
	    term->hi = blen-1;
	}
    }
}



void vl_bin_to_mv(vl_term *term)
{
    int blen;

    if (!(term->flag & MVar)) {
	Translate_Warning("enforced binary->mv encoding");
	
	term->flag |= MVar;
	blen = term->hi-term->lo+1;
	term->lo = 1;
	term->hi = (1 << (blen));
    }
}


void vl_write_mv_comp(FILE *file, short type, vl_term *in1, vl_term *in2, vl_term *out)
{
    lsList domain;
    lsGen igen, jgen;
    lsHandle ihandle, jhandle;
    vl_enumerator *i, *j;
    FILE *old_file;

    if (in1->hi-in1->lo != in2->hi-in2->lo)
	Translate_Warning("comparator have MV's of different domain elts");

    if (!dumpSMVPlus) {
	if (shift_Support) {
	    fprintf(file, ".subckt %s %s i0=%s | o=%s\n", 
		    (type==Beq2Expr)?"_EQ":"_NEQ",
        	    new_instname(), in1->name->name, out->name->name);
	    return;
	} else
            fprintf(file, ".names %s %s %s\n", 
		    in1->name->name, in2->name->name, out->name->name);
    }
    if (set_notation) {
        if (dumpSMVPlus) {
	    
	    fprintf(file, "%s %s %s %s %s %s ;\n", SMV_DEFINE, out->name->name,
		    SMV_COL_ASSIGN, in1->name->name,SMV_EQUAL,in2->name->name);
	} else {
	    
	    if (in1->term_type != in2->term_type) {
	        char buf[MAXSTRLEN];
		sprintf(buf, "'%s':comparing %s and %s of different domains",
			vl_currentModule->name->name,
			in1->name->name, in2->name->name);
		semantic_error(buf);
	    }
	
	    fprintf(file, "%s %d\n", HSIS_DEFAULT, type==Bneq2Expr);
	    if (shift_Support)
	        fprintf(file, "- ( %s ) %d\n", 
		    in1->name->name, type!=Bneq2Expr);
	    else
	        fprintf(file, "- %s%s %d\n", 
		    HSIS_EQUAL, in1->name->name, type!=Bneq2Expr);

	    if (shift_Support) {
 	   	fprintf(file, ".end\n");
		file = old_file;
	    }
	}
    } else {
	switch (type) {
	case Beq2Expr: 
	    
	    if (in1->term_type != in2->term_type) {
		char buf[MAXSTRLEN];
		sprintf(buf, "'%s':comparing %s and %s of different domains",
			vl_currentModule->name->name,
			in1->name->name, in2->name->name);
		semantic_error(buf);
	    }
	    
	    domain = in1->term_type->specifier->u.enum_type->domain_list;
	    for (igen=lsStart(domain);
		 lsNext(igen,(lsGeneric*)&i,&ihandle)!=LS_NOMORE;) {
		for (jgen=lsStart(domain);
		     lsNext(jgen,(lsGeneric*)&j,&jhandle)!=LS_NOMORE;) {
		    fprintf(file, "%s %s %d\n", 
			    i->name, j->name, (strcmp(i->name, j->name)==0));
		}
		lsFinish(jgen);
	    }
	    lsFinish(igen);
	    break;
	case Bneq2Expr: 
	    
	    if (in1->term_type != in2->term_type) {
		char buf[MAXSTRLEN];
		sprintf(buf, "'%s':comparing %s and %s of different domains",
			vl_currentModule->name->name,
			in1->name->name, in2->name->name);
		semantic_error(buf);
	    }
	    
	    domain = in1->term_type->specifier->u.enum_type->domain_list;
	    for (igen=lsStart(domain);
		 lsNext(igen,(lsGeneric*)&i,&ihandle)!=LS_NOMORE;) {
		for (jgen=lsStart(domain);
		     lsNext(jgen,(lsGeneric*)&j,&jhandle)!=LS_NOMORE;) {
		    fprintf(file, "%s %s %d\n", 
			    i->name, j->name, (strcmp(i->name, j->name)!=0));
		}
		lsFinish(jgen);
	    }
	    lsFinish(igen);
	    break;
	}
    }
}


void vl_write_bin_comp(FILE *file, short type, vl_term *in1, vl_term *in2, vl_term *out)
{
    vl_term *tmp, *ripple_term;
    char *ripple;

    
    tmp = new_term(NIL(vl_range), 0, -1);

    
    if (in1->lo > in1->hi) {
        tmp->lo = in2->lo; 
	tmp->hi = in2->hi;
    } else if (in2->lo > in2->hi) {
	tmp->lo = in1->lo; 
	tmp->hi = in1->hi;
    } else {                         
	tmp->lo = 0;                 
	if (in1->hi-in1->lo != in2->hi-in2->lo) {

	}
	tmp->hi = MIN(in1->hi-in1->lo, in2->hi-in2->lo);
    }
    write_var_decl(file, tmp);
    vl_write_vector_bop(file, BxorExpr, in1, in2, tmp);

    
    ripple = vlStrdup(new_termname());
    ripple_term = vl_create_term(vl_create_id_range(ripple,NIL(vl_range)),
				 tmp->lo, tmp->hi);
    if (shift_Support) {
        fprintf(file, ".internal %s\n", ripple_term->name->name);
        fprintf(file, ".mv %s 2\n", ripple_term->name->name);
        fprintf(file, ".internal %s\n", out->name->name);
        fprintf(file, ".mv %s 2\n", out->name->name);
    }
    
    if (tmp->lo <= tmp->hi) {
	ripple = 
	    vl_write_vector_bop(file, UorExpr, tmp, NIL(vl_term), ripple_term);
	vl_write_bit_connect(file, ripple_term->name->name, out->name->name, 
			     (type==Beq2Expr));
	vl_free_term(ripple_term);
    } else {
	vl_write_bit_connect(file, tmp->name->name, out->name->name, 
			     (type==Beq2Expr));
    }
    vl_free_term(tmp);
}


void vl_write_mv_connect(FILE *file, vl_term *in, vl_term *out)
{
    lsList domain;
    lsGen enum_gen;
    lsHandle enum_handle;
    vl_enumerator *enum_elt;
    FILE *old_file;

    if (in->term_type != out->term_type) {
	char buf[MAXSTRLEN];
	sprintf(buf, "connecting %s and %s of different domains",
		out->name->name, in->name->name);
	semantic_error(buf);
    }
    
    if (dumpSMVPlus) {
	
	fprintf(file, "%s %s %s %s ;\n", 
		SMV_ASSIGN, out->name->name, SMV_COL_ASSIGN, in->name->name);
	return;
    } else {
	
	if (shift_Support) {
	    fprintf(file, ".subckt _WIRE %s i0=%s | o=%s\n", 
		    new_instname(), in->name->name, out->name->name);
	    return;
	} else
	    fprintf(file, ".names %s %s\n", in->name->name, out->name->name);
    }

    
    
    if (set_notation) {
	if (shift_Support)
	    fprintf(file, "- ( %s )\n", in->name->name);
	else
	    fprintf(file, "- =%s\n", in->name->name);
    } else {
	domain = in->term_type->specifier->u.enum_type->domain_list;
	for (enum_gen=lsStart(domain);
	     lsNext(enum_gen,(lsGeneric*)&enum_elt,&enum_handle)!=LS_NOMORE;) {
	    fprintf(file, "%s %s\n", enum_elt->name, enum_elt->name);
	}
	lsFinish(enum_gen);
    }

    if (shift_Support) {
	fprintf(file, ".end\n");
	file = old_file;
    }
}


void vl_write_bin_connect(FILE *file, vl_term *in, vl_term *out, int inverted)
{
    int i;
    char out_buf[MAXSTRLEN], in_buf[MAXSTRLEN];
    char *cp;
    FILE *old_file;

    if (dumpSMVPlus) {
	
        if (out->hi < out->lo)
	    
	    if (in->hi < in->lo)
	        fprintf(file, "%s %s %s %s%s ;\n", 
			SMV_DEFINE, 
			out->name->name,SMV_COL_ASSIGN,
			(inverted)?SMV_NOT:"",
			in->name->name);
	    else
	        fprintf(file, "%s %s %s %s%s %s%d%s;\n",
			SMV_DEFINE, out->name->name, SMV_COL_ASSIGN,
			(inverted)?SMV_NOT:"",
			in->name->name, SEP_LBITSELECT,in->lo,SEP_RBITSELECT);
	else {
	    
	    if (in->hi < in->lo) {
	        if (out->hi == out->lo) 
		    fprintf(file, "%s %s [%d] %s %s ;\n",
			    SMV_ASSIGN, out->name->name, out->lo,
			    SMV_COL_ASSIGN, in->name->name);
		else
		    fprintf(file, "%s %s %s %s ;\n",
			    SMV_ASSIGN, out->name->name, SMV_COL_ASSIGN,
			    in->name->name);
	    } else
	        fprintf(file, "%s %s [%d%s%d] %s %s%s [%d%s%d];\n", SMV_ASSIGN, 
			out->name->name, out->hi, SMV_RANGE, out->lo,
			SMV_COL_ASSIGN,
			(inverted)?SMV_NOT:"",
			in->name->name, in->hi, SMV_RANGE, in->lo);
	}
	return;
    }

    
    if (out->lo > out->hi) {
	if (in->lo > in->hi) {
	    vl_write_bit_connect(file, in->name->name, out->name->name, 0);
	} else {
	    char buf[MAXSTRLEN];

	    sprintf(buf, "%s%s%d%s", in->name->name, 
		    SEP_LBITSELECT, in->lo, SEP_RBITSELECT);
	    vl_write_bit_connect(file, buf, out->name->name, 0);
	}
    } else {
	if (Use_Abstraction) {
	    fprintf(file, "%s %s %s a=%s o=%s\n", 
		    (Use_Macro)?".macro":".subckt",
		    (inverted)?lib_encode(LIBiconnect, in->hi-in->lo+1):
		               lib_encode(LIBconnect, in->hi-in->lo+1), 
		    new_termname(),
		    in->name->name, out->name->name);
	}

	if (!Use_Abstraction ||
	    !set_find(lib_encode(LIBconnect,in->hi-in->lo+1),
		      mod_list->lib_st)) {
	    if (Use_Abstraction) {
		vl_term *tdecl_term;
		set_add(lib_encode(LIBconnect,in->hi-in->lo+1),
			mod_list->lib_st);

		file = lib_file;
		fprintf(file, ".model %s\n",
			lib_encode(LIBconnect, in->hi-in->lo+1));
		
		fprintf(file, ".inputs a\n");
		fprintf(file, ".outputs o\n");
		tdecl_term = create_rename_term(in->name, vlStrdup("a"),
					      in->lo, in->hi);
		write_var_decl(file, tdecl_term);
		vl_free_term(tdecl_term);
		tdecl_term = create_rename_term(out->name, vlStrdup("o"),
					      out->lo, out->hi);
		write_var_decl(file, tdecl_term);
		vl_free_term(tdecl_term);
		fprintf(file, ".bundle a ");
		for (i=in->lo; i<=in->hi; i++)
		    fprintf(file, "%s%s%d%s ",
			    in->name->name, SEP_LBITSELECT, i, SEP_RBITSELECT);
		fprintf(file, "\n");
		fprintf(file, ".bundle o ");
		for (i=out->lo; i<=out->hi; i++)
		    fprintf(file, "%s%s%d%s ",
			    out->name->name, SEP_LBITSELECT,i,SEP_RBITSELECT);
		fprintf(file, "\n");
	    }

	    if (in->lo > in->hi) {
		int i;
		sprintf(out_buf, "%s%s%d%s", out->name->name, 
			SEP_LBITSELECT, out->lo, SEP_RBITSELECT);
		sprintf(in_buf, "%s", in->name->name);
		if (set_notation && !inverted) { 
		    if (shift_Support) {
			fprintf(file, ".subckt %s %s in0=%s | o=%s\n",
				(inverted)?"_NOT":"_WIRE",
				new_instname(), in_buf, out_buf);
			return;
		    } else {
		        fprintf(file, ".names %s %s\n- =%s\n",
			        in_buf, out_buf, in_buf);
		    }
		} else {
		    vl_write_bit_connect(file, in_buf, out_buf, inverted);
		}
		
		
		sprintf(in_buf, "%s", WRT_BLIF_GND(file));
		for (i=out->lo+1; i<=out->hi; i++) {
		    sprintf(out_buf, "%s%s%d%s", out->name->name, 
			    SEP_LBITSELECT, i, SEP_RBITSELECT);
		    if (set_notation) { 
			if (shift_Support) {
			    fprintf(file, ".subckt %s %s i0=%s | o=%s\n",
				    (inverted)?"_NOT":"_WIRE",
				    new_instname(), in_buf, out_buf);
			    continue;
			} else {
			    fprintf(file, ".names %s %s\n- =%s\n",
				    in_buf, out_buf, in_buf);
			}
		    } else {
			vl_write_bit_connect(file, in_buf, out_buf, 0);
		    }
		}
	    } else {
		if (UninterpretedFunction) {
		    fprintf(file, ".names %s %s\n- =%s\n",
			    in->name->name, out->name->name, in->name->name);
		} else {
		    if (shift_Support) {
			fprintf(file, ".subckt %s %s i0=%s | o=%s\n",
				(inverted)?"_NOT":"_WIRE", new_instname(),
				in->name->name, out->name->name);
                    } else {
			for (i=out->lo; i<=out->hi; i++) {
			    sprintf(out_buf, "%s%s%d%s", out->name->name, 
				    SEP_LBITSELECT, i, SEP_RBITSELECT);
			    sprintf(in_buf, "%s%s%d%s", in->name->name, 
				    SEP_LBITSELECT, i+in->lo-out->lo, 
				    SEP_RBITSELECT);
			    if (set_notation && !inverted) { 
				if (shift_Support) {
				    fprintf(file, ".subckt %s %s %s=%s | %s=%s\n",
					    cp=new_termname(), 
					    new_instname(), in_buf, in_buf,
					    out_buf, out_buf);
				    
				    old_file = file;
				    file = lib_file;
				    fprintf(file, ".cfsm %s\n", cp);
				    fprintf(file, ".inputs %s\n", 
					    cfsm_ports(in_buf));
				    fprintf(file, ".outputs %s\n", 
					    cfsm_ports(out_buf));
				    fprintf(file, ".trans\n");
				    fprintf(file, "- ( %s )\n", in_buf);
				    fprintf(file, ".end\n\n");
				    file = old_file;
				} else {
				    fprintf(file, ".names %s %s\n- =%s\n",
					    in_buf, out_buf, in_buf);
				}
			    } else {
				vl_write_bit_connect(file, in_buf, out_buf, 
						     inverted);
			    }
			}
		    }
		}
	    }

	    if (Use_Abstraction)
		fprintf(file, ".end\n\n");
	}
    }
}


void vl_write_consts(FILE *file)
{
    
    
    file = file;
}


void vl_write_const(FILE *file, vl_expr *val, vl_term *out)
{
    int ismvar=0;
    int i, v;
    int lo, hi;
    int find_elt=0;
    char buf[MAXSTRLEN];
    lsList domain;
    lsGen enum_gen;
    lsHandle enum_handle;
    vl_enumerator *enum_elt;
    lsList args=(lsList)0;

    ismvar = out->flag & MVar;

    if (ismvar) {
	assert (val);
	
	if (dumpSMVPlus)
	    fprintf(file, "%s %s %s ", 
		    SMV_ASSIGN, out->name->name, SMV_COL_ASSIGN);
	else {
	    if (shift_Support) { 
		fprintf(file, ".const %s ", out->name->name);
	    } else {
	        fprintf(file, ".names %s\n", out->name->name);
	    }
	}
	switch(val->type) {
	case BitExpr: 
	    Translate_Warning("Using binary constant as value of mv variable");
	case IntExpr: 
	    domain = out->term_type->specifier->u.enum_type->domain_list;
	    for (enum_gen=lsStart(domain);
		 lsNext(enum_gen,
			(lsGeneric*)&enum_elt,&enum_handle)!=LS_NOMORE;) {
		find_elt=1;
		if (enum_elt->val==val->u.intval) break;
		find_elt=0;
	    }
	    lsFinish(enum_gen);

	    if (find_elt) 
		if (dumpSMVPlus)
		    fprintf(file, "%s ;\n", enum_elt->name);
		else
		    fprintf(file, "%s\n", enum_elt->name);
	    else {
		char buf[MAXSTRLEN];
		sprintf(buf, "trying to assign to '%s' out of its domain",
			out->name->name);
		semantic_error(buf);
	    }
	    break;
	case RealExpr: 
	    semantic_error("assinging real value to enumeration typed var"); 
	    break;
	case IDExpr:
	    if (st_lookup(out->term_type->specifier->u.enum_type->domain_st,
			  val->u.name->name, (char**)&enum_elt)) {
		if (dumpSMVPlus)
		    fprintf(file, "%s ;\n", enum_elt->name);
		else
		    fprintf(file, "%s\n", enum_elt->name);
	    } else {
		char buf[MAXSTRLEN];

		sprintf(buf, "%s should be a constant/symbolic name",
			val->u.name->name);
		internal_error(buf);
	    }
	    break;
	}
    } else if (dumpSMVPlus) {
	
	
        if (out->hi < out->lo) 
	    
	    fprintf(file, "%s %s %s %d;\n", 
		    SMV_ASSIGN, out->name->name, SMV_COL_ASSIGN,
		    vl_eval_expr(val));
	else
	    
	    fprintf(file, "%s %s %s%d%s%d%s %s %d;\n", 
		    SMV_ASSIGN, out->name->name, 
		    SEP_LARRAY, out->hi, SMV_RANGE, out->lo, SEP_RARRAY, 
		    SMV_COL_ASSIGN,vl_eval_expr(val));
    } else {
	
	
	if (out->name->mpg_master_exp && out->hi==-1 && out->lo==0) 
	    
	    get_hilo(out->name, &hi, &lo);
	else {
	    
	    hi = out->hi;
	    lo = out->lo;
	}
	if (val) {
	    
	    if (lo <= hi) {
		if (Use_Abstraction) {
		    args = lsCreate();
		    sprintf(buf, "%d", hi-lo+1);
		    lsNewEnd(args, (lsGeneric)(vlStrdup(buf)), 0);
		    sprintf(buf, "%d", vl_eval_expr(val));
		    lsNewEnd(args, (lsGeneric)(vlStrdup(buf)), 0);
		    
		    fprintf(file, "%s %s %s o=%s\n",
			    (Use_Macro)?".macro":".subckt",
			    gen_lib_encode(LIBconst,args), new_termname(),
			    out->name->name);
		}

		if (!Use_Abstraction ||
		    !set_find(gen_lib_encode(LIBconst, args),
			      mod_list->lib_st)) {
		    if (Use_Abstraction) {
			vl_term *tdecl_term;
			set_add(gen_lib_encode(LIBconst, args),
				mod_list->lib_st);

			file = lib_file;
			fprintf(file, ".model %s\n",
				gen_lib_encode(LIBconst, args));

			fprintf(file, ".outputs o\n");
			fprintf(file, ".bundle o ");
			for (i=out->lo; i<=out->hi; i++) {
			    fprintf(file, "%s%s%d%s ",
				    out->name->name, 
				    SEP_LBITSELECT, i, SEP_RBITSELECT);
			}
			fprintf(file, "\n");
			tdecl_term = create_rename_term(out->name, vlStrdup("o"),
						      out->lo, out->hi);
			write_var_decl(file, tdecl_term);
			vl_free_term(tdecl_term);
		    }

		    if (!UninterpretedFunction) {
			int v0;
			v0 = val->u.bexpr.part0;
			if (shift_Support) {
			    fprintf(file, ".const %s %d\n", 
				    out->name->name, v0);
			    return;
  			}
			for (i=lo, v=vl_eval_expr(val); i<=hi; 
			     i++, v >>= 1, v0 >>= 1) {
			    sprintf(buf, "%s%s%d%s", out->name->name, 
				    SEP_LBITSELECT, i, SEP_RBITSELECT);
			    if (shift_Support) {
			        fprintf(file, ".const %s ", buf);
			        fprintf(file, "%d\n", (v & 1));
			    } else {
			        fprintf(file, ".names %s\n", buf);
				if ((v & 1) && (v0 & 1))
				    fprintf(file, "-\n");
				else
			            fprintf(file, "%d\n", (v & 1));
			    }
			}
		    } else {
			v = vl_eval_expr(val);
			fprintf(file, ".names %s\n%d\n", out->name->name, v);
		    }

		    if (Use_Abstraction) {
			fprintf(file, ".end\n\n");
			lsDestroy(args, vl_chk_free);
		    }
		}
	    } else {
		if (shift_Support) {
		    fprintf(file, ".const %s ", out->name->name);
		} else {
		    fprintf(file, ".names %s\n", out->name->name);
		}
		fprintf(file, "%d\n", vl_eval_expr(val) & 1);
	    }
	} else {
	    
	    if (lo <= hi) {
		if (Use_Abstraction) {
		    fprintf(file, "%s %s %s o=%s\n",
			    (Use_Macro)?".macro":".subckt",
			    lib_encode(LIBopen, out->hi-out->lo+1), 
			    new_termname(),
			    out->name->name);
		}
		
		if (!Use_Abstraction ||
		    !set_find(lib_encode(LIBopen,out->hi-out->lo+1),
			      mod_list->lib_st)) {
		    if (Use_Abstraction) {
			vl_term *tdecl_term;
			set_add(lib_encode(LIBopen, out->hi-out->lo+1),
				mod_list->lib_st);
			
			file = lib_file;
			fprintf(file, ".model %s\n",
				lib_encode(LIBopen, out->hi-out->lo+1));
			
			fprintf(file, ".outputs o\n");
			fprintf(file, ".bundle o ");
			for (i=out->lo; i<=out->hi; i++) {
			    fprintf(file, "%s%s%d%s ",
				    out->name->name, 
				    SEP_LBITSELECT, i, SEP_RBITSELECT);
			}
			fprintf(file, "\n");
			tdecl_term = create_rename_term(out->name, vlStrdup("o"),
						      out->lo, out->hi);
			write_var_decl(file, tdecl_term);
			vl_free_term(tdecl_term);
		    }
		    
		    if (shift_Support) {
			fprintf(file, ".const %s 0\n", out->name->name);
			return;
		    }
		    for (i=lo; i<=hi; i++) {
			if (shift_Support) {
			    sprintf(buf, "%s%s%d%s", out->name->name, 
				    SEP_LBITSELECT, i, SEP_RBITSELECT);
			    fprintf(file, ".const %s ", buf);
			    fprintf(file, "0\n");
			} else {
			    sprintf(buf, "%s%s%d%s", out->name->name, 
				    SEP_LBITSELECT, i, SEP_RBITSELECT);
			    fprintf(file, ".names %s\n", buf);
			    fprintf(file, "0\n1\n");
			}
		    }
		    
		    if (Use_Abstraction) fprintf(file, ".end\n\n");
		}
	    } else {
		if (shift_Support) {
		    fprintf(file, ".const %s ", out->name->name);
		    fprintf(file, "0\n");
		} else {
		    fprintf(file, ".names %s\n", out->name->name);
		    fprintf(file, "0\n1\n");
		}
	    }
	}
    }
}



void write_int_connect(FILE *file, int v, vl_term *out)
{
    int lo, hi, i;
    char buf[MAXSTRLEN];
    lsList args;

    if (dumpSMVPlus) {
	
	fprintf(file, "%s %s %s %d;\n",
		SMV_DEFINE, out->name->name, SMV_COL_ASSIGN, v);
    } else {
	
	lo = out->lo; hi = out->hi;
	if (hi < lo) {
	    if (shift_Support) {
	        fprintf(file, ".const %s ", out->name->name);
	    } else {
	        fprintf(file, ".names %s\n", out->name->name);
	    }
	    fprintf(file, "%d\n", (v&1));
	} else {
	    args = lsCreate();
	    sprintf(buf, "%d", out->hi-out->lo+1);
	    lsNewEnd(args, (lsGeneric)vlStrdup(buf), 0);
	    sprintf(buf, "%d", v);
	    lsNewEnd(args, (lsGeneric)vlStrdup(buf), 0);

	    if (Use_Abstraction) {
		fprintf(file, "%s %s %s o=%s\n",
			(Use_Macro)?".macro":".subckt",
			gen_lib_encode(LIBint, args), new_termname(),
			out->name->name);
	    }

	    if (!Use_Abstraction ||
		!set_find(gen_lib_encode(LIBint,args), mod_list->lib_st)) {
		if (Use_Abstraction) {
		    vl_term *tdecl_term;
		    set_add(gen_lib_encode(LIBint,args), mod_list->lib_st);

		    file = lib_file;
		    fprintf(file, ".model %s\n", gen_lib_encode(LIBint, args));

		    fprintf(file, ".outputs o\n");
		    fprintf(file, ".bundle o ");
		    for (i=out->lo; i<=out->hi; i++)
			fprintf(file, "%s%s%d%s ", out->name->name, 
				SEP_LBITSELECT, i, SEP_RBITSELECT);
		    fprintf(file, "\n");
		    tdecl_term = create_rename_term(out->name, vlStrdup("o"),
						    out->lo, out->hi);
		    write_var_decl(file, tdecl_term);
		    vl_free_term(tdecl_term);
		}
		
		if (shift_Support) {
		    fprintf(file, ".const %s %d\n", out->name->name, v);
		    return;
		}
		for (i=lo; i<=hi; i++, v >>= 1) {
		    sprintf(buf, "%s%s%d%s", out->name->name, 
			    SEP_LBITSELECT, i, SEP_RBITSELECT);
		    if (shift_Support) {
		        fprintf(file, ".const %s ", buf);
		    } else {
		        fprintf(file, ".names %s\n", buf);
		    }
		    fprintf(file, "%d\n", (v & 1));
		}

		if (Use_Abstraction) {
		    fprintf(file, ".end\n\n");
		}
	    }
	    
	    lsDestroy(args, vl_chk_free);
	}
    }
}



vl_term *write_local_control(FILE *file, vl_term *ctrl, lsList sub_ctrls, int inverted)
{
    int i, j;
    vl_term *retval;
    lsGen gen;
    lsHandle handle;
    vl_term *sub_ctrl;
    int unconditional_assign = 0;

    
    

    if (!sub_ctrls)
	unconditional_assign = 1;
    else if (lsLength(sub_ctrls)==0)
	unconditional_assign = 1;

    if (unconditional_assign) {
	retval = new_term(NIL(vl_range), 0, -1);
	vl_write_bit_connect(file, ctrl->name->name, retval->name->name, 
			     inverted);
	return retval;
    }

    retval = new_term(NIL(vl_range), 0, -1);

    fprintf(file, ".names %s ", ctrl->name->name);
    gen = lsStart(sub_ctrls);
    if (lsNext(gen, (lsGeneric*)&sub_ctrl, &handle) == LS_OK) {
	fprintf(file, "%s ", ((vl_term*)(((int)sub_ctrl)&~1))->name->name);
	while (lsNext(gen, (lsGeneric*)&sub_ctrl, &handle) != LS_NOMORE) {
	    fprintf(file, "%s ", ((vl_term*)(((int)sub_ctrl)&~1))->name->name);
	}
    }
    lsFinish(gen);
    fprintf(file, "%s\n", retval->name->name);

    for (i=0; i<lsLength(sub_ctrls); i++) {
	fprintf(file, "%c ", (inverted)?'0':'1');
	for (j=0; j<lsLength(sub_ctrls); j++) {
	    fprintf(file, "%c ", (i==j)?'1':'-');
	}
	fprintf(file, "1\n");
    }

    fprintf(file, "%c ", (inverted)?'0':'1');
    gen = lsStart(sub_ctrls);
    if (lsNext(gen, (lsGeneric*)&sub_ctrl, &handle) == LS_OK) {
	fprintf(file, "%c ", ((int)sub_ctrl&1)?'1':'0');
	while (lsNext(gen, (lsGeneric*)&sub_ctrl, &handle) != LS_NOMORE) {
	    fprintf(file, "%c ", ((int)sub_ctrl&1)?'1':'0');
	}
    }
    lsFinish(gen);
    fprintf(file, "0\n");

    fprintf(file, "%c ", (inverted)?'1':'0');
    for (i=0; i<lsLength(sub_ctrls); i++) {
	fprintf(file, "%c ", '-');
    }
    fprintf(file, "0\n");

    return retval;
}



void write_switch(FILE *file, vl_id_range *id_sym,
		  vl_term *sel, vl_expr *sel_expr,
		  vl_term *orig, vl_term *new, vl_term *out_term)
{
    int lo, hi;
    int bit_hi, bit_lo;
    int idx;
    vl_expr *hi_expr;
    char new_buf[MAXSTRLEN], orig_buf[MAXSTRLEN], out_buf[MAXSTRLEN];

    if (dumpSMVPlus && smv_NSyntax) {
        
        if (rst_ckt) {
	    char buf[MAXSTRLEN];
	    sprintf(buf, "%s: don't init array '%s' using array shorthand",
		    vl_currentModule->name->name, id_sym->name);
	    yylineno = -1;
	    compile_error(buf);
	}
      
        cntxt_event = vlStrdup(new_termname());
	fprintf(file, "%s %s %s %s;\n", SMV_VAR, cntxt_event, SMV_COLON, 
		SMV_BOOLEAN);
        fprintf(file, "%s ( %s ) %s (%s ", SMV_IF, cntxt_event, 
		SMV_TRANS, id_sym->name);
	fprintf(file, "%s ", SEP_LARRAY);
	vl_step_expr(file, sel_expr);
	fprintf(file, " %s", SEP_RARRAY);
	fprintf(file, ") %s %s ;\n", SMV_COL_ASSIGN, new->name->name);
	return;
    }

    get_hilo(id_sym, &bit_hi, &bit_lo);

    lo = vl_eval_expr(out_term->name->range->left);
    if (out_term->name->range->right)
	hi = vl_eval_expr(out_term->name->range->right);
    else
	hi = lo;

    if (!sel) {
	int const_hi, const_lo;

	assert(ISVLCONST(sel_expr->type));
	
	const_hi = min_bit_width(hi)-1;
	const_lo = 0;
	sel = new_term(NIL(vl_range), const_lo, const_hi);
	write_var_decl(file, sel);
	vl_write_const(file, sel_expr, sel);
    }

    hi_expr = vl_create_expr(IntExpr, hi, (double)0.0,
			     NIL(void), NIL(void), NIL(void));
    for (idx=lo; idx<=hi; idx++) {
	vl_term *ctrl;
	vl_term *new_elt, *orig_elt, *out_elt;
	vl_expr *const_expr;
	vl_term *const_trm;
	
	const_expr = vl_create_expr(IntExpr, idx, (double)0.0,
				    NIL(void), NIL(void), NIL(void));
	const_trm = new_term(NIL(vl_range), 0, data_width(hi_expr)-1);
	write_var_decl(file, const_trm);
	vl_write_const(file, const_expr, const_trm);
	vl_chk_free((char*)const_expr);

	
	
	ctrl = new_term(NIL(vl_range), 0, -1);
	if (shift_Support) {
	    write_var_decl(file, ctrl);
	}
	vl_write_bin_comp(file, Beq2Expr, const_trm, sel, ctrl);

	
	sprintf(new_buf, "%s%s%d%s", 
		new->name->name, SEP_LARRAY, idx, SEP_RARRAY);
	if (rst_ckt && !strstr(orig->name->name, SEP_GATEPIN)) {
	    int i;
	    sprintf(orig_buf, "%s", new_termname());
	    if (dumpSMVPlus) {
	        
	        fprintf(file, "%s %s %s ", SMV_ASSIGN,orig_buf,SMV_COL_ASSIGN);
		smv_dc(file, id_sym->id_type, bit_hi, bit_lo);
		fprintf(file, ";\n");
	    } else {
	        
	        if (bit_lo == 0 && bit_hi == -1) {
		    if (out_term->term_type) {
			if (vis_nond) {
			    char *old_name;
			    vl_range *old_range;
			    vl_enumerator *enum_elt;
			    old_name = out_term->name->name;
			    old_range = out_term->name->range;
			    out_term->name->name = orig_buf;
			    out_term->name->range = NIL(vl_range);
			    write_var_decl(file, out_term);
			    out_term->name->name = old_name;
			    out_term->name->range = old_range;
			    lsFirstItem(out_term->term_type->specifier->u.enum_type->domain_list, (lsGeneric*)&enum_elt, 0);
			    if (shift_Support) {
			        fprintf(file, ".const %s %s\n", orig_buf,
				        enum_elt->name);
			    } else {
			        fprintf(file, ".names %s\n%s\n", orig_buf,
				        enum_elt->name);
			    }
			} else {
			    if (shift_Support) {
			        fprintf(file, ".const %s -\n", orig_buf);
			    } else {
			        fprintf(file, ".names %s\n-\n", orig_buf);
			    }
			}
		    } else {
			if (vis_nond) {
			    if (shift_Support) {
			        fprintf(file, ".const %s 0\n", orig_buf);
			    } else {
			        fprintf(file, ".names %s\n0\n", orig_buf);
			    }
			} else {
			    if (shift_Support) {
			        fprintf(file, ".const %s -\n", orig_buf);
			    } else {
			        fprintf(file, ".names %s\n-\n", orig_buf);
			    }
			}
		    }
		} else {
		    if (shift_Support) {
			fprintf(file, ".const %s -\n", orig_buf);
			continue;
		    }
		    for (i=bit_lo; i<=bit_hi; i++)
			if (vis_nond) {
			    if (shift_Support) {
			        fprintf(file, ".const %s%s%d%s 0\n", orig_buf, 
				        SEP_LBITSELECT, i, SEP_RBITSELECT);
			    } else {
			        fprintf(file, ".names %s%s%d%s\n0\n", orig_buf, 
				        SEP_LBITSELECT, i, SEP_RBITSELECT);
			    }
			} else {
			    if (shift_Support) {
			        fprintf(file, ".const %s%s%d%s -\n", orig_buf, 
				        SEP_LBITSELECT, i, SEP_RBITSELECT);
			    } else {
			        fprintf(file, ".names %s%s%d%s\n-\n", orig_buf, 
				        SEP_LBITSELECT, i, SEP_RBITSELECT);
			    }
			}
		}
	    }
	} else {
	    sprintf(orig_buf, "%s%s%d%s", 
		    orig->name->name, SEP_LARRAY, idx, SEP_RARRAY);
	}
	sprintf(out_buf, "%s%s%d%s", 
		out_term->name->name, SEP_LARRAY, idx, SEP_RARRAY);
	new_elt = new;
	orig_elt = create_rename_term(orig->name, orig_buf, bit_lo, bit_hi);
	orig_elt->name->range = NIL(vl_range);
	orig_elt->flag = orig->flag;
	orig_elt->term_type = orig->term_type;
	out_elt = create_rename_term(out_term->name, out_buf, bit_lo, bit_hi);
	out_elt->name->range = NIL(vl_range);
	instantiate_mux(file, new_elt, orig_elt, ctrl, out_elt);
    }
    vl_chk_free((char*)hi_expr);
}


char *new_termname()
{
    static char sbuf[MAXSTRLEN];
    static unsigned int TermCount=0;

    sprintf(sbuf, "%s%x", NODE, TermCount++);
    return sbuf;
}

char *new_instname()
{
    static char sbuf[MAXSTRLEN];
    static unsigned int InstCount=0;

    sprintf(sbuf, "%s%x%s", NODE, InstCount++, NODE);
    return sbuf;
}


vl_range *get_decl_range(void *decl)
{
    if (!decl) return NIL(vl_range);
    switch (((typestructPtr)(decl))->type) {
    case InputDecl:
    case OutputDecl:
    case InoutDecl:
    case RegDecl:
	return ((vl_rangedeclPtr)(decl))->range;
    case WireDecl:
    case SWireDecl:
    case TriDecl:
    case Tri0Decl:
    case Tri1Decl:
    case TriandDecl:
    case TriorDecl:
    case WandDecl:
    case WorDecl:
	return ((vl_netdeclPtr)(decl))->range;
    default:
	return NIL(vl_range);
    }
}

vl_expr *get_decl_range_left(void *decl)
{
    switch (((typestructPtr)(decl))->type) {
    case InputDecl:
    case OutputDecl:
    case InoutDecl:
    case RegDecl:
	if (!((vl_rangedeclPtr)(decl))->range) return NIL(vl_expr);
	return ((vl_rangedeclPtr)(decl))->range->left;
    case WireDecl:
    case SWireDecl:
    case TriDecl:
    case Tri0Decl:
    case Tri1Decl:
    case TriandDecl:
    case TriorDecl:
    case WandDecl:
    case WorDecl:
	if (!((vl_netdeclPtr)(decl))->range) return NIL(vl_expr);
	return ((vl_netdeclPtr)(decl))->range->left;
    default:
	return NIL(vl_expr);
    }
}

vl_expr *get_decl_range_right(void *decl)
{
    switch (((typestructPtr)(decl))->type) {
    case InputDecl:
    case OutputDecl:
    case InoutDecl:
    case RegDecl:
	if (!((vl_rangedeclPtr)(decl))->range) return NIL(vl_expr);
	return ((vl_rangedeclPtr)(decl))->range->right;
    case WireDecl:
    case SWireDecl:
    case TriDecl:
    case Tri0Decl:
    case Tri1Decl:
    case TriandDecl:
    case TriorDecl:
    case WandDecl:
    case WorDecl:
	if (!((vl_netdeclPtr)(decl))->range) return NIL(vl_expr);
	return ((vl_netdeclPtr)(decl))->range->right;
    default:
	return NIL(vl_expr);
    }
}

void *
chng_decl_range(void *decl, vl_range *new_range)
{
    void *retval = NIL(void);
    if (!decl) return decl;

    switch (((typestructPtr)(decl))->type) {
    case InputDecl:
    case OutputDecl:
    case InoutDecl:
    case RegDecl:
	retval = (void*)chk_malloc(sizeof(vl_rangedecl));
	((vl_rangedeclPtr)(retval))->type = ((vl_rangedeclPtr)decl)->type;
	((vl_rangedeclPtr)(retval))->flags = ((vl_rangedeclPtr)decl)->flags;
	((vl_rangedeclPtr)(retval))->handle = ((vl_rangedeclPtr)decl)->handle;
	((vl_rangedeclPtr)(retval))->ids = lsCreate();
	((vl_rangedeclPtr)(retval))->range = new_range;
	break;
    case WireDecl:
    case SWireDecl:
    case TriDecl:
    case Tri0Decl:
    case Tri1Decl:
    case TriandDecl:
    case TriorDecl:
    case WandDecl:
    case WorDecl:
	retval = (void*)chk_malloc(sizeof(vl_netdecl));
	((vl_netdeclPtr)(retval))->type = ((vl_netdeclPtr)decl)->type;
	((vl_netdeclPtr)(retval))->flags = ((vl_netdeclPtr)decl)->flags;
	((vl_netdeclPtr)(retval))->strength = ((vl_netdeclPtr)decl)->strength;
	((vl_netdeclPtr)(retval))->delay = ((vl_netdeclPtr)decl)->delay;
	((vl_netdeclPtr)(retval))->handle = ((vl_netdeclPtr)decl)->handle;
	((vl_netdeclPtr)(retval))->ids = lsCreate();
	((vl_netdeclPtr)(retval))->range = new_range;
	break;
    default:
	break;
    }
    return retval;
}

short get_decl_flags(void *decl)
{
    if (!decl) return 0;

    switch (((typestructPtr)(decl))->type) {
    case InputDecl:
    case OutputDecl:
    case InoutDecl:
    case RegDecl:
	return ((vl_rangedeclPtr)(decl))->flags;
    case WireDecl:
    case SWireDecl:
    case TriDecl:
    case Tri0Decl:
    case Tri1Decl:
    case TriandDecl:
    case TriorDecl:
    case WandDecl:
    case WorDecl:
	return ((vl_netdeclPtr)(decl))->flags;
    default:
	return 0;
    }
}

void get_type(vl_id_range *id, vl_type **var_type)
{
    
    id = id;
    var_type = var_type;
}


void get_hilo(vl_id_range *id, int *hi, int *lo)
{
    vl_expr *left, *right;
    int leftval, rightval;

    if (get_decl_range(id->mpg_master_exp)) {
	left = get_decl_range_left(id->mpg_master_exp);
	right = get_decl_range_right(id->mpg_master_exp);
	leftval = vl_eval_expr(left);
	rightval = vl_eval_expr(right);
	if (leftval > rightval) {
	    int temp;

	    temp=leftval; leftval = rightval; rightval = temp;
	}
	*lo = leftval;
	*hi = rightval;
    } else {
	*lo = 0;
	*hi = -1;
    }
}



void insert_control_list(var_info *cur_var, vl_term *sel)
{
    vl_id_range *id_sym;

    if (!sel) return;
    st_lookup(vl_currentModule->sig_st, cur_var->id->name, (char**)&id_sym);
    lsNewEnd(cur_var->cond_list, (lsGeneric)sel, LS_NH);
}


void print_control_var_pair(FILE *file, char *ctrl, char *var)
{
    fprintf(file, "%s %s ", ctrl, var);
}


 
vl_term *write_multi_in_or(FILE *file, lsList in_list)
{
    lsGen gen;
    lsHandle handle;
    vl_term *term_out;
    vl_term *in_term, *true_in_term;
    int i, j;
    char *cp;
    FILE *old_file;

    term_out = new_term(NIL(vl_range), 0, -1);

    if (shift_Support) {
	write_var_decl(file, term_out);
	fprintf(file, ".subckt %s %s ", cp=new_termname(), new_instname());
	fprintf(lib_file, ".cfsm %s\n", cp);
	fprintf(lib_file, ".inputs ");
    } else {
        fprintf(file, ".names ");
    }
    gen = lsStart(in_list);
    if (lsNext(gen, (lsGeneric*)&in_term, &handle) == LS_OK) {
	true_in_term = (vl_term*)((int)in_term & (~1));
	if (shift_Support) {
	    fprintf(file, "%s=%s ", true_in_term->name->name,
		    true_in_term->name->name);
	    fprintf(lib_file, "%s ", true_in_term->name->name);
	} else {
	    fprintf(file, "%s ", true_in_term->name->name);
	}
	while (lsNext(gen, (lsGeneric*)&in_term, &handle) != LS_NOMORE) {
	    true_in_term = (vl_term*)((int)in_term & (~1));
	    if (shift_Support) {
	        fprintf(file, "%s=%s ", true_in_term->name->name,
		        true_in_term->name->name);
	        fprintf(lib_file, ", %s ", true_in_term->name->name);
	    } else {
	        fprintf(file, "%s ", true_in_term->name->name);
	    }
	}
    }
    if (shift_Support) {
        fprintf(file, " | %s=%s\n", term_out->name->name, term_out->name->name);
	fprintf(lib_file, "\n.outputs %s\n", term_out->name->name);
	old_file = file;
	file = lib_file;
    } else {
        fprintf(file, "%s\n", term_out->name->name);
    }
    lsFinish(gen);

    if (set_notation) {
	if (shift_Support) {
	} else {
	    fprintf(file, "%s 1\n", HSIS_DEFAULT);
	}
    } else {
	gen = lsStart(in_list);
	for (i=0; i<lsLength(in_list); i++) {
	    lsNext(gen, (lsGeneric*)&in_term, &handle);
	    for (j=0; j<lsLength(in_list); j++) {
		fprintf(file, "%c ", (i==j)?(((int)in_term&1)?'0':'1'):'-');
	    }
	    fprintf(file, "1\n");
	}
	lsFinish(gen);
    }

    gen = lsStart(in_list);
    if (lsNext(gen, (lsGeneric*)&in_term, &handle) == LS_OK) {
	fprintf(file, "%c ", ((int)in_term&1)?'1':'0');
	while (lsNext(gen, (lsGeneric*)&in_term, &handle) != LS_NOMORE) {
	    fprintf(file, "%c ", ((int)in_term&1)?'1':'0');
	}
    }
    lsFinish(gen);
    fprintf(file, "0\n");

    if (shift_Support) {
	fprintf(file, ".end\n\n");
	file = old_file;
    }

    return term_out;
}


 
vl_term *array_or(FILE *file, array_t *in_array)
{
    vl_term *term_out;
    vl_term *in_term, *true_in_term;
    int i, j;
    char *cp;
    FILE *old_file;
    int ithItem;

    term_out = new_term(NIL(vl_range), 0, -1);

    if (dumpSMVPlus) { 
	
	int ith_term=0;
	fprintf(file, "%s %s %s", SMV_DEFINE, 
		term_out->name->name, SMV_COL_ASSIGN);
	for (i=0; i<array_n(in_array); i++) {
	    in_term = array_fetch(vl_term*, in_array, i);
	    if (in_term) {
		if (ith_term==0)
		    fprintf(file, "%s", in_term->name->name);
		else 
		    fprintf(file, "%s%s", SMV_OR, in_term->name->name);
		ith_term++;
	    }
	}
	if (ith_term==0) fprintf(file, "1");
	fprintf(file, " ;\n");
    } else {
	if (shift_Support) {
	    write_var_decl(file, term_out);
	    fprintf(file, ".subckt %s %s ", cp=new_termname(), new_instname());
	    fprintf(lib_file, ".cfsm %s\n", cp);
	    fprintf(lib_file, ".inputs ");
	} else {
	    fprintf(file, ".names ");
	}
	ithItem = 0;
	for (i=0; i<array_n(in_array); i++) {
	    true_in_term = array_fetch(vl_term*, in_array, i);
	    if (true_in_term) {
		if (shift_Support) {
		    fprintf(file, "%s=%s ", true_in_term->name->name,
			    true_in_term->name->name);
		    if (ithItem > 0) {
		        fprintf(lib_file, ", %s ", true_in_term->name->name);
		    } else {
		        fprintf(lib_file, "%s ", true_in_term->name->name);
		    }
		    ithItem++;
		} else {
		    fprintf(file, "%s ", true_in_term->name->name);
		}
	    }
	    
	}
	if (shift_Support) {
	    fprintf(file, "%s=%s\n", term_out->name->name,
		    term_out->name->name);
	    fprintf(lib_file, "\n.outputs %s\n", term_out->name->name);
	    old_file = file;
	    file = lib_file;
	} else {
	    fprintf(file, "%s\n", term_out->name->name);
	}

	if (set_notation) {
	    if (shift_Support) {
	    } else {
	        fprintf(file, "%s 1\n", HSIS_DEFAULT);
	    }
	} else {
	    for (i=0; i<array_n(in_array); i++) {
		in_term = array_fetch(vl_term*, in_array, i);
		if (!in_term) continue;
		for (j=0; j<array_n(in_array); j++) {
		    if (array_fetch(vl_term*, in_array, j))
			fprintf(file, "%c ", (i==j)?'1':'-');
		}
		fprintf(file, "1\n");
	    }
	}
	
	for (i=0; i<array_n(in_array); i++)
	    if (array_fetch(vl_term*, in_array, i))
		fprintf(file, "0 ");
	fprintf(file, "0\n");

	if (shift_Support) {
	    fprintf(file, ".end\n\n");
	    file = old_file;
	}
    }

    return term_out;
}


vl_term *syndrome_to_control(FILE *file, char *key, st_table *sig_st)
{
    vl_term *retval=NIL(vl_term);
    vl_id_range *id_sym;
    syndrome_expr *se;
    vl_term *ctrl_term;
    int ith_var = 0;
    char *syndrome;
    char *dc;
    lsList comp;
    lsGen gen;
    lsHandle handle;
    var_info *cur_var;
    int fg_id = -1;
    char lc_name[MAXSTRLEN];
    int need_leading_and = 1;
    char *cp;
    FILE *old_file;
    int ithItem;

    if (!st_lookup(sig_st, key, (char**)&cur_var)) return true_term(file);
    id_sym = cur_var->id;

    
    if (!(dc = check_dc((!rst_ckt)?id_sym->syndrome_expr_list:
			id_sym->rst_syndrome_expr_list)))
	return NIL(vl_term);;
    
    
    retval = new_term(NIL(vl_range), 0, -1);
    if (shift_Support) 
	write_var_decl(file, retval);
    if (!vlTimedSystem)
	if (isTautology((!rst_ckt)?id_sym->syndrome_expr_list:
			           id_sym->rst_syndrome_expr_list)) 
	    retval->flag |= TautologyTrue;
    if (vlTimedSystem && !rst_ckt) {
	for (gen=lsStart((!rst_ckt)?
			 id_sym->syndrome_expr_list:
			 id_sym->rst_syndrome_expr_list); 
	     lsNext(gen,(lsGeneric*)&se,&handle)!=LS_NOMORE; ) {
	    st_table *dummy;
	    if (st_lookup(vl_description->fg_vars_st, (char*)se->fg_id, 
			  (char**)&dummy)) 
		if (dummy == sig_st) {
		    fg_id = se->fg_id; break;
		}
	}
	lsFinish(gen);
	sprintf(lc_name, "%s%06x", FG_LC_PS, fg_id);
	if (fg_id != -1) { 
	    if (dumpSMVPlus)
 	        
	        { }
	    else
		
		fprintf(file, ".names %s ", lc_name);
	} else {           
	  if (dumpSMVPlus)
	      
	      fprintf(file, "%s %s %s 0;\n",
		      SMV_DEFINE, retval->name->name, SMV_COL_ASSIGN);
	  else
	      
	      fprintf(file, ".names %s\n0\n", retval->name->name);
	  retval->flag |= ConflictFalse;
	  return retval;
	}
    } else {
	if (dumpSMVPlus) 
	    need_leading_and = 0;
	else {
	    if (shift_Support) {
		fprintf(file, ".subckt %s %s ", 
			cp=new_termname(), new_instname());
		fprintf(lib_file, ".cfsm %s\n", cp);
	    } else {
	        fprintf(file, ".names ");
	    }
	}
    }
    ithItem = 0;
    for (gen=lsStart((!rst_ckt)?ctrl_list:rst_ctrl_list), ith_var=0; 
	 lsNext(gen,(lsGeneric*)&ctrl_term,&handle)!=LS_NOMORE; ith_var++) {
	if (!dumpSMVPlus)
	    
	    if (!dc[ith_var]) {
		if (shift_Support) {
		    fprintf(file, "%s=%s ", ctrl_term->name->name,
			    ctrl_term->name->name);
		    if (ithItem > 0) {
		        fprintf(lib_file, ", %s ", ctrl_term->name->name);
		    } else {
		        fprintf(lib_file, ".inputs %s ", ctrl_term->name->name);
		    }
		    ithItem++;
		} else {
		    fprintf(file, "%s ", ctrl_term->name->name);
		}
	    }
    }
    lsFinish(gen);
    
    if (shift_Support) {
        if (ithItem > 0) {
            for (gen=lsStart((!rst_ckt)?ctrl_list:rst_ctrl_list), ith_var = 0;
                 lsNext(gen, (lsGeneric*)&ctrl_term, &handle) != LS_NOMORE;
                 ith_var++) {
              if (!dc[ith_var]) {
                  fprintf(lib_file, "\n.mv %s 2", ctrl_term->name->name);
              }
            }
            lsFinish(gen);
            fprintf(lib_file, "\n");
        }
    }
    
    if (dumpSMVPlus)
	
	fprintf(file, "%s %s %s\n\t%s\n", 
		SMV_DEFINE, retval->name->name, SMV_COL_ASSIGN, SMV_CASE);
    else {
	
	if (shift_Support) {
	    fprintf(file, "| %s=%s\n", retval->name->name, retval->name->name);
	    fprintf(lib_file, "\n.outputs %s\n", retval->name->name);
            fprintf(lib_file, ".mv %s 2\n", retval->name->name);
	    old_file = file;
	    file = lib_file;
	} else {
	    fprintf(file, "%s\n", retval->name->name);
	}
    }
    
    
    if (set_notation) 
	if (!dumpSMVPlus && !shift_Support) 
	    fprintf(file, "%s 0\n", HSIS_DEFAULT);
    if (shift_Support)
	fprintf(file, ".trans\n");

    for (gen=lsStart((!rst_ckt)?
		     id_sym->syndrome_expr_list:
		     id_sym->rst_syndrome_expr_list); 
	 lsNext(gen,(lsGeneric*)&se,&handle)!=LS_NOMORE; ) {
	st_table *dummy;
	int printed;

	printed = 0;
	if (st_lookup(vl_description->fg_vars_st, (char*)se->fg_id, 
		      (char**)&dummy))
	    if (dummy == sig_st) {
	        if (dumpSMVPlus) fprintf(file, "\t");
		if (vlTimedSystem && !rst_ckt) 
		    fg_put_loc_context(file, se->pre_cond, lc_name);
		fprintf(file, " ");
		printed = put_entry(file, se->syndrome, dc, need_leading_and);
		if (!need_leading_and && !printed)
		    fprintf(file, "%d ", 1);
		if (dumpSMVPlus) fprintf(file, "%s %d;\n", SMV_COLON, 1);
		else fprintf(file, "1\n");
	    }
    }
    lsFinish(gen);

    if (dumpSMVPlus) {
	
	fprintf(file, "\t%d %s %d;\n\t%s;\n", 1, SMV_COLON, 0, SMV_ESAC);
    }
    
    if (!set_notation) {
	comp=put_guard_zero(file, (!rst_ckt)?
			    id_sym->syndrome_expr_list:
			    id_sym->rst_syndrome_expr_list);
	for (gen=lsStart(comp); lsNext(gen,&syndrome,&handle)!=LS_NOMORE; ) {
	    put_entry(file, syndrome, dc, 1);
	    fprintf(file, "0\n");
	}
	lsFinish(gen);
    }

    if (shift_Support) {
	fprintf(file, ".end\n\n");
	file = old_file;
    }

    vl_chk_free(dc);
    
    return retval;
}


lsList put_guard_zero(FILE *file, lsList se_list)
{
    lsList retval=(lsList)0;

    return retval;
}


lsList get_transition(FILE *file)
{
    lsList retval;
    char buf[MAXSTRLEN], *cp;
    char syndrome[MAXSTRLEN];
    int n_entries, i;

    retval = lsCreate();
    while (fgets(buf, MAXSTRLEN-1, file)) {
	if ((cp = strstr(buf, ".p")) != NIL(char)) {
	    cp += strlen(".p");
	    n_entries = atoi(cp);
	    for (i=0; i<n_entries && fgets(buf, MAXSTRLEN-1, file); i++) {
		sscanf(buf, "%s", syndrome);
		lsNewEnd(retval, vlStrdup(syndrome), 0);
	    }
	    break;
	}
    }
    return retval;
}


int put_entry(FILE *file, char *str, char *dc, int need_leading_and)
{
    unsigned int i;
    lsGen gen;
    lsHandle handle;
    vl_term *ctrl_term;
    int ith_term=0;
    int print_something=0;

    for (i=0, gen=lsStart((!rst_ckt)?ctrl_list:rst_ctrl_list); 
	 i<strlen(str) && lsNext(gen,(lsGeneric*)&ctrl_term,&handle)!=LS_NOMORE;
	 i++) {
        if (!dc) {
	    if (dumpSMVPlus) {
	        
	        switch(str[i]) {
		case '1': 
		    print_something = 1;
		    if (!need_leading_and && ith_term==0)
			fprintf(file, "%s ", ctrl_term->name->name);
		    else
			fprintf(file, "%s %s ", 
				SMV_AND, ctrl_term->name->name); 
		    ith_term++;
		    break;
		case '0': 
		    print_something = 1;
		    if (!need_leading_and && ith_term==0)
			fprintf(file, "%s%s ", SMV_NOT, ctrl_term->name->name);
		    else
			fprintf(file, "%s %s%s ",
				SMV_AND, SMV_NOT, ctrl_term->name->name); 
		    ith_term++;
		    break;
		default:;
		}
	    } else
	        
	        fprintf(file, "%c ", str[i]);
	} else if (!dc[i]) {
	    if (dumpSMVPlus) {
	        
	        switch(str[i]) {
		case '1': 
		    print_something = 1;
		    if (!need_leading_and && ith_term==0)
			fprintf(file, "%s ", ctrl_term->name->name);
		    else
			fprintf(file, "%s %s ", 
				SMV_AND, ctrl_term->name->name); 
		    ith_term++;
		    break;
		case '0': 
		    print_something = 1;
		    if (!need_leading_and && ith_term==0)
			fprintf(file, "%s%s ", SMV_NOT, ctrl_term->name->name);
		    else
			fprintf(file, "%s %s%s ",
				  SMV_AND, SMV_NOT, ctrl_term->name->name); 
		    ith_term++;
		    break;
		default:;
		}
	    } else
	        
	        fprintf(file, "%c ", str[i]);
	}
    }

    return print_something;
}


int put_blif_header(FILE *file, lsList se_list)
{
    int terminal_count=0;
    int retval;
    unsigned int i;
    syndrome_expr *se;

    fprintf(file, ".model scratch\n");
    fprintf(file, ".outputs n%d\n", retval = terminal_count++);
    if (lsLength(se_list)) {
	fprintf(file, ".inputs");
	lsFirstItem(se_list, (lsGeneric*)&se, 0);
	for (i=0; i<strlen(se->syndrome); i++) {
	    fprintf(file, " n%d", terminal_count++);
	}
	fprintf(file, "\n");
    }
    return retval;
}


int put_blif_gate_header(FILE *file, lsList se_list)
{
    int terminal_count=0;
    int retval;
    unsigned int i;
    syndrome_expr *se;
    char *cp;
    FILE *old_file;

    if (shift_Support) {
	fprintf(file, ".subckt %s %s ", cp=new_termname(), new_instname());
	fprintf(lib_file, ".cfsm %s\n", cp);
	fprintf(lib_file, ".inputs ");
	old_file = file;
	file = lib_file;
    } else {
        fprintf(file, ".names");
    }
    if (lsLength(se_list)) {
	lsFirstItem(se_list, (lsGeneric*)&se, 0);
	for (i=0; i<strlen(se->syndrome); i++) {
	    fprintf(file, " n%d", ++terminal_count);
	}
    }
    fprintf(file, " n%d\n", retval = ++terminal_count);

    if (shift_Support) {
	fprintf(file, ".end\n\n");
	file = old_file;
    }
    return retval;
}

void put_blif_tail(FILE *file)
{
    fprintf(file, ".end\n\n");
}

 
vl_term *write_array_access(FILE *file, vl_id_range *id_sym, vl_term *idx_term, vl_expr *idx_expr)
{
    int lo, hi, idx;
    int bit_lo, bit_hi, bit;
    int i, j;
    unsigned int k;
    vl_term *retval;
    char buf[MAXSTRLEN];

    lo = vl_eval_expr(id_sym->range->left);
    if (id_sym->range->right)
	hi = vl_eval_expr(id_sym->range->right);
    else
	hi = lo;

    
    if (!idx_term) {
	int const_hi, const_lo;

	assert(ISVLCONST(idx_expr->type));
	
	const_hi = min_bit_width(hi)-1;
	const_lo = 0;
	idx_term = new_term(NIL(vl_range), const_lo, const_hi);
	write_var_decl(file, idx_term);
	vl_write_const(file, idx_expr, idx_term);
    }

    
    get_hilo(id_sym, &bit_hi, &bit_lo);
    retval = new_term(NIL(vl_range), bit_lo, bit_hi); 
    retval->flag = id_sym->flags;
    retval->term_type = id_sym->id_type;
    write_var_decl(file, retval);

    if (dumpSMVPlus) {
        
        if (smv_NSyntax) {
	    
	    char buf[MAXSTRLEN];
	    char *cp;
	    strcpy(buf, id_sym->name);
	    if ((cp=strstr(buf, SEP_GATEPIN))) *cp = '\0';
	    fprintf(file, "%s %s %s %s %s %s %s;\n", SMV_ASSIGN, 
		    retval->name->name, SMV_COL_ASSIGN,
		    buf, SEP_LARRAY,idx_term->name->name,SEP_RARRAY);
	} else {
	    fprintf(file, "%s %s %s\n\t%s\n", SMV_ASSIGN, retval->name->name,
		    SMV_COL_ASSIGN, SMV_CASE);
	    for (i=0; i<(1<<(vector_width(idx_term->lo,idx_term->hi))); i++) {
	        if (i<=hi && i>=lo)
		    fprintf(file, "\t%s%s%d %s %s %s%d%s ;\n", idx_term->name->name, 
			    SMV_EQUAL, i, SMV_COLON, 
			    id_sym->name, SEP_LARRAY, i, SEP_RARRAY);
	    }
	    fprintf(file, "\t%d %s %d;\n\t%s;\n", 1, SMV_COLON, 0, SMV_ESAC);
	}
	return retval;
    }

    if (bit_lo > bit_hi) {
	if (id_sym->flags & MVar) {
	    
	    lsList domain;

	    domain = id_sym->id_type->specifier->u.enum_type->domain_list;
	    
	    fprintf(file, ".names ");
	    for (idx=lo; idx<=hi; idx++) {
	        fprintf(file, "%s%s%d%s ", id_sym->name, 
			SEP_LARRAY, idx, SEP_RARRAY);
	    }
	    for (i=idx_term->hi; i>=idx_term->lo; i--) {
	        fprintf(file, "%s%s%d%s ", idx_term->name->name,
			SEP_LBITSELECT, i, SEP_RBITSELECT);
	    }
	    fprintf(file, "%s\n", retval->name->name);
	    
	    
	    if (set_notation) {
	        for (i=0; i<(1<<(idx_term->hi-idx_term->lo+1)); i++) {
		    for (idx=lo; idx<=hi; idx++) fprintf(file, "- ");
		    strcpy(buf, 
			   num_to_binstr(i,(idx_term->hi-idx_term->lo+1)));
		    for (k=0; k<strlen(buf); k++)
		        fprintf(file, "%c ", buf[k]);
		    if (i <= hi && i >= lo)
			if (shift_Support)
		            fprintf(file, "( %s%s%d%s )\n",
				id_sym->name, SEP_LARRAY, i, SEP_RARRAY);
			else
		            fprintf(file, "%s%s%s%d%s\n", HSIS_EQUAL, 
				id_sym->name, SEP_LARRAY, i, SEP_RARRAY);
		    else {
			if (arrayBoundNond) {
			    fprintf(file, "-\n");
			} else {
			    vl_enumerator *enum_elt;
			    lsFirstItem(id_sym->id_type->specifier
					    ->u.enum_type->domain_list,
					(lsGeneric*)&enum_elt, 0);
			    fprintf(file, "%s\n", enum_elt->name);
			}
		    }
		}
	    } else {
	        lsList domain;
		lsGen enum_gen;
		lsHandle enum_handle;
		vl_enumerator *enum_elt;
		domain = id_sym->id_type->specifier->u.enum_type->domain_list;
		for (i=0; i<(1<<(idx_term->hi-idx_term->lo+1)); i++) {
		    for (enum_gen=lsStart(domain);
			 lsNext(enum_gen,(lsGeneric*)&enum_elt,&enum_handle)!=
			 LS_NOMORE; ) {
		        for (idx=lo; idx<=hi; idx++)
			    fprintf(file, "%s ", 
				    (idx==i)?enum_elt->name:"-");
			strcpy(buf, 	
			       num_to_binstr(i,(idx_term->hi-idx_term->lo+1)));
			for (k=0; k<strlen(buf); k++)
			    fprintf(file, "%c ", buf[k]);
			fprintf(file, "%s\n", 
				(i<=hi && i>=lo)?enum_elt->name:
				    (arrayBoundNond)?"-":enum_elt->name);
		    }
		    lsFinish(enum_gen);
		}
	    }
	} else {
	    
	    
	    fprintf(file, ".names ");
	    for (idx=lo; idx<=hi; idx++) {
		fprintf(file, "%s%s%d%s ", id_sym->name, 
			SEP_LARRAY, idx, SEP_RARRAY);
	    }
	    for (i=idx_term->hi; i>=idx_term->lo; i--) {
		fprintf(file, "%s%s%d%s ", idx_term->name->name,
			SEP_LBITSELECT, i, SEP_RBITSELECT);
	    }
	    fprintf(file, "%s\n", retval->name->name);
	    
	    
	    for (i=0; i<(1<<(idx_term->hi-idx_term->lo+1)); i++) {
		for (j=0; j<=1; j++) {
		    for (idx=lo; idx<=hi; idx++) {
			fprintf(file, "%c ", (idx==i)?((j==0)?'0':'1'):'-');
		    }
		    strcpy(buf, 
			   num_to_binstr(i, (idx_term->hi-idx_term->lo+1)));
		    for (k=0; k<strlen(buf); k++)
			fprintf(file, "%c ", buf[k]);
		    fprintf(file, "%c\n", 
			    (i<=hi && i>=lo)?((j==0)?'0':'1'):
			        (arrayBoundNond)?'-':'0');
		}
	    }
	}
    } else {
	if (Use_Abstraction) {
	    char buf[MAXSTRLEN];
	    lsList args;
	    vl_term *tdecl_term;

	    args = lsCreate();
	    sprintf(buf, "%d", lo);
	    lsNewEnd(args, (lsGeneric)vlStrdup(buf), 0);
	    sprintf(buf, "%d", hi);
	    lsNewEnd(args, (lsGeneric)vlStrdup(buf), 0);
	    sprintf(buf, "%d", bit_lo);
	    lsNewEnd(args, (lsGeneric)vlStrdup(buf), 0);
	    sprintf(buf, "%d", bit_hi);
	    lsNewEnd(args, (lsGeneric)vlStrdup(buf), 0);
	    sprintf(buf, "%d", idx_term->lo);
	    lsNewEnd(args, (lsGeneric)vlStrdup(buf), 0);
	    sprintf(buf, "%d", idx_term->hi);
	    lsNewEnd(args, (lsGeneric)vlStrdup(buf), 0);

	    fprintf(file, "%s %s %s ", 
		    (Use_Macro)?".macro":".subckt", 
		    gen_lib_encode(LIBindex,args), new_termname());
	    for (idx=lo; idx<=hi; idx++) {
		fprintf(file, "i%d=%s%s%d%s ", 
			idx, id_sym->name, SEP_LARRAY, idx, SEP_RARRAY);
	    }
	    fprintf(file, "s=%s ", idx_term->name->name);
	    fprintf(file, "o=%s\n", retval->name->name);
	    if (!set_find(gen_lib_encode(LIBindex,args), mod_list->lib_st)) {
		set_add(gen_lib_encode(LIBindex,args), mod_list->lib_st);
		file = lib_file;
		fprintf(file, ".model %s\n", gen_lib_encode(LIBindex,args));
		for (idx=lo; idx<=hi; idx++)
		    fprintf(file, ".inputs i%d\n", idx);
		fprintf(file, ".inputs s\n");
		fprintf(file, ".outputs o\n");
		tdecl_term = create_rename_term(retval->name, vlStrdup("o"),
					      bit_lo, bit_hi);
		write_var_decl(file, tdecl_term);
		vl_free_term(tdecl_term);
		tdecl_term = create_rename_term(idx_term->name, vlStrdup("s"),
					      idx_term->lo, idx_term->hi);
		write_var_decl(file, tdecl_term);
		vl_free_term(tdecl_term);
		for (idx=lo; idx<=hi; idx++) {
		    tdecl_term = create_rename_term(id_sym, vlStrdup("i"),
						  bit_lo, bit_hi);
		    write_var_decl(file, tdecl_term);
		    vl_free_term(tdecl_term);
		}
		for (idx=lo; idx<=hi; idx++) {
		    fprintf(file, ".bundle i%d ", idx);
		    for (bit=bit_lo; bit<=bit_hi; bit++) {
			fprintf(file, "%s%s%d%s%s%d%s ", id_sym->name,
				SEP_LARRAY, idx, SEP_RARRAY,
				SEP_LBITSELECT, bit, SEP_RBITSELECT);
		    }
		    fprintf(file, "\n");
		}
		fprintf(file, ".bundle s ");
		if (idx_term->lo > idx_term->hi) {
		    fprintf(file, "%s", idx_term->name->name);
		} else {
		    for (bit=idx_term->lo; bit<=idx_term->hi; bit++)
			fprintf(file, "%s%s%d%s ", idx_term->name->name,
				SEP_LBITSELECT, bit, SEP_RBITSELECT);
		}
		fprintf(file, "\n");
		fprintf(file, ".bundle o ");
		for (bit=bit_lo; bit<=bit_hi; bit++)
		    fprintf(file, "%s%s%d%s ", retval->name->name,
			    SEP_LBITSELECT, bit, SEP_RBITSELECT);
		fprintf(file, "\n");

		
		for (bit=bit_lo; bit<=bit_hi; bit++) {
		    fprintf(file, ".names ");
		    for (idx=lo; idx<=hi; idx++) {
			fprintf(file, "%s%s%d%s%s%d%s ", id_sym->name, 
				SEP_LARRAY, idx, SEP_RARRAY,
				SEP_LBITSELECT, bit, SEP_RBITSELECT);
		    }
		    for (i=idx_term->hi; i>=idx_term->lo; i--) {
			fprintf(file, "%s%s%d%s ", idx_term->name->name,
				SEP_LBITSELECT, i, SEP_RBITSELECT);
		    }
		    fprintf(file, "%s%s%d%s\n", 
			    retval->name->name, 
			    SEP_LBITSELECT,bit,SEP_RBITSELECT);
		
		    
		    for (i=0; i<(1<<(idx_term->hi-idx_term->lo+1)); i++) {
			for (j=0; j<=1; j++) {
			    for (idx=lo; idx<=hi; idx++) {
				fprintf(file, "%c ",
					(idx==i)?((j==0)?'0':'1'):'-');
			    }
			    strcpy(buf, 
			       num_to_binstr(i,(idx_term->hi-idx_term->lo+1)));
			    for (k=0; k<strlen(buf); k++)
				fprintf(file, "%c ", buf[k]);
			    fprintf(file, "%c\n", 
				    (i<=hi && i>=lo)?
				    ((j==0)?'0':'1'):
				        (arrayBoundNond)?'-':'0');
			}
		    }
		}
	    }

	    fprintf(file, ".end\n");
	    lsDestroy(args, vl_chk_free);
	} else {
	    if (UninterpretedFunction) {
		fprintf(file, ".subckt %s %s <= %s %s <= %s %s => %s\n",
			HSIS_MEMREAD, HSIS_REGFILE, id_sym->name, 
			HSIS_ADDRESS, idx_term->name->name, 
			HSIS_VALUE, retval->name->name);
	    } else {
		for (bit=bit_lo; bit<=bit_hi; bit++) {
		    
		    fprintf(file, ".names ");
		    for (idx=lo; idx<=hi; idx++) {
			fprintf(file, "%s%s%d%s%s%d%s ", id_sym->name, 
				SEP_LARRAY, idx, SEP_RARRAY,
				SEP_LBITSELECT, bit, SEP_RBITSELECT);
		    }
		    for (i=idx_term->hi; i>=idx_term->lo; i--) {
			fprintf(file, "%s%s%d%s ", idx_term->name->name,
				SEP_LBITSELECT, i, SEP_RBITSELECT);
		    }
		    fprintf(file, "%s%s%d%s\n", 
			    retval->name->name, 
			    SEP_LBITSELECT,bit,SEP_RBITSELECT);
		
		    
		    for (i=0; i<(1<<(idx_term->hi-idx_term->lo+1)); i++) {
			for (j=0; j<=1; j++) {
			    for (idx=lo; idx<=hi; idx++) {
				fprintf(file, "%c ",
					(idx==i)?((j==0)?'0':'1'):'-');
			    }
			    strcpy(buf, 
				   num_to_binstr(i,(idx_term->hi-idx_term->lo+1)));
			    for (k=0; k<strlen(buf); k++)
				fprintf(file, "%c ", buf[k]);
			    fprintf(file, "%c\n", 
				    (i<=hi && i>=lo)?
				    ((j==0)?'0':'1'):(arrayBoundNond)?'-':'0');
			}
		    }
		}
	    }
	}
    }

    return retval;
}



char *sel_var(char *name)
{
    return name;
}

int isMVar(short unsigned flag)
{
    return (flag & MVar);
}

int isOutPort(short unsigned flag)
{
    return (flag & OutPort);
}


void check_assign(vl_bassign_stmt *assign, int procedural)
{
    vl_id_range *lhs_id;
    char buf[MAXSTRLEN];

    st_lookup(vl_currentModule->sig_st, 
	      assign->lhs->name->name, (char**)&lhs_id);

    if (procedural) {
	if (assign->type != NbassignStmt &&
	    assign->type != DelayNbassignStmt &&
	    assign->type != EventNbassignStmt &&
	    !(lhs_id->flags & RegVar)) {
	    yylineno = assign->lineno;
	    sprintf(buf, 
              "error: wire '%s' is used as lhs of = in procedural statement\n",
		    lhs_id->name);
	    compile_error(buf);
	}
	if (lhs_must_be_wire && (lhs_id->flags & RegVar)) {

	}
	if (compatibleChecking && !(lhs_id->flags & RegVar)) {
	    yylineno = assign->lineno;
	    sprintf(buf, 
              "error: wire '%s' is used as lhs of <= in procedural statement\n",
		    lhs_id->name);
	    compile_error(buf);
	}
    } else {
	if (lhs_id->flags & RegVar) {
	    yylineno = assign->lineno;
	    sprintf(buf, 
	      "error: reg '%s' is used as lhs of continus assignment\n",
		    lhs_id->name);
	    compile_error(buf);
	}
    }
}


void instantiate_reset_mux(FILE *file, vl_id_range *id_sym, int lo, int hi,
  var_info *var, var_info *lvar)
{
    extern vl_term *Initial_Signal;
    vl_term *term_out;
    char buf[MAXSTRLEN];
    vl_term *init_term;
    
    sprintf(buf, "%s%s", id_sym->name, new_termname());
    term_out = create_rename_term(id_sym, buf, lo, hi);
    term_out->flag = 
	get_decl_flags(var->id->mpg_master_exp);
    write_var_decl(file,term_out);
    lsFirstItem(id_sym->initial, (lsGeneric*)&init_term, 0);
    instantiate_mux(file, init_term,
		    lvar->current_terminal,
		    Initial_Signal, term_out);
    lvar->current_terminal = term_out;
}


void instantiate_input_latch(FILE *file, vl_id_range *id_sym)
{
    char buf[MAXSTRLEN];
    
    sprintf(buf, "%s%s%s", id_sym->name, SEP_DIR, PIN_IN);
    if (id_sym->flags & InPort && id_sym->flags & RegVar) {
	if (!instantiateInputLatch) return;
	if (dumpSMVPlus) {
   	    
	    fprintf(file, "%s %s(%s)%s%s ;\n", SMV_ASSIGN, SMV_TRANS,
		    buf, SMV_COL_ASSIGN, id_sym->name);
	} else {
	    
	    if (id_sym->flags & MVar) {
	        fprintf(file, ".latch %s %s\n", id_sym->name, buf);
	    } else {
	        int i, lo, hi;
	    
	        get_hilo(id_sym, &hi, &lo);
	        if (lo > hi) {
		    fprintf(file, ".latch %s %s\n", id_sym->name, buf);
	        } else {
		    for (i=lo; i<=hi; i++) {
		        fprintf(file, ".latch %s%s%d%s %s%s%d%s\n",
			        id_sym->name, 
			        SEP_LBITSELECT, i, SEP_RBITSELECT,
			        buf, SEP_LBITSELECT, i, SEP_RBITSELECT);
		    }
	        }
	    }
        }
    }
}


void instantiate_hidden_latch(FILE *file, vl_id_range *id_sym)
{
    char buf[MAXSTRLEN];
    lsList domain;
    lsGen enum_gen;
    lsHandle enum_handle;
    vl_enumerator *enum_elt;

    
    if (!id_sym->mpg_master_exp) return; 
    if (strstr(id_sym->name, SEP_LATCH)) return;

    sprintf(buf, "%s%s", id_sym->name, PIN_HIDDEN);
    if (id_sym->flags & HiddenLatch) {
	if (id_sym->flags & MVar) {
	    domain = id_sym->id_type->specifier->u.enum_type->domain_list;
	    fprintf(file, ".mv %s %d ", buf, lsLength(domain));
	    for (enum_gen = lsStart(domain);
		 lsNext(enum_gen, (lsGeneric*)&enum_elt, &enum_handle) != 
		     LS_NOMORE;) {
		fprintf(file, "%s ", enum_elt->name);
	    }
	    lsFinish(enum_gen);
	    fprintf(file, "\n");
	    fprintf(file, ".latch %s %s\n", id_sym->name, buf);
	    fprintf(file, ".r %s\n-\n", buf);
	} else {
	    int i, lo, hi;
	    
	    get_hilo(id_sym, &hi, &lo);
	    if (lo > hi) {
		fprintf(file, ".latch %s %s\n", id_sym->name, buf);
		fprintf(file, ".r %s\n-\n", buf);
	    } else {
		for (i=lo; i<=hi; i++) {
		    fprintf(file, ".latch %s%s%d%s %s%s%d%s\n",
			    id_sym->name, SEP_LBITSELECT, i, SEP_RBITSELECT,
			    buf, SEP_LBITSELECT, i, SEP_RBITSELECT);
		    fprintf(file, ".r %s%s%d%s\n-\n",
			    buf, SEP_LBITSELECT, i, SEP_RBITSELECT);
		}
	    }
	}
    }
}


char *check_dc(lsList syndrome_expr_list)
{
    lsGen lgen;
    lsHandle handle;
    char *retval;
    int nsym;
    syndrome_expr *se;
    int i;
    int rtvl;

    if (lsLength(syndrome_expr_list) == 0) return NIL(char);

    rtvl = lsFirstItem(syndrome_expr_list,(lsGeneric*)&se,0);
    assert(rtvl == LS_OK);
    nsym = strlen(se->syndrome);
    retval = (char*)chk_malloc(nsym * sizeof(char));
    for (i=0; i<nsym; i++) {
	retval[i] = 1;
	for (lgen=lsStart(syndrome_expr_list); 
	     lsNext(lgen,(lsGeneric*)&se,&handle)!=LS_NOMORE;) {
	    if (se->syndrome[i] != '-')
		retval[i] = 0;
	}	
	(void)lsFinish(lgen);
    }

    return retval;
}


void put_nblock_transition(FILE *file, int non_block_wire, int n_entries, 
		      vl_id_range *id_sym, int idx_lo, int idx_hi, int cur, char *dc, lsList ripple)
{
    lsGen lgen;
    lsList comp;
    lsHandle handle;
    int lo, hi;
    int i, j, k;
    char *syndrome;
    syndrome_expr *se;
    lsList domain=(lsList)0;
    lsGen enum_gen;
    lsHandle enum_handle;
    vl_enumerator *enum_elt;

    for (lgen=lsStart((!rst_ckt)?
		      id_sym->syndrome_expr_list:
		      id_sym->rst_syndrome_expr_list), 
	 i=0;
	 lsNext(lgen,(lsGeneric*)&se,&handle)!=LS_NOMORE; i++) {
	if (!(id_sym->flags & MVar)) {
	    lo=0; hi=1;
	} else {
	    get_hilo(id_sym, &hi, &lo);
	}

	if (id_sym->id_type)
	    domain = id_sym->id_type->specifier->u.enum_type->domain_list;
	    
	if (!(id_sym->flags & MVar)) {
	    for (k=lo; k<=hi; k++) {
		if (vlTimedSystem && !rst_ckt) 
		    fg_put_loc_context(file, se->pre_cond, NIL(char));
		fprintf(file, " ");
		put_entry(file, se->syndrome, dc, 1);

		if (ripple) {
		    for (j=0; j<i; j++) fprintf(file, "- ");
		    fprintf(file, "%d ", 1); j++;
		    for (; j<n_entries; j++) fprintf(file, "- ");
		}
		
		for (j=0; j<i; j++) fprintf(file, "- ");
		fprintf(file, "%d ", k); j++;
		for (; j<n_entries; j++) fprintf(file, "- ");
		fprintf(file, "%s%d\n", (non_block_wire||rst_ckt)?"":"- ", k);
	    }
	} else {
	    for (enum_gen=lsStart(domain);
		 lsNext(enum_gen,
			(lsGeneric*)&enum_elt,&enum_handle)!=LS_NOMORE;) {
		if (vlTimedSystem && !vlTimedSystem) 
		    fg_put_loc_context(file, se->pre_cond, NIL(char));
		fprintf(file, " ");
		put_entry(file, se->syndrome, dc, 1);

		if (ripple) { 
		    for (j=0; j<i; j++) fprintf(file, "- ");
		    fprintf(file, "%d ", 1); j++;
		    for (; j<n_entries; j++) fprintf(file, "- ");
		}
		
		for (j=0; j<i; j++) fprintf(file, "- ");
		fprintf(file, "%s ", enum_elt->name); j++;
		for (; j<n_entries; j++) fprintf(file, "- ");
		fprintf(file, "%s%s\n", 
			(non_block_wire||rst_ckt)?"":"- ", enum_elt->name);
	    }
	    lsFinish(enum_gen);
	}
	
	
    }
    lsFinish(lgen);

    
    if (deadlock_semantic) {
	comp = put_guard_zero(file, (!rst_ckt)?id_sym->syndrome_expr_list:
			      id_sym->rst_syndrome_expr_list);
	if (comp)
	    if (lsLength(comp) > 0 && !(id_sym->flags & RegVar)) {
		char buf[MAXSTRLEN], tmp_buf[MAXSTRLEN];
		strcpy(tmp_buf, id_sym->name);
		strip_char(tmp_buf,SEP_LATCH);
		sprintf(buf, "%s: wire '%s' might be unassigned in certain context(s).\n", vl_currentModule->name->name, tmp_buf);
		strcat(buf, "\tDeadlock is assumed. To make its value a don't care, turn off -k option");
		if (WarningLevel > 0)
		    Translate_Notice(buf);
	    }
    }

    
    if (!set_notation && !(deadlock_semantic && non_block_wire)) {
	comp = put_guard_zero(file, (!rst_ckt)?id_sym->syndrome_expr_list:
			      id_sym->rst_syndrome_expr_list);
	if (!(id_sym->flags & MVar)) { 
	    for (lgen=lsStart(comp); 
		 lsNext(lgen,&syndrome,&handle)!=LS_NOMORE;) {
		if (!(id_sym->flags & MVar)) {
		    lo=0; hi=1;
		}
		for (k=lo; k<=hi; k++) {
		    put_entry(file, syndrome, dc, 1);
		    for (j=0; j<n_entries*((ripple)?2:1); j++) 
			fprintf(file, "- ");
		    if (non_block_wire || rst_ckt)
			fprintf(file, "%d\n", k);
		    else
			fprintf(file, "%d %d\n", k, k);
		}
	    }
	    lsFinish(lgen);
	} else { 
	    for (lgen=lsStart(comp); 
		 lsNext(lgen,&syndrome,&handle)!=LS_NOMORE;) {
		if (!(id_sym->flags & MVar)) {
		    lo=0; hi=1;
		}
		for (enum_gen=lsStart(domain);
		     lsNext(enum_gen,
			    (lsGeneric*)&enum_elt,&enum_handle)!=LS_NOMORE;) {
		    put_entry(file, syndrome, dc, 1);
		    for (j=0; j<n_entries*((ripple)?2:1); j++) 
			fprintf(file, "- ");
		    if (non_block_wire || rst_ckt)
			fprintf(file, "%s\n", enum_elt->name);
		    else
			fprintf(file, "%s %s\n", 
				enum_elt->name, enum_elt->name);
		}
		lsFinish(enum_gen);
	    }
	    lsFinish(lgen);
	}
    }

    
    idx_lo = idx_lo;
    idx_hi = idx_hi;
    cur = cur;
}


void put_nblock_mout_transition(FILE *file, int non_block_wire,
				int n_entries, 
				vl_id_range *id_sym,
				int idx_lo, int idx_hi, int cur,
				char *dc, char *latch_name)
{
    lsGen lgen;
    lsList comp;
    lsHandle handle;
    int lo, hi;
    int i, j, k;
    char *syndrome;
    syndrome_expr *se;

    for (lgen=lsStart((!rst_ckt)?
		      id_sym->syndrome_expr_list:
		      id_sym->rst_syndrome_expr_list), 
	 i=0;
	 lsNext(lgen,(lsGeneric*)&se,&handle)!=LS_NOMORE; i++) {
	if (!(id_sym->flags & MVar)) {
	    lo=0; hi=1;
	} else {
	    get_hilo(id_sym, &hi, &lo);
	}

	if (vlTimedSystem && !rst_ckt) 
	    fg_put_loc_context(file, se->pre_cond, NIL(char));
	fprintf(file, " ");
	put_entry(file, se->syndrome, dc, 1);
	    
	for (j=0; j<n_entries; j++) 
	    if (idx_lo == 0 && idx_hi == -1)
		fprintf(file, "- ");
	    else
		for (k=idx_lo; k<=idx_hi; k++) fprintf(file, "- ");
	if (!(non_block_wire||rst_ckt)) {
	    if (idx_lo == 0 && idx_hi == -1)
		fprintf(file, "- ");
	    else
		for (k=idx_lo; k<=idx_hi; k++)
		    fprintf(file, "- ");
	}
	if (id_sym->flags & MVar || (idx_lo==0 && idx_hi==-1)) {
	    if (shift_Support)
	        fprintf(file, "( %s )\n", se->expr->name->name);
	    else
	        fprintf(file, "%s%s\n", HSIS_EQUAL, se->expr->name->name);
	} else {
	    for (k=idx_lo; k<=idx_hi; k++) {
		if (shift_Support)
		    fprintf(file, "( %s%s%d%s ) ",
			se->expr->name->name, 
			SEP_LBITSELECT, k, SEP_RBITSELECT);
	    	else
		    fprintf(file, "%s%s%s%d%s ", HSIS_EQUAL,
			se->expr->name->name, 
			SEP_LBITSELECT, k, SEP_RBITSELECT);
	    }
	    fprintf(file, "\n");
	}
    }
    lsFinish(lgen);
    
    
    if (deadlock_semantic) {
	comp = put_guard_zero(file, (!rst_ckt)?id_sym->syndrome_expr_list:
			      id_sym->rst_syndrome_expr_list);
	if (comp)
	    if (lsLength(comp) > 0 && !(id_sym->flags & RegVar)) {
		char buf[MAXSTRLEN], tmp_buf[MAXSTRLEN];
		strcpy(tmp_buf, id_sym->name);
		strip_char(tmp_buf,SEP_LATCH);
		sprintf(buf, "%s: wire '%s' might be unassigned in certain context(s).\n", vl_currentModule->name->name, tmp_buf);
		strcat(buf, "\tDeadlock is assumed. To make its value a don't care, use -k option");
		if (WarningLevel > 0)
		    Translate_Notice(buf);
	    }
    }

    
    if (!set_notation && !(deadlock_semantic && non_block_wire)) {
	comp = put_guard_zero(file, (!rst_ckt)?id_sym->syndrome_expr_list:
			      id_sym->rst_syndrome_expr_list);
	for (lgen=lsStart(comp); 
	     lsNext(lgen,&syndrome,&handle)!=LS_NOMORE;) {

	    put_entry(file, syndrome, dc, 1);
	    for (j=0; j<n_entries; j++) 
		if (idx_lo == 0 && idx_hi == -1)
		    fprintf(file, "- ");
		else
		    for (k=idx_lo; k<=idx_hi; k++) fprintf(file, "- ");
	    if (!(non_block_wire || rst_ckt)) {
		if (idx_lo == 0 && idx_hi == -1)
		    fprintf(file, "- ");
		else
		    for (k=idx_lo; k<=idx_hi; k++)
			fprintf(file, "- ");
	    }
	    if (id_sym->flags & MVar || (idx_lo==0 && idx_hi==-1)) {
		if (!(non_block_wire || rst_ckt)) {
		    if (shift_Support)
		        fprintf(file, "( %s )\n", latch_name);
		    else
		        fprintf(file, "%s%s\n", HSIS_EQUAL, latch_name);
		} else {
		    fprintf(file, "-\n");
		}
	    } else {
		if (!(non_block_wire || rst_ckt))
		    for (k=idx_lo; k<=idx_hi; k++) {
			if (shift_Support)
			    fprintf(file, "( %s%s%d%s ) ",
				latch_name, SEP_LBITSELECT, k, SEP_RBITSELECT);
			else
			    fprintf(file, "%s%s%s%d%s ", HSIS_EQUAL, 
				latch_name, SEP_LBITSELECT, k, SEP_RBITSELECT);
		    }
		else
		    for (k=idx_lo; k<=idx_hi; k++) {
			fprintf(file,"-");
		    }
		fprintf(file, "\n");
	    }
	}

	lsFinish(lgen);
    }

    
    cur = cur;
}


void create_wire_nondeterminism(FILE *file, char * var_name,
				vl_id_range *id_sym, array_t *vars_array)
{
    char buf[MAXSTRLEN];
    char input_buf[MAXSTRLEN];
    char *cp;
    st_table *vars;
    var_info *cur_var;
    int h, i, j, k, l;
    int hi, lo;
    int num_changer=0;
    lsList domain;
    lsGen enum_gen;
    lsHandle enum_handle;
    vl_enumerator *enum_elt;
    FILE *old_file = NULL;
    
    
    get_hilo(id_sym, &hi, &lo);
    
    cp = buf; *cp = '\0';
    if (shift_Support) {
    } else {
        cp = strappend(cp, ".names ");
    }
    for (i=0; i<array_n(vars_array); i++) {
	vars = array_fetch(st_table*, vars_array, i);
	if (vars) {
	    if (st_lookup(vars, var_name, (char**)&cur_var)) {
		num_changer++;
		cp = strappendS(cp,
				cur_var->current_terminal->name->name);
	    }
	}
    }
    strcpy(input_buf, buf);
    if (!num_changer) 
	if (!((id_sym->flags & OutPort) && Zconnection))
	    return;

    
    if (id_sym->flags &MVar || UninterpretedFunction) {
	if (dumpSMVPlus) {
	    
	    if (Zconnection)
	        fprintf(file, "%s %s %s ", 
			SMV_ASSIGN, triPort(id_sym->name), SMV_COL_ASSIGN);
	    else
	        fprintf(file, "%s %s %s\n\t%s\n",
			SMV_ASSIGN, id_sym->name, SMV_COL_ASSIGN, SMV_CASE);
	} else {
	    
	    if (shift_Support) {
		fprintf(file, ".subckt %s %s %s | %s=%s\n", cp=new_termname(),
			new_instname(),
			cfsm_inputs(buf), id_sym->name, id_sym->name);
		fprintf(lib_file, ".cfsm %s\n", cp);
		fprintf(lib_file, ".inputs %s\n", cfsm_ports(buf));
		fprintf(lib_file, ".outputs %s\n", id_sym->name);
		fprintf(lib_file, ".trans\n");
		old_file = file;
		file = lib_file;
	    } else {
	        fprintf(file, "%s %s\n", buf, id_sym->name);
	    }
	}
	
	
	if (set_notation) {
	    for (i=0; i<array_n(vars_array); i++) {
		vars = array_fetch(st_table*, vars_array, i);
		if (vars) {
		    if (st_lookup(vars, var_name, (char**)&cur_var)) {
			if (dumpSMVPlus) {
			    if (Zconnection)
			        fprintf(file, "%s %s ", 
					cur_var->current_terminal->name->name,
					SMV_OR);
			    else
			        fprintf(file, "\t%d %s %s ;\n", 1, SMV_COLON,
					cur_var->current_terminal->name->name);
			} else {
			    
			    for (j=0; j<num_changer; j++) {
				fprintf(file, "- ");
			    } 
			    if (shift_Support)
			        fprintf(file, "( %s )\n",
				    cur_var->current_terminal->name->name);
			    else
			        fprintf(file, "%s%s\n", HSIS_EQUAL,
				    cur_var->current_terminal->name->name);
			}
		    }
		}
	    }
	    if (dumpSMVPlus) {
	        if (Zconnection)
		    fprintf(file, "%d;\n", 0);
	        else
		    fprintf(file, "\t%s;\n", SMV_ESAC);
	    }
	} else {
	    domain = id_sym->id_type->specifier->u.enum_type->domain_list;
	    for (i=0; i<num_changer; i++) {
		for (enum_gen=lsStart(domain);
		     lsNext(enum_gen,
			    (lsGeneric*)&enum_elt,&enum_handle)!=LS_NOMORE;) {
		    for (k=0; k<num_changer; k++) {
			fprintf(file, "%s ", (i==k)?enum_elt->name:"-");
		    }
		    fprintf(file, "%s\n", enum_elt->name);
		}
		lsFinish(enum_gen);
	    }
	} 
        if (shift_Support) {
	    fprintf(file, ".end\n\n");
	    file = old_file;
        }

    } else if (lo > hi) {
	
	if (dumpSMVPlus) {
	    
	    if (Zconnection)
	        fprintf(file, "%s %s %s ", 
			SMV_ASSIGN, triPort(id_sym->name), SMV_COL_ASSIGN);
	    else
	        fprintf(file, "%s %s %s\n\t%s\n",
			SMV_DEFINE, id_sym->name, SMV_COL_ASSIGN, SMV_CASE);
	} else {
	    
	    if (shift_Support) {
		fprintf(file, ".subckt %s %s %s | %s=%s\n", cp=new_termname(),
			new_instname(),
			cfsm_inputs(buf), id_sym->name, id_sym->name);
		fprintf(lib_file, ".cfsm %s\n", cp);
		fprintf(lib_file, ".inputs %s\n", cfsm_ports(buf));
		fprintf(lib_file, ".outputs %s\n", id_sym->name);
		fprintf(lib_file, ".trans\n");
		old_file = file;
		file = lib_file;
	    } else {
	        fprintf(file, "%s %s\n", buf, id_sym->name);
	    }
	}
	
	if (dumpSMVPlus) {
	    
	    for (i=0; i<array_n(vars_array); i++) {
		vars = array_fetch(st_table*, vars_array, i);
		if (vars) {
		    if (st_lookup(vars, var_name, (char**)&cur_var)) {
		        if (Zconnection)
			    fprintf(file, "%s %s ",
				    cur_var->current_terminal->name->name,
				    SMV_OR);
			else
			    fprintf(file, "\t%d %s %s ;\n", 1, SMV_COLON,
				    cur_var->current_terminal->name->name);
		    }
		}
	    }
	    if (Zconnection)
	        fprintf(file, "%d;\n", 0);
	    else
	        fprintf(file, "\t%s;\n", SMV_ESAC);
	} else {
	    
	    for (i=0; i<num_changer; i++) {
		for (j=0; j<=1; j++) {
		    for (k=0; k<num_changer; k++) {
			fprintf(file, "%c ", (i==k)?'0'+j:'-');
		    }
		    fprintf(file, "%d\n", j);
		}
	    }
	}

	if (shift_Support) {
	    fprintf(file, ".end\n\n");
	    file = old_file;
	}
    } else {
	array_t *ctrlv;
	
	if (dumpSMVPlus) {
	    
	    if (num_changer == 1) {
	        
	        fprintf(file, "%s %s %s ", 
			SMV_ASSIGN, triPort(id_sym->name), SMV_COL_ASSIGN);
	        for (i=0; i<array_n(vars_array); i++) {
		    vars = array_fetch(st_table*, vars_array, i);
		    if (vars) {
		        if (st_lookup(vars, var_name, (char**)&cur_var)) {
			    fprintf(file, "%s ;\n",
				    cur_var->current_terminal->name->name);
			}
		    }
		}
	    } else {
	        for (h=lo; h<=hi; h++) {
		    fprintf(file, "%s %s %s%d%s %s ",
			    SMV_ASSIGN, triPort(id_sym->name), 
			    SEP_LBITSELECT, h, SEP_RBITSELECT, SMV_COL_ASSIGN);
		    
		    for (i=0; i<array_n(vars_array); i++) {
		        vars = array_fetch(st_table*, vars_array, i);
			if (vars) {
			    if (st_lookup(vars, var_name, (char**)&cur_var)) {
			        if (cur_var->current_terminal->lo<=h && 
				    cur_var->current_terminal->hi>=h)
				    fprintf(file, "%s %s%d%s %s ",
					cur_var->current_terminal->name->name,
					SEP_LBITSELECT, h, SEP_RBITSELECT,
					SMV_OR);
			    }
			}
		    }
		    fprintf(file, "%d;\n", 0);
		}
	    }
	} else {
	    
	    for (h=lo; h<=hi; h++) {
	        cp = buf; *cp = '\0';
		if (shift_Support) {
		} else {
		    cp = strappend(cp, ".names ");
		}
		ctrlv = array_alloc(char*,0);
		for (i=0, num_changer=0; i<array_n(vars_array); i++) {
		    vars = array_fetch(st_table*, vars_array, i);
		    if (vars) {
		        if (st_lookup(vars, var_name, (char**)&cur_var)) {
			    char tmp_buf[MAXSTRLEN];
			    int real_changer = 0;
			    if (h == lo &&
				cur_var->current_terminal->lo > 
				cur_var->current_terminal->hi)
			        real_changer = 1;
			    if (cur_var->current_terminal->lo <=
				cur_var->current_terminal->hi) 
			        if (cur_var->current_terminal->lo <= h &&
				    cur_var->current_terminal->hi >= h)
				    real_changer = 1;
			    if (real_changer) {
			        num_changer++;
			    
				if (Use_Abstraction && h==lo) {
				    fprintf(file, ".bundle %s ", 
					cur_var->current_terminal->name->name);
				    for (l=cur_var->current_terminal->lo;
					 l<=cur_var->current_terminal->hi;
					 l++) {
				        fprintf(file, "%s%s%d%s ", 
						cur_var->current_terminal->
					        name->name,
						SEP_LBITSELECT, l, SEP_RBITSELECT);
				    }
				    fprintf(file, "\n");
				}

				sprintf(tmp_buf, "%s%s%d%s",
					cur_var->current_terminal->name->name,
					SEP_LBITSELECT, h, SEP_RBITSELECT);
				cp = strappendS(cp, tmp_buf);
				array_insert_last(char*,ctrlv,
						  vlStrdup(cur_var->current_terminal->name->name));
			    }
			}
		    }
		}
		if (!num_changer) continue;
		if (Use_Abstraction && h==lo) {
		    fprintf(file, ".bundle %s ",id_sym->name);
		    for (l=lo; l<=hi; l++) {
		        fprintf(file, "%s%s%d%s ", id_sym->name, 
				SEP_LBITSELECT, l, SEP_RBITSELECT);
		    }
		    fprintf(file, "\n");
		}
		if (shift_Support && h==lo) {
		    fprintf(file, ".subckt %s %s %s | %s=%s\n", 
			    cp=new_termname(), new_instname(), 
			    cfsm_inputs(input_buf), id_sym->name, 
			    id_sym->name);
		    fprintf(lib_file, ".cfsm %s\n", cp);
		    fprintf(lib_file, ".inputs %s\n", cfsm_ports(input_buf));
		    fprintf(lib_file, ".outputs %s\n", id_sym->name);
		    fprintf(lib_file, ".mv %s %d\n", id_sym->name, 
			    ipower(2,hi-lo+1));
		    fprintf(lib_file, ".mv %s %d\n",
                            shift_mv_vars(input_buf, ipower(2,hi-lo+1)), ipower(2,hi-lo+1));
		    fprintf(lib_file, ".trans\n");
		    old_file = file;
		    file = lib_file;
		} else if (!shift_Support) {
		    fprintf(file, "%s %s%s%d%s\n", buf, id_sym->name,
			    SEP_LBITSELECT, h, SEP_RBITSELECT);
		}
		if (set_notation) {
		    for (i=0; i<num_changer; i++) {
			if (h==lo || !shift_Support) 
			    for (k=0; k<num_changer; k++) {
				fprintf(file, "- ");
			    }
			if (shift_Support && h==lo)
			    fprintf(file, "( %s )\n",
				array_fetch(char*, ctrlv, i));
			else if (!shift_Support)
			    fprintf(file, "%s%s%s%d%s\n", HSIS_EQUAL,
				array_fetch(char*, ctrlv, i),
				SEP_LBITSELECT, h, SEP_RBITSELECT);
		    }
		} else {
		    for (i=0; i<num_changer; i++) {
		        for (j=0; j<=1; j++) {
			    for (k=0; k<num_changer; k++) {
			        fprintf(file, "%c ", (i==k)?'0'+j:'-');
			    }
			    fprintf(file, "%d\n", j);
			}
		    }
		}

		for (i=0; i<array_n(ctrlv); i++) 
		    vl_chk_free(array_fetch(char*, ctrlv, i));
		array_free(ctrlv);

		if (shift_Support && h==lo) {
		    fprintf(file, ".end\n\n");
		    file = old_file;
                }
	    }
	}
    }
}


vl_term *put_quasi_control(FILE *file, char *dc, char *quasi_name, vl_id_range *id_sym, int n_entries)
{
    int ith_var;
    vl_term *ctrl_term;
    vl_term *retval;
    lsGen lgen;
    lsHandle handle;
    syndrome_expr *se;
    int retval_width, retval_range;
    char *dummy;

    
    
    retval_range = lsLength((!rst_ckt)?
			    id_sym->syndrome_expr_list:
			    id_sym->rst_syndrome_expr_list);
    retval_width  = min_bit_width(retval_range);
    retval = new_term(NIL(vl_range), 0, retval_width-1);
    if (dumpSMVPlus) {
	
	fprintf(file, "%s %s,%s%s%s %s %s %d%s%d %s %s;\n", SMV_VAR,
		retval->name->name, retval->name->name, SEP_GATEPIN, PIN_NS,
		SMV_COLON, SMV_ARRAY, retval->hi, SMV_RANGE, retval->lo,
		SMV_OF, SMV_BOOLEAN);
	if (!st_lookup(vl_currentModule->combVar_st, quasi_name, &dummy)) {
	    
	    fprintf(file, 
		    "%s (%s%s%d;%s%s%d;%s%s%s%s%d)\n\t%s %s(%s[%s])%s%d;\n", 
		    SMV_FOR,
		        SMV_INDEX, SMV_EQUAL, retval->lo,
		        SMV_INDEX, SMV_LE, retval->hi,
		        SMV_INDEX, SMV_EQUAL, SMV_INDEX, SMV_PLUS, 1,
		    SMV_ASSIGN, SMV_INIT, 
		    retval->name->name, SMV_INDEX,
		    SMV_COL_ASSIGN, 0);
	}
	if (!st_lookup(vl_currentModule->combVar_st, quasi_name, &dummy)) {
	    fprintf(file, "%s %s(%s)%s%s%s%s ;\n", SMV_ASSIGN, SMV_TRANS,
		    retval->name->name, SMV_COL_ASSIGN, 
		    retval->name->name, SEP_GATEPIN, PIN_NS);
	} else {
	    fprintf(file, "%s %s%s%s%s%s ;\n", SMV_ASSIGN,
		    retval->name->name, SMV_COL_ASSIGN, 
		    retval->name->name, SEP_GATEPIN, PIN_NS);
	}

	fprintf(file, "%s %s%s%s %s\n\t%s\n", SMV_DEFINE, 
		retval->name->name, SEP_GATEPIN, PIN_NS, SMV_COL_ASSIGN,
		SMV_CASE);
	for (lgen=lsStart((!rst_ckt)?
			  id_sym->syndrome_expr_list:
			  id_sym->rst_syndrome_expr_list), ith_var=0;
	     lsNext(lgen,(lsGeneric*)&se,&handle)!=LS_NOMORE; 
	     ith_var++) {
	    fprintf(file, "\t");
	    if (vlTimedSystem && !rst_ckt) {
		fprintf(file, "(");
		fg_put_loc_context(file, se->pre_cond, NIL(char));
		fprintf(file, ")");
	    }
	    put_entry(file, se->syndrome, dc, (vlTimedSystem && !rst_ckt));
	    fprintf(file, "%s %d;\n", SMV_COLON, 
		    (strcmp(se->expr->name->name, quasi_name))?ith_var+1:0);
	}
	(void)lsFinish(lgen);
	if (!st_lookup(vl_currentModule->combVar_st, quasi_name, &dummy)) {
	    fprintf(file, "\t%d %s %s ;\n", 1, SMV_COLON, retval->name->name);
	} else {
	    fprintf(file, "\t%d %s %d;\n", 1, SMV_COLON, 0);
	}
	fprintf(file, "\t%s;\n", SMV_ESAC);
    } else {
	
	fprintf(file, ".mv %s,%s%s%s %d\n", 
		retval->name->name, retval->name->name, SEP_GATEPIN, PIN_NS,
		n_entries+1);
	fprintf(file, ".latch %s%s%s %s\n", 
		retval->name->name, SEP_GATEPIN, PIN_NS, retval->name->name);
	fprintf(file, ".r %s\n0\n", retval->name->name);

	
	fprintf(file, ".names ");
	
	for (lgen=lsStart((!rst_ckt)?ctrl_list:rst_ctrl_list), ith_var=0;
	     lsNext(lgen,(lsGeneric*)&ctrl_term,&handle)!=LS_NOMORE; 
	     ith_var++) {
	    if (!dc[ith_var]) fprintf(file, "%s ", ctrl_term->name->name);
	}
	(void)lsFinish(lgen);
	
	fprintf(file, "%s %s%s%s\n", 
		retval->name->name, retval->name->name, SEP_GATEPIN, PIN_NS);
    
	
	
	if (shift_Support)
	    fprintf(file, "%s ( %s )\n", 
		HSIS_DEFAULT, retval->name->name);
	else
	    fprintf(file, "%s %s%s\n", 
		HSIS_DEFAULT, HSIS_EQUAL, retval->name->name);
	
	for (lgen=lsStart((!rst_ckt)?
			  id_sym->syndrome_expr_list:
			  id_sym->rst_syndrome_expr_list), ith_var=0;
	     lsNext(lgen,(lsGeneric*)&se,&handle)!=LS_NOMORE; 
	     ith_var++) {
	    if (vlTimedSystem && !rst_ckt) 
		fg_put_loc_context(file, se->pre_cond, NIL(char));
	    fprintf(file, " ");
	    put_entry(file, se->syndrome, dc, 1);
	    fprintf(file, "- %d\n", 
		    (strcmp(se->expr->name->name,quasi_name))?ith_var+1:0);
	}
	(void)lsFinish(lgen);
    }

    {
        
        char buf[MAXSTRLEN];
	sprintf(buf, "%s%s%s", retval->name->name, SEP_GATEPIN, PIN_NS);
	vl_chk_free(retval->name->name);
	retval->name->name = vlStrdup(buf);
    }

    return retval;
}


void put_quasi_table(FILE *file, char *dc, char *quasi_name, char *sync_name, 
		     vl_id_range *id_sym, vl_term *out_term, int lo, int hi,
		     int n_entries)
{
    int ith_var, j;
    lsGen lgen;
    lsHandle handle;
    syndrome_expr *se;
    vl_term *ctrl_term;
    char *dummy;

    
    ctrl_term = put_quasi_control(file, dc, quasi_name, id_sym, n_entries);

    if (dumpSMVPlus) {
	
	fprintf(file, "%s %s %s\n\t%s\n", SMV_DEFINE, 
		out_term->name->name, SMV_COL_ASSIGN, SMV_CASE);
	for (lgen=lsStart((!rst_ckt)?
			  id_sym->syndrome_expr_list:
			  id_sym->rst_syndrome_expr_list), ith_var=0;
	     lsNext(lgen,(lsGeneric*)&se,&handle)!=LS_NOMORE;
	     ith_var++) {
	    if (strcmp(se->expr->name->name, quasi_name)) {
		fprintf(file, "\t%s%s%d %s %s ;\n", 
			ctrl_term->name->name, SMV_EQUAL, ith_var+1, SMV_COLON,
			se->expr->name->name);
	    }
	}
	(void)lsFinish(lgen);
	if (st_lookup(vl_currentModule->seqVar_st, quasi_name, &dummy)) {
	    fprintf(file, "\t%s%s%d %s %s ;\n", 
		    ctrl_term->name->name, SMV_EQUAL, 0, SMV_COLON, 
		    sync_name);
	} else {
	    
	    fprintf(file, "\t%d %s %d;\n", 1, SMV_COLON, 0);
	}
	fprintf(file, "\t%s;\n", SMV_ESAC);
    } else {
	
        if (hi < lo) {
	    
	    
	    fprintf(file, ".names %s ", ctrl_term->name->name);
	    
	    for (lgen=lsStart((!rst_ckt)?
			      id_sym->syndrome_expr_list:
			      id_sym->rst_syndrome_expr_list);
		 lsNext(lgen,(lsGeneric*)&se,&handle)!=LS_NOMORE;) {
	        fprintf(file, "%s ", se->expr->name->name);
	    }
	    (void)lsFinish(lgen);
	    fprintf(file, "%s ", sync_name);
	    
	    fprintf(file, "%s\n", out_term->name->name);
	
	    
	    for (lgen=lsStart((!rst_ckt)?
			      id_sym->syndrome_expr_list:
			      id_sym->rst_syndrome_expr_list), ith_var=0;
		 lsNext(lgen,(lsGeneric*)&se,&handle)!=LS_NOMORE;
		 ith_var++) {
	        if (strcmp(se->expr->name->name, quasi_name)) {
		    fprintf(file, "%d ", ith_var+1);
		    for (j=0; j<n_entries; j++) fprintf(file, "- ");
		    fprintf(file, "- %s%s\n", HSIS_EQUAL,se->expr->name->name);
		}
	    }
	    (void)lsFinish(lgen);
	    fprintf(file, "0 ");
	    for (j=0; j<n_entries; j++) fprintf(file, "- ");
	    fprintf(file, "- %s%s\n", HSIS_EQUAL, sync_name);
	} else {
	    int bit;
	    
	    
	    fprintf(file, ".names %s ", ctrl_term->name->name);
	    
	    for (lgen=lsStart((!rst_ckt)?
			      id_sym->syndrome_expr_list:
			      id_sym->rst_syndrome_expr_list);
		 lsNext(lgen,(lsGeneric*)&se,&handle)!=LS_NOMORE;) {
	        for (bit=lo; bit<=hi; bit++)
		   fprintf(file, "%s%s%d%s ", se->expr->name->name,
			   SEP_LBITSELECT, bit, SEP_RBITSELECT);
	    }
	    (void)lsFinish(lgen);
	    
	    for (bit=lo; bit<=hi; bit++)
	        fprintf(file, "%s%s%d%s%s%s ", quasi_name, 
			SEP_LBITSELECT, bit, SEP_RBITSELECT,
			SEP_GATEPIN, PIN_PS);
	    
	    fprintf(file, "%s ", HSIS_ARROW);
	    for (bit=lo; bit<=hi; bit++)
	        fprintf(file, "%s%s%d%s ", out_term->name->name,
			SEP_LBITSELECT, bit, SEP_RBITSELECT);
	    fprintf(file, "\n");
	
	    
	    for (lgen=lsStart((!rst_ckt)?
			      id_sym->syndrome_expr_list:
			      id_sym->rst_syndrome_expr_list), ith_var=0;
		 lsNext(lgen,(lsGeneric*)&se,&handle)!=LS_NOMORE;
		 ith_var++) {
	        if (strcmp(se->expr->name->name, quasi_name)) {
		    fprintf(file, "%d ", ith_var+1);
		    for (j=0; j<n_entries; j++)
		        for (bit=lo; bit<=hi; bit++) fprintf(file, "- ");
		    for (bit=lo; bit<=hi; bit++) fprintf(file, "- ");
		    for (bit=lo; bit<=hi; bit++)
		        fprintf(file, "%s%s%s%d%s ", 
				HSIS_EQUAL,se->expr->name->name,
				SEP_LBITSELECT, bit, SEP_RBITSELECT);
		    fprintf(file, "\n");
		}
	    }
	    (void)lsFinish(lgen);
	    fprintf(file, "0 ");
	    for (j=0; j<n_entries; j++)
	        for (bit=lo; bit<=hi; bit++) fprintf(file, "- ");
	    for (bit=lo; bit<=hi; bit++) fprintf(file, "- ");
	    
	    for (bit=lo; bit<=hi; bit++)
	        fprintf(file, "%s%s%s%d%s%s%s ", 
			HSIS_EQUAL, quasi_name, 
			SEP_LBITSELECT, bit, SEP_RBITSELECT, 
			SEP_GATEPIN, PIN_PS);
	    fprintf(file, "\n");
	}
    }
}


void declare_mvar_io(FILE *file, char *dir, vl_id_range *id_sym)
{
    int idx, idx_hi, idx_lo;
    
    if (dumpSMVPlus) {
	if (!id_sym->range) { 
	    fprintf(file, "%s\t%s %s", dir, id_sym->name, SMV_COLON);
	    smv_dc (file, id_sym->id_type, 0, -1);
	    fprintf(file, ";\n");
	} else { 
	    idx_lo = vl_eval_expr(id_sym->range->left);
	    if (id_sym->range->right)
		idx_hi = vl_eval_expr(id_sym->range->right);
	    else 
		idx_hi = idx_lo;
	
	    for (idx = idx_lo; idx <= idx_hi; idx++) {
		fprintf(file, "%s\t%s %s", dir, id_sym->name, SMV_COLON);
		smv_dc (file, id_sym->id_type, 0, -1);
		fprintf(file, ";\n");
	    }
	}
    } else {
	
	if (!id_sym->range) { 
	    if (shift_Support) {
		lsList domain;
		lsGen enum_gen;
		lsHandle enum_handle;
		vl_enumerator *enum_elt;
		int i;

		domain = id_sym->id_type->specifier->u.enum_type->domain_list;
		fprintf(file, "%s %s\n", dir, id_sym->name);
		fprintf(file, ".mv %s %d ", id_sym->name, lsLength(domain));
		for (enum_gen=lsStart(domain), i=0;
		     lsNext(enum_gen, (lsGeneric*)&enum_elt, &enum_handle) !=
		     LS_NOMORE; i++) {
		    fprintf(file, "%s ", enum_elt->name);
		}
		lsFinish(enum_gen);
		fprintf(file, "\n");
	    } else {
		fprintf(file, "%s %s", dir, id_sym->name);
		fprintf(file, "\n");
	    }
	} else { 
	    idx_lo = vl_eval_expr(id_sym->range->left);
	    if (id_sym->range->right)
		idx_hi = vl_eval_expr(id_sym->range->right);
	    else 
		idx_hi = idx_lo;
	
	    for (idx = idx_lo; idx <= idx_hi; idx++) {
		fprintf(file, "%s %s%s%d%s", dir,
			id_sym->name, SEP_LARRAY, idx, SEP_RARRAY);
		fprintf(file, "\n");
	    }
	}
    }
}

void declare_bin_scalar_io(FILE *file, char *dir, vl_id_range *id_sym)
{
    int idx, idx_lo, idx_hi;

    if (dumpSMVPlus) {
	
	if (!id_sym->range) { 
	    fprintf(file, "%s\t%s %s %s;\n", dir, id_sym->name, SMV_COLON, 
		    SMV_BOOLEAN);
	} else { 
	    idx_lo = vl_eval_expr(id_sym->range->left);
	    if (id_sym->range->right)
		idx_hi = vl_eval_expr(id_sym->range->right);
	    else 
		idx_hi = idx_lo;

	    fprintf(file, "%s\t%s %s %s %d%s%d %s %s;\n", 
		    dir, id_sym->name, SMV_COLON, 
		    SMV_ARRAY, idx_hi, SMV_RANGE, idx_lo, SMV_OF, SMV_BOOLEAN);
	}
    } else {
	
	if (!id_sym->range) { 
	    if (shift_Support) {
		fprintf(file, "%s %s\n", dir, id_sym->name);
		fprintf(file, ".mv %s %d\n", id_sym->name, 2);
	    } else {
		fprintf(file, "%s %s", dir, id_sym->name);
		fprintf(file, "\n");
	    }
	} else { 
	    idx_lo = vl_eval_expr(id_sym->range->left);
	    if (id_sym->range->right)
		idx_hi = vl_eval_expr(id_sym->range->right);
	    else 
		idx_hi = idx_lo;
	
	    for (idx = idx_lo; idx <= idx_hi; idx++) {
		fprintf(file, "%s %s%s%d%s", dir,
			id_sym->name, SEP_LARRAY, idx, SEP_RARRAY);
		fprintf(file, "\n");
	    }
	}
    }
}

void declare_bin_vector_io(FILE *file, char *dir, vl_id_range *id_sym)
{
    int idx, idx_lo, idx_hi;
    int i, lo, hi;
    int ithItem;

    get_hilo(id_sym, &hi, &lo);
    
    if (dumpSMVPlus) {
	
	if (!id_sym->range) { 
	    fprintf(file, "%s\t%s %s %s %d%s%d %s %s;\n", dir, id_sym->name, 
		    SMV_COLON, SMV_ARRAY, hi, SMV_RANGE, lo, SMV_OF,
		    SMV_BOOLEAN);
	} else { 
	    idx_lo = vl_eval_expr(id_sym->range->left);
	    if (id_sym->range->right)
		idx_hi = vl_eval_expr(id_sym->range->right);
	    else 
		idx_hi = idx_lo;

	    fprintf(file, "%s\t%s %s %s %d%s%d %s %s %d%s%d %s %s;\n", 
		    dir, id_sym->name, SMV_COLON, 
		    SMV_ARRAY, idx_hi, SMV_RANGE, idx_lo, SMV_OF, 
		    SMV_ARRAY, hi, SMV_RANGE, lo, SMV_OF, SMV_BOOLEAN);
	}
    } else {
	
	if (Use_Abstraction || UninterpretedFunction) {
	    char buf[MAXSTRLEN];
	    if (!id_sym->range) { 
		fprintf(file, "%s ", dir);
		sprintf(buf, "%s", id_sym->name);
		fprintf(file, "%s ", buf);
		fprintf(file, "\n");
	    } else { 
		idx_lo = vl_eval_expr(id_sym->range->left);
		if (id_sym->range->right)
		    idx_hi = vl_eval_expr(id_sym->range->right);
		else 
		    idx_hi = idx_lo;
	    
		for (idx = idx_lo; idx <= idx_hi; idx++) {
		    fprintf(file, "%s ", dir);
		    sprintf(buf, "%s%s%d%s", id_sym->name, 
			    SEP_LARRAY, idx, SEP_RARRAY);
		    fprintf(file, "%s ", buf);
		    fprintf(file, "\n");
		}
	    }
	} else {
	    if (!id_sym->range) { 
		fprintf(file, "%s ", dir);
		ithItem = 0;
                if (shift_Support) {
		    char buf[MAXSTRLEN];

		    sprintf(buf, "%s", id_sym->name);
		    fprintf(file, "%s\n", buf);
		    fprintf(file, ".mv %s %d\n", buf, ipower(2,hi-lo+1));
                } else {
		    for (i=lo; i<=hi; i++) {
			char buf[MAXSTRLEN];
		
			sprintf(buf, "%s%s%d%s", id_sym->name, 
				SEP_LBITSELECT, i, SEP_RBITSELECT);
			if (shift_Support) {
			    if (ithItem > 0) 
				fprintf(file, ", ");
			    ithItem++;
			}
			fprintf(file, "%s ", buf);
		    }
		    fprintf(file, "\n");
                }
	    } else { 
		idx_lo = vl_eval_expr(id_sym->range->left);
		if (id_sym->range->right)
		    idx_hi = vl_eval_expr(id_sym->range->right);
		else 
		    idx_hi = idx_lo;
		
		for (idx = idx_lo; idx <= idx_hi; idx++) {
		    fprintf(file, "%s ", dir);
		    for (i=lo; i<=hi; i++) {
			char buf[MAXSTRLEN];
		    
			sprintf(buf, "%s%s%d%s%s%d%s", id_sym->name, 
				SEP_LARRAY, idx, SEP_RARRAY,
				SEP_LBITSELECT, i, SEP_RBITSELECT);
			fprintf(file, "%s ", buf);
		    }
		    fprintf(file, "\n");
		}
	    }
	}
    }
}


void put_const_port_connect(FILE *file, char *outstr,
			    vl_id_range *master,
			    vl_port_connect *instance,
			    lsList input_consts,
			    vl_term *term_out)
{
    int i, hi, lo;
    char buf[MAXSTRLEN];

    get_hilo(master, &hi, &lo);
    if (isMVar(master->flags)) {
	
	sprintf(buf, "%s=%s ", master->name, term_out->name->name);
    } else {
	
	if (lo > hi) {
	    
	    sprintf(buf, "%s=%s ", 
		    master->name, term_out->name->name);
	} else {
	    
	    if (Use_Abstraction) {
		sprintf(buf, "%s=%s ", master->name, term_out->name->name);
	    } else {
		char tmp[MAXSTRLEN];

		buf[0] = '\0';
		for (i=lo; i<=hi; i++) {
		    sprintf(tmp, "%s%s%d%s=%s%s%d%s ",
			    master->name,
			    SEP_LBITSELECT, i, SEP_RBITSELECT,
			    term_out->name->name,
			    SEP_LBITSELECT, i, SEP_RBITSELECT);
		    strcat(buf, tmp);
		}
	    }
	}
    }
    
    if (file) fprintf(file, "%s", buf);
    if (outstr) sprintf(outstr, "%s", buf);
}


void put_mvar_port_connect(FILE *file, char *outstr,
			   vl_id_range *master,
			   vl_port_connect *instance)
{
    int idx, idx_lo, idx_hi;
    char buf[MAXSTRLEN];

    if (!master->range) {  
	sprintf(buf, "%s=%s ", 
		master->name,
		instance->expr->term->name->name);
    } else { 
	char tmp[MAXSTRLEN];

	buf[0] = '\0';
	idx_lo = vl_eval_expr(master->range->left);
	if (master->range->right)
	    idx_hi = vl_eval_expr(master->range->right);
	else 
	    idx_hi = idx_lo;
	
	for (idx=idx_lo; idx<=idx_hi; idx++) {
	    sprintf(tmp, "%s%s%d%s=%s%s%d%s ", 
		    master->name, SEP_LARRAY, idx, SEP_RARRAY,
		    instance->expr->term->name->name,
		    SEP_LARRAY, idx, SEP_RARRAY);
	    strcat(buf, tmp);
	}
    }

    if (file) fprintf(file, "%s", buf);
    if (outstr) sprintf(outstr, "%s", buf);
}


void put_bin_scalar_port_connect(FILE *file, char *outstr,
				 vl_id_range *master,
				 vl_port_connect *instance)
{
    int idx, idx_lo, idx_hi;
    char buf[MAXSTRLEN];

    if (dumpSMVPlus) {
        sprintf(buf, "%s", instance->expr->term->name->name);

	if (file) fprintf(file, "%s", buf);
	if (outstr) sprintf(outstr, "%s", buf);
	return;
    }

    if (instance->expr->term->lo > instance->expr->term->hi){
	if (!master->range) {  
	    sprintf(buf, "%s=%s ", 
		    master->name,
		    instance->expr->term->name->name);
	} else { 
	    char tmp[MAXSTRLEN];

	    buf[0] = '\0';
	    idx_lo = vl_eval_expr(master->range->left);
	    if (master->range->right)
		idx_hi = vl_eval_expr(master->range->right);
	    else 
		idx_hi = idx_lo;
	    
	    for (idx=idx_lo; idx<=idx_hi; idx++) {
		sprintf(tmp, "%s%s%d%s=%s%s%d%s ", 
			master->name,
			SEP_LARRAY, idx, SEP_RARRAY,
			instance->expr->term->name->name,
			SEP_LARRAY, idx, SEP_RARRAY);
		strcat(buf, tmp);
	    }			    
	}
    } else {
	if (!master->range) { 
	    sprintf(buf, "%s=%s%s%d%s ", 
		    master->name,
		    instance->expr->term->name->name,
		    SEP_LBITSELECT, 
		    instance->expr->term->lo,
		    SEP_RBITSELECT);
	} else {
	    char tmp[MAXSTRLEN];

	    buf[0] = '\0';
	    idx_lo = vl_eval_expr(master->range->left);
	    if (master->range->right)
		idx_hi = vl_eval_expr(master->range->right);
	    else 
		idx_hi = idx_lo;
	    
	    for (idx=idx_lo; idx<=idx_hi; idx++) {
		sprintf(tmp, "%s%s%d%s=%s%s%d%s%s%d%s ", 
			master->name, 
			SEP_LARRAY, idx, SEP_RARRAY,
			instance->expr->term->name->name, 
			SEP_LARRAY, idx, SEP_RARRAY,
			SEP_LBITSELECT, 
			instance->expr->term->lo,
			SEP_RBITSELECT);
		strcat(buf, tmp);
	    }
	}
    }

    if (file) fprintf(file, "%s", buf);
    if (outstr) sprintf(outstr, "%s", buf);
}


void put_bin_vector_port_connect(FILE *file, char *outstr,
				 vl_id_range *master,
				 vl_port_connect *instance)
{
    int sig_lo;
    int lo, hi;
    int idx, idx_lo, idx_hi;
    int i;
    char buf[MAXSTRLEN];
    
    get_hilo(master, &hi, &lo);
    sig_lo = instance->expr->term->lo;

    if (dumpSMVPlus) {
        sprintf(buf, "%s [%d%s%d]", instance->expr->term->name->name,
		sig_lo+(hi-lo+1), SMV_RANGE, sig_lo);
	if (file) fprintf(file, "%s", buf);
	if (outstr) sprintf(outstr, "%s", buf);
	return;
    }
    
    if (!master->range) { 
	if (Use_Abstraction || UninterpretedFunction) {
	    sprintf(buf, "%s=%s ", 
		    master->name, instance->expr->term->name->name);
	} else {
	    char tmp[MAXSTRLEN];

	    buf[0] = '\0';
	    for (i=lo; i<=hi; i++) {
		char mast_buf[MAXSTRLEN];
		char inst_buf[MAXSTRLEN];
	    
		sprintf(mast_buf, "%s%s%d%s", master->name,
			SEP_LBITSELECT, i, SEP_RBITSELECT);
		sprintf(inst_buf, "%s%s%d%s", 
			instance->expr->term->name->name,
			SEP_LBITSELECT,sig_lo-lo+i,SEP_RBITSELECT);
		sprintf(tmp, "%s=%s ", mast_buf, inst_buf);
		strcat(buf, tmp);
	    }
	}
    } else {
	idx_lo = vl_eval_expr(master->range->left);
	if (master->range->right)
	    idx_hi = vl_eval_expr(master->range->right);
	else 
	    idx_hi = idx_lo;
	
	if (Use_Abstraction) {
	    for (idx=idx_lo; idx<=idx_hi; idx++) {
		char mast_buf[MAXSTRLEN];
		char inst_buf[MAXSTRLEN];
		    
		sprintf(mast_buf, "%s%s%d%s", master->name,
			SEP_LARRAY, idx, SEP_RARRAY);
		sprintf(inst_buf, "%s%s%d%s", 
			instance->expr->term->name->name,
			SEP_LARRAY, idx, SEP_RARRAY);
		sprintf(buf, "%s=%s ", mast_buf, inst_buf);
	    }
	} else {
	    char tmp[MAXSTRLEN];

	    buf[0] = '\0';
	    for (idx=idx_lo; idx<=idx_hi; idx++) {
		for (i=lo; i<=hi; i++) {
		    char mast_buf[MAXSTRLEN];
		    char inst_buf[MAXSTRLEN];
		    
		    sprintf(mast_buf, "%s%s%d%s%s%d%s", master->name,
			    SEP_LARRAY, idx, SEP_RARRAY,
			    SEP_LBITSELECT, i, SEP_RBITSELECT);
		    sprintf(inst_buf, "%s%s%d%s%s%d%s", 
			    instance->expr->term->name->name,
			    SEP_LARRAY, idx, SEP_RARRAY,
			    SEP_LBITSELECT, 
			    sig_lo-lo+i, 
			    SEP_RBITSELECT);
		    sprintf(tmp, "%s=%s ", mast_buf, inst_buf);
		    strcat(buf, tmp);
		}
	    }
	}
    }

    if (file) fprintf(file, "%s", buf);
    if (outstr) sprintf(outstr, "%s", buf);
}


void put_bin_scalar_func_connect(FILE *file, vl_id_range *master,
				 vl_term *instance)
{
    int idx, idx_lo, idx_hi;

    if (dumpSMVPlus) {
        fprintf(file, "%s", instance->name->name);
        return;
    }

    if (instance->lo > instance->hi){
	if (!master->range) {  
	    fprintf(file, "%s=%s ", 
		    master->name,
		    instance->name->name);
	} else { 
	    idx_lo = vl_eval_expr(master->range->left);
	    if (master->range->right)
		idx_hi = vl_eval_expr(master->range->right);
	    else 
		idx_hi = idx_lo;
	    
	    for (idx=idx_lo; idx<=idx_hi; idx++) {
		fprintf(file, "%s%s%d%s=%s%s%d%s ", 
			master->name,
			SEP_LARRAY, idx, SEP_RARRAY,
			instance->name->name,
			SEP_LARRAY, idx, SEP_RARRAY);
	    }			    
	}
    } else {
	if (!master->range) { 
	    fprintf(file, "%s=%s%s%d%s ", 
		    master->name,
		    instance->name->name,
		    SEP_LBITSELECT, 
		    instance->lo,
		    SEP_RBITSELECT);
	} else {
	    idx_lo = vl_eval_expr(master->range->left);
	    if (master->range->right)
		idx_hi = vl_eval_expr(master->range->right);
	    else 
		idx_hi = idx_lo;
	    
	    for (idx=idx_lo; idx<=idx_hi; idx++) {
		fprintf(file, "%s%s%d%s=%s%s%d%s%s%d%s ", 
			master->name, 
			SEP_LARRAY, idx, SEP_RARRAY,
			instance->name->name, 
			SEP_LARRAY, idx, SEP_RARRAY,
			SEP_LBITSELECT, 
			instance->lo,
			SEP_RBITSELECT);
	    }
	}
    }
}


void put_bin_vector_func_connect(FILE *file, vl_id_range *master,
				 vl_term *instance)
{
    int sig_lo;
    int lo, hi;
    int idx, idx_lo, idx_hi;
    int i;
    
    get_hilo(master, &hi, &lo);
    sig_lo = instance->lo;

    if (dumpSMVPlus) {
        fprintf(file, "%s[%d%s%d]", instance->name->name, 
		sig_lo+(hi-lo), SMV_RANGE, sig_lo);
        return;
    }
    
    if (!master->range) { 
	for (i=lo; i<=hi; i++) {
	    char mast_buf[MAXSTRLEN];
	    char inst_buf[MAXSTRLEN];
	    
	    sprintf(mast_buf, "%s%s%d%s", master->name,
		    SEP_LBITSELECT, i, SEP_RBITSELECT);
	    sprintf(inst_buf, "%s%s%d%s", 
		    instance->name->name,
		    SEP_LBITSELECT,sig_lo-lo+i,SEP_RBITSELECT);
	    fprintf(file, "%s=%s ", mast_buf, inst_buf);
	}
    } else {
	idx_lo = vl_eval_expr(master->range->left);
	if (master->range->right)
	    idx_hi = vl_eval_expr(master->range->right);
	else 
	    idx_hi = idx_lo;
	
	for (idx=idx_lo; idx<=idx_hi; idx++) {
	    for (i=lo; i<=hi; i++) {
		char mast_buf[MAXSTRLEN];
		char inst_buf[MAXSTRLEN];
		
		sprintf(mast_buf, "%s%s%d%s%s%d%s", master->name,
			SEP_LARRAY, idx, SEP_RARRAY,
			SEP_LBITSELECT, i, SEP_RBITSELECT);
		sprintf(inst_buf, "%s%s%d%s%s%d%s", 
			instance->name->name,
			SEP_LARRAY, idx, SEP_RARRAY,
			SEP_LBITSELECT, 
			sig_lo-lo+i, 
			SEP_RBITSELECT);
		fprintf(file, "%s=%s ", mast_buf, inst_buf);
	    }
	}
    }
}


char *write_red_op(FILE *file, short type, vl_term *in1, vl_term *in2, vl_term *out)
{
    int bpos;
    char *ripple=NIL(char);
    FILE *old_file;

    if (dumpSMVPlus) { 
	fprintf(file, "%s %s %s", SMV_DEFINE, out->name->name, SMV_COL_ASSIGN);
	if (type==UnandExpr || type==UnorExpr) fprintf(file, "%s", SMV_NOT);
	fprintf(file, "( ");
	for (bpos = in1->lo; bpos<=in1->hi; bpos++) {
	    switch (type) {
	      case UandExpr: case UnandExpr:
		if (bpos==in1->lo)
		    fprintf(file, "%s %s%d%s",
			    in1->name->name, SEP_LARRAY, bpos, SEP_RARRAY);
		else
		    fprintf(file, " %s %s %s%d%s", SMV_AND, 
			    in1->name->name, SEP_LARRAY, bpos, SEP_RARRAY);
	      case UorExpr:  case UnorExpr:
		if (bpos==in1->lo)
		    fprintf(file, "%s%s%d%s",
			    in1->name->name, SEP_LARRAY, bpos, SEP_RARRAY);
		else
		    fprintf(file, " %s %s %s%d%s", SMV_OR, 
			    in1->name->name, SEP_LARRAY, bpos, SEP_RARRAY);
	      default: break;
	    }
	}
	fprintf(file, " )");
	fprintf(file, ";\n");
    } else {
	if (Use_Abstraction || UninterpretedFunction) {
	    if (UninterpretedFunction) {
		fprintf(file, "%s %s %s a <= %s o => %s\n",
			(Use_Macro)?".macro":".subckt",
			sys_lib_encode(type,in1->hi-in1->lo+1,1), 
			new_termname(),
			in1->name->name, out->name->name);
		return ripple;
	    } else {
		if (shift_Support) {
		    fprintf(file, "%s %s %s a=%s | o=%s\n",
			    (Use_Macro)?".macro":".subckt",
			    lib_encode(type,in1->hi-in1->lo+1), new_termname(),
			    in1->name->name, out->name->name);
		} else {
		    fprintf(file, "%s %s %s a=%s o=%s\n",
			    (Use_Macro)?".macro":".subckt",
			    lib_encode(type,in1->hi-in1->lo+1), new_termname(),
			    in1->name->name, out->name->name);
		}
	    }
	}
    
	if (!Use_Abstraction || 
	    !set_find(lib_encode(type,in1->hi-in1->lo+1),
		      mod_list->lib_st)) {
	    if (Use_Abstraction) {
		vl_term *tdecl_term;

		set_add(lib_encode(type,in1->hi-in1->lo+1),
			mod_list->lib_st);
	    
		file = lib_file;
		fprintf(file, ".model %s\n", 
			lib_encode(type,in1->hi-in1->lo+1));
	    
		fprintf(file, ".inputs a\n");
		fprintf(file, ".outputs o\n");
		tdecl_term = create_rename_term(in1->name, vlStrdup("a"),
						in1->lo, in1->hi);
		write_var_decl(file, tdecl_term);
		vl_free_term(tdecl_term);
		tdecl_term = create_rename_term(out->name, vlStrdup("o"),
						out->lo, out->hi);
		write_var_decl(file, tdecl_term);
		vl_free_term(tdecl_term);
		fprintf(file, ".bundle a ");
		for (bpos=in1->lo; bpos<=in1->hi; bpos++) {
		    fprintf(file, "%s%s%d%s ", 
			    in1->name->name, 
			    SEP_LBITSELECT, bpos, SEP_RBITSELECT);
		}
		fprintf(file, "\n");
	    }
	
	    if (shift_Support) {
		fprintf(file, ".subckt _RED_%s %s i0=%s | o=%s\n",
			(type==UandExpr)?"AND":
			(type==UnandExpr)?"NAND":
			(type==UorExpr)?"OR":
			(type==UnorExpr)?"NOR":"OR", 
			new_instname(),
			in1->name->name, out->name->name);
		return ripple;
		/*
		fprintf(file, ".subckt %s %s ", cp=new_termname(),
			new_instname());
		fprintf(lib_file, ".cfsm %s\n", cp);
		fprintf(lib_file, ".inputs ");
		*/
	    } else {
	        fprintf(file, ".names ");
	    }
	    for (bpos=in1->lo; bpos<=in1->hi; bpos++) {
		if (shift_Support) {
		    fprintf(file, "%s%s%d%s=%s%s%d%s ", 
			    in1->name->name, 
			    SEP_LBITSELECT, bpos, SEP_RBITSELECT,
			    in1->name->name, 
			    SEP_LBITSELECT, bpos, SEP_RBITSELECT);
		    if (bpos > in1->lo) {
		        fprintf(lib_file, ", %s%s%d%s ", 
			        in1->name->name, 
			        SEP_LBITSELECT, bpos, SEP_RBITSELECT);
		    } else {
		        fprintf(lib_file, "%s%s%d%s ", 
			        in1->name->name, 
			        SEP_LBITSELECT, bpos, SEP_RBITSELECT);
		    }
		} else {
		    fprintf(file, "%s%s%d%s ", 
			    in1->name->name, 
			    SEP_LBITSELECT, bpos, SEP_RBITSELECT);
		}
	    }
	
	    if (shift_Support) {
	        fprintf(file, "| %s=%s\n", 
			(Use_Abstraction)?"o":out->name->name,
			(Use_Abstraction)?"o":out->name->name);
		fprintf(lib_file, "\n.outputs %s\n", 
			(Use_Abstraction)?"o":out->name->name);
		fprintf(lib_file, ".trans\n");
		old_file = file;
		file = lib_file;
	    } else {
	        fprintf(file, "%s\n", (Use_Abstraction)?"o":out->name->name);
	    }
	    
	    if (set_notation && !shift_Support) {
		fprintf(file, "%s %c\n", HSIS_DEFAULT, 
			(type==UnorExpr||type==UandExpr)?'0':'1');
		for (bpos=in1->lo; bpos<=in1->hi; bpos++) {
		    fprintf(file, "%c ",
			    (type==UorExpr||type==UnorExpr)?'0':'1');
		}	
		fprintf(file, "%c\n", 
			(type==UnorExpr||type==UandExpr)?'1':'0');
	    } else {
		for (bpos=in1->lo; bpos<=in1->hi; bpos++) {
		    int i;
		    for (i=in1->lo; i<=in1->hi; i++) {
			fprintf(file, "%c ", 
				(i==bpos)?
				((type==UorExpr||type==UnorExpr)?'1':'0'):'-');
		    }
		    fprintf(file, "%c\n",
			    (type==UorExpr||type==UnandExpr)?'1':'0');
		}
		for (bpos=in1->lo; bpos<=in1->hi; bpos++) {
		    fprintf(file, "%c ",
			    (type==UorExpr||type==UnorExpr)?'0':'1');
		}	
		fprintf(file, "%c\n", 
			(type==UorExpr||type==UnandExpr)?'0':'1');
		
		if (Use_Abstraction) fprintf(file, ".end\n\n");
	    }

	    if (shift_Support) {
		fprintf(file, ".end\n\n");
		file = old_file;
	    }
	}
    }

    
    in2 = in2;
    
    return ripple;
}



char *write_rel_vector_bop(FILE *file, short type, vl_term *in1, vl_term *in2, vl_term *out)
{
    int bpos, i;
    vl_term *tmpterm;
    char buf[MAXSTRLEN], term1[MAXSTRLEN], term2[MAXSTRLEN], outerm[MAXSTRLEN];
    char *ripple=NIL(char);
    lsList args=NULL;

    
    if (dumpSMVPlus) {
	fprintf(file, "%s %s %s %s %s %s ;\n", 
		SMV_DEFINE, out->name->name, SMV_COL_ASSIGN, 
		in1->name->name, vl_get_smv_expr_op(type), in2->name->name);
	return ripple;
    }

    
    if (Use_SystemFunc || (UninterpretedFunction && !(type == Beq2Expr))) {
	if (in1->hi-in1->lo == in2->hi-in2->lo) {
	    if (UninterpretedFunction) {
		if (in1->hi == -1 && in1->hi == 0)
		    fprintf(file, "%s %s %s o => %s i1 <= %s i2 <= %s\n",
			    ".subckt",
			    sys_lib_encode(type,1,1), new_termname(),
			    out->name->name, in1->name->name, in2->name->name);
		else
		    fprintf(file, "%s %s %s o => %s i1 <= %s i2 <= %s\n",
			    ".subckt", 
			    sys_lib_encode(type,in1->hi-in1->lo+1,1), new_termname(),
			    out->name->name, in1->name->name, in2->name->name);
		return ripple;
	    } else {
		if (in1->hi == -1 && in1->hi == 0) {
		    if (shift_Support) {
		        fprintf(file, "%s %s %s i1=%s i2=%s | o=%s\n",
			        (Use_Macro)?".macro":".subckt",
			        sys_lib_encode(type,1,1), new_termname(),
			        in1->name->name, in2->name->name, out->name->name);
		    } else {
		        fprintf(file, "%s %s %s o=%s i1=%s i2=%s\n",
			        (Use_Macro)?".macro":".subckt",
			        sys_lib_encode(type,1,1), new_termname(),
			        out->name->name, in1->name->name, in2->name->name);
		    }
		} else {
		    if (shift_Support) {
			char buf[MAXSTRLEN];
			sprintf(buf, "_%s", SYS_LIB_NAME(type));
			to_upper(buf);
		        fprintf(file, "%s %s %s ",
			        (Use_Macro)?".macro":".subckt", buf,
				/*
			        sys_lib_encode(type,in1->hi-in1->lo+1,1), 
				*/
				new_termname());
			fprintf(file, "i0=%s i1=%s | o=%s", 
				in1->name->name, in2->name->name,
				out->name->name);
			/*
			if (in1->lo > in1->hi) {
			    fprintf(file, "i1=%s ", in1->name->name);
			} else {
			    for (i=in1->lo; i<=in1->hi; i++)
				fprintf(file, "i1%s%d%s=%s%s%d%s ", 
					SEP_LBITSELECT, i, SEP_RBITSELECT,
					in1->name->name,
					SEP_LBITSELECT, i, SEP_RBITSELECT);
			}
			if (in2->lo > in2->hi) {
			    fprintf(file, "i2=%s ", in2->name->name);
			} else {
			    for (i=in2->lo; i<=in2->hi; i++)
				fprintf(file, "i2%s%d%s=%s%s%d%s ", 
					SEP_LBITSELECT, i, SEP_RBITSELECT,
					in2->name->name,
					SEP_LBITSELECT, i, SEP_RBITSELECT);
			}
		        fprintf(file, " | ");
			if (out->lo > out->hi) {
			    fprintf(file, "out=%s ", out->name->name);
			} else {
			    for (i=out->lo; i<=out->hi; i++)
				fprintf(file, "out%s%d%s=%s%s%d%s ", 
					SEP_LBITSELECT, i, SEP_RBITSELECT,
					out->name->name,
					SEP_LBITSELECT, i, SEP_RBITSELECT);
			}
			*/
			fprintf(file, "\n");
		    } else {
		        fprintf(file, "%s %s %s o=%s i1=%s i2=%s\n",
			        (Use_Macro)?".macro":".subckt", 
			        sys_lib_encode(type,in1->hi-in1->lo+1,1), new_termname(),
			        out->name->name, in1->name->name, in2->name->name);
		    }
		}
		return ripple;
	    }
	}
    }

    tmpterm = create_rename_term(out->name, new_termname(), out->lo, out->hi);
    out->lo = 0;
    out->hi = -1;

    
    if (Use_Abstraction) {
	
	args = lsCreate();
	sprintf(buf, "%d", in1->hi-in1->lo+1);
	lsNewEnd(args, (lsGeneric)(vlStrdup(buf)), 0);
	sprintf(buf, "%d", in2->hi-in2->lo+1);
	lsNewEnd(args, (lsGeneric)(vlStrdup(buf)), 0);

	fprintf(file, "%s %s %s a=%s b=%s o=%s\n",
		(Use_Macro)?".macro":".subckt",
		gen_lib_encode(type, args), new_termname(),
		in1->name->name, in2->name->name, out->name->name);
    }

    
    
    if (!Use_Abstraction ||
	!set_find(gen_lib_encode(type, args), mod_list->lib_st)) {
	if (Use_Abstraction) {
	    vl_term *tdecl_term;

	    set_add(gen_lib_encode(type, args), mod_list->lib_st);
	    
	    file = lib_file;
	    fprintf(file, ".model %s\n", gen_lib_encode(type, args));
	    
	    fprintf(file, ".inputs a b\n");
	    tdecl_term = create_rename_term(in1->name, vlStrdup("a"),
					  in1->lo, in1->hi);
	    write_var_decl(file, tdecl_term);
	    vl_free_term(tdecl_term);
	    tdecl_term = create_rename_term(in2->name, vlStrdup("b"),
					  in2->lo, in2->hi);
	    write_var_decl(file, tdecl_term);
	    vl_free_term(tdecl_term);
	    if (in1->lo <= in1->hi) {
		fprintf(file, ".bundle a ");
		for (i=in1->lo; i<=in1->hi; i++)
		    fprintf(file, "%s%s%d%s ",
			    in1->name->name,
			    SEP_LBITSELECT, i, SEP_RBITSELECT);
		fprintf(file, "\n");
	    }
	    if (in2->lo <= in2->hi) {
		fprintf(file, ".bundle b ");
		for (i=in2->lo; i<=in2->hi; i++)
		    fprintf(file, "%s%s%d%s ",
			    in2->name->name,
			    SEP_LBITSELECT, i, SEP_RBITSELECT);
		fprintf(file, "\n");
	    }
	    fprintf(file, ".outputs o\n");
	    tdecl_term = create_rename_term(out->name, vlStrdup("o"),
					  out->lo, out->hi);
	    write_var_decl(file, tdecl_term);
	    vl_free_term(tdecl_term);
	    fprintf(file, ".bundle o ");
	    for (i=out->lo; i<=out->hi; i++)
		fprintf(file, "%s%s%d%s ",
			out->name->name,
			SEP_LBITSELECT, i, SEP_RBITSELECT);
	    fprintf(file, "\n");

	    lsDestroy(args,vl_chk_free);
	}

	if (in1->lo > in1->hi && in2->lo > in2->hi) {
	    
	    ripple = vl_write_bop(file, type, 
				  in1->name->name, in2->name->name, NIL(char), 
				  tmpterm->name->name, 
				  !IS_VLR_REL_OP(type));
	    if (IS_VLR_REL_OP(type))
		postprocess_vlr_rel(file, type, ripple, tmpterm, out);
	} else if (in1->lo > in1->hi && in2->lo <= in2->hi) {
	    
	    char tmpterm_buf[MAXSTRLEN];
	    if (tmpterm->lo > tmpterm->hi) 
		sprintf(tmpterm_buf, "%s", tmpterm->name->name);
	    else
		sprintf(tmpterm_buf, "%s%s%d%s", tmpterm->name->name, 
			SEP_LBITSELECT, tmpterm->lo, SEP_RBITSELECT);
	    sprintf(term2, "%s%s%d%s", in2->name->name, 
		    SEP_LBITSELECT, in2->lo, SEP_RBITSELECT);
	    ripple = vl_write_bop(file, type, 
				  in1->name->name, term2, NIL(char), 
				  tmpterm_buf,
				  !IS_VLR_REL_OP(type));
	    
	    for (bpos=in2->lo+1; bpos<=in2->hi; bpos++) {
		sprintf(term2, "%s%s%d%s", in2->name->name, 
			SEP_LBITSELECT, bpos, SEP_RBITSELECT);
		sprintf(tmpterm_buf, "%s%s%d%s", 
			tmpterm->name->name, 
			SEP_LBITSELECT,
			tmpterm->lo+(bpos-in2->lo),
			SEP_RBITSELECT);
		vl_write_bit_connect(file, term2, tmpterm_buf, 0);
	    }
	    if (IS_VLR_REL_OP(type))
		postprocess_vlr_rel(file, type, ripple, tmpterm, out);
	} else if (in1->lo <= in1->hi && in2->lo > in2->hi) {
	    
	    char tmpterm_buf[MAXSTRLEN];
	    if (tmpterm->lo > tmpterm->hi) 
		sprintf(tmpterm_buf, "%s", tmpterm->name->name);
	    else
		sprintf(tmpterm_buf, "%s%s%d%s", tmpterm->name->name, 
			SEP_LBITSELECT, tmpterm->lo, SEP_RBITSELECT);
	    sprintf(term1, "%s%s%d%s", in1->name->name, 
		    SEP_LBITSELECT, in1->lo, SEP_RBITSELECT);
	    ripple = vl_write_bop(file, type, 
				  term1, in2->name->name, NIL(char), 
				  tmpterm_buf, 
				  !IS_VLR_REL_OP(type));
	    
	    for (bpos=in1->lo+1; bpos<=in1->hi; bpos++) {
		sprintf(term1, "%s%s%d%s", in1->name->name, 
			SEP_LBITSELECT, bpos, SEP_RBITSELECT);
		sprintf(tmpterm_buf, "%s%s%d%s", 
			tmpterm->name->name, 
			SEP_LBITSELECT,
			tmpterm->lo+(bpos-in1->lo),
			SEP_RBITSELECT);
		vl_write_bit_connect(file, term1, tmpterm_buf, 0);
	    }
	    if (IS_VLR_REL_OP(type))
		postprocess_vlr_rel(file, type, ripple, tmpterm, out);
	} else {
	    
	    for (bpos=tmpterm->lo, ripple=NIL(char); bpos<=tmpterm->hi; bpos++) {
		if (bpos > in1->hi-in1->lo)
		    sprintf(term1, "%s", WRT_BLIF_GND(file));
		else
		    sprintf(term1, "%s%s%d%s", 
			    in1->name->name, 
			    SEP_LBITSELECT, in1->lo+bpos, SEP_RBITSELECT);
		if (bpos > in2->hi-in2->lo)
		    sprintf(term2, "%s", WRT_BLIF_GND(file));
		else 
		    sprintf(term2, "%s%s%d%s", 
			    in2->name->name, 
			    SEP_LBITSELECT, in2->lo+bpos, SEP_RBITSELECT);
		sprintf(outerm, "%s%s%d%s", 
			tmpterm->name->name, 
			SEP_LBITSELECT, tmpterm->lo+bpos, SEP_RBITSELECT);
		ripple = vl_write_bop(file, type, term1, term2, ripple, outerm,
				      !IS_VLR_REL_OP(type));
	    }
	    if (IS_VLR_REL_OP(type))
		postprocess_vlr_rel(file, type, ripple, tmpterm, out);
	}

	if (Use_Abstraction) fprintf(file, ".end\n\n");
    }
    vl_chk_free((char*)tmpterm);

    return ripple;
}


char *write_op_vector_bop(FILE *file, short type, vl_term *in1, vl_term *in2, vl_term *out)
{
    int bpos, i;
    char buf[MAXSTRLEN], term1[MAXSTRLEN], term2[MAXSTRLEN], outerm[MAXSTRLEN];
    char *ripple = NIL(char);
    lsList args=(lsList)0;

    
    if (dumpSMVPlus) {
        char outbuf[MAXSTRLEN], in1buf[MAXSTRLEN], in2buf[MAXSTRLEN];
	if (type == BlshiftExpr || type == BrshiftExpr) {
	    smv_barrel_shifter(file, in1, in2, out, (type==BlshiftExpr));
	    return ripple;
	}
	if (out->hi < out->lo) 
	    sprintf(outbuf, "%s", out->name->name);
	else if (out->hi == out->lo) 
	    sprintf(outbuf, "%s [%d]", out->name->name, out->lo);
	else 
	    sprintf(outbuf, "%s [%d%s%d]",
		    out->name->name, out->hi, SMV_RANGE, out->lo);
	if (in1->hi < in1->lo) 
	    sprintf(in1buf, "%s", in1->name->name);
	else if (in1->hi == in1->lo) 
	    sprintf(in1buf, "%s [%d]", in1->name->name, in1->lo);
	else 
	    sprintf(in1buf, "%s [%d%s%d]",
		    in1->name->name, in1->hi, SMV_RANGE, in1->lo);
	if (in2->hi < in2->lo) 
	    sprintf(in2buf, "%s", in2->name->name);
	else if (in2->hi == in2->lo) 
	    sprintf(in2buf, "%s [%d]", in2->name->name, in2->lo);
	else 
	    sprintf(in2buf, "%s [%d%s%d]",
		    in2->name->name, in2->hi, SMV_RANGE, in2->lo);
	fprintf(file, "%s %s %s %s %s %s ;\n", 
		SMV_ASSIGN, outbuf, SMV_COL_ASSIGN, 
		in1buf, vl_get_smv_expr_op(type), in2buf);
	return ripple;
    }

    
    if (Use_SystemFunc || UninterpretedFunction) {
	if (vector_width(in1->lo,in1->hi) == vector_width(in2->lo,in2->hi)) {
	    if (in1->lo == 0 && in1->hi == -1) {
		sprintf(term1, "%s", in1->name->name);
	    } else {
		sprintf(term1, "%s", in1->name->name);
	    }
	    if (in2->lo == 0 && in2->hi == -1) {
		sprintf(term2, "%s", in2->name->name);
	    } else {
		sprintf(term2, "%s", in2->name->name);
	    }
	    if (UninterpretedFunction) {
		fprintf(file, "%s %s %s o => %s i1 <= %s i2 <= %s\n",
			(Use_Macro)?".macro":".subckt", 
			sys_lib_encode(type,vector_width(in1->lo,in1->hi),
				       vector_width(out->lo,out->hi)),
			new_termname(), 
			out->name->name, term1, term2);
	    } else {
		if (shift_Support) {
		    char buf[MAXSTRLEN];
		    sprintf(buf, "_%s", SYS_LIB_NAME(type));
		    to_upper(buf);
		    fprintf(file, "%s %s %s ",
			    (Use_Macro)?".macro":".subckt", buf,
			    /*
			    sys_lib_encode(type,vector_width(in1->lo,in1->hi),
				           vector_width(out->lo,out->hi)),
			    */
			    new_termname());
		    fprintf(file, "i1=%s i2=%s | o=%s",
			    term1, term2, out->name->name);
		    /*
		    if (in1->lo > in1->hi) {
		        fprintf(file, "i1=%s ", term1);
		    } else {
		        for (i=in1->lo; i<=in1->hi; i++)
			    fprintf(file, "i1%s%d%s=%s%s%d%s ", 
				    SEP_LBITSELECT, i, SEP_RBITSELECT,
				    term1,
				    SEP_LBITSELECT, i, SEP_RBITSELECT);
		    }
		    if (in2->lo > in2->hi) {
		        fprintf(file, "i2=%s ", term2);
		    } else {
		        for (i=in2->lo; i<=in2->hi; i++)
			    fprintf(file, "i2%s%d%s=%s%s%d%s ", 
				    SEP_LBITSELECT, i, SEP_RBITSELECT,
				    term2,
				    SEP_LBITSELECT, i, SEP_RBITSELECT);
		    }
		    fprintf(file, " | ");
		    if (out->lo > out->hi) {
		        fprintf(file, "o=%s ", out->name->name);
		    } else {
		        for (i=out->lo; i<=out->hi; i++)
			    fprintf(file, "o%s%d%s=%s%s%d%s ", 
				    SEP_LBITSELECT, i, SEP_RBITSELECT,
				    out->name->name,
				    SEP_LBITSELECT, i, SEP_RBITSELECT);
		    }
		    */
		    fprintf(file, "\n");
		} else {
		    fprintf(file, "%s %s %s o=%s i1=%s i2=%s\n",
			    (Use_Macro)?".macro":".subckt", 
			    sys_lib_encode(type,vector_width(in1->lo,in1->hi),
				           vector_width(out->lo,out->hi)),
			    new_termname(), 
			    out->name->name, term1, term2);
		} 
	    }
	    return ripple;
	} else if (!UninterpretedFunction && shift_Support) {
            char buf[MAXSTRLEN];
            
            sprintf(term1, "%s", in1->name->name);
            sprintf(term2, "%s", in2->name->name);
            
            sprintf(buf, "_%s", SYS_LIB_NAME(type));
            to_upper(buf);
            fprintf(file, "%s %s %s ",
                    (Use_Macro)?".macro":".subckt", buf, new_termname());
            fprintf(file, "i1=%s i2=%s | o=%s\n",
                    term1, term2, out->name->name);
            return ripple;
        }
    } 

    
    if (Use_Abstraction) {
	args = lsCreate();
	sprintf(buf, "%d", in1->hi-in1->lo+1);
	lsNewEnd(args, (lsGeneric)(vlStrdup(buf)), 0);
	sprintf(buf, "%d", in2->hi-in2->lo+1);
	lsNewEnd(args, (lsGeneric)(vlStrdup(buf)), 0);
	
	fprintf(file, "%s %s %s a=%s b=%s o=%s\n",
		(Use_Macro)?".macro":".subckt",
		gen_lib_encode(type, args), new_termname(),
		in1->name->name, in2->name->name, out->name->name);
    }

    if (UninterpretedFunction) return ripple;


    if (!Use_Abstraction ||
	!set_find(gen_lib_encode(type, args), mod_list->lib_st)) {
	if (Use_Abstraction) {
	    vl_term *tdecl_term;

	    set_add(gen_lib_encode(type, args), mod_list->lib_st);
	    
	    file = lib_file;
	    fprintf(file, ".model %s\n", gen_lib_encode(type, args));
	    
	    fprintf(file, ".inputs a b\n");
	    tdecl_term = create_rename_term(in1->name, vlStrdup("a"),
					  in1->lo, in1->hi);
	    write_var_decl(file, tdecl_term);
	    vl_free_term(tdecl_term);
	    tdecl_term = create_rename_term(in2->name, vlStrdup("b"),
					  in2->lo, in2->hi);
	    write_var_decl(file, tdecl_term);
	    vl_free_term(tdecl_term);
	    if (in1->lo <= in1->hi) {
		fprintf(file, ".bundle a ");
		for (i=in1->lo; i<=in1->hi; i++)
		    fprintf(file, "%s%s%d%s ",
			    in1->name->name,
			    SEP_LBITSELECT, i, SEP_RBITSELECT);
		fprintf(file, "\n");
	    } else {
		fprintf(file, ".bundle a %s\n", in1->name->name);
	    }
	    if (in2->lo <= in2->hi) {
		fprintf(file, ".bundle b ");
		for (i=in2->lo; i<=in2->hi; i++)
		    fprintf(file, "%s%s%d%s ",
			    in2->name->name,
			    SEP_LBITSELECT, i, SEP_RBITSELECT);
		fprintf(file, "\n");
	    } else {
		fprintf(file, ".bundle b %s\n", in2->name->name);
	    }
	    fprintf(file, ".outputs o\n");
	    tdecl_term = create_rename_term(out->name, vlStrdup("o"),
					  out->lo, out->hi);
	    write_var_decl(file, tdecl_term);
	    vl_free_term(tdecl_term);
	    fprintf(file, ".bundle o ");
	    if (out->hi >= out->lo) {
		for (i=out->lo; i<=out->hi; i++)
		    fprintf(file, "%s%s%d%s ",
			    out->name->name,
			    SEP_LBITSELECT, i, SEP_RBITSELECT);
	    } else {
		fprintf(file, "%s\n", out->name->name);
	    }
	    fprintf(file, "\n");
	    
	    lsDestroy(args, vl_chk_free);
	}
	
	if (in1->lo > in1->hi && in2->lo > in2->hi) {
	    
	    if ((vector_width(in1->lo, in1->hi) < 
		 vector_width(out->lo, out->hi)) &&
		(vector_width(in2->lo, in2->hi) <
		 vector_width(out->lo, out->hi))) {
	        sprintf(outerm, "%s%s%d%s",
			out->name->name,
			SEP_LBITSELECT,
			out->lo, 
			SEP_RBITSELECT);
		ripple = vl_write_bop(file, type, 
				      in1->name->name, in2->name->name, 
				      NIL(char), 
				      outerm, 0);
	        sprintf(outerm, "%s%s%d%s",
			out->name->name,
			SEP_LBITSELECT,
			out->lo+1, 
			SEP_RBITSELECT);
	        vl_write_bit_connect(file, ripple, outerm, 0);
	    } else {
		ripple = vl_write_bop(file, type, 
				      in1->name->name, in2->name->name, 
				      NIL(char), 
				      out->name->name, 0);
	    }
	} else if (in1->lo > in1->hi && in2->lo <= in2->hi) {
	    
	    sprintf(term2, "%s%s%d%s", in2->name->name, 
		    SEP_LBITSELECT, in2->lo, SEP_RBITSELECT);
	    sprintf(outerm, "%s%s%d%s", out->name->name, 
		    SEP_LBITSELECT, out->lo, SEP_RBITSELECT);
	    ripple = vl_write_bop(file, type, 
				  in1->name->name,term2,NIL(char),outerm, 0);
	    
	    if (IS_VLR_LOG_OP(type)) {
		sprintf(term2, "%s", WRT_BLIF_GND(file));
		for (bpos=in1->lo+1; bpos<=in1->hi; bpos++) {
		    sprintf(outerm, "%s%s%d%s", 
			    out->name->name, 
			    SEP_LBITSELECT,
			    out->lo+(bpos-in2->lo),
			    SEP_RBITSELECT);
		    vl_write_bit_connect(file, term2, outerm, 0);
		}
	    } else {
		for (bpos=in2->lo+1; bpos<=in2->hi; bpos++) {
		    sprintf(term2, "%s%s%d%s", in2->name->name, 
			    SEP_LBITSELECT, bpos, SEP_RBITSELECT);
		    sprintf(outerm, "%s%s%d%s", 
			    out->name->name, 
			    SEP_LBITSELECT,
			    out->lo+(bpos-in2->lo),
			    SEP_RBITSELECT);
		    if (type == BplusExpr || type == BminusExpr) {
		        ripple = vl_write_bop(file, type, 
					      term2,ripple,NIL(char),outerm,0);
		    } else {
			vl_write_bit_connect(file, term2, outerm, 0);
		    }
		}
	    }

	    if ((vector_width(in1->lo, in1->hi) < 
		 vector_width(out->lo, out->hi)) &&
		(vector_width(in2->lo, in2->hi) <
		 vector_width(out->lo, out->hi))) {
	        sprintf(outerm, "%s%s%d%s",
			out->name->name,
			SEP_LBITSELECT,
			bpos, 
			SEP_RBITSELECT);
	        vl_write_bit_connect(file, ripple, outerm, 0);
	    }
	} else if (in1->lo <= in1->hi && in2->lo > in2->hi) {
	    
	    sprintf(term1, "%s%s%d%s", in1->name->name, 
		    SEP_LBITSELECT, in1->lo, SEP_RBITSELECT);
	    sprintf(outerm, "%s%s%d%s", out->name->name, 
		    SEP_LBITSELECT, out->lo, SEP_RBITSELECT);
	    ripple = vl_write_bop(file, type, 
				  term1,in2->name->name,NIL(char),outerm, 0);
	    
	    if (IS_VLR_LOG_OP(type)) {
		sprintf(term1, "%s", WRT_BLIF_GND(file));
		for (bpos=in1->lo+1; bpos<=in1->hi; bpos++) {
		    sprintf(outerm, "%s%s%d%s", out->name->name, 
			    SEP_LBITSELECT,
			    out->lo+(bpos-in1->lo),
			    SEP_RBITSELECT);
		    vl_write_bit_connect(file, term1, outerm, 0);
		}
	    } else {
		for (bpos=in1->lo+1; bpos<=in1->hi; bpos++) {
		    sprintf(term1, "%s%s%d%s", in1->name->name, 
			    SEP_LBITSELECT, bpos, SEP_RBITSELECT);
		    sprintf(outerm, "%s%s%d%s", 
			    out->name->name, 
			    SEP_LBITSELECT,
			    out->lo+(bpos-in1->lo),
			    SEP_RBITSELECT);
		    if (type == BplusExpr || type == BminusExpr) {
		        ripple = vl_write_bop(file, type, 
					      term1,ripple,NIL(char),outerm,0);
		    } else {
			vl_write_bit_connect(file, term1, outerm, 0);
		    }
		}
	    }

	    if ((vector_width(in1->lo, in1->hi) < 
		 vector_width(out->lo, out->hi)) &&
		(vector_width(in2->lo, in2->hi) <
		 vector_width(out->lo, out->hi))) {
	        sprintf(outerm, "%s%s%d%s",
			out->name->name,
			SEP_LBITSELECT,
			bpos, 
			SEP_RBITSELECT);
	        vl_write_bit_connect(file, ripple, outerm, 0);
	    }
	} else {
	    
	    for (bpos=out->lo, ripple=NIL(char); bpos<=out->hi; bpos++) {
		if (RIPPLE_INTERFERE(type)) {
		    if (bpos-out->lo <= 
			MIN(in1->hi-in1->lo,in2->hi-in2->lo)) {
			sprintf(term1, "%s%s%d%s", 
				in1->name->name, 
				SEP_LBITSELECT, in1->lo+bpos, SEP_RBITSELECT);
			sprintf(term2, "%s%s%d%s", 
				in2->name->name, 
				SEP_LBITSELECT, in2->lo+bpos, SEP_RBITSELECT);
			sprintf(outerm, "%s%s%d%s", 
				out->name->name, 
				SEP_LBITSELECT, out->lo+bpos, SEP_RBITSELECT);
			ripple = 
			    vl_write_bop(file, type, term1, term2, ripple,
					 outerm, (bpos==out->hi));
		    } else if (bpos-out->lo == 
			       MIN(in1->hi-in1->lo,in2->hi-in2->lo)+1) {
			sprintf(outerm, "%s%s%d%s", 
				out->name->name, 
				SEP_LBITSELECT, out->lo+bpos, SEP_RBITSELECT);
			fprintf(file, ".names %s %s\n1 1\n0 0\n",
				ripple, outerm);
		    } else {
			sprintf(outerm, "%s%s%d%s", 
				out->name->name, 
				SEP_LBITSELECT, out->lo+bpos, SEP_RBITSELECT);
			fprintf(file, ".names %s\n0\n", outerm);
		    }
		} else {
		    if (bpos-out->lo <= 
			MIN(in1->hi-in1->lo,in2->hi-in2->lo)) {
			sprintf(term1, "%s%s%d%s", 
				in1->name->name, 
				SEP_LBITSELECT, in1->lo+bpos, SEP_RBITSELECT);
			sprintf(term2, "%s%s%d%s", 
				in2->name->name, 
				SEP_LBITSELECT, in2->lo+bpos, SEP_RBITSELECT);
			sprintf(outerm, "%s%s%d%s", 
				out->name->name, 
				SEP_LBITSELECT, out->lo+bpos, SEP_RBITSELECT);
			ripple = 
			    vl_write_bop(file, type, term1, term2, ripple,
					 outerm, (bpos==out->hi));
		    } else {
			if (bpos-out->lo <= in1->hi-in1->lo) {
			    sprintf(term1, "%s%s%d%s", 
				    in1->name->name, 
				    SEP_LBITSELECT, in1->lo+bpos, 
				    SEP_RBITSELECT);
			    sprintf(outerm, "%s%s%d%s", 
				    out->name->name, 
				    SEP_LBITSELECT, out->lo+bpos, 
				    SEP_RBITSELECT);
			    fprintf(file, ".names %s %s\n0 0\n1 1\n", 
				    term1, outerm);
			} else if (bpos-out->lo <= in2->hi-in2->lo) {
			    sprintf(term2, "%s%s%d%s", 
				    in2->name->name, 
				    SEP_LBITSELECT, in2->lo+bpos, 
				    SEP_RBITSELECT);
			    sprintf(outerm, "%s%s%d%s", 
				    out->name->name, 
				    SEP_LBITSELECT, out->lo+bpos, 
				    SEP_RBITSELECT);
			    fprintf(file, ".names %s %s\n0 0\n1 1\n", 
				    term2, outerm);
			} else {
			    sprintf(outerm, "%s%s%d%s", 
				    out->name->name, 
				    SEP_LBITSELECT, out->lo+bpos, 
				    SEP_RBITSELECT);
			    fprintf(file, ".names %s\n0\n", outerm);
			}
		    }
		}
	    }
	}
	
	if (Use_Abstraction) fprintf(file, ".end\n\n");
    }
    
    return ripple;
}


static void postprocess_vlr_rel(FILE *file, short type, char *carry,
				vl_term *results, vl_term *out)
{
    char *tmp_termname;
    vl_term *zero_term;

    switch(type) {
    case BltExpr:
	
	zero_term = new_term(NIL(vl_range), 0, -1);
	if (results->hi < results->lo)
	    vl_write_bit_connect(file, 
				results->name->name, zero_term->name->name, 0);
	else
	    vl_write_vector_bop(file, UorExpr,
				results, NIL(vl_term), zero_term);
	vl_write_bop(file, BandExpr, carry, zero_term->name->name, NIL(char),
		     out->name->name, 1);
	break;
    case BgtExpr:
	
	zero_term = new_term(NIL(vl_range), 0, -1);
	if (results->hi < results->lo)
	    vl_write_bit_connect(file, 
				results->name->name, zero_term->name->name, 1);
	else
	    vl_write_vector_bop(file, UnorExpr,
				results, NIL(vl_term), zero_term);
	tmp_termname = new_termname();
	vl_write_bop(file, BorExpr, carry, zero_term->name->name, NIL(char),
		     tmp_termname, 1);
	vl_write_bit_connect(file, tmp_termname, out->name->name, 1);
	break;
    case BleExpr:
	
	zero_term = new_term(NIL(vl_range), 0, -1);
	if (results->hi < results->lo)
	    vl_write_bit_connect(file, 
				results->name->name, zero_term->name->name, 1);
	else
	    vl_write_vector_bop(file, UnorExpr,
				results, NIL(vl_term), zero_term);
	vl_write_bop(file, BorExpr, carry, zero_term->name->name, NIL(char),
		     out->name->name, 1);
	break;
    case BgeExpr:
	
	zero_term = new_term(NIL(vl_range), 0, -1);
	if (results->hi < results->lo)
	    vl_write_bit_connect(file, 
				results->name->name, zero_term->name->name, 0);
	else
	    vl_write_vector_bop(file, UorExpr,
				results, NIL(vl_term), zero_term);
	tmp_termname = new_termname();
	vl_write_bop(file, BandExpr, carry, zero_term->name->name, NIL(char),
		     tmp_termname, 1);
	vl_write_bit_connect(file, tmp_termname, out->name->name, 1);
	break;
    }
}


vl_port *search_match_port(char *name, lsList ports)
{
    lsGen gen;
    lsHandle handle;
    vl_port *retval=NIL(vl_port), *port;
    lsHandle port_handle;
    vl_id_range *id;

    gen = lsStart(ports);
    while (lsNext(gen, (lsGeneric*)&port, &handle)!=LS_NOMORE) {
	lsFirstItem(port->port_exp, (lsGeneric*)&id, &port_handle);
	if (!strcmp(name, id->name)) {
	    retval = port;
	    break;
	}
    }
    lsFinish(gen);

    return retval;
}


vl_port_connect *search_inst_port(char *name, lsList ports)
{
    lsGen gen;
    lsHandle handle;
    vl_port_connect *retval=NIL(vl_port_connect), *port;

    gen = lsStart(ports);
    while (lsNext(gen, (lsGeneric*)&port, &handle)!=LS_NOMORE) {
	if (!strcmp(name, port->id->name)) {
	    retval = port;
	    break;
	}
    }
    lsFinish(gen);

    return retval;
}



char *vl_translate_prim_symbol(unsigned char sym)
{
    char buf[MAXSTRLEN];

    switch(sym) {
    case PrimNone: return("");
    case Prim0: return("0");
    case Prim1: return("1");	
    case PrimX: return("-");	
    case PrimQ: return("-");
    case PrimB: return("-");
    case PrimM: return("-");
    case PrimR: return("0 1");
    case PrimF: return("1 0");
    case PrimS: return("- -");
    case PrimBB: return("- -");
    case PrimQ0: return("- 0");
    case PrimQ1: return("- 1");
    case PrimQB: return("- -");
    case Prim0X: return("0 -");
    case Prim1X: return("1 -");
    case PrimX0: return("- 0");
    case PrimX1: return("- 1");       
    case PrimXB: return("- -");
    case PrimBX: return("- -");
    case PrimP: sprintf(buf, "P");
    case PrimN: sprintf(buf, "N");
	strcat(buf, " :: can not be handled yet");
	Translate_Warning(buf);
	return("");
    default: {
	char msg[MAXSTRLEN];
	sprintf(msg, "Unexpected primitive symbol type %d", sym);
	internal_error(msg); return(NULL);
    }
    }
}

vl_term *sensitive_control(FILE *file, st_table *sensitive_list)
{
    vl_term *retval;
    st_generator *gen;
    char *key, *dummy;
    vl_id_range *id_sym;
    int i, j;
    int lo, hi;
    char *cp;
    FILE *old_file;
    int ithItem;
    
    retval = new_term(NIL(vl_range), 0, -1);
    if (shift_Support) {
        fprintf(file, ".subckt %s %s ", cp=new_termname(), new_instname());
	fprintf(lib_file, ".cfsm %s\n", cp);
	fprintf(lib_file, ".inputs ");
    } else {
        fprintf(file, ".names ");
    }
    ithItem = 0;
    gen = st_init_gen(sensitive_list);
    while (st_gen(gen, &key, &dummy)) {
	if (!st_lookup(vl_currentModule->sig_st, key, (char**)&id_sym)) {
	    char buf[MAXSTRLEN];

	    sprintf(buf, "sensitive var:%s is not defined in module %s",
		    key, vl_currentModule->name->name);
	    semantic_error(buf);
	}

	get_hilo(id_sym, &hi, &lo);
	if (lo < hi || id_sym->range) {
	    char buf[MAXSTRLEN];

	    sprintf(buf, "%s is vector/array while as sensitive var in %s",
		    key, vl_currentModule->name->name);
	    semantic_error(buf);
	}

	if (shift_Support) {
	    fprintf(file, "%s=%s ", key, key);
	    if (ithItem > 0) {
	        fprintf(lib_file, ", %s ", key);
	    } else {
	        fprintf(lib_file, "%s ", key);
	    }
	    ithItem++;
	} else {
	    fprintf(file, "%s ", key);
	}
    }
    st_free_gen(gen);
    if (shift_Support) {
	fprintf(file, "| %s=%s\n", retval->name->name, retval->name->name);
	fprintf(lib_file, "\n.outputs %s\n", retval->name->name);
	fprintf(lib_file, ".trans\n");
	old_file = file;
	file = lib_file;
    } else {
        fprintf(file, "%s\n", retval->name->name);
    }
    
    for (i=0; i<st_count(sensitive_list); i++) {
	for (j=0; j<st_count(sensitive_list); j++)
	    fprintf(file, "%c ", (i==j)?'1':'-');
	fprintf(file, "1\n");
    }
    for (i=0; i<st_count(sensitive_list); i++)
	fprintf(file, "0 ");
    fprintf(file, "0\n");

    if (shift_Support) {
	fprintf(file, ".end\n\n");
	file = old_file;
    }
    
    return retval;
}


void patch_unaffected_term(FILE *file, vl_id_range *id_sym,
			   vl_term *orig_term,
			   vl_term *out_term)
{
    int i;
    int set_floating = 0;
    char *cp;

    if (orig_term->lo == out_term->lo && orig_term->hi == out_term->hi)
	return;
    if (orig_term->lo >= orig_term->hi && out_term->lo >= out_term->hi)
	return;

    if (vl_currentFunction)
	if (!strcmp(id_sym->name, orig_term->name->name))
	    set_floating = 1;

    if (set_floating) {
        if (dumpSMVPlus) {
	} else {
	    for (i=orig_term->lo; i<out_term->lo; i++) {
	        fprintf(file, ".names %s%s%d%s\n-\n",
			out_term->name->name, 
			SEP_LBITSELECT, i, SEP_RBITSELECT);
	    }
	
	    for (i=out_term->hi+1; i<=orig_term->hi; i++) {
	        fprintf(file, ".names %s%s%d%s\n-\n",
			out_term->name->name, 
			SEP_LBITSELECT, i, SEP_RBITSELECT);
	    }
	}
    } else {
        if (dumpSMVPlus) {
	    
	    if (orig_term->lo < out_term->lo)
	        fprintf(file, "%s %s [%d%s%d] %s %s [%d%s%d] ;\n", SMV_ASSIGN,
			out_term->name->name, 
			orig_term->lo,SMV_RANGE,out_term->lo-1, SMV_COL_ASSIGN,
			orig_term->name->name,
			orig_term->lo, SMV_RANGE, out_term->lo-1);
	    if (out_term->hi+1 <= orig_term->hi)
	        fprintf(file, "%s %s [%d%s%d] %s %s [%d%s%d] ;\n", SMV_ASSIGN,
			out_term->name->name, 
			orig_term->hi,SMV_RANGE,out_term->hi+1, SMV_COL_ASSIGN,
			orig_term->name->name,
			orig_term->hi,SMV_RANGE,out_term->hi+1);
	} else {
	    
	    for (i=orig_term->lo; i<out_term->lo; i++) {
	        if (set_notation) {
		    if (shift_Support) {
			fprintf(file, ".subckt %s %s %s%s%d%s=%s%s%d%s | %s%s%d%s=%s%s%d%s\n",
				cp=new_termname(), new_instname(), 
				orig_term->name->name, 
				SEP_LBITSELECT, i, SEP_RBITSELECT,
				orig_term->name->name,
				SEP_LBITSELECT, i, SEP_RBITSELECT,
				out_term->name->name, 
				SEP_LBITSELECT, i, SEP_RBITSELECT,
				out_term->name->name,
				SEP_LBITSELECT, i, SEP_RBITSELECT);

			fprintf(lib_file, ".cfsm %s\n", cp);
			fprintf(lib_file, ".inputs %s%s%d%s\n", 
				orig_term->name->name,
				SEP_LBITSELECT, i, SEP_RBITSELECT);
			fprintf(lib_file, ".outputs %s%s%d%s\n", 
				out_term->name->name,
				SEP_LBITSELECT, i, SEP_RBITSELECT);
			fprintf(lib_file, ".trans\n - ( %s%s%d%s )\n",
				orig_term->name->name,
				SEP_LBITSELECT, i, SEP_RBITSELECT);
			fprintf(lib_file, ".end\n\n");
		    } else {
		        fprintf(file,".names %s%s%d%s %s%s%d%s\n- %s%s%s%d%s\n",
			        orig_term->name->name, 
			        SEP_LBITSELECT, i, SEP_RBITSELECT,
			        out_term->name->name, 
			        SEP_LBITSELECT, i, SEP_RBITSELECT, 
			        HSIS_EQUAL,
			        orig_term->name->name, 
			        SEP_LBITSELECT, i, SEP_RBITSELECT);
		    }
		} else {
		    fprintf(file, ".names %s%s%d%s %s%s%d%s\n1 1\n0 0\n",
			    orig_term->name->name, 
			    SEP_LBITSELECT, i, SEP_RBITSELECT,
			    out_term->name->name, 
			    SEP_LBITSELECT, i, SEP_RBITSELECT);
		}
	    }
	
	    for (i=out_term->hi+1; i<=orig_term->hi; i++) {
	        if (set_notation) {
		    if (shift_Support) {
			fprintf(file, ".subckt %s %s %s%s%d%s=%s%s%d%s | %s%s%d%s=%s%s%d%s\n",
				cp=new_termname(), new_instname(),
				orig_term->name->name, 
				SEP_LBITSELECT, i, SEP_RBITSELECT,
				orig_term->name->name,
				SEP_LBITSELECT, i, SEP_RBITSELECT,
				out_term->name->name, 
				SEP_LBITSELECT, i, SEP_RBITSELECT,
				out_term->name->name,
				SEP_LBITSELECT, i, SEP_RBITSELECT);

			fprintf(lib_file, ".cfsm %s\n", cp);
			fprintf(lib_file, ".inputs %s%s%d%s\n", 
				orig_term->name->name,
				SEP_LBITSELECT, i, SEP_RBITSELECT);
			fprintf(lib_file, ".outputs %s%s%d%s\n", 
				out_term->name->name,
				SEP_LBITSELECT, i, SEP_RBITSELECT);
			fprintf(lib_file, ".trans\n - ( %s%s%d%s )\n",
				orig_term->name->name,
				SEP_LBITSELECT, i, SEP_RBITSELECT);
			fprintf(lib_file, ".end\n\n");
		    } else {
		        fprintf(file,".names %s%s%d%s %s%s%d%s\n- %s%s%s%d%s\n",
			        orig_term->name->name, 
			        SEP_LBITSELECT, i, SEP_RBITSELECT,
			        out_term->name->name, 
			        SEP_LBITSELECT, i, SEP_RBITSELECT,
			        HSIS_EQUAL,
			        orig_term->name->name, 
			        SEP_LBITSELECT, i, SEP_RBITSELECT);
		    }
		} else {
		    fprintf(file, ".names %s%s%d%s %s%s%d%s\n1 1\n0 0\n",
			    orig_term->name->name, 
			    SEP_LBITSELECT, i, SEP_RBITSELECT,
			    out_term->name->name, 
			    SEP_LBITSELECT, i, SEP_RBITSELECT);
		}
	    }
	}
    }

    out_term->lo = orig_term->lo;
    out_term->hi = orig_term->hi;
}

int need_edge_detector(lsList table_entries, int ith_port)
{
    int retval=0;
    lsGen gen;
    lsHandle handle;
    vl_prim_entry *e;

    for (gen=lsStart(table_entries); 
	 lsNext(gen, (lsGeneric*)&e, &handle) != LS_NOMORE; ) {
	register unsigned char sym;
	sym = e->inputs[ith_port];
	if (IS_TRANSITION(sym)) {
	    retval = 1;
	    break;
	}
    }
    (void)lsFinish(gen);

    return retval;
}


void dump_debug_information(FILE *file, vl_id_range *id_var,
			    vl_term *current_term, int lineno,
			    lsList ctrl_list, char *ctrl_syndrome)
{
    lsGen gen;
    lsHandle handle;
    vl_term *ctrl;
    int i;
    char *Comment;

    Comment = (dumpSMVPlus) ? SMV_COMMENT : HSIS_COMMENT;
    if (debug_mode) {
	if (lineno >= 0) {
	    fprintf(file, "%s%sl %d%s%s\n", 
		    Comment, Comment,
		    lineno, 
		    Comment, Comment);
	}
	fprintf(file, "%s%sv %s.%s%s%s\n", 
		Comment, Comment,
		vl_currentModule->name->name, id_var->name, 
		Comment, Comment);
	for (i=0, gen=lsStart(ctrl_list); 
	     lsNext(gen, (lsGeneric*)&ctrl, &handle)!=LS_NOMORE; i++) {
	    if (ctrl_syndrome[i] == '-') continue;
	    if (ctrl_syndrome[i] == '1') 
		fprintf(file, "%s%sg %s%s%s\n", 
			Comment, Comment,
			ctrl->name->name, 
			Comment, Comment);
	    if (ctrl_syndrome[i] == '0')
		fprintf(file, "%s%sG %s%s%s\n", 
			Comment, Comment,
			ctrl->name->name,
			Comment, Comment);
	}
	lsFinish(gen);
    }

    current_term = current_term;
}


int vector_width(int lo, int hi)
{
    if (lo > hi) return 1;
    return hi - lo + 1;
}


void expand_term(FILE *file, vl_term *in, vl_term *out)
{
    int i;
    char in_buf[MAXSTRLEN], out_buf[MAXSTRLEN];
    lsList args;

    assert(vector_width(in->lo, in->hi) <= vector_width(out->lo, out->hi));

    if (vector_width(in->lo, in->hi) == vector_width(out->lo, out->hi)) {
	vl_write_bin_connect(file, in, out, 0);
    } else {
	char buf[MAXSTRLEN];
	args = lsCreate();
	sprintf(buf, "%d", in->hi-in->lo+1);
	lsNewEnd(args, (lsGeneric)vlStrdup(buf), 0);
	sprintf(buf, "%d", out->hi-out->lo+1);
	lsNewEnd(args, (lsGeneric)vlStrdup(buf), 0);
	
	if (Use_Abstraction) {
	    fprintf(file, "%s %s %s a=%s o=%s\n", 
		    (Use_Macro)?".macro":".subckt",
		    gen_lib_encode(LIBexpand, args), new_termname(),
		    in->name->name, out->name->name);
	}

	if (!Use_Abstraction ||
	    !set_find(gen_lib_encode(LIBexpand,args),
		      mod_list->lib_st)) {
	    if (Use_Abstraction) {
		vl_term *tdecl_term;

		set_add(gen_lib_encode(LIBexpand,args),
			mod_list->lib_st);

		file = lib_file;
		fprintf(file, ".model %s\n",
			gen_lib_encode(LIBexpand, args));
		
		fprintf(file, ".inputs a\n");
		fprintf(file, ".outputs o\n");
		tdecl_term = create_rename_term(in->name, vlStrdup("a"),
					      in->lo, in->hi);
		write_var_decl(file, tdecl_term);
		vl_free_term(tdecl_term);
		tdecl_term = create_rename_term(out->name, vlStrdup("o"),
					      out->lo, out->hi);
		write_var_decl(file, tdecl_term);
		vl_free_term(tdecl_term);
		fprintf(file, ".bundle a ");
		for (i=in->lo; i<=in->hi; i++)
		    fprintf(file, "%s%s%d%s ",
			    in->name->name, SEP_LBITSELECT, i, SEP_RBITSELECT);
		fprintf(file, "\n");
		fprintf(file, ".bundle o ");
		for (i=out->lo; i<=out->hi; i++)
		    fprintf(file, "%s%s%d%s ",
			    out->name->name, SEP_LBITSELECT,i,SEP_RBITSELECT);
		fprintf(file, "\n");
	    }

	    for (i=out->lo; i<=out->hi; i++) {
		if (in->lo > in->hi) {
		    sprintf(out_buf, "%s%s%d%s", out->name->name, 
			    SEP_LBITSELECT, i, SEP_RBITSELECT);
		    sprintf(in_buf, "%s", 
			    (i==out->lo)?in->name->name:WRT_BLIF_GND(file));
		    if (set_notation) { 
		        if (dumpSMVPlus) 
			    
			    fprintf(file, "%s %s %s %s ;\n", SMV_ASSIGN,
				    out_buf, SMV_COL_ASSIGN, in_buf);
			else
			    
			    fprintf(file, ".names %s %s\n- =%s\n",
				    in_buf, out_buf, in_buf);
		    } else {
			vl_write_bit_connect(file, in_buf, out_buf, 0);
		    }
		} else {
		    sprintf(out_buf, "%s%s%d%s", out->name->name, 
			    SEP_LBITSELECT, i, SEP_RBITSELECT);
		    if (i-out->lo <= in->hi-in->lo)
			sprintf(in_buf, "%s%s%d%s", in->name->name, 
			    SEP_LBITSELECT, i+in->lo-out->lo, SEP_RBITSELECT);
		    else
			sprintf(in_buf, "%s", WRT_BLIF_GND(file));
		    if (set_notation) { 
		        if (dumpSMVPlus) 
			    
			    fprintf(file, "%s %s %s %s ;\n", SMV_ASSIGN,
				    out_buf, SMV_COL_ASSIGN, in_buf);
			else
			    
			    fprintf(file, ".names %s %s\n- =%s\n",
				    in_buf, out_buf, in_buf);
		    } else {
			vl_write_bit_connect(file, in_buf, out_buf, 0);
		    }
		}
	    }
	    
	    if (Use_Abstraction)
		fprintf(file, ".end\n\n");
	}

	lsDestroy(args, vl_chk_free);
    }
}

void shrink_term(FILE *file, vl_term *in, vl_term *out)
{
    int i;
    char in_buf[MAXSTRLEN], out_buf[MAXSTRLEN];
    lsList args;

    assert(vector_width(in->lo, in->hi) >= vector_width(out->lo, out->hi));

    if (vector_width(in->lo, in->hi) == vector_width(out->lo, out->hi)) {
	vl_write_bin_connect(file, in, out, 0);
    } else {
	char buf[MAXSTRLEN];
	args = lsCreate();
	sprintf(buf, "%d", in->hi-in->lo+1);
	lsNewEnd(args, (lsGeneric)vlStrdup(buf), 0);
	sprintf(buf, "%d", out->hi-out->lo+1);
	lsNewEnd(args, (lsGeneric)vlStrdup(buf), 0);
	
	if (Use_Abstraction) {
	    fprintf(file, "%s %s %s a=%s o=%s\n", 
		    (Use_Macro)?".macro":".subckt",
		    gen_lib_encode(LIBshrink, args), new_termname(),
		    in->name->name, out->name->name);
	}

	if (!Use_Abstraction ||
	    !set_find(gen_lib_encode(LIBexpand,args),
		      mod_list->lib_st)) {
	    if (Use_Abstraction) {
		vl_term *tdecl_term;

		set_add(gen_lib_encode(LIBexpand,args),
			mod_list->lib_st);

		file = lib_file;
		fprintf(file, ".model %s\n",
			gen_lib_encode(LIBexpand, args));
		
		fprintf(file, ".inputs a\n");
		fprintf(file, ".outputs o\n");
		tdecl_term = create_rename_term(in->name, vlStrdup("a"),
					      in->lo, in->hi);
		write_var_decl(file, tdecl_term);
		vl_free_term(tdecl_term);
		tdecl_term = create_rename_term(out->name, vlStrdup("o"),
					      out->lo, out->hi);
		write_var_decl(file, tdecl_term);
		vl_free_term(tdecl_term);
		fprintf(file, ".bundle a ");
		for (i=in->lo; i<=in->hi; i++)
		    fprintf(file, "%s%s%d%s ",
			    in->name->name, SEP_LBITSELECT, i, SEP_RBITSELECT);
		fprintf(file, "\n");
		fprintf(file, ".bundle o ");
		for (i=out->lo; i<=out->hi; i++)
		    fprintf(file, "%s%s%d%s ",
			    out->name->name, SEP_LBITSELECT,i,SEP_RBITSELECT);
		fprintf(file, "\n");
	    }

	    for (i=in->lo; i<=in->hi; i++) {
		if (out->lo > out->hi) {
		    if (i == in->lo) {
			sprintf(out_buf, "%s", out->name->name);
			sprintf(in_buf, "%s%s%d%s", in->name->name,
				SEP_LARRAY, i, SEP_RARRAY);
			if (set_notation) { 
			    if (dumpSMVPlus)
			        
			        fprintf(file, "%s %s %s %s ;\n", SMV_ASSIGN,
					out_buf, SMV_COL_ASSIGN, in_buf);
			    else
			        
			        fprintf(file, ".names %s %s\n- =%s\n",
					in_buf, out_buf, in_buf);
			} else {
			    vl_write_bit_connect(file, in_buf, out_buf, 0);
			}
		    }
		} else {
		    if (i-in->lo <= out->hi-out->lo) {
			sprintf(out_buf, "%s%s%d%s", out->name->name, 
			    SEP_LBITSELECT,i+in->lo-out->lo,SEP_RBITSELECT);
			sprintf(in_buf, "%s%s%d%s", in->name->name, 
				SEP_LBITSELECT, i, SEP_RBITSELECT);
			if (set_notation) { 
			    if (dumpSMVPlus) 
			        
			        fprintf(file, "%s %s %s %s ;\n", SMV_ASSIGN,
					out_buf, SMV_COL_ASSIGN, in_buf);
			    else
			        
			        fprintf(file, ".names %s %s\n- =%s\n",
					in_buf, out_buf, in_buf);
			} else {
			    vl_write_bit_connect(file, in_buf, out_buf, 0);
			}
		    }
		}
	    }

	    if (Use_Abstraction) {
		fprintf(file, ".end\n\n");
	    }
	}
	lsDestroy(args, vl_chk_free);
    }
}


void subrange_term(FILE *file, vl_term *in, vl_term *out)
{
    int i;
    lsList args;
    char buf[MAXSTRLEN];
    
    if (Use_Abstraction) {
	vl_term *tdecl_term;

	args = lsCreate();
	sprintf(buf, "%d", in->lo);
	lsNewEnd(args, (lsGeneric)vlStrdup(buf), 0);
	sprintf(buf, "%d", in->hi);
	lsNewEnd(args, (lsGeneric)vlStrdup(buf), 0);
	sprintf(buf, "%d", out->lo);
	lsNewEnd(args, (lsGeneric)vlStrdup(buf), 0);
	sprintf(buf, "%d", out->hi);
	lsNewEnd(args, (lsGeneric)vlStrdup(buf), 0);

	fprintf(file, "%s %s %s i=%s o=%s\n",
		(Use_Macro)?".macro":".subckt", 
		gen_lib_encode(LIBsubrange,args), new_termname(),
		in->name->name, out->name->name);
	if (!set_find(gen_lib_encode(LIBsubrange,args), mod_list->lib_st)) {
	    set_add(gen_lib_encode(LIBsubrange,args), mod_list->lib_st);
	    file = lib_file;
	    fprintf(file, "model %s\n", gen_lib_encode(LIBsubrange,args));
	    fprintf(file, ".inputs i\n");
	    fprintf(file, ".outputs o\n");
	    tdecl_term = create_rename_term(in->name, vlStrdup("i"),
					  in->lo, in->hi);
	    write_var_decl(file, tdecl_term);
	    vl_free_term(tdecl_term);
	    tdecl_term = create_rename_term(out->name, vlStrdup("o"),
					  out->lo, out->hi);
	    write_var_decl(file, tdecl_term);
	    vl_free_term(tdecl_term);
	    if (in->lo <= in->hi) {
		fprintf(file, ".bundle i ");
		for (i=in->lo; i<=in->hi; i++) {
		    fprintf(file, "%s%s%d%s ", 
			    in->name->name, SEP_LBITSELECT, i, SEP_RBITSELECT);
		}
		fprintf(file, "\n");
	    }
	    if (out->lo <= in->hi) {
		fprintf(file, ".bundle o ");
		for (i=out->lo; i<=out->hi; i++) {
		    fprintf(file, "%s%s%d%s ",
			    out->name->name, SEP_LBITSELECT,i,SEP_RBITSELECT);
		}
		fprintf(file, "\n");
	    }

	    if (out->lo > out->hi) {
		if (in->lo > in->hi) {
		    fprintf(file, ".names %s %s\n0 0\n1 1\n",
			    in->name->name, out->name->name);
		} else {
		    fprintf(file, ".names %s%s%d%s %s\n0 0\n1 1\n",
			    in->name->name, 
			    SEP_LBITSELECT, in->lo, SEP_RBITSELECT,
			    out->name->name);
		}
	    } else {
		if (in->lo > in->hi) {
		    fprintf(file, ".names %s %s %s%d%s\n0 0\n1 1\n",
			    in->name->name,
			    out->name->name, 
			    SEP_LBITSELECT, out->lo, SEP_RBITSELECT);
		} else {
		    for (i=out->lo; i<=out->hi; i++) {
			fprintf(file, ".names %s%s%d%s %s%s%d%s\n0 0\n1 1\n",
				in->name->name, 
				SEP_LBITSELECT,i,SEP_RBITSELECT,
				out->name->name, 
				SEP_LBITSELECT,i,SEP_RBITSELECT);
		    }
		}
	    }
	
	    fprintf(file, ".end\n");
	}

	lsDestroy(args, vl_chk_free);
    }
}


vl_term *vl_write_nond_wire(FILE *file, vl_term *ctrl_term, lsList nond_list, vl_term *reference_term)
{
    vl_term *retval;
    vl_term *nond_term;
    vl_expr *nond_expr;
    lsHandle handle;
    lsGen gen;
    lsList domain;
    lsGen enum_gen;
    vl_enumerator *enum_elt;
    lsHandle enum_handle;
    lsList nond_consts, nond_terms;
    int num_terms, num_consts;
    int i, j, k, l;

    retval = typed_new_term(reference_term->term_type, NIL(vl_range), 
			    reference_term->lo, reference_term->hi);
    if (vis_nond && rst_ckt) {
	char *cp;
	cp = (char*)chk_malloc(strlen(reference_term->name->name) +
			       strlen(retval->name->name) +
			       2*strlen(SEP_GATEPIN)+strlen(PIN_INITIAL)+1);
	sprintf(cp, "%s%s%s%s%s", reference_term->name->name, SEP_GATEPIN,
		PIN_INITIAL, SEP_GATEPIN, retval->name->name);
	retval->name->name = cp;
    }
    retval->flag = reference_term->flag;
    if (!vis_nond || rst_ckt)
	write_var_decl(file, retval);
    nond_consts = lsCreate();
    nond_terms = lsCreate();
    for (gen=lsStart(nond_list), num_terms=0, num_consts=0;
	 lsNext(gen, (lsGeneric*)&nond_expr, &handle) != LS_NOMORE; ) {
	if (ISVLCONST(nond_expr->type)) {
	    
	    num_consts++;
	    lsNewEnd(nond_consts, (lsGeneric)nond_expr->u.intval, 0);
	} else {
	    
	    num_terms++;
	    lsNewEnd(nond_terms, (lsGeneric)nond_expr->term, 0);
	}
    }
    (void)lsFinish(gen);

    if (dumpSMVPlus) {
        int ith_term=0;
        
        
        
        fprintf(file, "%s %s %s %s", SMV_ASSIGN,
		retval->name->name, SMV_COL_ASSIGN, SMV_LBRACE);
	for (gen=lsStart(nond_consts), ith_term=0;
	     lsNext(gen,(lsGeneric*)&k,&handle) != LS_NOMORE; 
	     ith_term++) {
	    if (reference_term->flag & MVar) {
	        domain = 
		  reference_term->term_type->specifier->
		      u.enum_type->domain_list;
		for (enum_gen = lsStart(domain), i=0;
		     lsNext(enum_gen, (lsGeneric*)&enum_elt, &enum_handle) !=
		         LS_NOMORE; i++) 
		    if (k == i) {
		        if (ith_term==0) 
			    fprintf(file, "%s", enum_elt->name);
			else
			    fprintf(file, "%s%s", SMV_COMMA, enum_elt->name);
		    }
		(void)lsFinish(enum_gen);
	    } else {
	        
	        if (reference_term->lo > reference_term->hi) {
		    if (ith_term==0)
		        fprintf(file, "%d", k);
		    else
		        fprintf(file, "%s%d", SMV_COMMA, k);
		}
	    }
	}
	lsFinish(gen);
	fprintf(file, "%s;\n", SMV_RBRACE);
	lsDestroy(nond_consts, 0);
	lsDestroy(nond_terms, 0);
        return retval;
    }

    
    
    fprintf(file, ".names ");
    for (gen=lsStart(nond_terms);
	 lsNext(gen, (lsGeneric*)&nond_term, &handle) != LS_NOMORE; ) {
	if (reference_term->lo > reference_term->hi || 
	    reference_term->flag & MVar)
	    if (nond_term->lo > nond_term->hi || reference_term->flag & MVar)
		fprintf(file, "%s ", nond_term->name->name);
	    else
		fprintf(file, "%s%s%d%s ", nond_term->name->name,
			SEP_LBITSELECT, nond_term->lo, SEP_RBITSELECT);
	else {
	    for (l=reference_term->lo; l<=reference_term->hi; l++)
		fprintf(file, "%s%s%d%s ", nond_term->name->name,
			SEP_LBITSELECT, l, SEP_RBITSELECT);
	}
    }
    (void)lsFinish(gen);
    if (reference_term->lo > reference_term->hi ||
	reference_term->flag & MVar)
	fprintf(file, "%s\n", 
		nond_output(retval->name->name, reference_term->name->name));
    else {
	fprintf(file, "%s ", HSIS_ARROW);
	for (l=reference_term->lo; l<=reference_term->hi; l++)
	    fprintf(file, "%s%s%d%s ", 
		    nond_output(retval->name->name,reference_term->name->name),
		    SEP_LBITSELECT, l, SEP_RBITSELECT);
	fprintf(file, "\n");
    }

    
    
    for (gen=lsStart(nond_consts);
	 lsNext(gen,(lsGeneric*)&k,&handle) != LS_NOMORE; ) {
	if (reference_term->lo > reference_term->hi ||
	    reference_term->flag & MVar)
	    for (j=0; j<num_terms; j++) fprintf(file, "- ");
	else 
	    for (l=reference_term->lo; l<=reference_term->hi; l++)
		for (j=0; j<num_terms; j++) fprintf(file, "- ");
		
	if (reference_term->flag & MVar) {
	    domain = reference_term->term_type->specifier->u.enum_type->domain_list;
	    for (enum_gen = lsStart(domain), i=0;
		 lsNext(enum_gen, (lsGeneric*)&enum_elt, &enum_handle) !=
		     LS_NOMORE; i++) 
		if (k == i) {
		    fprintf(file, "%s ", enum_elt->name);

		}
	    (void)lsFinish(enum_gen);
	} else {
	    if (reference_term->lo > reference_term->hi) {
		
		fprintf(file, "%d", k);
	    } else {
		
		for (l=reference_term->lo, j=k; l<=reference_term->hi; 
		     l++, j >>= 1)
		    fprintf(file, "%d ", j & 0x1);
	    }
	}
	fprintf(file, "\n");
    }
    (void)lsFinish(gen);
    
    for (gen=lsStart(nond_terms), j=0;
	 lsNext(gen,(lsGeneric*)&nond_term,&handle) != LS_NOMORE; j++) {
	if (set_notation || reference_term->lo <= reference_term->hi) {

	    
	    for (i=0; i<num_terms; i++) 
		if (reference_term->lo > reference_term->hi ||
		    reference_term->flag & MVar)
		    fprintf(file, "- ");
		else {
		    for (l=reference_term->lo; l<=reference_term->hi; l++)
			fprintf(file, "- ");
		}

	    if (reference_term->lo > reference_term->hi || 
		reference_term->flag & MVar) {
		if (nond_term->lo > nond_term->hi)
		    fprintf(file, "%s%s\n", HSIS_EQUAL, nond_term->name->name);
		else
		    fprintf(file, "%s%s%s%d%s\n", HSIS_EQUAL, 
			    nond_term->name->name, 
			    SEP_LBITSELECT, nond_term->lo, SEP_RBITSELECT);
	    } else {
		for (l=reference_term->lo; l<=reference_term->hi; l++)
		    fprintf(file, "%s%s%s%d%s ", HSIS_EQUAL, 
			    nond_term->name->name,
			    SEP_LBITSELECT, 
			    nond_term->lo-reference_term->lo+l, 
			    SEP_RBITSELECT);
		fprintf(file, "\n");
	    }

	} else {

	    
	    if (reference_term->flag & MVar) {
		
		domain = reference_term->term_type->specifier->u.enum_type->domain_list;
		for (enum_gen=lsStart(domain);
		     lsNext(enum_gen, (lsGeneric*)&enum_elt, 
			    &enum_handle) != 
		         LS_NOMORE; ) {
		    for (i=0; i<j; i++) fprintf(file, "- ");
		    fprintf(file, "%s ", enum_elt->name);
		    for (i++; i<num_terms; i++) fprintf(file, "- ");
		    fprintf(file, "%s\n", enum_elt->name);
		}
		(void)lsFinish(enum_gen);
	    } else {
		
	    }

	}
    }
    (void)lsFinish(gen);

    lsDestroy(nond_consts, 0);
    lsDestroy(nond_terms, 0);
    return retval;
}


void vl_get_minmax_delay(vl_delay *delay, vl_expr **min_delay, vl_expr **max_delay)
{
    lsGen gen;
    lsHandle handle;
    vl_expr *delayi;
    int i;

    if (!(delay->delay3 && !delay->delay2)) return;
    assert(lsLength((lsList)delay->delay1) == 2);

    *min_delay = *max_delay = NIL(vl_expr);
    for (gen=lsStart((lsList)delay->delay1), i=1;
	 lsNext(gen, (lsGeneric*)&delayi, &handle) != LS_NOMORE; i++) {
	if (i==1) *min_delay = delayi;
	else if (i==2) *max_delay = delayi;
	else break;
    }
    lsFinish(gen);
}


static int isTautology(lsList syndrome_expr_list)
{
    lsGen gen;
    lsHandle handle;
    syndrome_expr *se;
    unsigned int i;
    int unguarded = 0;

    for (gen = lsStart(syndrome_expr_list);
	 lsNext(gen, (lsGeneric*)&se, &handle) != LS_NOMORE; ) {
	unguarded = 1;
	for (i=0; i<strlen(se->syndrome); i++) {
	    if ((se->syndrome)[i] != '-') {
		unguarded = 0;
		break;
	    }
	}
	if (unguarded) break;
    }
    lsFinish(gen);

    return unguarded;
}



void write_case_tag_const(FILE *file, vl_term *selector,
			  vl_expr *tag_expr, st_table *vars)
{
    
    if (!tag_expr->term) {
	if (tag_expr->type == IntExpr || tag_expr->type == BitExpr ||
	    evaluable_expr(tag_expr)) {
	    tag_expr->term = typed_new_term(selector->name->id_type,
					NIL(vl_range), 
					selector->lo, selector->hi);
	    write_var_decl(file, tag_expr->term);
	    write_int_connect(file, vl_eval_expr(tag_expr), tag_expr->term);
	} else if (tag_expr->type != IDExpr && tag_expr->type != ConcatExpr) {
	    vl_write_expr(file, tag_expr, vars);
	} else if (tag_expr->type == IDExpr) {
	    vl_id_range *sel_id_sym;
	    vl_enumerator *enum_elt;

	    if (!st_lookup(vl_currentModule->sig_st, selector->name->name,
			   (char**)&sel_id_sym)) {
		sel_id_sym = vl_copy_id_range(selector->name);
		if (selector->term_type) 
		    sel_id_sym->id_type = selector->term_type;
		if (!strstr(selector->name->name, SEP_GATEPIN)) {
		    st_insert(vl_currentModule->sig_st, 
			      vlStrdup(selector->name->name), 
			      (char*)sel_id_sym);
		}
	    }
	    if (!sel_id_sym->id_type) {
	        vl_write_expr(file, tag_expr, vars);
		return;
	    }
	    
	    if (st_lookup(sel_id_sym->id_type->specifier->
			  u.enum_type->domain_st, 
			  tag_expr->u.name->name,
			  (char**)&enum_elt)) {
		
		tag_expr->term = typed_new_term(selector->term_type,
					    NIL(vl_range), 
					    selector->lo, selector->hi);
		tag_expr->term->flag = selector->flag;
		write_var_decl(file, tag_expr->term);
		tag_expr->type = IntExpr;
		tag_expr->u.intval = enum_elt->val;
		vl_write_const(file, tag_expr, tag_expr->term);
	    } else {
		char buf[MAXSTRLEN];

		sprintf(buf,"'%s':var '%s' should not be used as CASE-tag",
			vl_currentModule->name->name, tag_expr->u.name->name);
		semantic_error(buf);
	    }
	} else if (tag_expr->type == ConcatExpr) {
	    vl_write_expr(file, tag_expr, vars);
	}
    }
}


void smv_mv_dc(FILE *file, vl_type *id_type)
{
    vl_enumerator *enum_elt;
    lsHandle enum_handle;
    lsGen enum_gen;
    lsList domain;
    int i;

    fprintf(file, "%s", SMV_LBRACE);
    domain = id_type->specifier->u.enum_type->domain_list;
    for (enum_gen=lsStart(domain), i=0;
	 lsNext(enum_gen,(lsGeneric*)&enum_elt,&enum_handle)!=LS_NOMORE;
	 i++) {
	if (i!=0)
	    fprintf(file, "%s%s", SMV_COMMA, enum_elt->name);
	else 
	    fprintf(file, "%s", enum_elt->name);
    }
    lsFinish(enum_gen);
    fprintf(file, "%s", SMV_RBRACE);
}


void smv_dc(FILE *file, vl_type *id_type, int hi, int lo)
{
    if (!id_type) {
        if (hi < lo)
	    fprintf(file, "%s", SMV_BIN_DC);
	else 
	    
	    fprintf(file, "%d", 0);
    } else
	smv_mv_dc(file, id_type);
}


void smv_create_bin_vector_nondeterminism(FILE *file,
					  st_table *resultant_vars,
					  char *var_name,
					  vl_id_range *id_sym,
					  int lo, int hi,
					  array_t *controls,
					  array_t *vars_array,
					  int idx_lo, int idx_hi,
					  vl_term *nond_out)
{
    int idx;
    int i;
    vl_term *ctrl_i;
    st_table *vars;
    var_info *cur_var;
    char buf_old[MAXSTRLEN];

    for (idx=idx_lo; idx<=idx_hi; idx++) {
	
	if (id_sym->range) {
	    fprintf(file, "%s %s %s%d%s %s\n\t%s\n", SMV_DEFINE,
		    nond_out->name->name,
		    SEP_LARRAY, idx, SEP_RARRAY, SMV_COL_ASSIGN,
		    SMV_CASE);
	} else {
	    fprintf(file, "%s %s %s\n\t%s\n", SMV_ASSIGN,
		    nond_out->name->name, SMV_COL_ASSIGN, SMV_CASE);
	}

	
	for (i=0; i<array_n(controls); i++) {
	    ctrl_i = array_fetch(vl_term*, controls, i);
	    if (ctrl_i) {
		vars = array_fetch(st_table*, vars_array, i);
		st_lookup(vars, var_name, (char**)&cur_var);
		if (id_sym->range)
		    fprintf(file, "\t%s %s %s%s%d%s ;\n",
			    ctrl_i->name->name, SMV_COLON,
			    cur_var->current_terminal->name->name,
			    SEP_LARRAY, idx, SEP_RARRAY);
		else
		    fprintf(file, "\t%s %s %s ;\n",
			     ctrl_i->name->name, SMV_COLON,
			     cur_var->current_terminal->name->name);
	    }
	}
	
	
	strcpy(buf_old, id_sym->name);
	strip_char(buf_old, SEP_LATCH);
	if (id_sym->range) 
	    fprintf(file, "\t%d %s %s%s%d%s ;\n", 1, SMV_COLON,
		    buf_old, SEP_LARRAY, idx, SEP_RARRAY);
	else
	    fprintf(file, "\t%d %s %s ;\n", 1, SMV_COLON, buf_old);
	
	fprintf(file, "\t%s;\n", SMV_ESAC);
    }
}


void width_unknown()
{
    char buf[MAXSTRLEN];
    
    sprintf(buf, "%s:you are giving me concatenation of something I can't determined the width", vl_currentModule->name->name);
    yylineno = -1;
    compile_error(buf);
}


vl_term *concate_assigns(array_t *assign_array)
{
    vl_term *retval;
    vl_term *ith_term;
    int n_bits;
    int i;
    
    n_bits=0;
    for (i=0; i<array_n(assign_array); i++) {
        ith_term = array_fetch(vl_term*, assign_array, i);
	if (ith_term->flag & MVar) 
	    compile_error("boomer:concating symbolic variables");

	if (ith_term->hi < ith_term->lo) n_bits++;
	else n_bits += (ith_term->hi - ith_term->lo + 1);
    }

    retval = new_term(NIL(vl_range), 0, n_bits-1);

    return retval;
}


void connect_concat(FILE *file, vl_term *assign_term, array_t *lhs_array)
{
    int i;
    int old_lo, old_hi;
    int n_bits, bit_pos;
    vl_term *lhs_term;

    old_lo = assign_term->lo;
    old_hi = assign_term->hi;
    for (i=array_n(lhs_array)-1, bit_pos = assign_term->lo; i>=0; i--) {
	lhs_term = array_fetch(vl_term*, lhs_array, i);
	if (lhs_term->hi < lhs_term->lo) n_bits = 1;
	else n_bits = lhs_term->hi - lhs_term->lo + 1;
	assign_term->lo = bit_pos;
	assign_term->hi = assign_term->lo + n_bits - 1;
	vl_write_bin_connect(file, assign_term, lhs_term, 0);
	bit_pos += n_bits;
    }
    assign_term->lo = old_lo;
    assign_term->hi = old_hi;
}


fg_graph_info *get_assoc_lc_name(char *loc, char *lc_name)
{
    int location;
    lsGen ggen;
    lsHandle ghandle;
    graph_t *graph;
    fg_graph_info *retval=NIL(fg_graph_info);

    if (!loc) return retval;
    if (!lc_name) return retval;

    location = atoi(strstr(loc, FG_LLOC)+strlen(FG_LLOC));
    for(ggen=lsStart(vl_currentModule->flow_graphs);
	lsNext(ggen, (lsGeneric*)&graph, &ghandle) != LS_NOMORE; ) {
        if (location >= ((fg_graph_info*)graph->user_data)->pause_lo &&
	    location <  ((fg_graph_info*)graph->user_data)->pause_hi) {
	    sprintf(lc_name, "%s%06x",
		    FG_LC_PS, ((fg_graph_info*)graph->user_data)->fg_id);
	    retval = (fg_graph_info*)(graph->user_data);
	    break;
	}
    }
    lsFinish(ggen);

    return retval;
}


static void smv_barrel_shifter(FILE *file, vl_term *operand, vl_term *amount,
			       vl_term *result, int lr)
{
    char ctrl[MAXSTRLEN];
    int i, j;
    int cntr_width, max_shift;

    strcpy(ctrl, new_termname());
    cntr_width = (amount->hi<amount->lo)?1:(amount->hi-amount->lo+1);
    cntr_width = (cntr_width>4)?4:cntr_width; 
    max_shift = (1 << cntr_width)-1;

    
    fprintf(file, "%s %s %s %s %d%s%d %s %s;\n", SMV_VAR,
	    ctrl, SMV_COLON, SMV_ARRAY, max_shift, SMV_RANGE, 0,
	    SMV_OF, SMV_BOOLEAN);

    
    fprintf(file, "%s %s %s\n\t%s\n", 
	    SMV_ASSIGN, ctrl, SMV_COL_ASSIGN, SMV_CASE);
    for (i=0; i<=max_shift; i++)
        fprintf(file, "\t%s%s%d %s %u ;\n", amount->name->name, SMV_EQUAL,
		i, SMV_COLON, (1<<i));
    fprintf(file, "\t%d %s %d;\n%s;\n", 1, SMV_COLON, 0, SMV_ESAC);

    
    for (j=result->lo; j<=result->hi; j++) {
        fprintf(file, "%s %s[%d] %s\n\t%s\n",
		SMV_ASSIGN, result->name->name, j, SMV_COL_ASSIGN, SMV_CASE);
	for (i=0; 
	     i<=max_shift && ((lr)?(j-i>=result->lo):(j+i<=result->hi));
	     i++) {
	    int ith;
	    ith = 
	      (lr)?j-i+(operand->lo-result->lo):j+i+(operand->lo-result->lo);
	    if ((ith >= operand->lo && ith <= operand->hi)) {
	        fprintf(file, "\t%s[%d]%s%d %s %s[%d] ;\n", 
			ctrl, i, SMV_EQUAL, 1, 
			SMV_COLON, operand->name->name, ith);
	    }
	}
	fprintf(file, "\t%d %s %d;\n\t%s;\n", 1, SMV_COLON, 0, SMV_ESAC);
    }
}


void write_out_port(FILE *file, vl_id_range *id_sym,
		    int m_hi, int m_lo, vl_expr *inst_expr,
		    st_table *auxSigST)
{
    if (inst_expr->type == IDExpr) {
        if (dumpSMVPlus)
	    if (auxSigST) st_insert(auxSigST, inst_expr->u.name->name, 0);
	st_insert(vl_currentModule->sig_st, inst_expr->u.name->name,
		  (char*)vl_create_id_range(inst_expr->u.name->name, 
					    NIL(vl_range)));
    }
    inst_expr->term = new_term(NIL(vl_range), m_lo, m_hi);
}


void vl_write_outport_connect(FILE *file, vl_expr *inst_expr)
{
    int rep=1;
    int i;
    int bitWidth;
    lsGen gen;
    lsHandle handle;
    vl_term *term_out;
    vl_expr *e;

    if (inst_expr->type != ConcatExpr) return;

    if (inst_expr->u.exprs.e2) {
        rep = vl_eval_expr(inst_expr->u.exprs.e2);
    }

    term_out = inst_expr->term;
    assert(term_out);
    term_out->hi = term_out->lo - 1;
    for (i=0; i<rep; i++) {
        for (gen=lsStart((lsList)(inst_expr->u.exprs.e1));
	     lsNext(gen, (lsGeneric*)&e, &handle) != LS_NOMORE; ) {
	    vl_write_expr(file, e, NIL(st_table));
	    assert(e->term);
	    bitWidth = (e->term->hi - e->term->lo+1);
	    bitWidth = (bitWidth>0) ? bitWidth : 1;
	    term_out->lo = term_out->hi + 1;
	    term_out->hi = term_out->lo + bitWidth - 1;
	    vl_write_bin_connect(file, term_out, e->term, 0);
	}
	lsFinish(gen);
    }
    term_out->lo = 0;
}


void smv_predeclare_timers(file, flow_graphs)
FILE *file;
lsList flow_graphs;
{
    lsGen gen;
    lsHandle handle;
    graph_t *graph;

    if (!dumpSMVPlus)  return;

    for (gen=lsStart(flow_graphs);
	 lsNext(gen, (lsGeneric*)&graph, &handle) != LS_NOMORE; ) {
	if (graph) {
	    if (!fg_check_timer_consistency(file, graph)) {
		char buf[MAXSTRLEN];
		yylineno = -1;
		sprintf(buf, "%s: contains delay free cycle(s)", 
			vl_currentModule->name->name);
		fprintf(stderr, "%s\n", buf);
	    }
	    fg_set_fg(graph);
	    fg_declare_smv_timers(file, graph);
	    fg_set_fg(NIL(graph_t));
	}
    }
    lsFinish(gen);
}


static int evaluable_expr(vl_expr *expr)
{
    int old_silent_err;
    int retval;

    old_silent_err = silent_err;
    silent_err = 1;
    Vlerrno = 0;

    vl_eval_expr(expr);

    retval = Vlerrno;
    silent_err = old_silent_err;
    return !retval;
}


void write_const_param(FILE *file, vl_expr *expr, vl_id_range *ival)
{
    int l, r;
    vl_expr *ce;

    if (expr->type == IDExpr) {
        
        l = 31; r = 0;
    } else {
        l = vl_eval_expr(expr->u.idrng->range->left);
	if (expr->u.idrng->range->right) 
	    r = vl_eval_expr(expr->u.idrng->range->right);
	else
	    r = l;
    }

    expr->term = new_term(NIL(vl_range), 0, (l>r)?l:r);
    write_var_decl(file, expr->term);

    ce = vl_create_expr(IntExpr, (int)ival->mpg_master_exp, (double)0.0,
			NIL(void), NIL(void), NIL(void));
    vl_write_const(file, ce, expr->term);
    vl_chk_free((char*)ce);

    expr->term->hi = (l>r)?l:r;
    expr->term->lo = (l>r)?r:l;
}


void chkUndefPorts(vl_expr *expr, st_table *sig_st)
{
    char *dummy;

    if (implicitDeclare)
        if (sig_st)
	    if (expr->type == IDExpr)
	        if (!st_lookup(vl_currentModule->sig_st, expr->u.name->name,
			       &dummy)) {
		    st_insert(sig_st, expr->u.name->name, 0);
		}
}


void record_pseudo_cntxt(FILE *file, int fg_id, st_table *pre_cond,
			 char *ctrl_syndrome,
			 char *rst_ctrl_syndrome, st_table *vars)
{
    vl_id_range *cntxt_idsym;
    vl_term *out_term, *new_out;

    cntxt_idsym = vl_create_id_range(cntxt_event, NIL(vl_range));
    cntxt_idsym->flags |= EventVar;
    st_insert(vl_currentModule->sig_st, cntxt_idsym->name, (char*)cntxt_idsym);

    out_term = new_term(NIL(vl_range), 0, -1);
    write_int_connect(file, 1, out_term);
    new_out = vl_copy_term(out_term);

    if (!rst_ckt) {
        lsNewEnd(cntxt_idsym->syndrome_expr_list, 
		 (lsGeneric)create_syndrome_expr(vlStrdup(ctrl_syndrome),
						 new_out, pre_cond, fg_id), 
		 0);
    } else {
        lsNewEnd(cntxt_idsym->rst_syndrome_expr_list, 
		 (lsGeneric)create_syndrome_expr(vlStrdup(rst_ctrl_syndrome),
						 new_out, pre_cond, fg_id), 
		 0);
    }

    
    
    
    st_insert(vars, cntxt_idsym->name, 
	      (char*)create_var_info(vl_copy_id_range(cntxt_idsym), out_term));

    cntxt_event = NIL(char);
}


char *descape(char *str, char ch1, char ch2)
{
    static char retval[MAXSTRLEN];

    strcpy(retval, str);
    if (dumpSMVPlus)
	if (retval[0] == ch1) retval[0] = ch2;
    return retval;
}


char *triPort(char *name)
{
    static char retval[MAXSTRLEN];
    vl_id_range *id_sym;

    strcpy(retval, name);
    if (st_lookup(vl_currentModule->sig_st, name, (char**)&id_sym)) {
	if (Zconnection) {
	    if ((id_sym->flags & InPort) && (id_sym->flags & OutPort)) {
		strcat(retval, SEP_GATEPIN);  strcat(retval, PIN_INOUT);
	    }
	}
    }
    return retval;
}


static char *
nond_output(char *local_name, char *var_name)
{
    static char buf[MAXSTRLEN];
    char *cp;

    if (vis_nond && !rst_ckt) {
	sprintf(buf, var_name);
	if ((cp=strstr(buf, SEP_GATEPIN))) *cp = '\0';
	vis_nond_var = 1;
	return buf;
    } else {
	return local_name;
    }
}


void to_upper(char *str)
{
    int i;
    int len;

    len = strlen(str);
    for (i=0; i<len; i++)
	if (islower((int)(str[i])))
	    str[i] += ('A' - 'a');
}


char *
shift_mv_vars(char *inputs, int nval)
{
    static char buf[MAXSTRLEN];
    int len, i;
    char arg[MAXSTRLEN];
    char token[MAXSTRLEN];
    char *cp;
    int ith;
    
    buf[0] = '\0';
    len = strlen(inputs);
    for (cp=inputs, ith=0; cp<inputs+len; ith++) {
        i=0;
        while ((*cp == ' ' || *cp == '\t') && *cp != '\0') cp++;
	while ((*cp != ' ' && *cp != '\t') && *cp != '\0') {
	    token[i] = *cp;
	    cp++;  i++;
	}
	if (i > 0) {
	    token[i] = '\0';
            if (ith == 0)
                sprintf(arg, " %s ", token);
            else
                sprintf(arg, " , %s ", token);
	    strcat(buf, arg);
	}
    }

    return buf;
}
