/*

  Copyright (c) 1992, 1993
        Regents of the University of California
  All rights reserved.

  Use and copying of this software and preparation of derivative works
  based upon this software are permitted.  However, any distribution of
  this software or derivative works must include the above copyright 
  notice.

  This software is made available AS IS, and neither the Electronics
  Research Laboratory or the Universify of California make any
  warranty about the software, its performance or its conformity to
  any specification.

  Author: Szu-Tsung Cheng, stcheng@ic.Berkeley.EDU
          10/92
          10/93

  $Id: vlr_int.h,v 1.3 2003/11/28 17:07:00 fabio Exp $

*/


#define VL2MV_VERSION "1.4"

#define MAXSTRLEN    16384
#define MAXBITNUM    32
#define ERR_CHK      1
#define ERR_COMPILE  2
#define ERR_INTERNAL 3
#define ERR_ASSERT   4
#define ERR_SEMANTIC 5

#define NODE           "_n"
#define PC             "_pc"
#define LABEL          "_label"


#define VL_NOND        "$ND"

#define SEP_LBITSELECT ((shift_Support)?"*":((dumpSMVPlus)?"[":"<"))
#define SEP_RBITSELECT ((shift_Support)?"*":((dumpSMVPlus)?"]":">"))
#define SEP_LARRAY     ((shift_Support)?"**":((dumpSMVPlus)?"[":"<*"))
#define SEP_RARRAY     ((shift_Support)?"**":((dumpSMVPlus)?"]":"*>"))
#define SEP_LTRANGE    ((dumpSMVPlus)?"_I_":"<<")
#define SEP_RTRANGE    ((dumpSMVPlus)?"_I_":">>")
#define SEP_GATEPIN   ((dumpSMVPlus)?"$":"$")
#define SEP_DIR       ((dumpSMVPlus)?"$":"___")
#define SEP_LATCH     ((dumpSMVPlus)?"_V_":"_V_")
#define SEP_QUASI     ((dumpSMVPlus)?"_Q_":"_Q_")
#define SEP_SEL_VAR   "+"
#define PIN_INITIAL   "initial"
#define PIN_DELAYED   "*"
#define PIN_LATCH     "lat"
#define PIN_RAWOUT    "raw"
#define PIN_TRUE      "true"
#define PIN_FALSE     "false"
#define PIN_IN        "in"
#define PIN_PS        "ps"
#define PIN_NS        "ns"
#define PIN_FEEDBACK  "@"
#define PIN_DELAY     "prev"
#define PIN_EVENT     "e"
#define PIN_HIDDEN    "*||*"
#define PIN_INOUT     "_IO_"


#define HSIS_EQUAL    "="
#define HSIS_ARROW    ((shift_Support)?"=>":"->")
#define HSIS_DEFAULT  ".def"
#define HSIS_SET_BEGIN "("
#define HSIS_SET_END   ")"
#define HSIS_SET_SEP   ","
#define HSIS_BLIF_MVT_TIMER "T"
#define HSIS_DELTA_TIMER    "dD"
#define HSIS_TIMER_SEP "&&"
#define HSIS_COMMENT   "#"
#define HSIS_MODEL     ".model"
#define HSIS_TYPE      "type"
#define HSIS_MEMREAD   "HSIS_READ_MEM"
#define HSIS_MEMWRITE  "HSIS_WRITE_MEM"
#define HSIS_REGFILE   "regfile"
#define HSIS_ADDRESS   "address"
#define HSIS_VALUE     "value"


#define SMV_COMMENT    "--"
#define SMV_DEFINE     ((smv_NSyntax)?"DEFINE":"DEFINE")
#define SMV_ASSIGN     ((smv_NSyntax)?"ASSIGN":"ASSIGN")
#define SMV_VAR        "VAR"
#define SMV_WIRE       "WIRE"
#define SMV_MODULE     "MODULE"
#define SMV_PROLOGUE   ((smv_NSyntax)?"{":"")
#define SMV_EPILOGUE   ((smv_NSyntax)?"}":"")
#define SMV_INPUT      "INPUT"
#define SMV_OUTPUT     "OUTPUT"
#define SMV_CLOCK      "CLOCK"
#define SMV_MEMORY     "MEMORY"
#define SMV_IF         "if"
#define SMV_COL_ASSIGN ":="
#define SMV_COLON      ":"
#define SMV_CMPL       "~"
#define SMV_NOT        "!"
#define SMV_AND        "&"
#define SMV_OR         "|"
#define SMV_XOR        "^"
#define SMV_MOD        "mod"
#define SMV_EQUIV      "<->"
#define SMV_IMP        "->"
#define SMV_EQUAL      "="
#define SMV_NEQUAL     "~="
#define SMV_LBRACE     "{"
#define SMV_RBRACE     "}"
#define SMV_LBRACKET   "("
#define SMV_RBRACKET   ")"
#define SMV_COMMA      ","
#define SMV_RANGE      ".."
#define SMV_PLUS       "+"
#define SMV_MINUS      "-"
#define SMV_LE         "<="
#define SMV_GE         ">="
#define SMV_OF         "of"
#define SMV_ARRAY      "array"
#define SMV_BOOLEAN    "boolean"
#define SMV_FOR        "for"
#define SMV_PROCESS    "process"
#define SMV_INIT       "init"
#define SMV_TRANS      "next"

#define SMV_CASE       "case {"
#define SMV_ESAC       "}"
#define SMV_CTL_OP     "AEFGUX"


#define SMV_BIN_DC     "{0,1}"
#define SMV_INDEX      "__SMV_index__"


#define SCRATCH_FILE  "gate.blif"
#define OUT_SCRATCH   "gate.o"
#define SCRIPT_NAME   "script.complement"
#define SIS_LOG       "sis.log"


#define CLOCK         "clk"


#define NO_MUX        0x0
#define MUX_T         0x3    
#define MUX_F         0x2    


#define DEFAULT_MAX_TABLE_SIZE 1


#define MACRO_DEFINE  "define"
#define MACRO_IFDEF   "ifdef"
#define MACRO_IFNDEF  "ifndef"
#define MACRO_ELSE    "else"
#define MACRO_ENDIF   "endif"





#define BLIF_GND         "_BLIF_GND"
#define BLIF_SUP         "_BLIF_SUP"
#define BLIF_LIB_AND     "_BLIF_AND"
#define BLIF_LIB_OR      "_BLIF_OR"
#define BLIF_LIB_XOR     "_BLIF_XOR"
#define BLIF_LIB_XNOR    "_BLIF_XNOR"
#define BLIF_LIB_ADD     "_BLIF_ADD"
#define BLIF_LIB_SUB     "_BLIF_SUB"


#define LIB_MUX      0

#define SIG_ST(crt_module) (((crt_module)->type==ModDecl)? \
                               (((vl_module*)(crt_module))->sig_st): \
 			       (((vl_function*)(crt_module))->sig_st))
#define YYTRACE(str) if (YYTrace) fprintf(stderr, "%s\n", str);
#define CpyTRACE(str) if (CpyTrace) fprintf(stderr, "  <Y>%s", str);
#define CreTRACE(str) if (CreTrace) fprintf(stderr, "  <C>%s", str);
#define PrtTRACE(str) if (PrtTrace) fprintf(stderr, "  <P>%s", str);
#define StpTRACE(str) if (StpTrace) fprintf(stderr, "  <S>%s", str);
#define WrtTRACE(str) if (WrtTrace) fprintf(stderr, "  <W>%s", str);
#define TODO(str) \
  {fprintf(stderr, "%d:not implemented (translation not precise)\n%s\n", yylineno, str); }
#define ASSERT(cond,msg) if (!(cond)) {fprintf(stderr,"ASSERT Fail:%s\n",msg);}
#define Assert(cond)  if (!cond) {fprintf(stderr,"Assert fail: file \"%s\", line %d\n",__FILE__,__LINE__);exit(ERR_ASSERT);}
				      
#define ISVLCONST(type) ((type)==BitExpr||(type)==IntExpr||(type)==RealExpr)
#define IS_VLR_REL_OP(type) ((type)==BgtExpr||(type)==BltExpr||(type)==BgeExpr||(type)==BleExpr)
#define IS_VLR_LOG_OP(type) ((type)==BlandExpr||(type)==BlorExpr)
#define ISREDUCTION(type) ((type)==UnandExpr||(type)==UnorExpr|| \
			   (type)==UxnorExpr||(type)==UandExpr|| \
			   (type)==UorExpr||(type)==UxorExpr)
#define RIPPLE_INTERFERE(type) ((type)==UandExpr||(type)==UnandExpr|| \
                                (type)==UorExpr||(type)==UnorExpr|| \
                                (type)==UxorExpr||(type)==UxnorExpr|| \
                                (type)==BplusExpr||(type)==BminusExpr|| \
                                (type)==BltExpr||(type)==BleExpr|| \
                                (type)==BgtExpr||(type)==BgeExpr)
#define IS_TRANSITION(sym) ((sym)==PrimR || (sym)==PrimF || (sym)==PrimS || \
                            (sym)==PrimBB|| (sym)==PrimQ0|| (sym)==PrimQ1|| \
			    (sym)==PrimQB|| (sym)==Prim0X|| (sym)==Prim1X|| \
			    (sym)==PrimX0|| (sym)==PrimX1|| (sym)==PrimXB|| \
			    (sym)==PrimBX)


#if defined(_IBMR2) || defined(_snake)
extern unsigned char yytext[];
#else
extern char *yytext;
#endif
extern int yylineno;
extern FILE *yyin;
extern struct vl_desc *vl_description;
extern struct vl_module *vl_currentModule;
extern struct vl_primitive *vl_currentPrimitive;
extern struct vl_function *vl_currentFunction;
extern int smv_NSyntax;
extern int shift_Support;



void yyerror ARGS((char *str));


int yywrap ARGS(());
void skipcommentblock ARGS(());
void skipcommentline ARGS(());
void binbin ARGS((char *, char *));
void octbin ARGS((char *, char *));
void decbin ARGS((char *, char *));
void hexbin ARGS((char *, char *));
char *utol ARGS((char *));
void memorize_macro ARGS((char *, st_table *));
void expand_macro ARGS((char *, st_table *));


void chk_error ARGS((char *));
char *chk_malloc ARGS((unsigned));
void vl_chk_free ARGS((char *));
char *vlStrdup ARGS((char *));
char *strappend ARGS((char*, char*));
char *strappendS ARGS((char*, char*));
char *WRT_BLIF_DC ARGS((FILE *));
char *WRT_BLIF_MV_DC ARGS((FILE *, lsList));
char *WRT_BLIF_GND ARGS((FILE *));
char *WRT_BLIF_SUP ARGS((FILE *));
vl_term *true_term ARGS((FILE *));
vl_term *false_term ARGS((FILE *));
int ptrcmp ARGS((char *, char *));
int ptrhash ARGS((char *, int));
int declcmp ARGS((char *, char *));
int declhash ARGS((char *, int));
char *strip_char ARGS((char *, char *));
FILE *open_file ARGS((char *, char *));
void close_file ARGS((FILE *));
char *num_to_binstr ARGS((int, int));
int min_bit_width ARGS((int));
char *sys_lib_encode ARGS((int, int, int));
char *lib_encode ARGS((int, int));
char *gen_lib_encode ARGS((int, lsList));
EXTERN int ipower ARGS((int, int));
char *basename ARGS((char *));
char *extname ARGS((char *));
