@echo off
rem
rem This script starts xcircuit under the Tcl interpreter,
rem reading commands from a special .wishrc script which
rem launches magic and retains the Tcl interactive interpreter.
rem

set XCIRCUIT_LIB_DIR=C:/OpenCircuitDesign/XCircuit-3.8
set XCIRCUIT_WISH=C:/Tcl/bin/wish85.exe

set loclibdir=%XCIRCUIT_LIB_DIR%

set TKCON=1
for %%i in (%*) do (
	if "%%i" == "-noconsole" set TKCON=0
)

if "%TKCON%" == "1" (

   if not exist %loclibdir%/tkcon.tcl set loclibdir=%loclibdir%/tcl

   start %XCIRCUIT_WISH% %loclibdir%/tkcon.tcl -eval "source %loclibdir%/console.tcl" -slave "package require Tk; set argv [list %*]; set argc [llength argv]; source %loclibdir%/xcircuit.tcl"

) else (


rem Run the stand-in for wish (xcircexec), which acts exactly like "wish"
rem except that it replaces ~/.wishrc with xcircuit.tcl.  This executable is
rem *only* needed when running without the console; the console itself is
rem capable of sourcing the startup script.

   %loclibdir%/xcircexec -- %*

)
