/*-------------------------------------------------------------------------*/
/* menudefs.h								   */
/* Copyright (c) 1998  Tim Edwards, Johns Hopkins University       	   */
/*-------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------*/
/* Menu Definitions for hierarchical pulldown menus                        */
/*-------------------------------------------------------------------------*/

typedef struct _menustruct *menuptr;

typedef struct _menustruct {
        char *name;
        menuptr submenu;
        short size;
        XtCallbackProc func;
        void *passeddata;
} menustruct;

/*-------------------------------------------------------------------------*/
/* Functions declared externally to the menu structures			   */
/* (A list of every function called from the menu buttons)		   */
/*-------------------------------------------------------------------------*/

extern Clientdata areastruct;
extern object	areaobject;

extern XtCallbackProc DoNothing(), toggle(), getint(), getfloat(), quit();
extern XtCallbackProc getstr(), drawarea(), zoomin(), zoomout(), centerpan();
extern XtCallbackProc startdelete(), startcatalog(), startrotate();
extern XtCallbackProc drawuser(), placedot(), getfile();
extern XtCallbackProc startbox(), startcopy(), starttext();
extern XtCallbackProc zoomview(), saveas(), startarc(), sethjust(), setvjust();
extern XtCallbackProc getfill(), getset(), getopaque(), join();
extern XtCallbackProc addnewfont(), setfont(), fontstyle(), newpagemenu();
extern XtCallbackProc getline(), startpush(), popobject(), resetbutton(), gettsize();
extern XtCallbackProc selectsave(), addtotext(), dooutput(), undelete(), getosize();
extern XtCallbackProc getwirewidth(), getwwidth(), getlib(), savelib(), getuserlib();
extern XtCallbackProc startdesel(), starthelp(), getdscale(), startspline();
extern XtCallbackProc getgridtype(), zoombox(), startedit(), startman(), boxedit(); 
extern XtCallbackProc inversecolor(), addnewcolor(), setcolor();

/*-------------------------------------------------------------------------*/
/* Hierarchical menus must be listed in bottom-up order			   */
/*-------------------------------------------------------------------------*/
/* Note:  underscore (_) before name denotes a color to paint the button.  */
/*	  colon (:) before name denotes a stipple, defined by the data	   */
/*		    passed to getfill().				   */
/*-------------------------------------------------------------------------*/

#define submenu(a) 	a, (sizeof (a) / sizeof(menustruct)), \
			(XtCallbackProc)DoNothing, NULL
#define action(b,c)	NULL, 0, (XtCallbackProc)b, c
#define setaction(b,c)	NULL, 1, (XtCallbackProc)b, c
#define noaction	NULL, 0, (XtCallbackProc)DoNothing, NULL

/* Things commented out here are reminders of future implementations. */

menustruct Fonts[] = {
	{"Add New Font", action(addnewfont, NULL)},
	{" ", noaction},
        {"Times Roman", action(setfont, Number(0))},
	{"Helvetica", setaction(setfont, Number(4))},
	{"Courier", action(setfont, Number(8))},
	{"Symbol", action(setfont, Number(12))}
};

/* Note the unorthodox passing of integer constants through type pointer */

menustruct FontStyles[] = {
	{"Normal", setaction(fontstyle, Number(0))},
	{"Italic", action(fontstyle, Number(1))},
	{"Bold", action(fontstyle, Number(2))},
	{"BoldItalic", action(fontstyle, Number(3))},
	{" ", noaction},
	{"Subscript", action(addtotext, Number(SUBSCRIPT))},
	{"Superscript", action(addtotext, Number(SUPERSCRIPT))},
	{"Normalscript", action(addtotext, Number(NORMALSCRIPT))},
	{" ", noaction},
	{"Underline", action(addtotext, Number(UNDERLINE))},
	{"Overline", action(addtotext, Number(OVERLINE))},
	{"No line", action(addtotext, Number(NOLINE))},
};

menustruct TextSpacing[] = {
	{"Backspace", action(addtotext, Number(BACKSPACE))},
	{"1/2 space", action(addtotext, Number(HALFSPACE))},
	{"1/4 space", action(addtotext, Number(QTRSPACE))},
};

menustruct Justifs[] = {
	{"Left Justified", setaction(sethjust, Number(NORMAL))},
	{"Center Justified", action(sethjust, Number(NOTLEFT))},
	{"Right Justified", action(sethjust, Number(NOTLEFT | RIGHT))},
	{" ", noaction},
	{"Top Justified", action(setvjust, Number(NOTBOTTOM | TOP))},
	{"Middle Justified", action(setvjust, Number(NOTBOTTOM))},
	{"Bottom Justified", setaction(setvjust, Number(NORMAL))},
};
	
menustruct BoxEditStyles[] = {
	{"Manhattan Box Edit", setaction(boxedit, Number(MANHATTAN))},
	{"Rhomboid X", action(boxedit, Number(RHOMBOIDX))},
	{"Rhomboid Y", action(boxedit, Number(RHOMBOIDY))},
	{"Rhomboid A", action(boxedit, Number(RHOMBOIDA))},
	{"Normal", action(boxedit, Number(NORMAL))},
};

menustruct GridStyles[] = {
	{"Decimal Inches", action(getgridtype, Number(DEC_INCH))},
	{"Fractional Inches", setaction(getgridtype, Number(FRAC_INCH))},
	{"Centimeters", action(getgridtype, Number(CM))},
	{" ", noaction},
	{"Drawing Scale", action(getdscale, NULL)},
};

menustruct Pages[] = {
	{"Add New Page", action(newpagemenu, Number(255))},
	{" ", noaction},
	{"Page 1", action(newpagemenu, Number(0))},
	{"Page 2", action(newpagemenu, Number(1))},
	{"Page 3", action(newpagemenu, Number(2))},
	{"Page 4", action(newpagemenu, Number(3))},
	{"Page 5", action(newpagemenu, Number(4))},
	{"Page 6", action(newpagemenu, Number(5))},
	{"Page 7", action(newpagemenu, Number(6))},
	{"Page 8", action(newpagemenu, Number(7))},
	{"Page 9", action(newpagemenu, Number(8))},
	{"Page 10", action(newpagemenu, Number(9))}
};

menustruct BorderStyles[] = {
	{"Linewidth", action(getwwidth, NULL)},
	{" ", noaction},
	{"Solid", setaction(getline, Number(NORMAL))},
	{"Dashed", action(getline, Number(DASHED))},
	{"Dotted", action(getline, Number(DOTTED))},
	{"Unbordered", action(getline, Number(NOBORDER))},
	{" ", noaction},
	{"Closed", action(getset, Number(UNCLOSED))}, 
};

menustruct Colors[] = {
	{"Add New Color", action(addnewcolor, NULL)},
	{" ", noaction},
	{"Inherit Color", setaction(setcolor, Number(1))},
	{"_Black", action(setcolor, NULL)},
	{"_White", action(setcolor, NULL)},
};

menustruct Stipples[] = {
	{":Black",  action(getfill, Number(FILLED | FILLSOLID))},
	{":Gray12", action(getfill, Number(FILLED | STIP2 | STIP1))},
	{":Gray25", action(getfill, Number(FILLED | STIP2 | STIP0))},
	{":Gray37", action(getfill, Number(FILLED | STIP2))},
	{":Gray50", action(getfill, Number(FILLED | STIP0 | STIP1))},
	{":Gray62", action(getfill, Number(FILLED | STIP1))},
	{":Gray75", action(getfill, Number(FILLED | STIP0))},
	{":Gray87", action(getfill, Number(FILLED))},
	{":White", setaction(getfill, Number(FILLSOLID))},
	{" ", noaction},
	{"Opaque", action(getopaque, Number(OPAQUE))},
};

menustruct TextMenu[] = {
	{"Text Size", action(gettsize, &areastruct.textscale)},
	{"Font", submenu(Fonts)},
	{"Style", submenu(FontStyles)},
	{"Insert Space", submenu(TextSpacing)},
	{"Justification (keypad)", submenu(Justifs)},
	{" ", noaction},
	{"Make Label (t)", action(starttext, NULL)},
};

menustruct PolyMenu[] = {
	{"Border", submenu(BorderStyles)},
	{"Fill", submenu(Stipples)},
	{"Color", submenu(Colors)},
	{" ", noaction},
	{"Object size", action(getosize, NULL)},
	{"Manhattan Draw", action(toggle, &areastruct.manhatn)},
	{"Polygon Edit", submenu(BoxEditStyles)},
};

menustruct RotateMenu[] = {
	{"Flip Horizontal (f)", action(startrotate, Number(64))},
	{"Flip Vertical (F)", action(startrotate, Number(65))},
	{" ", noaction},
	{"Rotate CW 90", action(startrotate, Number(18))},
	{"Rotate CW 45", action(startrotate, Number(9))},
	{"Rotate CW 30", action(startrotate, Number(6))},
	{"Rotate CW 15 (r)", action(startrotate, Number(3))},
	{"Rotate CW 5 (o)", action(startrotate, Number(1))},
	{" ", noaction},
	{"Rotate CCW 90", action(startrotate, Number(-18))},
	{"Rotate CCW 45", action(startrotate, Number(-9))},
	{"Rotate CCW 30", action(startrotate, Number(-6))},
	{"Rotate CCW 15 (R)", action(startrotate, Number(-3))},
	{"Rotate CCW 5 (O)", action(startrotate, Number(-1))},
};

menustruct GridMenu[] = {
	{"Grid", setaction(toggle, &areastruct.gridon)},
	{"Axes", setaction(toggle, &areastruct.axeson)},
	{"Grid spacing", action(getint, &areastruct.gridspace)},
	{"Grid type/display", submenu(GridStyles)},
};

menustruct SnapMenu[] = {
	{"Snap-to", setaction(toggle, &areastruct.snapto)},
        {"Snap spacing", action(getint, &areastruct.snapspace)},
};

menustruct WindowMenu[] = {
	{"Zoom In (Z)", action(zoomin, Number(0))},
	{"Zoom Out (z)", action(zoomout, NULL)},
	{"Zoom Box", action(zoombox, NULL)},
	{"Full View (v)", action(zoomview, Number(1))},
	{"Center Pan (p)",action(centerpan, NULL)},
	{" ", noaction},
	{"Show Library (l)", action(startcatalog, Number(LIBRARY))},
	{"Show User Library (L)", action(startcatalog, Number(USERLIB))},
	{"Goto Page", submenu(Pages)}
};

menustruct QuitMenu[] = {
	{"No Kidding", action(quit, NULL)}
};

menustruct FileMenu[] = {
	{"Read Xcircuit File", action(getfile, Number(0))},
	{"Import Xcircuit PS", action(getfile, Number(1))},
	{"Write Xcircuit PS", action(dooutput, NULL)},
	{" ", noaction},
	{"Add To Library", action(getlib, NULL)},
	{"Load User Library", action(getuserlib, NULL)},
	{"Save User Library", action(savelib, NULL)},
	{" ", noaction},
        {"Clear Page", action(resetbutton, NULL)},
	{" ", noaction},
	{"Quit", submenu(QuitMenu)},
};

menustruct OptionMenu[] = {
	{"Alt Colors", action(inversecolor, &areastruct.invert)},
	{"Grid", submenu(GridMenu)},
	{"Snap-to", submenu(SnapMenu)},
	{"Linewidth", action(getwirewidth, &areastruct.wirewidth)},
	{"Elements", submenu(PolyMenu)},
	{" ", noaction},
	{"Help!", action(starthelp, NULL)},
};

menustruct EditMenu[] = {
	{"Delete (d)", action(startdelete, NULL)},
	{"Undelete (u)", action(undelete, Number(DRAW))},
	{"Copy (c)", action(startcopy, NULL)},
	{"Edit (e)", action(startedit, NULL)},
	{"Rotate/Flip", submenu(RotateMenu)},
	{"Deselect (x)", action(startdesel, NULL)},
	{"Refresh ( )", action(drawarea, NULL)},
/*	{"Array", noaction}, */
	{"Push selected (>)", action(startpush, NULL)},
	{"Pop hierarchy (<)", action(popobject, Number(0))},
	{" ", noaction},
	{"Make User Object (m)", action(selectsave, NULL)},
	{"Make Arc (a)", action(startarc, NULL)},
	{"Make Box (b)", action(startbox, NULL)},
	{"Make Spline (s)", action(startspline, NULL)},
	{"Join (j)", action(join, NULL)},
};

menustruct TopButtons[] = {
	{"File", submenu(FileMenu)},
	{"Edit", submenu(EditMenu)},
	{"Text", submenu(TextMenu)},
	{"Options", submenu(OptionMenu)},
	{"Window", submenu(WindowMenu)},
};

#undef submenu
#undef action
#undef noaction

/*-------------------------------------------------------------------------*/
