//-----------------------------------------------------------------------------
// COPYRIGHT  (c)  1997 
// THE REGENTS OF THE UNIVERSITY OF MICHIGAN
// ALL RIGHTS RESERVED
// 
// PERMISSION IS GRANTED TO USE, COPY, CREATE DERIVATIVE WORKS 
// AND REDISTRIBUTE THIS SOFTWARE AND SUCH DERIVATIVE WORKS FOR 
// ANY PURPOSE, SO LONG AS NO FEE IS CHARGED, AND SO LONG AS 
// THE COPYRIGHT NOTICE ABOVE, THIS GRANT OF PERMISSION, AND 
// THE DISCLAIMER BELOW APPEAR IN ALL COPIES MADE; AND SO LONG 
// AS THE NAME OF THE UNIVERSITY OF MICHIGAN IS NOT USED IN ANY 
// ADVERTISING OR PUBLICITY PERTAINING TO THE USE OR 
// DISTRIBUTION OF THIS SOFTWARE WITHOUT SPECIFIC, WRITTEN 
// PRIOR AUTHORIZATION.
// 
// THIS SOFTWARE IS PROVIDED AS IS, WITHOUT REPRESENTATION 
// FROM THE UNIVERSITY OF MICHIGAN AS TO ITS FITNESS 
// FOR ANY PURPOSE, AND WITHOUT WARRANTY BY THE 
// UNIVERSITY OF MICHIGAN OF ANY KIND, EITHER EXPRESS OR 
// IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES 
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE 
// REGENTS OF THE UNIVERSITY OF MICHIGAN SHALL NOT BE LIABLE 
// FOR ANY DAMAGES, INCLUDING SPECIAL, INDIRECT, INCIDENTAL, OR 
// CONSEQUENTIAL DAMAGES, WITH RESPECT TO ANY CLAIM ARISING OUT 
// HAS BEEN OR IS HEREAFTER ADVISED OF THE POSSIBILITY OF SUCH 
// DAMAGES.
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// File: hspice_parser.hh
//
// Purpose: Contains declaration/definition of a parser class for spice grammar
//
// Remarks: 
//
// History: 07/07/95 - JPMS - created; using some ideas from Tim Burks'
//                            parser in MooCAF.
//          03/27/96 - JPMS - repackaged for new version of the software.
//          03/20/97 - MAR - adapted for spice grammar
//
// Copyright (c) 1996 Joao P. Marques Silva.
//
// RCS Version:
//     $Id: hspice_parser.hh,v 1.1.1.1 2002/05/01 14:23:27 mguthaus Exp $
//-----------------------------------------------------------------------------

#ifndef __HSPICE_PARSER__
#define __HSPICE_PARSER__

class hspice_parser;

#include <map>
#include <vector>
#include <list>
using namespace std;
#include "circuit.hh"
#include "netlist_parser.hh"

//-----------------------------------------------------------------------------
// Parser for spice-format files
//-----------------------------------------------------------------------------

class hspice_parser : public netlist_parser {
public:

    //-------------------------------------------------------------------------
    // constructor
    //-------------------------------------------------------------------------

    hspice_parser(circuit &circ) : netlist_parser(circ) {}
    virtual ~hspice_parser() {}

    //-------------------------------------------------------------------------
    // Parse function.
    //-------------------------------------------------------------------------

    virtual int parse (vector<char*> *files);

private:

};

#endif
