//-----------------------------------------------------------------------------
// COPYRIGHT  (c)  1997 
// THE REGENTS OF THE UNIVERSITY OF MICHIGAN
// ALL RIGHTS RESERVED
// 
// PERMISSION IS GRANTED TO USE, COPY, CREATE DERIVATIVE WORKS 
// AND REDISTRIBUTE THIS SOFTWARE AND SUCH DERIVATIVE WORKS FOR 
// ANY PURPOSE, SO LONG AS NO FEE IS CHARGED, AND SO LONG AS 
// THE COPYRIGHT NOTICE ABOVE, THIS GRANT OF PERMISSION, AND 
// THE DISCLAIMER BELOW APPEAR IN ALL COPIES MADE; AND SO LONG 
// AS THE NAME OF THE UNIVERSITY OF MICHIGAN IS NOT USED IN ANY 
// ADVERTISING OR PUBLICITY PERTAINING TO THE USE OR 
// DISTRIBUTION OF THIS SOFTWARE WITHOUT SPECIFIC, WRITTEN 
// PRIOR AUTHORIZATION.
// 
// THIS SOFTWARE IS PROVIDED AS IS, WITHOUT REPRESENTATION 
// FROM THE UNIVERSITY OF MICHIGAN AS TO ITS FITNESS 
// FOR ANY PURPOSE, AND WITHOUT WARRANTY BY THE 
// UNIVERSITY OF MICHIGAN OF ANY KIND, EITHER EXPRESS OR 
// IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES 
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE 
// REGENTS OF THE UNIVERSITY OF MICHIGAN SHALL NOT BE LIABLE 
// FOR ANY DAMAGES, INCLUDING SPECIAL, INDIRECT, INCIDENTAL, OR 
// CONSEQUENTIAL DAMAGES, WITH RESPECT TO ANY CLAIM ARISING OUT 
// HAS BEEN OR IS HEREAFTER ADVISED OF THE POSSIBILITY OF SUCH 
// DAMAGES.
//-----------------------------------------------------------------------------

//
// file:      cmdLine.C
// purpose:   code declarations for command line class
//
// Author: Joao Paulo Silva
//
// RCS Version:
//     $Id: cmdLine.cc,v 1.1.1.1 2002/05/01 14:23:27 mguthaus Exp $
//
#include <iostream.h>
#include <string.h>
#include <vector>
#include <map>
#include <list>
using namespace std;

#include "defs.hh"
#include "cmdLine.hh"

const int cmdLine::commandBufferSize = 1024;
cmdArg cmdLine::dummy;

//
// parse a character string into a vector of commands
//
void cmdLine::parse (char *str) {
    //
    // parse tokens into separate arguments
    //
    DBGn(cout<<"\t-> Processing string: "<<str<<endl;);
    char buf[256];
    strncpy (buf,str,256);
    char *c = strtok (buf, " ");
    if(!c) c = strtok(0,"\n");
    if (c) {
	_size = 1;
	args[0] = new cmdArg(c);
	DBGn(cout<<"\t-> String read: "<<args[0]->string()<<endl;);
	while ((c = strtok (0, " ")) || (c = strtok(0,"\n"))) {
	    if (_size == MAXARGS) {
		cout << "Too many command arguments.  "
		    << "Increase MAXARGS in cmdLine.h" << endl;
		return;
	    }
	    args[_size++] = new cmdArg(c);
	    DBGn(cout<<"\t-> String read: "<<args[_size-1]->string()<<endl;);
	}
    } else {
	_size = 0;
    }
    //
    // zero out remaining arguments (for safety)
    //
    for (int i = _size; i < MAXARGS; i++)
        args[i] = new cmdArg("");
    DBGn(cout<<"\t-> String processed!"<<endl;);
}

//
// constructor (from program command line)
//
cmdLine::cmdLine (int argc, char *argv[]) : args (argc) {
    for (int i = 0; i < argc; i++)
	args[i] = new cmdArg(argv[i]);
}

//
// access an individual command argument
//
cmdArg& cmdLine::operator[] (int index) {
    if ((index >= args.size()) || (index < 0))
	return dummy;
    else
        return *args[index];
}

//
// stream output method
//
ostream& operator<< (ostream& stream, cmdLine &command) {
    if (command.size()) {
    	for (int i = 0; i < command.size(); i++) {
	    if (i != 0) stream << " ";
	    stream << command[i].string();
    	}
    } else {
	stream << "NULL";
    }
    return stream;
}

//
// stream input method
//
istream& operator>> (istream& stream, cmdLine &c) {
    static char buf [cmdLine::commandBufferSize];
    stream.getline (buf, cmdLine::commandBufferSize);
    if (stream) {
	c.parse (buf);
    }
    return stream;
}

