//-----------------------------------------------------------------------------
// COPYRIGHT  (c)  1997 
// THE REGENTS OF THE UNIVERSITY OF MICHIGAN
// ALL RIGHTS RESERVED
// 
// PERMISSION IS GRANTED TO USE, COPY, CREATE DERIVATIVE WORKS 
// AND REDISTRIBUTE THIS SOFTWARE AND SUCH DERIVATIVE WORKS FOR 
// ANY PURPOSE, SO LONG AS NO FEE IS CHARGED, AND SO LONG AS 
// THE COPYRIGHT NOTICE ABOVE, THIS GRANT OF PERMISSION, AND 
// THE DISCLAIMER BELOW APPEAR IN ALL COPIES MADE; AND SO LONG 
// AS THE NAME OF THE UNIVERSITY OF MICHIGAN IS NOT USED IN ANY 
// ADVERTISING OR PUBLICITY PERTAINING TO THE USE OR 
// DISTRIBUTION OF THIS SOFTWARE WITHOUT SPECIFIC, WRITTEN 
// PRIOR AUTHORIZATION.
// 
// THIS SOFTWARE IS PROVIDED AS IS, WITHOUT REPRESENTATION 
// FROM THE UNIVERSITY OF MICHIGAN AS TO ITS FITNESS 
// FOR ANY PURPOSE, AND WITHOUT WARRANTY BY THE 
// UNIVERSITY OF MICHIGAN OF ANY KIND, EITHER EXPRESS OR 
// IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES 
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE 
// REGENTS OF THE UNIVERSITY OF MICHIGAN SHALL NOT BE LIABLE 
// FOR ANY DAMAGES, INCLUDING SPECIAL, INDIRECT, INCIDENTAL, OR 
// CONSEQUENTIAL DAMAGES, WITH RESPECT TO ANY CLAIM ARISING OUT 
// HAS BEEN OR IS HEREAFTER ADVISED OF THE POSSIBILITY OF SUCH 
// DAMAGES.
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// File: functors.hh
//
// Purpose: Functors (function objects) are objects that can be called
//          like functions.  Used heavily in STL objects.  This file
//          defines the functors that are used in this application.
//
// Remarks: 
//
// History: 03/22/97 - MAR - created.
//
// Copyright (c) 1997 Michael A. Riepe
//
// RCS Version:
//     $Id: functors.hh,v 1.1.1.1 2002/05/01 14:23:27 mguthaus Exp $
//-----------------------------------------------------------------------------

#ifndef __FUNCTORS__
#define __FUNCTORS__

#ifdef HAVE_STL
   #include <string>	// Should be okay with the check for stl
   #include <stl>
#else
   #include <string.h>
   #include <stl.h>
#endif

//-----------------------------------------------------------------------------
// gloablly scoped functions used with STL objects
//-----------------------------------------------------------------------------

// a functor to define the integer equality, <, >, operators
// commonly used for map<> and hash_map<> objects
struct eqint {
    bool operator()(const int i1, const int i2) const {
        return (i1 == i2);
    }
};
struct ltint {
    bool operator()(const int i1, const int i2) const {
        return (i1 < i2);
    }
};
struct gtint {
    bool operator()(const int i1, const int i2) const {
        return (i1 < i2);
    }
};

// a functor to define the string equality, <, >, operators
// commonly used for map<> and hash_map<> objects
struct eqstr {
    bool operator()(const char* s1, const char* s2) const {
        return strcmp(s1, s2) == 0;
    }
};
struct ltstr {
    bool operator()(const char* s1, const char* s2) const {
        return strcmp(s1, s2) < 0;
    }
};
struct gtstr {
    bool operator()(const char* s1, const char* s2) const {
        return strcmp(s1, s2) > 0;
    }
};

// A unary functor to call the dump method of the class T
// Generally used in iterators.
template<class T>
struct G_dump: public unary_function<T, int> {
    G_dump(ostream& out) : os(out), count(0) {}
    void operator() (T x) {
        x->dump(os); os<<",";
        ++count;
    }
    ostream& os;
    int count;
};

// A binary functor that performs a less-than operation
// on pointer objects (differes from the < operator
// because the operands require dereferencing).  Model
// of a binary predicate.  T must be dereferencable.
template<class T>
struct ptr_comp: public binary_function<T,T,bool> {
    bool operator() (T op1, T op2) {
        return (*op1 < *op2);
    }
};

#endif // __FUNCTORS__

/*****************************************************************************/
