* TEST SPICE
* tests spice parser
* M. Riepe

* test number multipliers
.DCVOLT 1 1.0F
.DCVOLT 1 1.0P
.DCVOLT 1 1.0N
.DCVOLT 1 1.0U
.DCVOLT 1 1.0M
.DCVOLT 1 1.0K
.DCVOLT 1 1.0MEG
.DCVOLT 1 1.0MI
.DCVOLT 1 1.0G
.DCVOLT 1 1.0amps

* test recursive includes
.INCLUDE 'include.file'

.MODEL nbjt NPN
.MODEL pbjt PNP
.MODEL nmos NMOS
.MODEL pmos PMOS
.MODEL njfet NJF
.MODEL pjfet PJF
.MODEL cap C
.MODEL res R
.MODEL diode D

* test parameter types
M1 1 1 1 1 nmos A=1 B=0.1 C=2u D=0.5u E=5.0e+2

* test dual-value parameter
M2 out d Vdd Vdd pmos A=1.0u,2.0u

* test input control
.ALTER
.DATA devinf width length thresh cap
+            50u   40u    1.2v   1.2pf
+            25u   15u    1.0v   0.8pf
+             5u    2u    0.7v   0.6pf
.ENDDATA
.DEL LIB 'MOS.LIB' NORMAL
.DEL LIB 4 lm101
.GLOBAL node1 node2 node3
.IC V(11)=5 V(4)=-5 V(2)=2.2
.DCVOLT 11 5 4 -5 2 2.2
.LIB '/usr/spice/macro.lib' lm101
.ENDL lm101
.LIB 4 cmos1
.ENDL cmos1
.MODEL MOD1 NPN BF=50 IS=1E-13 VBF=50 AREA=2 PJ=3 N=1.03
.NODESET V(5:SETX)=3.5V V(X1.X2.VINT)=1V
.NODESET 12 4.5 4 2.23 1 1
.OPTIONS ACCT LIST GMIN=1E-11
.PC ACCT LIST GMIN=1E-11
.CONTROL ACCT LIST GMIN=1E-11
.PARAM TC1=.0015 TC2=0.0010 RSH=25
.PARAM A=4 B='5*sqrt(A)' C='25*A-4*B/sin(B)'
.PROT
.SYS 'cp temp temp.old'
.UNPROT
.WIDTH OUT=132

* test devices
R1 Rnode1 Rnode2 100
C1 1 2 cap
L1 42 69 1UH
D1 3 substrate diode 3 IC=0.2
Q1 3 2 5 nbjt AREA=1.5 AREAB=2.5 AREAC=3.0 IC=0.6,5.0
J1 7 2 3 njfet
M3 24 2 0 20 PC1_PM1_DU2

* test sources
I1 8 7 PULSE(1MA 0S 5MA 25MS)
V1 1 0 AC=10V,90

* test subcircuit
.SUBCKT nand4 a b c d out
J0 1 a GND GND pjfet L=0.5u W=5.0u
.ENDS nand4

* test subcircuit instance
X1 10 11 12 13 14 nand4

* test analysis cards
.DC VIN 0.25 5.0 0.25
.OP .5ns CUR 10NS VOL 17.5NS 20NS 25NS
.SENS V(9) V(4,3) V(17) I(VCC)
.TF V(5,3) VIN
.AC DEC 10 1K 100MEG
.DISTO RL 2 0.95 1.0E-3 0.75
.NOISE V(5) VIN 10
.SAMPLE FS=10.0s TOL=1.0e-3 NUMF=100 MAXFLD=10.0 BETA=1
.NET V(10,30) VINAC ROUT=75 RIN=50
.TEMP -55.0 25.0 125.0
.TRAN 1NS 100NS
.FOUR 100K V(5)
.TRAN 1ns 100nS UIC
.PZ V(10) Vin

* test output format
.PRINT TRAN V(4) I(VIN) PAR('V(OUT)/V(IN)')
.PLOT DC V(4) V(5) V(1) PAR('I1(Q1)/I2(Q1)')
.GRAPH AC MODEL=plotac_db VM(OUT)
.MEAS TRAN TDLAY TRIG V(1) VAL=2.5 TD=10ns RISE=2
+                TARG V(2) VAL=2.5         FALL=2

.END test spice parser
.END
