/*-------------------------------------------------------------------------*/
/* Copyright (c) 1998  Tim Edwards, Johns Hopkins University        	   */
/*-------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------*/
/* Spun off from xcircuit.c 10/4/98 in the hopes of expanding it sometime. */
/*-------------------------------------------------------------------------*/

#include <stdio.h>
#include <string.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include "Xw/Xw.h"
#include "Xw/Form.h"
#include "Xw/WorkSpace.h"
#include "Xw/MenuBtn.h"

/*-------------------------------------------------------------------------*/
/* Local includes							   */
/*-------------------------------------------------------------------------*/

#include "colordefs.h"
#include "xcircuit.h"
#include "menudep.h"

/*-------------------------------------------------------------------------*/
/* Global Variable definitions						   */
/*-------------------------------------------------------------------------*/

extern Display    *dpy;
extern Window     win;
extern GC	  hgc;
extern Clientdata areastruct;
extern ApplicationData appdata;
extern int 	  *appcolors;
extern Widget     top;
extern short	  popups;
extern Widget	  menuwidgets[];

Pixmap   helppix = (Pixmap)NULL;     /* For help window */
Dimension helpwidth, helpheight, helptop;
short help_up;

/*------------------------------------------------------------------------*/
/* Declarations of functions defined externally to xcircuit.c		  */
/*------------------------------------------------------------------------*/

XtCallbackProc printhelp(), simplescroll(), destroypopup();

/*-----------------------------------------*/
/* Print help list into a pixmap           */
/* Return width and height of map through  */
/* global variables helpwidth, helpheight. */
/*-----------------------------------------*/

#define NENTRIES 46
#ifdef SCHEMA
#define LENTRIES 50
#endif

int printhelppix(w)
  Widget w;
{
   static char *helptitle = "Short Command Summary:";
   static char *helptext[] = {
    "Z",        "Zoom in 3/2",
    "z",        "Zoom out 3/2",
    "p",        "Pan to center",
    "<arrows>", "Half-page pan U,D,R,L",
    "+/-",      "Change snap-to spacing",
    "l",        "Go To Library",
    ">",        "Push object",
    "<",        "Pop object",
    "<space>",  "Refresh screen",
    "0--9",     "Go To Page",
    "W",	"Output dialog",
    " ",	" ",
    "<Button1>","Polygon (fast click)",
    "b",        "Box",
    "a",        "Arc",
    "t",        "Text",
    "s",        "Spline",
    "m",        "Make object",
    "j",        "Join (make path)",
    "J",        "Un-join",
    " ",	" ",
    "d",        "Delete",
    "u",        "Undelete",
    "<Button1>","Move (when held down)",
    "<Button2>","Select",
    "x",        "Deselect",
    "c",        "Copy",
    "e",        "Edit",
    " ",	" ",
    "R",        "Rotate counterclockwise",
    "r",        "Rotate clockwise",
    "O",        "5 degree ccw rotate",
    "o",        "5 degree cw rotate",
    "f/F",      "Flip object horiz/vert",
    "S",        "Snap to grid",
    "A",	"Attach to",
    "| / : / _","Dashed/Dotted/Solid",
    " ",	" ",
    "<Keypad>", "Text Justification",
    "<KP +/->", "Super/Subscript",
    " ",	" ",
    "E",	"Library name edit",
    "M",	"Library move object",
    "D",	"Library object delete",
    "H",	"Library hide object",
    "C",	"Library copy object",
#ifdef SCHEMA
    " ",	" ",
    "T",	"Make Pin Label",
    "g",	"Generate schematic",
    "/",	"Symbol<->Schematic",
#endif
    };

    XGCValues	values;
    Window hwin = XtWindow(w);
    Dimension	mtmp, mwidth;
    int i, t1, t2, dum;
    XCharStruct csdum;

    int nentries = NENTRIES;

#ifdef SCHEMA
    if (areastruct.schemon) nentries = LENTRIES;
#endif

    /* Set up the GC for drawing to the help window pixmap */

    if (hgc == NULL) {
       values.foreground = FOREGROUND;
       values.background = BACKGROUND;
       values.font = appdata.helpfont->fid;
       hgc = XCreateGC(dpy, hwin, GCForeground | GCBackground | GCFont, &values);
    }

    /* Determine the dimensions of the help text */

    mwidth = helpwidth = helpheight = 0;

    for (i = 0; i < nentries; i += 2) {
       mtmp = XTextWidth(appdata.helpfont, helptext[i], strlen(helptext[i]));
       if (mtmp > mwidth) mwidth = mtmp;
       mtmp = XTextWidth(appdata.helpfont, helptext[i+1], strlen(helptext[i+1]));
       if (mtmp > helpwidth) helpwidth = mtmp;
    }
    for (i = 0; i < nentries; i ++) {
       XTextExtents(appdata.helpfont, helptext[i], strlen(helptext[i]), &dum, &t1,
	   &t2, &csdum);
       mtmp = t1 + t2 + 5;
       if (mtmp > helpheight) helpheight = mtmp;
    }
    XTextExtents(appdata.helpfont, helptitle, strlen(helptitle), &dum, &t1,
	&t2, &csdum);
    t1 += t2;
    helpwidth += mwidth + 15;
    mtmp = helpheight;
    helpheight = helpheight * nentries + 15 + t1;

    helppix = XCreatePixmap(dpy, hwin, helpwidth, helpheight,
	   	  DefaultDepthOfScreen(XtScreen(w)));

    XSetForeground(dpy, hgc, FOREGROUND);
    XFillRectangle(dpy, helppix, hgc, 0, 0, helpwidth, helpheight);

    XSetForeground(dpy, hgc, BACKGROUND);
    XDrawString(dpy, helppix, hgc, (helpwidth - XTextWidth(appdata.helpfont,
	helptitle, strlen(helptitle))) >> 1, t1 + 2, helptitle, strlen(helptitle));
    for (i = 0; i < nentries; i++) {
	XDrawString(dpy, helppix, hgc, 7, (i + 1) * mtmp + 15, helptext[i << 1],
		strlen(helptext[i << 1]));
	XDrawString(dpy, helppix, hgc, 7 + mwidth, (i + 1) * mtmp + 15,
		helptext[1 + (i << 1)], strlen(helptext[1 + (i << 1)]));
    }
    XSetForeground(dpy, hgc, AUXCOLOR);
    XDrawLine(dpy, helppix, hgc, 0, t1 + 7, helpwidth, t1 + 7);
}

/*-----------------------------------------*/
/* Create the help popup window		   */
/*-----------------------------------------*/

XtCallbackProc starthelp(button, clientdata, nulldata)
  Widget button;
  caddr_t *clientdata;
  caddr_t nulldata;
{
   Arg		wargs[8];
   Widget	popup, cancelbutton, hspace, help2;
   short 	n = 0;
   popupstruct  *okaystruct;
   buttonsave   *savebutton = (buttonsave *)malloc(sizeof(buttonsave));
   Dimension    areawidth, bwidth, pheight;
   Position	xpos, ypos;
   unsigned int xmax, ymax;

   if (help_up) return;  /* no multiple help windows */

   /* for positioning the help window outside of the xcircuit    */
   /* window, get information about the display width and height */
   /* and the xcircuit window.					  */

   /* The "- 30" leaves space for the Windows-95-type title bar that */
   /* runs across the bottom of the screen in some window managers   */
   /* (specifically, fvwm95 which is the default for RedHat Linux)   */

   xmax = DisplayWidth(dpy, DefaultScreen(dpy));
   ymax = DisplayHeight(dpy, DefaultScreen(dpy)) - 30;

   XtnSetArg(XtNwidth, &areawidth);
   XtGetValues(areastruct.area, wargs, n); n = 0;
   XtTranslateCoords(areastruct.area, (Position) (areawidth + 10), -50,
	&xpos, &ypos);

   /*  If called from main window, redirect call to the proper button */

   if (button == areastruct.area) button = OptionsHelpButton;

   getgeneric(savebutton, button, starthelp, NULL);

   /* Generate the pixmap and write the help text to it */

   if (helppix == (Pixmap)NULL) printhelppix(button);

   /* Use the pixmap size to size the help window */

   if (xpos + helpwidth > xmax)  xpos = xmax - helpwidth  - 4;
   if (ypos + helpheight > ymax) ypos = ymax - helpheight - 4;
   if (ypos < 4) ypos = 4;

   XtnSetArg(XtNx, xpos);
   XtnSetArg(XtNy, ypos);
   popup = XtCreatePopupShell("help", transientShellWidgetClass,
	button, wargs, n); n = 0;
   popups++;
   help_up = True;
   helptop = 0;

   XtnSetArg(XtNwidth, helpwidth);
   XtnSetArg(XtNyResizable, True);
   XtnSetArg(XtNxResizable, False);
   help2 = XtCreateManagedWidget("help2", XwformWidgetClass,
	popup, wargs, n); n = 0;

   XtnSetArg(XtNfont, appdata.xcfont);
   cancelbutton = XtCreateManagedWidget("Dismiss", XwmenuButtonWidgetClass,
	help2, wargs, n); n = 0;

   XtnSetArg(XtNyRefWidget, cancelbutton);
   XtnSetArg(XtNyAddHeight, True);
   XtnSetArg(XtNyAttachBottom, True);
   XtnSetArg(XtNborderWidth, 0);
   XtnSetArg(XtNheight, helpheight);
   XtnSetArg(XtNwidth, helpwidth);
   XtnSetArg(XtNxAttachRight, True);
   hspace = XtCreateManagedWidget("HSpace", XwworkSpaceWidgetClass,
	help2, wargs, n); n = 0;

   okaystruct = (popupstruct *) malloc(sizeof(popupstruct));
   okaystruct->buttonptr = savebutton;
   okaystruct->popup = popup;

   XtPopup(popup, XtGrabNone);

   /* reposition the "Dismiss" button to center */

   XtSetArg(wargs[0], XtNwidth, &bwidth);
   XtGetValues(cancelbutton, wargs, 1);
   XtnSetArg(XtNx, ((helpwidth - bwidth) >> 1));
   XtSetValues(cancelbutton, wargs, n); n = 0;

   /* Check for total size of window compared to computer screen */
   /* and add simple button-click callback if necessary.	 */

   XtSetArg(wargs[0], XtNheight, &pheight);
   XtGetValues(help2, wargs, 1);

   if (pheight > (ymax - 8)) {
      XtnSetArg(XtNheight, helpheight - (pheight - ymax) - 8);
      XtSetValues(hspace, wargs, n); n = 0;
      XtnSetArg(XtNheight, ymax - 8);
      XtSetValues(help2, wargs, n);
      XtSetValues(popup, wargs, n); n = 0;
      XtAddCallback(hspace, XtNselect, (XtCallbackProc)simplescroll, NULL);
   }

   /* Expose and End callbacks */

   XtAddCallback(cancelbutton, XtNselect, (XtCallbackProc)destroypopup, okaystruct); 
   XtAddCallback(hspace, XtNexpose, (XtCallbackProc)printhelp, popup);
}

/*----------------------------------------------*/
/* Very simple scroll mechanism			*/
/*----------------------------------------------*/

XtCallbackProc simplescroll(hspace, clientdata, calldata)
  Widget hspace;
  caddr_t clientdata, calldata;
{
   if (helptop == 0) {
      Dimension hheight;
      Arg wargs[1];

      XtSetArg(wargs[0], XtNheight, &hheight);
      XtGetValues(hspace, wargs, 1);

      helptop = helpheight - hheight;

   }
   else (helptop = 0);

   printhelp(hspace, NULL, NULL);
}

/*----------------------------------------------*/
/* Expose callback for the help window		*/
/*----------------------------------------------*/

XtCallbackProc printhelp(hspace, clientdata, calldata)
  Widget hspace;
  caddr_t clientdata, calldata;
{
   Window hwin = XtWindow(hspace);
   XEvent	discard;

   /* Draw the pixmap to the window */

   XCopyArea(dpy, helppix, hwin, hgc, 0, helptop - 5, helpwidth, helpheight,
	0, 0);

   /* flush out multiple expose events */

   while (XCheckWindowEvent(dpy, hwin, ExposureMask, &discard) == True);
}

/*-------------------------------------------------------------------------*/
