/*-------------------------------------------------------------------------*/
/* menudefs.h								   */
/* Copyright (c) 2000  Tim Edwards, Johns Hopkins University        	   */
/*-------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------*/
/* Menu Definitions for hierarchical pulldown menus                        */
/*-------------------------------------------------------------------------*/

typedef struct _menustruct *menuptr;

typedef struct _menustruct {
        char *name;
        menuptr submenu;
        short size;
        XtCallbackProc func;
        void *passeddata;
} menustruct;

typedef struct _toolbarstruct {
	char *name;
	char **icon_data;
        XtCallbackProc func;
        void *passeddata;
	char *hint;
} toolbarstruct;

/*-------------------------------------------------------------------------*/
/* Functions declared externally to the menu structures			   */
/* (A list of every function called from the menu buttons)		   */
/*-------------------------------------------------------------------------*/

extern Clientdata areastruct;
extern object	areaobject;

extern XtCallbackProc DoNothing(), toggle(), getgridspace(), getsnapspace(), quit();
extern XtCallbackProc getstr(), refresh(), zoomin(), zoomout(), centerpan();
extern XtCallbackProc startdelete(), startcatalog(), startrotate(), changecat();
extern XtCallbackProc drawuser(), placedot(), getfile(), selectfilter();
extern XtCallbackProc fontencoding(), setfontencoding();
extern XtCallbackProc startbox(), startcopy(), starttext(), join(), unjoin();
extern XtCallbackProc zoomview(), saveas(), startarc(), sethjust(), setvjust();
extern XtCallbackProc setflipinv(), getfill(), getset(), getopaque(), makebbox();
extern XtCallbackProc addnewfont(), setfont(), fontstyle(), newpagemenu();
extern XtCallbackProc getline(), startpush(), popobject(), resetbutton(), gettsize();
extern XtCallbackProc selectsave(), addtotext(), dooutput(), undelete(), getosize();
extern XtCallbackProc getwirewidth(), getwwidth(), getlib(), savelib(), getuserlib();
extern XtCallbackProc startdesel(), starthelp(), getdscale(), startspline();
extern XtCallbackProc getgridtype(), zoombox(), startedit(), startman(), boxedit(); 
extern XtCallbackProc inversecolor(), addnewcolor(), setcolor();
extern XtCallbackProc startparam(), startunparam();
extern XtCallbackProc border_popup(), color_popup(), fill_popup();
extern XtCallbackProc newlibrary(Widget, caddr_t, caddr_t);
#ifdef SCHEMA
extern XtCallbackProc swapschem(), callgennet(), makefund(), dopintype();
extern XtCallbackProc pinconvert(), schemdisassoc(), connectivity(), doxschema();
#endif
#ifdef HAVE_XPM
extern XtCallbackProc dotoolbar();
#endif

/*-------------------------------------------------------------------------*/
