/*-------------------------------------------------------------------------*/
/* rcfile.c --- Load initialization variables from the .xcircuitrc file	   */
/* Copyright (c) 2000  Tim Edwards, Johns Hopkins University        	   */
/*-------------------------------------------------------------------------*/
   
/*-------------------------------------------------------------------------*/
/*      written by Tim Edwards, 9/9/96                                     */
/*-------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "Xw/Xw.h"

/*-------------------------------------------------------------------------*/
/* Local includes                                                          */
/*-------------------------------------------------------------------------*/

#include "xcircuit.h"
#include "menudep.h"

/*-------------------------------------------------------------------------*/
/* Global Variable definitions						   */
/*-------------------------------------------------------------------------*/

extern char _STR2[250], _STR[150];
extern fontinfo *fonts;
extern short fontcount;
extern Clientdata areastruct;
extern Globaldata xobjs;
extern short beeper;
extern Widget    menuwidgets[];
extern void setdefaultfontmarks();

/*-------------------------------------------------------------------------*/

#define LIBOVERRIDE	1
#define LIBLOADED	2
#define COLOROVERRIDE	4
#define FONTOVERRIDE	8

/*-------------------------------------------------------------------------*/

short execcommand(short pflags, char *cmdptr)
{
   short flags = pflags;
   short i;
   Boolean a;
   char type[50], value[50];
   char *argptr;

   for(argptr = cmdptr; isspace(*argptr); argptr++)
      if (*argptr == '\0') return flags;
   cmdptr = argptr;

   for(argptr = cmdptr; (!isspace(*argptr)) && (*argptr != '\0'); argptr++);
   *argptr++ = '\0';
   while(isspace(*argptr)) argptr++;

   /* very liberal about comment line characters */

   if (*cmdptr == '#' || *cmdptr == '%' || *cmdptr == ';');

   /* startup configuration: enables/disables */

   else if (!(a = strcmp(cmdptr, "enable")) || !strcmp(cmdptr, "disable")) {
      sscanf(argptr, "%s", _STR);
      if (!strcmp(_STR, "grid")) {
	 areastruct.gridon = a ? True : False;
	 toggle(GridGridButton, &areastruct.gridon, NULL);
      }
      else if (!strcmp(_STR, "snap") || !strcmp(_STR, "snap-to")) {
	 areastruct.snapto = a ? True : False;
	 toggle(SnaptoSnaptoButton, &areastruct.snapto, NULL);
      }
      else if (!strcmp(_STR, "axis") || !strcmp(_STR, "axes")) {
	 areastruct.axeson = a ? True : False;
	 toggle(GridAxesButton, &areastruct.axeson, NULL);
      }
#ifdef SCHEMA
      else if (!strcmp(_STR, "xschema") || !strcmp(_STR, "schema")) {
	 areastruct.schemon = a ? True : False;
	 doxschema(OptionsEnableXSchemaButton, NULL, NULL);
      }
#endif
#ifdef HAVE_XPM
      else if (!strcmp(_STR, "toolbar")) {
	 areastruct.toolbar_on = a ? True : False;
	 dotoolbar(OptionsDisableToolbarButton, NULL, NULL);
      }
#endif
   }

   /* startup configuration: overrides */

   else if (!strcmp(cmdptr, "override")) {
      sscanf(argptr, "%s", _STR);
      if (!strcmp(_STR, "default")) {
	 sscanf(argptr, "%*s %s", value);
	 if (!strcmp(value, "library") || !strcmp(value, "libraries")) {
	    flags |= LIBOVERRIDE;
	 }
	 else if (!strcmp(value, "color") || !strcmp(value, "colors")) {
	    flags |= COLOROVERRIDE;
	 }
	 else if (!strcmp(value, "font") || !strcmp(value, "fonts")) {
	    flags |= FONTOVERRIDE;
	  }
      }
   }

   /* load builtin libraries */

   else if (!strcmp(cmdptr, "library")) {
      int libno;

      /* if loading of default libraries is not overridden, load them first */

      if (!(flags & (LIBOVERRIDE | LIBLOADED))) {
	 strcpy(_STR, BUILTINS_FILE);
	 loadlibrary(LIBRARY);
	 renamelib(LIBRARY);
	 flags |= LIBLOADED;
      }

      /* Optional third argument is the library number */
      if (sscanf(argptr, "%s %d", _STR, &libno) == 1)
	 libno = LIBRARY;
      else {
	 if (libno >= xobjs.numlibs)
	    libno = createlibrary();
	 else
	    libno += LIBRARY - 1;
      }
      loadlibrary(libno);
   }

   /* load extra fonts */

   else if (!strcmp(cmdptr, "font")) {

      /* if default font is not overridden, load it first */

      if (!(flags & FONTOVERRIDE)) {
	 loadfontfile("Helvetica");
	 flags |= FONTOVERRIDE;
      }
      sscanf(argptr, "%s", _STR);
      loadfontfile(_STR);
   }

   /* load extra colors */

   else if (!strcmp(cmdptr, "color")) {
      sscanf(argptr, "%s", _STR2);
      addnewcolorentry(xc_alloccolor(_STR2));
   }

   /* set variables */
 
   else if (!strcmp(cmdptr, "set") || !strcmp(cmdptr, "select")) {
      sscanf(argptr, "%s", _STR);
      if (!strcmp(_STR, "default")) {
	 sscanf(argptr, "%*s %s %s", type, value);
	 if (!strcmp(type, "font")) {
	    short i;
	    for (i = 0; i < fontcount; i++)
	       if (!strcmp(fonts[i].psname, value)) break;

	    if (i == fontcount) {
	       loadfontfile(value);
	    }
   	    areastruct.psfont = i;
	 }
      }
      else if (!strcmp(_STR, "boxedit")) {
	 sscanf(argptr, "%*s %s", value);
	 if (!strcmp(value, "rhomboid-x")) boxedit(NULL, RHOMBOIDX, NULL);
	 else if (!strcmp(value, "rhomboid-y")) boxedit(NULL, RHOMBOIDY, NULL);
	 else if (!strcmp(value, "rhomboid-a")) boxedit(NULL, RHOMBOIDA, NULL);
	 else if (!strcmp(value, "manhattan")) boxedit(NULL, MANHATTAN, NULL);
	 else if (!strcmp(value, "normal")) boxedit(NULL, NORMAL, NULL);
      }
      else if (!strcmp(_STR, "linewidth")) {
	 sscanf(argptr, "%*s %f", &areastruct.linewidth);
      }
      else if (!strcmp(_STR, "beep")) {
	 sscanf(argptr, "%*s %s %s", type, value);
	 if (!strcmp(type, "off")) beeper = 0;
      }
      else if (!strcmp(_STR, "colorscheme")) {
	 sscanf(argptr, "%*s %s", value);
	 if (!strcmp(value, "inverse") || !strcmp(value, "2"))
	    areastruct.invert = False;
	 inversecolor(NULL, &areastruct.invert, NULL);
      }
      else if (!strcmp(_STR, "coordstyle")) {
	 sscanf(argptr, "%*s %s", value);
	 if (!strcmp(value, "cm") || !strcmp(value, "centimeters")) {
	    xobjs.pagelist[0]->coordstyle = CM;
	    xobjs.pagelist[0]->pagesize.x = 595;  /* A4 size */
	    xobjs.pagelist[0]->pagesize.y = 842;
	    togglegrid((unsigned short)xobjs.pagelist[0]->coordstyle);
         }
      }
   }
   return flags;
}

/*-------------------------------------------------------------------------*/
#define TEMPLEN 128

short readcommand(short mode, FILE *fd)
{
   char *temp, *tmpptr, *endptr;
   short templen = TEMPLEN, tempmax = TEMPLEN;
   short flags = (mode == 0) ? 0 : LIBOVERRIDE | LIBLOADED |
		COLOROVERRIDE | FONTOVERRIDE;

   temp = (char *)malloc(templen);
   tmpptr = temp;

   while (fgets(tmpptr, templen, fd) != NULL) {
      endptr = tmpptr;
      while ((*endptr != '\0') && (*endptr != '\\')) {
         if (*endptr == '\n') {
	    endptr = temp;
	    templen = tempmax;
            flags = execcommand(flags, temp);
	    break;
	 }
	 endptr++;
	 templen--;
      }
      if (templen == 0) {
	 templen = (int)(endptr - temp);
	 tempmax += TEMPLEN;
	 temp = (char *)realloc(temp, tempmax);
	 tmpptr = temp + templen;
	 templen = TEMPLEN;
      }
      else
         tmpptr = endptr;
   }

   free(temp);
   return flags;
}

/*----------------------------------------------------------------------*/
/* Execute a script							*/
/*----------------------------------------------------------------------*/

void execscript()
{
   FILE *fd;

   if ((fd = fopen(_STR2, "r")) != NULL) readcommand(0, fd);
   else {
      sprintf(_STR, "Failed to open script file \"%s\"\n", _STR2);
      Wprintf(_STR);
   }
}

/*----------------------------------------------------------------------*/
/* Execute the .xcircuitrc startup script				*/
/*----------------------------------------------------------------------*/

loadrcfile()
{
   char *userdir = getenv((const char *)"HOME");
   FILE *fd;
   short i, flags = 0;

   sprintf(_STR2, "%s", USER_RC_FILE);     /* Name imported from Makefile */

   /* try first in current directory, then look in user's home directory */

   if ((fd = fopen(_STR2, "r")) == NULL) {
      sprintf(_STR2, "%s/%s", userdir, USER_RC_FILE);
      fd = fopen(_STR2, "r");
   }
   if (fd != NULL) flags = readcommand(0, fd);

   /* Add the default font if not loaded already */

   if (!(flags & FONTOVERRIDE)) {
      loadfontfile("Helvetica");
      for (i = 0; i < fontcount; i++)
	 if (!strcmp(fonts[i].psname, "Helvetica")) areastruct.psfont = i;
   }
   setdefaultfontmarks();

   /* arrange the loaded libraries */

   if (!(flags & (LIBOVERRIDE | LIBLOADED))) {
      strcpy(_STR, BUILTINS_FILE);
      loadlibrary(LIBRARY);
      renamelib(LIBRARY);
   }

   /* Add the default colors */

   if (!(flags & COLOROVERRIDE)) {
      addnewcolorentry(xc_alloccolor("Gray40"));
      addnewcolorentry(xc_alloccolor("Gray60"));
      addnewcolorentry(xc_alloccolor("Gray80"));
      addnewcolorentry(xc_alloccolor("Gray90"));
      addnewcolorentry(xc_alloccolor("Red"));
      addnewcolorentry(xc_alloccolor("Blue"));
      addnewcolorentry(xc_alloccolor("Green"));
      addnewcolorentry(xc_alloccolor("Yellow"));
      addnewcolorentry(xc_alloccolor("Purple"));
      addnewcolorentry(xc_alloccolor("Cyan"));
      addnewcolorentry(xc_alloccolor("Magenta"));
      addnewcolorentry(xc_alloccolor("Orange"));
      addnewcolorentry(xc_alloccolor("Tan"));
      addnewcolorentry(xc_alloccolor("Brown"));
   }
}

/*-------------------------------------------------------------------------*/
