#-----------------------------------------------------------
# Python script which creates a function "loadlgf" that
# replaces the code formerly in "formats.c" (deprecated).
# Python scripting is now the preferred method for handling
# alternate file formats.
#-----------------------------------------------------------

def loadlgf(f):
   keywords = 'nswlpbgh'
   symbols = {}

   try:
      fi = open(f, 'r')
   except IOError:
      return
   else:

      # check magic cookie to see if it's a real LGF file

      S = fi.readline()
      if S <> '-5\n':
	 return

      S = fi.readline()
      if S <> 'f s\n':
	 return

      # Now go load the LGF library (required)
      # '-1' loads at the end of the current library pages

      library('lgf.lps', -1)

      # clear the page

      reset()

      # read in the file

      S = fi.readline()
      while S:
	 L=S.split()
	 if len(L) == 2:
	    if (n = keywords.find(L[0])) == -1:
	       if L[0] == '.' or L[0]:		# end record
		  break
	       elif L[0].startswith('#') == 1 or L[0] == '\n':	# comment line
		  L[1] = 0
	       else:
		  print 'Error:  Bad keyword in LGF file'
		  return -1
	 else
	    print 'Error: Bad line in LGF file'

	 for X in range(0, L[1]):
	    S=fi.readline()
	    N=S.split()
	    if n == 0:			# 'n' (nodes)
	       break;
	    elif n == 1:		# 's' (symbols)
	       symbols[N[0]] = N[1]
	    elif n == 2:		# 'w' (wires)
	       create_polygon()
	    elif n == 3:		# 'l' (labels)
	       create_label()
	    elif n == 4:		# 'p' (solder dots)
	       place_dot()
	    elif n == 5:		# 'b' (boxes)
	       create_polygon()
	    elif n == 6:		# 'g' (gates)
	       create_objinst()
	    else:			# 'h' (history)
	       # (to be worked out)

	 S=fi.readline()

      h1 = getpage();
      return h1

def promptlgf():
   filepopup('Enter filename to load:', 'loadlgf')

bind('Control_l', 'promptlgf')
newbutton('Edit', 'Load LGF File (^L)', 'promptlgf')

#-----------------------------------------------------------
