/*-------------------------------------------------------------------------*/
/* menus.h								   */
/* Copyright (c) 2001  Tim Edwards, Johns Hopkins University        	   */
/*-------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------*/
/* Hierarchical menus must be listed in bottom-up order			   */
/*-------------------------------------------------------------------------*/
/* Note:  underscore (_) before name denotes a color to paint the button.  */
/*	  colon (:) before name denotes a stipple, defined by the data	   */
/*		    passed to getfill().				   */
/*-------------------------------------------------------------------------*/

#ifdef _MENUDEP

#define submenu(a)      a, (sizeof (a) / sizeof(menustruct)), NULL, NULL
#define action(b,c)     NULL, 0, NULL, NULL
#define setaction(b,c)  NULL, 1, NULL, NULL
#define toolaction(b,c) NULL, NULL
#define noaction        NULL, 0, NULL, NULL

#else                   /* real definitions. . .*/

#define submenu(a)	a, (sizeof (a) / sizeof(menustruct)), \
			(XtCallbackProc)DoNothing, NULL
#define action(b,c)	NULL, 0, (XtCallbackProc)b, c
#define setaction(b,c)	NULL, 1, (XtCallbackProc)b, c
#define toolaction(b,c) (XtCallbackProc)b, c
#define noaction	NULL, 0, (XtCallbackProc)DoNothing, NULL

#endif

/* Inclusions for pixmap icons */

#include "tool_bar.h"

/* Things commented out here are reminders of future implementations. */

menustruct Fonts[] = {
	{"Add New Font", action(addnewfont, NULL)},
	{" ", noaction},
};

/* Note the unorthodox passing of integer constants through type pointer */

menustruct FontStyles[] = {
	{"Normal", setaction(fontstyle, Number(0))},
	{"Bold", action(fontstyle, Number(1))},
	{"Italic", action(fontstyle, Number(2))},
	{"BoldItalic", action(fontstyle, Number(3))},
	{" ", noaction},
	{"Subscript", action(addtotext, Number(SUBSCRIPT))},
	{"Superscript", action(addtotext, Number(SUPERSCRIPT))},
	{"Normalscript", action(addtotext, Number(NORMALSCRIPT))},
	{" ", noaction},
	{"Underline", action(addtotext, Number(UNDERLINE))},
	{"Overline", action(addtotext, Number(OVERLINE))},
	{"No line", action(addtotext, Number(NOLINE))},
};

menustruct FontEncodings[] = {
	{"Standard", setaction(fontencoding, Number(0))},
	{"ISO-Latin1", action(fontencoding, Number(2))},
};

menustruct TextSpacing[] = {
	{"Tab stop", action(addtotext, Number(TABSTOP))},
	{"Tab forward", action(addtotext, Number(TABFORWARD))},
	{"Tab backward", action(addtotext, Number(TABBACKWARD))},
	{"Carriage Return", action(addtotext, Number(RETURN))},
	{"1/2 space", action(addtotext, Number(HALFSPACE))},
	{"1/4 space", action(addtotext, Number(QTRSPACE))},
	{"Kern", action(getkern, NULL)},
	{"Character", action(addtotext, Number(SPECIAL))},
};

menustruct Justifs[] = {
	{"Left Justified", setaction(sethjust, Number(NORMAL))},
	{"Center Justified", action(sethjust, Number(NOTLEFT))},
	{"Right Justified", action(sethjust, Number(NOTLEFT | RIGHT))},
	{" ", noaction},
	{"Top Justified", action(setvjust, Number(NOTBOTTOM | TOP))},
	{"Middle Justified", action(setvjust, Number(NOTBOTTOM))},
	{"Bottom Justified", setaction(setvjust, Number(NORMAL))},
	{" ", noaction},
	{"Flip Invariant", setaction(setflipinv, Number(FLIPINV))},
};
	
menustruct BoxEditStyles[] = {
	{"Manhattan Box Edit", setaction(boxedit, Number(MANHATTAN))},
	{"Rhomboid X", action(boxedit, Number(RHOMBOIDX))},
	{"Rhomboid Y", action(boxedit, Number(RHOMBOIDY))},
	{"Rhomboid A", action(boxedit, Number(RHOMBOIDA))},
	{"Normal", action(boxedit, Number(NORMAL))},
};

menustruct GridStyles[] = {
	{"Decimal Inches", action(getgridtype, Number(DEC_INCH))},
	{"Fractional Inches", setaction(getgridtype, Number(FRAC_INCH))},
	{"Centimeters", action(getgridtype, Number(CM))},
	{" ", noaction},
	{"Drawing Scale", action(getdscale, NULL)},
};

menustruct Libraries[] = {
	{"Add New Library", action(newlibrary, NULL)},
	{" ", noaction},
	{"Library 1", action(startcatalog, Number(LIBRARY))},
	{"Library 2", action(startcatalog, Number(LIBRARY + 1))},
};

menustruct Pages[] = {
	{"Add New Page", action(newpagemenu, Number(255))},
	{" ", noaction},
	{"Page 1", action(newpagemenu, Number(0))},
	{"Page 2", action(newpagemenu, Number(1))},
	{"Page 3", action(newpagemenu, Number(2))},
	{"Page 4", action(newpagemenu, Number(3))},
	{"Page 5", action(newpagemenu, Number(4))},
	{"Page 6", action(newpagemenu, Number(5))},
	{"Page 7", action(newpagemenu, Number(6))},
	{"Page 8", action(newpagemenu, Number(7))},
	{"Page 9", action(newpagemenu, Number(8))},
	{"Page 10", action(newpagemenu, Number(9))}
};

menustruct BorderStyles[] = {
	{"Linewidth", action(getwwidth, NULL)},
	{" ", noaction},
	{"Solid", setaction(getline, Number(NORMAL))},
	{"Dashed", action(getline, Number(DASHED))},
	{"Dotted", action(getline, Number(DOTTED))},
	{"Unbordered", action(getline, Number(NOBORDER))},
	{" ", noaction},
	{"Closed", action(getset, Number(UNCLOSED))}, 
	{"Bounding Box", action(makebbox, Number(BBOX))},
};

menustruct Colors[] = {
	{"Add New Color", action(addnewcolor, NULL)},
	{" ", noaction},
	{"Inherit Color", setaction(setcolor, Number(1))},
	{"_Black", action(setcolor, NULL)},
	{"_White", action(setcolor, NULL)},
};

menustruct Stipples[] = {
	{":Black",  action(getfill, Number(FILLED | FILLSOLID))},
	{":Gray12", action(getfill, Number(FILLED | STIP2 | STIP1))},
	{":Gray25", action(getfill, Number(FILLED | STIP2 | STIP0))},
	{":Gray37", action(getfill, Number(FILLED | STIP2))},
	{":Gray50", action(getfill, Number(FILLED | STIP0 | STIP1))},
	{":Gray62", action(getfill, Number(FILLED | STIP1))},
	{":Gray75", action(getfill, Number(FILLED | STIP0))},
	{":Gray87", action(getfill, Number(FILLED))},
	{":White", setaction(getfill, Number(FILLSOLID))},
	{" ", noaction},
	{"Opaque", action(getopaque, Number(OPAQUE))},
};

menustruct TextMenu[] = {
	{"Text Size", action(gettsize, &areastruct.textscale)},
	{"Font", submenu(Fonts)},
	{"Style", submenu(FontStyles)},
	{"Encoding", submenu(FontEncodings)},
	{"Insert", submenu(TextSpacing)},             
	{"Justification (keypad)", submenu(Justifs)},
	{"Parameterize", action(startparam, Number(LABEL))},
	{"Unparameterize", action(startunparam, Number(LABEL))},
	{" ", noaction},
	{"Make Label (t)", action(starttext, Number(NORMAL))},
};

menustruct PolyMenu[] = {
	{"Border", submenu(BorderStyles)},
	{"Fill", submenu(Stipples)},
	{"Color", submenu(Colors)},
	{" ", noaction},
	{"Object size", action(getosize, NULL)},
/*	{"Parameterize", action(startparam, Number(0))},	*/
/*	{"Unparameterize", action(startunparam, Number(0))},	*/
	{"Center Object", setaction(toggle, &areastruct.center)},
	{"Manhattan Draw", action(toggle, &areastruct.manhatn)},
	{"Polygon Edit", submenu(BoxEditStyles)},
};

menustruct FilterMenu[] = {
	{"Labels", setaction(selectfilter, Number(LABEL))},
	{"Objects", setaction(selectfilter, Number(OBJECT))},
	{"Polygons", setaction(selectfilter, Number(POLYGON))},
	{"Arcs", setaction(selectfilter, Number(ARC))},
	{"Splines", setaction(selectfilter, Number(SPLINE))},
	{"Paths", setaction(selectfilter, Number(PATH))},
};

menustruct RotateMenu[] = {
	{"Flip Horizontal (f)", action(startrotate, Number(64))},
	{"Flip Vertical (F)", action(startrotate, Number(65))},
	{" ", noaction},
	{"Rotate CW 90", action(startrotate, Number(18))},
	{"Rotate CW 45", action(startrotate, Number(9))},
	{"Rotate CW 30", action(startrotate, Number(6))},
	{"Rotate CW 15 (r)", action(startrotate, Number(3))},
	{"Rotate CW 5 (o)", action(startrotate, Number(1))},
	{" ", noaction},
	{"Rotate CCW 90", action(startrotate, Number(-18))},
	{"Rotate CCW 45", action(startrotate, Number(-9))},
	{"Rotate CCW 30", action(startrotate, Number(-6))}, 
	{"Rotate CCW 15 (R)", action(startrotate, Number(-3))},
	{"Rotate CCW 5 (O)", action(startrotate, Number(-1))},
};

menustruct GridMenu[] = {
	{"Grid", setaction(toggle, &areastruct.gridon)},
	{"Axes", setaction(toggle, &areastruct.axeson)},
	{"Grid spacing", action(getgridspace, NULL)},
	{"Grid type/display", submenu(GridStyles)},
};

menustruct SnapMenu[] = {
	{"Snap-to", setaction(toggle, &areastruct.snapto)},
        {"Snap spacing", action(getsnapspace, NULL)},
};

#ifdef SCHEMA
menustruct PinConvert[] = {
	{"Normal label", action(dopintype, Number(NORMAL))},
	{"Local Pin", action(dopintype, Number(LOCAL))},
	{"Global Pin", action(dopintype, Number(GLOBAL))},
	{"Info label", action(dopintype, Number(INFO))},
};

menustruct SchemaMenu[] = {
	{"Make Pin (T)", action(starttext, Number(LOCAL))},
	{"Make Info Pin (I)", action(starttext, Number(INFO))},
	{"Make Global Pin (G)", action(starttext, Number(GLOBAL))},
	{"Convert Label to...", submenu(PinConvert)},
/*	{"Make Object Non-Schematic", action(maketrivial, NULL)}, */
	{"Make Matching Symbol", action(dobeforeswap, NULL)},
	{"Associate with Symbol", action(startschemassoc, NULL)},
	{"Highlight Connectivity", action(connectivity, NULL)},
	{"Auto-number Components", action(callgennet, Number(4))},
	{" ", noaction},
	{"Write spice", action(callgennet, Number(0))},
	{"Write flattened spice", action(callgennet, Number(3))},
	{"Write sim", action(callgennet, Number(1))},
	{"Write pcb", action(callgennet, Number(2))},
};
#endif

menustruct WindowMenu[] = {
	{"Zoom In (Z)", action(zoomin, Number(0))},
	{"Zoom Out (z)", action(zoomout, NULL)},
	{"Zoom Box", action(zoombox, NULL)},
	{"Full View (v)", action(zoomview, NULL)},
	{"Center Pan (p)",action(centerpan, NULL)},
	{" ", noaction},
	{"Library Directory (L)", action(startcatalog, Number(LIBLIB))},
	{"Goto Library", submenu(Libraries)},
	{" ", noaction},
	{"Page Directory (P)", action(startcatalog, Number(PAGELIB))},
	{"Goto Page", submenu(Pages)}
};

menustruct QuitMenu[] = {
	{"No Kidding", action(quit, NULL)}
};

menustruct FileMenu[] = {
	{"Read Xcircuit File", action(getfile, Number(0))},
	{"Import Xcircuit PS", action(getfile, Number(1))},
	{"Import background PS", action(getfile, Number(2))},
	{"Execute script", action(getfile, Number(3))},
	{"Write Xcircuit PS (W)", action(dooutput, NULL)},
	{" ", noaction},
	{"Add To Library", action(getlib, NULL)},
	{"Load New Library", action(getuserlib, NULL)},
	{"Save Library", action(savelib, NULL)},
	{" ", noaction},
        {"Clear Page", action(resetbutton, NULL)},
	{" ", noaction},
	{"Quit", submenu(QuitMenu)},
};

menustruct OptionMenu[] = {
	{"Alt Colors", action(inversecolor, &areastruct.invert)},
	{"Show Bounding box", action(toggle, &areastruct.bboxon)},
#ifdef SCHEMA
	{"Show Pin Positions", action(toggle, &areastruct.pinpointon)},
	{"Enable XSchema", action(doxschema, NULL)},
#endif
#ifdef HAVE_XPM
	{"Disable Toolbar", action(dotoolbar, NULL)},
#endif
	{"Grid", submenu(GridMenu)},
	{"Snap-to", submenu(SnapMenu)},
	{"Global Linewidth", action(getwirewidth, NULL)},
	{"Elements", submenu(PolyMenu)},
	{" ", noaction},
	{"Help!", action(starthelp, NULL)},
};

menustruct EditMenu[] = {
	{"Delete (d)", action(startdelete, NULL)},
	{"Undelete (u)", action(xc_undelete, Number(DRAW))},
	{"Copy (c)", action(startcopy, NULL)},
	{"Edit (e)", action(startedit, NULL)},
	{"Rotate/Flip", submenu(RotateMenu)},
	{"Deselect (x)", action(startdesel, NULL)},
	{"Select filter", submenu(FilterMenu)},
	{"Refresh ( )", action(refresh, NULL)},
/*	{"Array", noaction}, */
	{"Push selected (>)", action(startpush, NULL)},
	{"Pop hierarchy (<)", action(popobject, Number(0))},
	{" ", noaction},
	{"Make User Object (m)", action(selectsave, NULL)},
	{"Make Arc (a)", action(startarc, NULL)},
	{"Make Box (b)", action(startbox, NULL)},
	{"Make Spline (s)", action(startspline, NULL)},
	{"Join (j)", action(join, NULL)},
};

menustruct TopButtons[] = {
	{"File", submenu(FileMenu)},
	{"Edit", submenu(EditMenu)},
	{"Text", submenu(TextMenu)},
	{"Options", submenu(OptionMenu)},
	{"Window", submenu(WindowMenu)},
#ifdef SCHEMA
	{"Netlist", submenu(SchemaMenu)},
#endif
};

short maxbuttons = sizeof(TopButtons) / sizeof(menustruct);

/* Toolbar buttons */
toolbarstruct ToolBar[] = {
	{"Box",    b_xpm,  toolaction(startbox, NULL),
		"draw box"},
	{"Arc",    a_xpm,  toolaction(startarc, NULL),
		"draw arc"},
	{"Spline", s_xpm,  toolaction(startspline, NULL),
		"draw spline"},
	{"Text",   t_xpm,  toolaction(starttext, Number(NORMAL)),
		"enter text"},
	{"Copy",   cp_xpm, toolaction(startcopy, NULL),
		"copy element"},
	{"Edit",   e_xpm,  toolaction(startedit, NULL),
		"edit element"},
	{"Delete", d2_xpm, toolaction(startdelete, NULL),
		"delete element"},
	{"RotP",   cw_xpm, toolaction(startrotate, Number(3)),
		"rotate 15 degrees clockwise"},
	{"RotN",  ccw_xpm, toolaction(startrotate, Number(-3)),
		"rotate 15 degrees counterclockwise"},
	{"HFlip",  hf_xpm, toolaction(startrotate, Number(64)),
		"flip horizontal"},
	{"VFlip",  vf_xpm, toolaction(startrotate, Number(65)),
		"flip vertical"},
	{"Push",  pu2_xpm, toolaction(startpush, NULL),
		"push (edit object)"},
	{"Pop",   po2_xpm, toolaction(popobject, Number(0)),
		"pop (return from object edit)"},
	{"Make",   mk_xpm, toolaction(selectsave, NULL),
		"make an object from selected elements"},
	{"Join",   j4_xpm, toolaction(join, NULL),
		"join elements into polygon or path"},
	{"Unjoin", uj_xpm, toolaction(unjoin, NULL),
		"separate path into elements"},
	{"Colors", co_xpm, toolaction(color_popup, NULL),
		"set color"},
	{"Border", bd_xpm, toolaction(border_popup, NULL),
		"set border and line properties"},
	{"Fills",  fi_xpm, toolaction(fill_popup, NULL),
		"set fill properties"},
	{"Library",li_xpm, toolaction(changecat, NULL),
		"go to next library"},
	{"Libdir", yp_xpm, toolaction(startcatalog, Number(LIBLIB)),
		"go to library directory"},
	{"Pagedir",pl_xpm, toolaction(startcatalog, Number(PAGELIB)),
		"go to page directory"},
	{"ZoomI",  z4_xpm, toolaction(zoomin, Number(0)),
		"zoom in"},
	{"ZoomO",  z5_xpm, toolaction(zoomout, NULL),
		"zoom out"},
	{"Help",   q_xpm,  toolaction(starthelp, NULL),
		"pop up help window"},
};

short toolbuttons = sizeof(ToolBar) / sizeof(toolbarstruct);

#undef submenu
#undef action
#undef setaction
#undef toolaction
#undef noaction

/*-------------------------------------------------------------------------*/
