/*----------------------------------------------------------------------*/
/* xcircuit.h 								*/
/* Copyright (c) 2001  Tim Edwards, Johns Hopkins University        	*/
/*----------------------------------------------------------------------*/

/*----------------------------------------------------------------------*/
/*      written by Tim Edwards, 8/20/93    				*/
/*----------------------------------------------------------------------*/

/*----------------------------------------------------------------------*/
/* Definition shortcuts 						*/
/*----------------------------------------------------------------------*/

#define XtnSetArg(a,b)  	XtSetArg(wargs[n], a, b); n++
#define abs(a)			((a) < 0 ? -(a) : (a))
#define sign(a)			((a) <= 0 ? -1 : 1)
#define max(a,b)		((a) < (b) ? (b) : (a))
#define min(a,b)		((a) < (b) ? (a) : (b))
#define Number(a)		(void *)((u_int) a)
#define ROT_UNIT (360 / RSTEPS) /* degrees per xcircuit rotational unit */

/*----------------------------------------------------------------------*/
/* Lengthier define constructs						*/
/*----------------------------------------------------------------------*/

#define objectdata      areastruct.topobject->thisobject
#define PLIST_INCR(a) \
	a->plist = (genericptr *) realloc (a->plist, \
	(a->parts + 1) * sizeof(genericptr))
#define SELECTTYPE(a)   (*(objectdata->plist + *a))->type
#define SELTOCOLOR(a)	(*(objectdata->plist + *a))->color
#define GSELTOCOLOR(b, a) (*(b->plist + *a))->color
#define ENDPART		objectdata->plist + objectdata->parts
#define EDITPART	objectdata->plist + areastruct.editpart

/* conversions from generic to specific types */
/* specifically, from type (generic *) to type (polyptr), etc. */

#define TOPOLY(a)	(*((polyptr *)a))
#define TOLABEL(a)	(*((labelptr *)a))
#define TOOBJINST(a)	(*((objinstptr *)a))
#define TOARC(a)	(*((arcptr *)a))
#define TOSPLINE(a)	(*((splineptr *)a)) 
#define TOPATH(a)	(*((pathptr *)a))

/* conversions from a selection to a specific type */

#define SELTOPOLY(a)	TOPOLY(objectdata->plist + (*a))
#define SELTOLABEL(a)	TOLABEL(objectdata->plist + (*a))
#define SELTOOBJINST(a)	TOOBJINST(objectdata->plist + (*a))
#define SELTOARC(a)	TOARC(objectdata->plist + (*a))
#define SELTOSPLINE(a)	TOSPLINE(objectdata->plist + (*a))
#define SELTOPATH(a)	TOPATH(objectdata->plist + (*a))

/* creation of new elements */

#define NEW_POLY(a,b) \
	PLIST_INCR(b); \
	a = (polyptr *)b->plist + b->parts; \
	*a = (polyptr) malloc(sizeof(polygon)); \
	(*a)->type = POLYGON
#define NEW_LABEL(a,b) \
	PLIST_INCR(b); \
	a = (labelptr *)b->plist + b->parts; \
	*a = (labelptr) malloc(sizeof(label)); \
	(*a)->type = LABEL
#define NEW_OBJINST(a,b) \
	PLIST_INCR(b); \
	a = (objinstptr *)b->plist + b->parts; \
	*a = (objinstptr) malloc(sizeof(objinst)); \
	(*a)->type = OBJECT
#define NEW_ARC(a,b) \
	PLIST_INCR(b); \
	a = (arcptr *)b->plist + b->parts; \
	*a = (arcptr) malloc(sizeof(arc)); \
	(*a)->type = ARC
#define NEW_SPLINE(a,b) \
	PLIST_INCR(b); \
	a = (splineptr *)b->plist + b->parts; \
	*a = (splineptr) malloc(sizeof(spline)); \
	(*a)->type = SPLINE
#define NEW_PATH(a,b) \
	PLIST_INCR(b); \
	a = (pathptr *)b->plist + b->parts; \
	*a = (pathptr) malloc(sizeof(path)); \
	(*a)->type = PATH

/* normal choice of calling object instance */

#define NORMINST ((pushlist == NULL) ? NULL : pushlist->thisinst)
		   
/* selection from top-level object */

#define objectselect(a)		selectobject(a, objectdata, NORMINST)
#define easydraw(a, b)		geneasydraw(a, b, objectdata, NORMINST)
#define drawselected(a)		gendrawselected(a, objectdata, NORMINST)

/*----------------------------------------------------------------------*/

#if !defined(_SYS_TYPES_H) || !defined(__USE_BSD)
typedef unsigned char	u_char;
typedef unsigned short	u_short;
typedef unsigned int	u_int;
typedef unsigned long	u_long;
#endif

typedef struct {
   float x, y;
} XfPoint;

typedef struct {
   long x, y;
} XlPoint;

typedef struct {
   short width, ascent, descent, base;
} TextExtents;

/*----------------------------------------------------------------------*/
/* Implementation-specific definitions 					*/
/*----------------------------------------------------------------------*/

#define LIBS	    5 /* initial number of library pages 		*/
#define PAGES      10 /* default number of top-level pages 		*/
#define SCALEFAC  1.5 /* zoom in/out scaling multiplier 		*/
#define SUBSCALE 0.67 /* ratio of subscript size to normal script size 	*/
#define SBARSIZE   13 /* Pixel size of the scrollbar 			*/
#define RSTEPS     72 /* Number of allowed rotation positions 		*/
#define SPLINESEGS 20 /* Number of points per spline approximation 	*/
#define DELBUFSIZE 10 /* Number of delete events to save for undeleting */
#define MINAUTOSCALE 0.75 /* Won't automatically scale closer than this */

#ifdef SCHEMA
#define PADSPACE   20 /* Spacing of pinlabels from their origins	*/
#endif

#ifdef HAVE_XPM
#define TBBORDER   1  /* border around toolbar buttons */
#endif

#define TOPLEVEL	0
#define SINGLE		1

#define INTSEGS		(SPLINESEGS - 2)
#define LASTSEG		(SPLINESEGS - 3)

#define FONTHEIGHT(y)	 (y->ascent + y->descent + 6) 
#define ROWHEIGHT	 FONTHEIGHT(appdata.xcfont)
#define FILECHARASCENT   (appdata.filefont->ascent)
#define FILECHARHEIGHT   (FILECHARASCENT + appdata.filefont->descent)
#define LISTHEIGHT	 200
#define TEXTHEIGHT	 28 /* Height of xcircuit vectored font at nominal size */
#define BASELINE	 40 /* Height of baseline */
#define DEFAULTGRIDSPACE 32
#define DEFAULTSNAPSPACE 16

/*----------------------------------------------------------------------*/

#define INVRFAC 57.295779       /* 180 / pi */

/*----------------------------------------------------------------------*/

#define INCHSCALE 0.375     /* Scale of .25 inches to PostScript units */
#define CMSCALE 0.35433071  /* Scale of .5 cm to PostScript units */
#define IN_CM_CONVERT 28.3464567	/* 72 (in) / 2.54 (cm/in) */

/*----------------------------------------------------------------------*/
/* Event mode definitions (state of drawing area)			*/
/*----------------------------------------------------------------------*/

enum editmode {NORMAL_MODE = 0, 
PRESS_MODE, DELETE_MODE, COPY_MODE, COPY2_MODE, ROTATE_MODE,
PUSH_MODE, EDIT_MODE, SELAREA_MODE, SELAREA2_MODE, DESEL_MODE, PAN_MODE,
CATPAN_MODE, CATALOG_MODE, CATTEXT_MODE, FONTCAT_MODE, FONTCAT2_MODE,
TEXT1_MODE, TEXT2_MODE, TEXT3_MODE, WIRE_MODE, BOX0_MODE, BOX_MODE,
EBOX_MODE, ARC0_MODE, ARC_MODE, EARC_MODE, SPLINE0_MODE, SPLINE_MODE,
ESPLINE_MODE, EPATH_MODE, LPARAM_MODE, IPARAM_MODE, ULPARAM_MODE,
UIPARAM_MODE

#ifdef SCHEMA
, CONNECT_MODE, ASSOC_MODE
#endif

};

/*----------------------------------------------------------------------*/
/* Text justification styles						*/
/*----------------------------------------------------------------------*/

#define NOTLEFT		1
#define RIGHT		2
#define NOTBOTTOM	4
#define TOP		8
#define FLIPINV		16

/*----------------------------------------------------------------------*/
/* Text string part: types						*/
/*----------------------------------------------------------------------*/

#define TEXT_STRING	 0  /* data is a text string 			*/
#define SUBSCRIPT	 1  /* start subscript; no data			*/
#define SUPERSCRIPT	 2  /* start superscript; no data		*/
#define NORMALSCRIPT	 3  /* stop super-/subscript; no data		*/
#define UNDERLINE	 4  /* start underline; no data			*/
#define OVERLINE	 5  /* start overline; no data			*/
#define NOLINE		 6  /* stop over-/underline; no data		*/
#define TABSTOP	 	 7  /* insert tab stop position			*/
#define TABFORWARD 	 8  /* insert tab stop position			*/
#define TABBACKWARD 	 9  /* insert tab stop position			*/
#define HALFSPACE	10  /* insert half-space; no data		*/
#define QTRSPACE	11  /* insert quarter space; no data		*/
#define RETURN		12  /* carriage-return character; no data	*/
#define FONT_NAME       13  /* inline font designator; data = font name */
#define FONT_SCALE	14  /* font scale change; data = scale		*/
#define FONT_COLOR	15  /* font color change; data = color		*/
#define KERN		16  /* set new kern values; data = kern x, y	*/
#define PARAM_START	17  /* bounds a parameter; data = param #	*/
#define PARAM_END	18  /* bounds a parameter; data = param #	*/

#define SPECIAL		63  /* used only when called from menu		*/
#define NULL_TYPE	255 /* used as a placeholder			*/

/*----------------------------------------------------------------------*/
/* Reset modes								*/
/*----------------------------------------------------------------------*/

#define SAVE		1
#define DESTROY		2

/*----------------------------------------------------------------------*/
/* Coordinate display types						*/
/*----------------------------------------------------------------------*/

#define DEC_INCH	0
#define FRAC_INCH	1
#define CM		2

/*----------------------------------------------------------------------*/
/* Library types							*/
/*----------------------------------------------------------------------*/

#define FONTLIB		0
#define PAGELIB		1
#define LIBLIB		2
#define LIBRARY		3
#define USERLIB		(xobjs.numlibs + LIBRARY - 1)

/*----------------------------------------------------------------------*/
/* Box styles								*/
/*----------------------------------------------------------------------*/

#define NORMAL 0
#define UNCLOSED 1
#define DASHED 2
#define DOTTED 4
#define NOBORDER 8
#define FILLED 16
#define STIP0 32
#define STIP1 64
#define STIP2 128
#define FILLSOLID 224  /* = 32 + 64 + 128 */
#define OPAQUE 256
#define BBOX 512

/*----------------------------------------------------------------------*/
/* Box edit styles							*/
/*----------------------------------------------------------------------*/

#define MANHATTAN 1
#define RHOMBOIDX 2
#define RHOMBOIDY 4
#define RHOMBOIDA 8

#define NONE  0
#define LASTX 1
#define NEXTX 2
#define LASTY 4
#define NEXTY 8

/*----------------------------------------------------------------------*/
/* Arc creation and edit styles						*/
/*----------------------------------------------------------------------*/

#define CENTER 1
#define RADIAL 2

/*----------------------------------------------------------------------*/
/* Delete/undelete draw-mode styles					*/
/*----------------------------------------------------------------------*/

#define ERASE 1
#define DRAW  1

/*----------------------------------------------------------------------*/
/* Schematic object types and pin label types	   			*/
/*----------------------------------------------------------------------*/

#ifdef SCHEMA

#define SCHEMATIC 0		/* Schematic on page */
#define TRIVIAL 1		/* Symbol as non-schematic element */
#define SYMBOL 2		/* Symbol associated with a schematic */
#define FUNDAMENTAL 3		/* Standalone symbol */

#define LOCAL 1
#define GLOBAL 2
#define INFO 3

#endif

/*----------------------------------------------------------------------*/
/* Save types								*/
/*----------------------------------------------------------------------*/

#define CURRENT_PAGE	0
#define ALL_PAGES	1

/*----------------------------------------------------------------------*/
/* Color scheme styles (other than NORMAL)				*/
/*----------------------------------------------------------------------*/

#define INVERSE		1

/*----------------------------------------------------------------------*/
/* Cursor definitions 							*/
/*----------------------------------------------------------------------*/

#define NUM_CURSORS	10

#define ARROW 		appcursors[0]
#define CROSS 		appcursors[1]
#define SCISSORS 	appcursors[2]
#define COPYCURSOR	appcursors[3]
#define ROTATECURSOR    appcursors[4]
#define EDCURSOR	appcursors[5]
#define TEXTPTR 	appcursors[6]
#define CIRCLE		appcursors[7]
#define QUESTION	appcursors[8]
#define WAITFOR		appcursors[9]

/*----------------------------------------------------------------------*/
/* selection-mechanism structures					*/
/*----------------------------------------------------------------------*/

typedef XPoint* pointlist;
typedef XfPoint* fpointlist;

/*----------------------------------------------------------------------*/
/* select types 							*/
/*----------------------------------------------------------------------*/

#define	OBJECT	1
#define LABEL	2
#define POLYGON	4
#define ARC	8
#define SPLINE  16
#define PATH	32
#define SEL_ANY	63  /* for selection mechanism only */

/*----------------------------------------------------------------------*/
/* Labels are constructed of strings and executables 			*/
/*----------------------------------------------------------------------*/

typedef struct _stringpart *stringptr;

typedef struct _stringpart {
   stringptr	nextpart;
   u_char	type;
   union {
     u_char	*string;
     int	color;
     int	font;
     int	paramno;
     float	scale;
     short	kern[2];
   }		data;
} stringpart;

/*----------------------------------------------------------------------*/
/* structures of all main elements which can be displayed & manipulated	*/
/*----------------------------------------------------------------------*/

/*----------------------------------------------------------------------*/
/* Generic element type	is a superset of all elements.			*/	
/*----------------------------------------------------------------------*/

typedef struct {
   u_char	type;		/* type is LABEL, POLYGON, etc., from below */
   int		color;
} generic, *genericptr;		/* (convenience function for retypecasting) */

/*----------------------------------------------------------------------*/
/* Object & object instance parameter structure				*/
/* (Add types as necessary)						*/
/*----------------------------------------------------------------------*/

enum paramtypes {XC_SHORT = 0, XC_STRING};

typedef struct {
   u_char	type;		/* type is from paramtypes list above */
   union {
      stringpart *string;
      short	 svalue;
   } parameter;			/* default or substitution value */
} oparam, *oparamptr;

/*----------------------------------------------------------------------*/
/* Object instance type							*/
/*----------------------------------------------------------------------*/

typedef struct _xcobject *objectptr;

typedef struct {
   u_char	type;
   int		color;
   XPoint	position;
   short	rotation;
   float	scale;
   oparamptr    *params;	/* parameter substitutions for this instance */
   objectptr	thisobject;
} objinst, *objinstptr;

typedef struct _objectpair *objectpairptr;

typedef struct _objectpair {
   objectptr    thisobject;
   objinstptr	thisinst;
   objectpairptr nextpair;
} objectpair;

/*----------------------------------------------------------------------*/
/* Label								*/
/*----------------------------------------------------------------------*/

typedef struct {
   u_char	type;
   int		color;
   XPoint	position;
   short	rotation;
   float	scale;
   short	justify;
#ifdef SCHEMA
   u_char	pin;
#endif
   stringpart	*string;
} label, *labelptr;

/*----------------------------------------------------------------------*/
/* Polygon								*/
/*----------------------------------------------------------------------*/

typedef struct {
   u_char	type;
   int		color;
   short	style;
   float	width;
   short	number;
   pointlist	points;
} polygon, *polyptr;

/*----------------------------------------------------------------------*/
/* Bezier Curve								*/
/*----------------------------------------------------------------------*/

typedef struct {
   u_char	type;
   int		color;
   short	style;
   float	width;
   XPoint	ctrl[4];
   /* the following are for rendering only */
   XfPoint	points[INTSEGS];
} spline, *splineptr;

/*----------------------------------------------------------------------*/
/* Arc									*/
/*----------------------------------------------------------------------*/

typedef struct {
   u_char	type;
   int		color;
   short	style;
   float	width;
   short	radius; 	/* x-axis radius */
   short	yaxis;		/* y-axis radius */
   float	angle1;
   float	angle2;
   XPoint	position;
   /* the following are for rendering only */
   short	number;
   XfPoint	points[RSTEPS + 1];
} arc, *arcptr;

/*----------------------------------------------------------------------*/
/* Path									*/
/*----------------------------------------------------------------------*/

typedef struct {
   u_char	type;
   int		color;
   short	style;
   float	width;
   short	parts;
   genericptr	*plist;		/* to be retypecast to polygon, arc, or spline */
} path, *pathptr;

/*----------------------------------------------------------------------*/
/* Netlist structures for schematic capture				*/
/*----------------------------------------------------------------------*/

#ifdef SCHEMA

/* Linked polygon list */

typedef struct _Polylist *PolylistPtr;
typedef struct _Polylist
{
   polyptr poly;
   PolylistPtr next;
} Polylist;

/* Linked label list */

typedef struct _Labellist *LabellistPtr;
typedef struct _Labellist
{
   labelptr label;
   LabellistPtr next;
} Labellist;

/* List of object's networks */

typedef struct _Netlist *NetlistPtr;
typedef struct _Netlist
{
   int netid;
   PolylistPtr polygons;
   LabellistPtr labels;
   stringpart *localpin;
   NetlistPtr next;
} Netlist;

/* List of object's I/O ports */

typedef struct _Portlist *PortlistPtr;
typedef struct _Portlist
{
   int portid;
   int netid;
   PortlistPtr next;
} Portlist;

/* List of calls to instances of objects */
/* or subcircuit objects.		 */

typedef struct _Calllist *CalllistPtr;
typedef struct _Calllist
{
   objectptr callobj;
   objinstptr callinst;
   PortlistPtr ports;
   CalllistPtr next;
} Calllist;

/* PCB netlist structures */

struct Pnet {
   int numnets;
   int *netidx;
   struct Pnet *next;
};

struct Pstr {
   stringpart *string;
   struct Pstr *next;
};

struct Ptab {
   struct Pnet *nets;
   struct Pstr *pins;
   struct Ptab *next;
};

#endif

/*----------------------------------------------------------------------*/
/* Main object structure						*/
/*----------------------------------------------------------------------*/

typedef struct _xcobject {
   char		name[80];
   Boolean	hidden;
   float	viewscale;
   XPoint	pcorner;	/* position relative to window */
   XPoint	lowerleft;	/* bounding box */
   Dimension	width, height;  /* information  */
   short	parts;
   genericptr	*plist;	 	/* to be retypecast to label, polygon, etc. */
   u_char	num_params;	/* number of calling parameters */
   oparamptr	*params;	/* list of parameter defaults */
   
#ifdef SCHEMA
   XPoint	lleft2;		 /* bounding box info excluding pins */
   Dimension	width2, height2;

   u_char	schemtype;
   objectptr	symschem;	 /* schematic page support */

   NetlistPtr   netlist;
   PortlistPtr  portlist;
   CalllistPtr  calllist;
   short traversed;
#endif
} object;

/*----------------------------------------------------------------------*/
/* Transformation matrices						*/
/*----------------------------------------------------------------------*/

typedef struct _matrix *Matrixptr;

typedef struct _matrix {
   float a, b, c, d, e, f;
   Matrixptr nextmatrix;
} Matrix;

/*----------------------------------------------------------------------*/
/* Some convenience functions for matrix manipulation			*/
/*----------------------------------------------------------------------*/

#define DCTM  areastruct.MatStack

/*----------------------------------------------------------------------*/
/* button tap/press definitions 					*/
/*----------------------------------------------------------------------*/

#define PRESSTIME	150	/* milliseconds of push to be a "press" */

/*----------------------------------------------------------------------*/
/* structures for managing the popup prompt widgets 			*/
/*----------------------------------------------------------------------*/

typedef struct {
   Widget	button;
   int		foreground;
   void		(*buttoncall)();
   void		*dataptr;
} buttonsave;

typedef struct {
   Widget	popup;
   Widget	textw;
   void		(*setvalue)();
   buttonsave	*buttonptr;
   Boolean	fileprompt;
} popupstruct;

typedef struct {
   Widget	textw;
   Widget	buttonw;
   void		(*setvalue)();
   void		*dataptr;
} propstruct;

/*----------------------------------------------------------------------*/
/* Initial Resource Management						*/
/*----------------------------------------------------------------------*/

typedef struct {
   /* color scheme 1 */
   Pixel	fg, bg;
   Pixel	gridpix, snappix, selectpix, axespix;
   Pixel	buttonpix, querypix;
   Pixel	auxpix, barpix, bboxpix;

   /* color scheme 2 */

   Pixel	fg2, bg2;
   Pixel	gridpix2, snappix2, selectpix2, axespix2;
   Pixel	buttonpix2, querypix2;
   Pixel	auxpix2, barpix2, bboxpix2;

   int		width, height, timeout;
   XFontStruct	*xcfont, *helpfont, *filefont, *textfont, *titlefont;
} ApplicationData, *ApplicationDataPtr;

/*----------------------------------------------------------------------*/
/* Macros for GC color and function handling				*/
/*----------------------------------------------------------------------*/

#define XTopSetForeground(a) if (a == DEFAULTCOLOR) XSetForeground(dpy, \
	areastruct.gc, FOREGROUND); else XSetForeground(dpy, areastruct.gc, a)

#define XSetXORFg(a,b) if (a == DEFAULTCOLOR) XSetForeground(dpy, \
	areastruct.gc, FOREGROUND ^ b); else XSetForeground(dpy, areastruct.gc,\
	a ^ b)

#define XcSetFunction(z) XSetFunction(dpy, areastruct.gc, z); \
	areastruct.gctype = z

#define XcSetForeground(z) XTopSetForeground(z); areastruct.gccolor = \
	((z) == DEFAULTCOLOR) ? FOREGROUND : (z)

#define XcSetXORFg(y,z) XSetXORFg(y,z); areastruct.gccolor = \
	((y) == DEFAULTCOLOR) ? (FOREGROUND ^ z) : (y ^ z)

/*----------------------------------------------------------------------*/
/* Structure for maintaining list of colors				*/
/*----------------------------------------------------------------------*/

typedef struct {
   Widget	cbutton;
   XColor	color;
} colorindex;

/*----------------------------------------------------------------------*/
/* Font information structure						*/
/*----------------------------------------------------------------------*/
/* Flags:   bit  description						*/
/* 	    0    bold = 1,  normal = 0					*/
/*	    1    italic = 1, normal = 0					*/
/*	    2    <reserved, possibly for narrow font type>		*/
/*	    3    drawn = 1,  PostScript = 0				*/
/* 	    4	 <reserved, possibly for LaTeX font type>		*/
/*	    5    special encoding = 1, Standard Encoding = 0		*/
/*	    6	 ISOLatin1 = 2, ISOLatin2 = 3				*/
/*	    7    <reserved for other encoding schemes>			*/
/*----------------------------------------------------------------------*/

typedef struct {
   char *psname;
   char *family;
   float scale;
   u_short flags;
   objectptr *encoding;
} fontinfo;

/*----------------------------------------------------------------------*/

typedef struct {
   char *name;
   XPoint lowerleft;
   XPoint upperright;
} psbkground;

/*----------------------------------------------------------------------*/
/* Key macro information						*/
/*----------------------------------------------------------------------*/

typedef struct _keybinding *keybindingptr;

typedef struct _keybinding {
   int keywstate;
   int function;
   short value;
   keybindingptr nextbinding;
} keybinding;

/*----------------------------------------------------------------------*/
/* Enumeration of functions available for binding to keys/buttons	*/
/*----------------------------------------------------------------------*/

enum {
   XCF_ENDDATA = -2, XCF_SPACER,
   XCF_Page, XCF_Justify, XCF_Superscript, XCF_Subscript, XCF_Normalscript,
   XCF_Nextfont, XCF_Boldfont, XCF_Italicfont, XCF_Normalfont, XCF_Underline,
   XCF_Overline, XCF_ISO_Encoding, XCF_Return, XCF_Halfspace, XCF_Quarterspace,
   XCF_Special, XCF_TabStop, XCF_TabForward, XCF_TabBackward,
   XCF_Text_Return, XCF_Text_Delete, XCF_Text_Right, XCF_Text_Left,
   XCF_Text_Home, XCF_Text_End, XCF_Return_Char,
   XCF_Parameter, XCF_Edit_Break, XCF_Edit_Delete, XCF_Edit_Insert,
   XCF_Edit_Next, XCF_Attach, XCF_Next_Library, XCF_Library_Directory,
   XCF_Library_Move, XCF_Library_Copy, XCF_Library_Edit, XCF_Library_Delete,
   XCF_Library_Duplicate, XCF_Library_Hide, XCF_Page_Directory, XCF_Library_Pop,
   XCF_Help, XCF_Redraw, XCF_View, XCF_Zoom_In, XCF_Zoom_Out, XCF_Pan,
   XCF_Double_Snap, XCF_Halve_Snap, XCF_Pan_Left, XCF_Pan_Right, XCF_Pan_Up,
   XCF_Pan_Down, XCF_Write, XCF_Rotate, XCF_Flip_X, XCF_Flip_Y, XCF_Snap,
   XCF_Pop, XCF_Push, XCF_Delete, XCF_Select, XCF_Box, XCF_Arc, XCF_Text,
   XCF_Exchange, XCF_Copy, XCF_Join, XCF_Unjoin, XCF_Spline, XCF_Edit,
   XCF_Undelete, XCF_Select_Save, XCF_Unselect, XCF_Dashed, XCF_Dotted,
   XCF_Solid, XCF_Prompt, XCF_Dot, XCF_Wire, XCF_Nothing, XCF_Exit,

#ifdef SCHEMA
   XCF_Netlist, XCF_Swap, XCF_Pin_Label, XCF_Info_Label, XCF_Connectivity,
   XCF_Sim, XCF_SPICE, XCF_PCB,
#endif
   NUM_FUNCTIONS
};

/*----------------------------------------------------------------------*/
/* Per-drawing-page parameters						*/
/*----------------------------------------------------------------------*/

typedef struct {
   /* per-drawing-page parameters */
   objectptr	pageobj;
   char		*filename;	/* file to save as */
   psbkground	background;	/* background rendered file info */
   float	wirewidth;
   float	outscale;
   float	gridspace;
   float	snapspace;
   short	orient;
   short	pmode;
   short	coordstyle;
   XPoint	drawingscale;
   XPoint	pagesize;	/* size of page to print on */
} Pagedata;

/*----------------------------------------------------------------------*/
/* The main globally-accessible data structure.  This structure holds	*/
/* all the critical data needed by the drawing window 			*/
/*----------------------------------------------------------------------*/

typedef struct {

   /* widgets and X11 parameters */
   Widget	area;
   Widget	scrollbarh, scrollbarv;
   GC 		gc;
   int		gccolor, gctype;
   XtIntervalId time_id;

   /* global page parameters */
   short	width, height;
   short	page;
   float	*vscale;	/* pointer to proper scale */
   XPoint	*pcorner;	/* pointer to page position */

   /* global option defaults */
   float	textscale;
   float	linewidth;
   short	psfont;
   short	justify;
   short	style;
   short	filter;		/* selection filter */
   int		color;
   Boolean	manhatn;
   Boolean	boxedit;
   Boolean	snapto;
   Boolean	bboxon;
   Boolean	center;
   Boolean	gridon;
   Boolean	axeson;
   Boolean	invert;
   Boolean	mapped;		/* indicates if window is drawable */
#ifdef SCHEMA
   Boolean	schemon;
#endif
#ifdef HAVE_XPM
   Boolean	toolbar_on;
#endif

   /* buffers, pages, and associated variables */
   XPoint	save, origin;
   short	selects;
   short	*selectlist;
   objinstptr	topobject;
   objectpair	*hierarchy;
   objectptr	editstack;
   Matrixptr	MatStack;
   short	editcycle;
   short	editpart, editsubpart;
   char		*lastbackground;
} Clientdata;

typedef struct {
   short	number;
   objectptr	*library;
} Library;

/*----------------------------------------------------------------------*/
/* A convenient structure for holding all the object lists		*/
/*----------------------------------------------------------------------*/

typedef struct {
   char		*tempfile;
   int		timeout_id;
   int		save_interval;
   short	pages;
   short	numlibs;
   Pagedata	**pagelist;
   Library	delbuffer;
   Library	fontlib;
   Library	*userlibs;
   objectptr	*libtop;
} Globaldata;

/*----------------------------------------------------------------------*/
/* structures previously defined in menudefs.h				*/
/*----------------------------------------------------------------------*/
/*----------------------------------------------------------------------*/
/* Menu Definitions for hierarchical pulldown menus                     */
/*----------------------------------------------------------------------*/

typedef struct _menustruct *menuptr;

typedef struct _menustruct {
        char *name;
        menuptr submenu;
        short size;
        XtCallbackProc func;
        void *passeddata;
} menustruct;

/*----------------------------------------------------------------------*/
/* Structure for calling routines from the Toolbar icons		*/
/*----------------------------------------------------------------------*/

typedef struct _toolbarstruct {
	char *name;
	char **icon_data;
        XtCallbackProc func;
        void *passeddata;
	char *hint;
} toolbarstruct;

/*----------------------------------------------------------------------*/
