/*----------------------------------------------------------------------*/
/* prototypes.h:							*/
/*     Master list of function prototypes				*/
/*----------------------------------------------------------------------*/

/* from elements.c: */

extern void copyparams(objinstptr, objinstptr);
extern void objectdefaults(objinstptr, objectptr, int, int);
extern void labeldefaults(labelptr, u_char, int, int);
extern void polydefaults(polyptr, int, int, int);
extern void splinedefaults(splineptr, int, int);
extern void arcdefaults(arcptr, int, int);
extern void pathdefaults(pathptr, int, int);
extern void drawdot(int, int);
extern void startspline(Widget, caddr_t, caddr_t);
extern void starttext(Widget, u_int, caddr_t);
extern void textbutton(u_char, XButtonEvent *);
extern void charreport(labelptr);
extern void labeltext(int, char *);
extern void textreturn();
extern void rejustify(short);
extern void splinebutton(XButtonEvent *);
extern void trackspline(Widget, caddr_t, caddr_t);
extern void startarc(Widget, caddr_t, caddr_t);
extern void arcbutton(XButtonEvent *);
extern void trackarc(Widget, caddr_t, caddr_t);
extern void startbox(Widget, caddr_t, caddr_t);
extern void boxbutton(XButtonEvent *);
extern void trackbox(Widget, caddr_t, caddr_t);
extern void trackwire(Widget, caddr_t, caddr_t);
extern void startwire(XPoint);
extern void finddir(polyptr);
extern void trackpoly(Widget, caddr_t, caddr_t);
extern void setendpoint(short *, short, XPoint **, XPoint *);
extern void reversepoints(XPoint *, short);
extern void reversefpoints(XfPoint *, short);
extern void freeparts(short *, short);
extern void removep(short *, short);
extern void unjoin();
extern labelptr findlabelcopy(labelptr, stringpart *);
extern Boolean neartest(XPoint *, XPoint *);
extern void join();
extern void wirebutton(XButtonEvent *);

/* from events.c: */

extern Boolean recursefind(objectptr, objectptr);
extern void transferselects();
extern void newmatrix();
extern void setpage();
extern int changepage(short);
extern void newpage(short);
extern void startpush(Widget, caddr_t, caddr_t);
extern void pushobject(XButtonEvent *);
extern void popobject(Widget, caddr_t, caddr_t);
extern void resetbutton(Widget, caddr_t, caddr_t);
extern void drawhbar(Widget, caddr_t, caddr_t);
extern void drawvbar(Widget, caddr_t, caddr_t);
extern void panhbar(Widget, caddr_t, XButtonEvent *);
extern void endhbar(Widget, caddr_t, XButtonEvent *);
extern void panvbar(Widget, caddr_t, XButtonEvent *);
extern void endvbar(Widget, caddr_t, XButtonEvent *);
extern void zoombox(Widget, caddr_t, caddr_t);
extern void zoomin(Widget, caddr_t, XButtonEvent *);
extern void zoomout(Widget, caddr_t, XButtonEvent *);
extern void panbutton(u_int, XButtonEvent *);
extern void zoominrefresh(Widget, caddr_t, XButtonEvent *);
extern void zoomoutrefresh(Widget, caddr_t, XButtonEvent *);
extern void panrefresh(u_int, XButtonEvent *);
extern void centerpan(Widget, caddr_t, caddr_t);
extern void checkwarp(XPoint *);
extern int checkcycle(short, short);
extern void nextpolycycle(polyptr, short);
extern void nextsplinecycle(splineptr, short);
extern void nextarccycle(arcptr, short);
extern short getkeynum();
extern void buttonhandler(Widget, caddr_t, XButtonEvent *);
extern void keyhandler(Widget, caddr_t, XKeyEvent *);
extern void setsnap(short);
extern void snapobject();
extern int ipow10(int);
extern int calcgcf(int, int);
extern void fraccalc(float, char *);
extern void printpos(short, short);
extern void findwirex(XPoint *, XPoint *, XPoint *, XPoint *, int *);
extern void findattach(XPoint *, int *, XPoint *);
extern XPoint *pathclosepoint(pathptr, XPoint *);
extern void drag(Widget, caddr_t, XButtonEvent *);
extern void rotatebutton(XButtonEvent *);
extern void elemrotate(genericptr *, short);
extern void objectrotate(short);
extern void edit(XButtonEvent *);
extern void pathedit(genericptr *, short);
extern void exchange();
extern void elhflip(genericptr *);
extern void elvflip(genericptr *);
extern void objectflip();
extern void objectvflip();
extern void makepress(XtIntervalId, caddr_t);
extern void startrotate(Widget, caddr_t, caddr_t);
extern void startcopy(Widget, caddr_t, caddr_t);
extern void startedit(Widget, caddr_t, caddr_t);
extern void startdelete(Widget, caddr_t, caddr_t);
extern void reviseselect(short *);
extern void objectdelete(short);
extern void deletebutton(XButtonEvent *);
extern short xc_undelete(Widget, u_int, XButtonEvent *);
extern void printname(objectptr);
extern void checkname(objectptr);
extern objectptr finddot();
extern void movepoints(genericptr *, short, short);
extern void domakeobject(Widget, caddr_t);
extern void selectsave(Widget, caddr_t, caddr_t);
extern void arceditpush(arcptr);
extern void splineeditpush(splineptr);
extern void polyeditpush(polyptr);
extern void arccopy(arcptr, arcptr);
extern void polycopy(polyptr, polyptr);
extern void splinecopy(splineptr, splineptr);
extern void copybutton(XButtonEvent *);
extern void selectbutton(XButtonEvent *);
extern void releasebutton(XButtonEvent *);
extern void pathbutton(genericptr *, XButtonEvent *);
extern void resizearea(Widget, caddr_t, caddr_t);
extern void drawarea(Widget, caddr_t, caddr_t);

/* from filelist.c: */

extern int fcompare(const void *, const void *);
extern void dragfilebox(Widget, caddr_t, XMotionEvent *);
extern void startfiletrack(Widget, caddr_t, XCrossingEvent *);
extern void endfiletrack(Widget, caddr_t, XCrossingEvent *);
extern char *getcrashfilename();
extern void crashrecover();
extern void findcrashfiles();
extern void listfiles(Widget, popupstruct *, caddr_t);
extern void newfilelist(Widget, popupstruct *);
extern void fileselect(Widget, popupstruct *, XButtonEvent *);
extern void showlscroll(Widget, caddr_t, caddr_t);
extern void draglscroll(Widget, popupstruct *, XButtonEvent *);
extern void genfilelist(Widget, popupstruct *, Dimension);
extern int lookdirectory(char *);

/* from files.c: */

extern void ridnewline(char *);
extern void free_single(genericptr *);
extern void reset(objectptr, short);
extern void topreset();
extern void initmem(objectptr);
extern void freelabel(stringpart *);
extern Boolean compare_single(genericptr *, genericptr *);
extern Boolean elemcompare(genericptr *, genericptr *);
extern short objcompare(objectptr, objectptr);
extern float getpsscale(float, short);
extern void dostcount(FILE *, short *, short);
extern void varcheck(FILE *, short *, objectptr, int, short *);
extern void getfile(Widget, void *, caddr_t);
extern Boolean nextfilename();
extern void loadfontlib();
extern void loadglib(Boolean, short, short);
extern void loadulib();
extern void loadblib();
extern void getlib(Widget, caddr_t, caddr_t);
extern void getuserlib(Widget, caddr_t, caddr_t);
extern void loadlibrary(short);
extern void startloadfile();
extern void importfile();
extern void loadfile(short);
extern void readlabel(objectptr, char *, stringpart **);
extern u_char *find_match(u_char *);
extern void varscan(objectptr, char *, short *);
extern Boolean objectread(FILE *, objectptr, short, short, short, char *, int);
extern void setfile(Widget, Widget, caddr_t);
extern XtTimerCallbackProc savetemp(Widget, XtIntervalId *);
extern void savelib(Widget, caddr_t, caddr_t);
extern void savelibrary(Widget, int);
extern void findfonts(objectptr, short *);
extern void savefile(objectptr, short);
extern int printRGBvalues(char *, int, const char *);
extern int nosprint(char *);
extern Boolean tilde_expand(char *);
extern short writelabel(FILE *, stringpart *, short *);
extern void writesegment(stringpart *, float *, int *);
extern void writelabelsegs(FILE *, short *, stringpart *);
extern void printobjects(FILE *, objectptr, float, float, float, short, short,
                         objectptr **, short *, int);

/* from fontfile.c: */

extern FILE *findfontfile(char *);
extern void loadfontfile(char *);

/* from formats.c: */

extern void loadlgf(int);
extern void loadmat4(caddr_t);

/* from functions.c: */

extern long sqwirelen(XPoint *, XPoint *);
extern float fsqwirelen(XfPoint *, XfPoint *);
extern int wirelength(XPoint *, XPoint *);
extern long finddist(XPoint *,XPoint *, XPoint *);
extern void calcarc(arcptr);
extern void initsplines();
extern void computecoeffs(splineptr, float *, float *, float *, float *,
                          float *, float *);
extern void calcspline(splineptr);
extern void findsplinepos(splineptr, float, XPoint *, int *);
extern void ffindsplinepos(splineptr, float, XfPoint *);
extern float findsplinemin(splineptr, XPoint *);
extern short closepoint(polyptr, XPoint *);
extern short checkbounds();
extern void window_to_user(short, short, XPoint *);
extern void user_to_window(XPoint, XPoint *);
extern float UTopScale();
extern short UTopTransScale(float);
extern XPoint UGetCursor();
extern XPoint UGetCursorPos();
extern void u2u_snap(XPoint *);
extern void snap(short, short, XPoint *);
extern void UResetCTM(Matrix *);
extern void InvertCTM(Matrix *);
extern void UCopyCTM(Matrix *, Matrix *);
extern void UMakeWCTM(Matrix *);
extern void UMultCTM(Matrix *, XPoint, float, short);
extern void USlantCTM(Matrix *, float);
extern void UPreScaleCTM(Matrix *);
extern short flipadjust(short);
extern void UPreMultCTM(Matrix *, XPoint, float, short);
extern void UTransformbyCTM(Matrix *, XPoint *, XPoint *, short);
extern void UfTransformbyCTM(Matrix *, XfPoint *, XPoint *, short);
extern void UPopCTM(void);
extern void UPushCTM(void);
extern void UTransformPoints(XPoint *, XPoint *, short, XPoint, float,
                             short);
extern void InvTransformPoints(XPoint *, XPoint *, short, XPoint, float,
                             short);
extern void manhattanize(XPoint *, polyptr);
extern void bboxcalc(short, short *, short *);
extern void calcextents(genericptr *, short *, short *, short *, short *);
extern void objinstbbox(objinstptr, XPoint *);
extern void labelbbox(labelptr, XPoint *, objinstptr);
extern void calcinstbbox(genericptr *, short *, short *, short *, short *);
extern void calcbboxsingle(genericptr *, short *, short *, short *, short *
#ifdef SCHEMA
                           ,short *, short *, short *, short *
#endif
);
extern Boolean object_in_library(short, objectptr);
extern short find_object(objectptr, objectptr);
extern void updatepagebounds(objectptr);
extern void calcbbox(objectptr);
extern void calcbboxparam(objectptr, int);
extern void singlebbox(objectptr, genericptr *);
extern void calcbboxselect();
extern void calcbboxvalues(objectptr, u_char, genericptr *);
extern void centerview(objectptr);
extern void refresh(Widget, caddr_t, caddr_t);
extern void zoomview(Widget, caddr_t, caddr_t);
extern void UDrawSimpleLine(objinstptr, XPoint *, XPoint *);
extern void UDrawLine(objinstptr, XPoint *, XPoint *);
extern void UDrawX(labelptr);
#ifdef SCHEMA
extern void UDrawXDown(labelptr);
#endif
extern void pinadjust(short, short *, short *, short);
extern void UDrawTextLine(labelptr, short);
extern void UDrawTLine(labelptr);
extern void UDrawXLine(XPoint, XPoint);
extern void UDrawBox(XPoint, XPoint);
extern void UDrawBBox(objectptr);
extern void strokepath(XPoint *, short, short, float);
extern void makesplinepath(splineptr, XPoint *);
extern void UDrawSpline(objinstptr, splineptr);
extern void UDrawEditSpline(objinstptr, splineptr);
extern void UDrawPolygon(objinstptr, polyptr);
extern void UDrawArc(objinstptr, arcptr);
extern void UDrawPath(objinstptr, pathptr);
extern void UDrawObject(objinstptr, objectptr, short, int);

/* from help.c: */

extern void printhelppix(Widget);
extern void starthelp(Widget, caddr_t, caddr_t);
extern void simplescroll(Widget, caddr_t, XPointerMovedEvent *);
extern void printhelp(Widget, caddr_t, caddr_t);

/* from keybindings.c */

extern int firstbinding(int);
extern Boolean ismacro(int);
extern Boolean isbound(int, int);
extern Boolean isnbound(int, int, short *);
extern int string_to_func(const char *, short *);
extern int string_to_key(const char *);
extern char *binding_to_string(int, int);
extern char *func_to_string(int);
extern char *key_to_string(int);
extern int add_vbinding(int, int, short);
extern int add_binding(int, int);
extern int add_keybinding(const char *, const char *);
extern void default_keybindings();
extern int remove_binding(int, int);
extern void remove_keybinding(const char *, const char *);

/* from libraries.c: */

extern short findhelvetica();
extern void catreturn();
extern int pageposition(short, XButtonEvent *, int);
extern short pagelinks();
extern int is_page(objectptr);
extern int is_library(objectptr);
extern void pagecatbutton(XButtonEvent *);
extern void pageinstpos(short, short, objinstptr, int, int, int, int);
extern objinstptr makeinstofpage(objectptr, objectptr);
extern void computespacing(short, int *, int *, int *, int *);
extern void composepagelib(short);
extern void updatepagelib(short, short);
extern void pagecatmove(XKeyEvent *);
extern void composelib(short);
extern short finddepend(objinstptr, objectptr **);
extern void cathide();
extern void catdelete();
extern void catmove(XKeyEvent *);
extern void copycat();
extern void catbutton(u_int, XButtonEvent *);
extern void changecat();
extern void startcatalog(Widget, u_int, caddr_t);

/* from menucalls.c: */

extern void dotoolbar(Widget, caddr_t, caddr_t);
extern void overdrawpixmap(Widget);
extern void getgeneric(buttonsave *, Widget, void (*getfunction)(), void *);
extern void setgrid(Widget, float *);
extern void measurestr(float, char *);
extern void getsnapspace(Widget, caddr_t, caddr_t);
extern void getgridspace(Widget, caddr_t, caddr_t);
extern void setfloat(Widget, float *);
extern void setwidth(Widget, float *);
extern void settsize(Widget, labelptr);
extern void autoset(Widget, WidgetList, caddr_t);
extern void autostop(Widget, caddr_t, caddr_t);
extern void autoscale();
extern void setscaley(Widget, float *);
extern void setscalex(Widget, float *);
extern void setorient(Widget, short *);
extern void setpmode(Widget, short *);
extern void setpagesize(Widget, XPoint *);
extern void getkern(Widget, caddr_t, caddr_t);
extern void setkern(Widget, stringpart *);
extern void getdscale(Widget, caddr_t, caddr_t);
extern void setdscale(Widget, XPoint *);
extern void gettsize(Widget, caddr_t, caddr_t);
extern void setosize(Widget, objinstptr);
extern void getosize(Widget, caddr_t, caddr_t);
extern void getwirewidth(Widget, caddr_t, caddr_t);
extern void setwwidth(Widget, void *);
extern void getwwidth(Widget, caddr_t, caddr_t);
extern void getfloat(Widget, float *, caddr_t);
extern void setfilename(Widget, char **);
extern void setpagelabel(Widget, char *);
extern void makenewfontbutton();
extern void makenewencodingbutton(char *, char);
extern void togglefontmark(int);
extern void toggleexcl(Widget, menuptr, int);
extern void toggle(Widget, Boolean *, caddr_t);
extern void setcolorscheme(Boolean);
extern void inversecolor(Widget, Boolean *, caddr_t);
extern void togglegrid(u_short);
extern void setgridtype(char *);
extern void getgridtype(Widget, u_int, caddr_t);
extern void newlibrary(Widget, caddr_t, caddr_t);
extern int findemptylib();
extern int createlibrary();
extern void newpagemenu(Widget, u_int, caddr_t);
extern void makepagebutton();
extern void renamepage(short);
extern void renamelib(short);
extern void setstylemarks(Widget, u_int, Boolean);
extern void setcolormark(int);
extern void setallstylemarks(short);
extern polyptr checkforbbox(objectptr);
extern void getfill(Widget, u_int, caddr_t);
extern void makebbox(Widget, u_int, caddr_t);
extern void getset(Widget, u_int, caddr_t);
extern void getline(Widget, u_int, caddr_t);
extern void getopaque(Widget, u_int, caddr_t);
extern void setcolor(Widget, u_int, caddr_t);
extern void setnewcolor(Widget, caddr_t);
extern void addnewcolor(Widget, caddr_t, caddr_t);
extern void setfontmarks(short, short);
extern void startparam(Widget, u_int, caddr_t);
extern void startunparam(Widget, u_int, caddr_t);
extern void setdefaultfontmarks();
extern void dopinvisible(Widget, labelptr);
extern void doflipflip(Widget, labelptr);
extern void setjust(Widget, u_int, labelptr, short);
extern void setvjust(Widget, u_int, caddr_t);
extern void sethjust(Widget, u_int, caddr_t);
extern void setflipinv(Widget, u_int, caddr_t);
extern void setpinvisible(Widget, u_int, caddr_t);
extern void boxedit(Widget, u_int, caddr_t);
extern void locloadfont(Widget, char *);
extern void addnewfont(Widget, caddr_t, caddr_t);
extern short findbestfont(short, short, short, short);
extern void setfontval(Widget, u_int, labelptr);
extern void setfont(Widget, u_int, caddr_t);
extern void setfontstyle(Widget, u_int, labelptr);
extern void fontstyle(Widget, u_int, caddr_t);
extern void setfontencoding(Widget, u_int, labelptr);
extern void fontencoding(Widget, u_int, caddr_t);
extern void addtotext(Widget, u_int, caddr_t);
extern void position_popup(Widget, Widget);
extern void border_popup(Widget, caddr_t, caddr_t);
extern void color_popup(Widget, caddr_t, caddr_t);
extern void fill_popup(Widget, caddr_t, caddr_t);
extern void dospecial(void);

/* from netlist.c: */

#ifdef SCHEMA
extern void createnets(Boolean, char *);
extern void destroynets();
extern void gennet(char *, char *);
extern Boolean nonnetwork(polyptr);
extern int globalmax();
extern void gennetlist(objectptr, char *);
extern void gencalllist(objectptr, Boolean);
extern void search_on_siblings(objinstptr, objinstptr, objectpair *,
		short, short, short, short);
extern int is_resolved(genericptr *, objectpair *, objectptr *);
extern void highlightnet(objectptr, objinstptr, int);
extern int pushnetwork(objectpair *, objectptr);
extern int onsegment(XPoint *, XPoint *, XPoint *);
extern Boolean neardist(long);
extern Boolean nearpoint(XPoint *, XPoint *);
extern int make_tmp_pin(objectptr, XPoint *);
extern Boolean searchconnect(XPoint *, int, objinstptr);
extern int translateup(int, objectptr, objectptr, objinstptr);
extern void addpoly(objectptr, polyptr, int);
extern long zsign(long, long);
extern void mergecleanup(objectptr);
extern void mergenets(objectptr, int, int);
extern void removecall(objectptr, CalllistPtr);
extern void addpin(objectptr, labelptr, int);
extern void addglobal(labelptr, int);
extern void addcall(objectptr, objectptr, objinstptr);
extern Boolean addport(objectptr, int);
extern void addportcall(objectptr, objinstptr, objectptr, int, int);
extern void makelocalpins(objectptr, CalllistPtr, char *);
extern int porttonet(objectptr, int);
extern int pointtonet(objectptr, XPoint *);
extern stringpart *nettopin(int, objectptr, char *);
extern int pintonet(objectptr, labelptr);
extern char *parseinfo(objectptr, CalllistPtr, char *, char *, Boolean);
extern int writedevice(FILE *, char *, objectptr, CalllistPtr, char *);
extern void writeflat(objectptr, CalllistPtr, char *, FILE *, char *);
extern void writeglobals(objectptr, FILE *);
extern void writehierarchy(objectptr, CalllistPtr, FILE *);
extern void writenet(objectptr, char *, char *);
extern void writepcb(objectptr, CalllistPtr, char *, char *);
extern void outputpcb(objectptr, FILE *);
extern void freepcb();
extern void freenets(objectptr);
extern void freeglobals();
extern int cleartraversed(objectptr, int);
extern void clearpins(objectptr);
#endif

/* from parameter.c: */ 

extern void rehook(objectptr, char *, char *);
extern void hookexpand(objectptr, char *, short);
extern void makeshortp(genericptr *);
extern void unmakeshortp(genericptr *);
extern void noparmstrcpy(u_char *, u_char *);
extern void insertparam();
extern void makeparam(labelptr);
extern void initinst(objectptr, objectptr, short);
extern void searchinst(objectptr, objectptr, short);
extern stringpart *searchparam(stringpart *);
extern void unmakeparam(labelptr, stringpart *);
extern void unparameterize(u_int);
extern void parameterize(u_int);
extern genericptr findparam(objectptr, void *, u_char);
extern Boolean paramcross(objectptr, labelptr);
extern oparamptr parampos(objectptr, labelptr, char *, short *, short *);
extern void psubstitute(objinstptr);
extern short paramlen(u_char *);
extern int natstrlen(u_char *);
extern int natstrcmp(u_char *, u_char *);
extern void curtail(u_char *);
extern objectptr checklibtop();
extern void removeinst(objinstptr);
extern void removeparams(objectptr);
extern void resolveparams(objinstptr);

/* from python.c: */

#ifdef HAVE_PYTHON
extern void init_interpreter();
extern void exit_interpreter();
#endif

#ifdef HAVE_XPM
extern Widget *pytoolbuttons(int *);
#endif

/* from rcfile.c: */

extern short execcommand(short, char *);
extern void defaultscript();
extern void execscript();
extern void loadrcfile();
#ifndef HAVE_PYTHON
extern short readcommand(short, FILE *);
#endif

/* from render.c: */

extern void ghostinit();
extern void send_client(Atom);
extern void ask_for_next();
extern void wait_for_page();
extern void wait_for_done();
extern void start_gs();
extern void parse_bg(FILE *, FILE *);
extern void bg_get_bbox();
extern void backgroundbbox(int);
extern void readbackground(FILE *);
extern void savebackground(FILE *, char *);
extern void call_loadbg(char *);
extern void loadbackground();
extern void send_to_gs(char *);
extern int renderbackground();
extern int copybackground();
extern int exit_gs();
extern int reset_gs();

/* from schema.c: */

extern void callgennet(Widget, u_int, caddr_t);
extern void doxschema(Widget, caddr_t, caddr_t);
extern void startconnect(Widget, caddr_t, caddr_t);
extern void connectivity(Widget, caddr_t, caddr_t);
extern Boolean setobjecttype(objectptr, char *);
extern void pinconvert(labelptr, u_int);
extern void dopintype(Widget, u_int, caddr_t);
extern void setsymschem();
extern int findpageobj(objectptr);
extern int findsubschems(int, objectptr, int);
extern void copypinlabel(labelptr);
extern int checkschem(objectptr, char *);
extern int checksym(objectptr, char *);
extern void changeotherpins(labelptr, stringpart *);
extern void swapschem(Widget, u_int, caddr_t);
extern void dobeforeswap(Widget, caddr_t, caddr_t);
extern void schemdisassoc();
extern void startschemassoc(Widget, caddr_t, caddr_t);
extern void schemassoc(objectptr, objectptr);

/* from selection.c: */

extern void selectfilter(Widget, caddr_t, caddr_t);
extern Boolean checkselect(short);
extern void geneasydraw(short, short, objectptr, objinstptr);
extern void gendrawselected(short *, objectptr, objinstptr);
extern short *selectobject(short, objectptr, objinstptr);
extern short *allocselect();
extern void setoptionmenu();
extern int test_insideness(int, int, XPoint *);
extern Boolean pathselect(genericptr *, short);
extern Boolean areaelement(genericptr *);
extern void selectarea();
extern void startdesel(Widget, caddr_t, caddr_t);
extern void deselect(Widget, caddr_t, caddr_t);
extern void drawselects();
extern void clearselects();
extern void objectdeselect();
extern genericptr recurselect(objectpair **);
extern void startselect(XtIntervalId, caddr_t);
extern void trackselarea(Widget, XtPointer, XMotionEvent *);

/* from text.c: */

extern Boolean hasparameter(labelptr);
extern void drawparamlabels(labelptr, short);
extern stringpart *nextstringpart(stringpart *, objinstptr);
extern stringpart *makesegment(stringpart **, stringpart *);
extern stringpart *splitstring(int, stringpart **, objinstptr);
extern stringpart *mergestring(stringpart *);
extern stringpart *linkstring(objinstptr, stringpart *);
extern int findcurfont(int, stringpart *, objinstptr);
extern stringpart *findstringpart(int, int *, stringpart *, objinstptr);
extern void charprint(char *, stringpart *, int);
extern char *stringprint(stringpart *, objinstptr);
extern char *textprint(stringpart *, objinstptr);
extern int textcomp(stringpart *, char *, objinstptr);
extern int textncomp(stringpart *, char *, objinstptr);
extern int stringcomp(stringpart *, stringpart *);
extern int stringcomprelaxed(stringpart *, stringpart *);
extern int stringparts(stringpart *);
extern int stringlength(stringpart *, Boolean, objinstptr);
extern stringpart *stringcopy(stringpart *);
extern stringpart *stringcopyall(stringpart *, objinstptr);
extern stringpart *stringcopyback(stringpart *, objinstptr);
extern stringpart *deletestring(stringpart *, stringpart **, objinstptr);

extern short UDrawChar(objinstptr, u_char, short, short, int, int);
extern void UDrawString(objinstptr, labelptr, int);
extern TextExtents ULength(stringpart *, objinstptr, float, short, XPoint *);
extern void undrawtext(labelptr);
extern void redrawtext(labelptr);
extern void composefontlib(short);
extern void fontcatbutton(XButtonEvent *);

/* from xcircuit.c: */

extern void printeventmode();
extern void Wprintf(char *);
extern void popupprompt(Widget, char *, char *, void (*function)(),
                        buttonsave *, const char *);
extern void getproptext(Widget, propstruct *, caddr_t);
extern int rgb_alloccolor(int, int, int);
extern void addtocolorlist(Widget, int);
extern void addnewcolorentry(int);
extern void dooutput(Widget, caddr_t, caddr_t);
extern void docommand();
extern void W1printf(char *);
extern void W2printf(char *);
extern void destroypopup(Widget, popupstruct *, caddr_t);
extern int xc_alloccolor(char *);
extern void dointr(int);
extern void DoNothing(Widget, caddr_t, caddr_t);
extern u_short countchanges(char **);
extern void quitcheck(Widget, caddr_t, caddr_t);
extern void quit(Widget, caddr_t);
extern void resizetoolbar();
extern void updatetext(Widget, WidgetList, caddr_t);
extern void makecursors();
