/*----------------------------------------------------------------------*/
/* prototypes.h:							*/
/*     Master list of function prototypes				*/
/*----------------------------------------------------------------------*/

/* from tclxcircuit.c */

#ifdef TCL_WRAPPER

extern Tk_EventProc *xctk_drag(ClientData, XEvent *);
extern Tk_EventProc *xctk_draglscroll(ClientData, XEvent *);
extern Tk_EventProc *xctk_dragfilebox(ClientData, XEvent *);
extern int XcTagCallback(Tcl_Interp *, int, Tcl_Obj *CONST objv[]);

#endif

/* from elements.c: */

extern void copyparams(objinstptr, objinstptr);
extern void objectdefaults(objinstptr, objectptr, int, int);
extern void labeldefaults(labelptr, u_char, int, int);
extern void polydefaults(polyptr, int, int, int);
extern void splinedefaults(splineptr, int, int);
extern void arcdefaults(arcptr, int, int);
extern void pathdefaults(pathptr, int, int);
extern void drawdot(int, int);
extern void startspline(xcWidget, caddr_t, caddr_t);
extern void starttext(xcWidget, pointertype, caddr_t);
extern void textbutton(u_char, XButtonEvent *);
extern void charreport(labelptr);
extern void labeltext(int, char *);
extern void textreturn();
extern void rejustify(short);
extern void splinebutton(XButtonEvent *);
extern void trackspline(xcWidget, caddr_t, caddr_t);
extern void startarc(xcWidget, caddr_t, caddr_t);
extern void arcbutton(XButtonEvent *);
extern void trackarc(xcWidget, caddr_t, caddr_t);
extern void startbox(xcWidget, caddr_t, caddr_t);
extern void boxbutton(XButtonEvent *);
extern void trackbox(xcWidget, caddr_t, caddr_t);
extern void trackwire(xcWidget, caddr_t, caddr_t);
extern void startwire(XPoint);
extern void finddir(polyptr);
extern void trackpoly(xcWidget, caddr_t, caddr_t);
extern void setendpoint(short *, short, XPoint **, XPoint *);
extern void reversepoints(XPoint *, short);
extern void reversefpoints(XfPoint *, short);
extern void freeparts(short *, short);
extern void removep(short *, short);
extern void unjoin();
extern labelptr findlabelcopy(labelptr, stringpart *);
extern Boolean neartest(XPoint *, XPoint *);
extern void join();
extern void wirebutton(XButtonEvent *);

/* from events.c: */

extern Boolean recursefind(objectptr, objectptr);
extern void transferselects();
extern void newmatrix();
extern void setpage(Boolean);
extern int changepage(short);
extern void newpage(short);
extern void startpush(xcWidget, caddr_t, caddr_t);
extern void pushobject(XButtonEvent *);
extern void push_stack(pushlistptr *, objinstptr);
extern void pop_stack(pushlistptr *);
extern void free_stack(pushlistptr *);
extern void popobject(xcWidget, caddr_t, caddr_t);
extern void resetbutton(xcWidget, pointertype, caddr_t);
extern void drawhbar(xcWidget, caddr_t, caddr_t);
extern void drawvbar(xcWidget, caddr_t, caddr_t);
extern void panhbar(xcWidget, caddr_t, XButtonEvent *);
extern void endhbar(xcWidget, caddr_t, XButtonEvent *);
extern void panvbar(xcWidget, caddr_t, XButtonEvent *);
extern void endvbar(xcWidget, caddr_t, XButtonEvent *);
extern void zoombox(xcWidget, caddr_t, caddr_t);
extern void zoomin(xcWidget, caddr_t, XButtonEvent *);
extern void zoomout(xcWidget, caddr_t, XButtonEvent *);
extern void panbutton(u_int, XButtonEvent *);
extern void zoominrefresh(xcWidget, caddr_t, XButtonEvent *);
extern void zoomoutrefresh(xcWidget, caddr_t, XButtonEvent *);
extern void panrefresh(u_int, XButtonEvent *);
extern void centerpan(xcWidget, caddr_t, caddr_t);
extern void checkwarp(XPoint *);
extern int checkcycle(short, short);
extern void copyvirtual();
extern void nextpolycycle(polyptr, short);
extern void nextsplinecycle(splineptr, short);
extern void nextarccycle(arcptr, short);
extern short getkeynum();
extern void buttonhandler(xcWidget, caddr_t, XButtonEvent *);
extern void keyhandler(xcWidget, caddr_t, XKeyEvent *);
extern void setsnap(short);
extern void snapobject();
extern int ipow10(int);
extern int calcgcf(int, int);
extern void fraccalc(float, char *);
extern void printpos(short, short);
extern void findwirex(XPoint *, XPoint *, XPoint *, XPoint *, int *);
extern void findattach(XPoint *, int *, XPoint *);
extern XPoint *pathclosepoint(pathptr, XPoint *);
extern void placeselects(short, short, XPoint *);
extern void drag(xcWidget, caddr_t, XButtonEvent *);
extern void rotatebutton(XButtonEvent *);
extern void elemrotate(genericptr *, short);
extern void objectrotate(short);
extern void edit(XButtonEvent *);
extern void pathedit(genericptr *, short);
extern void xc_lower(short *);
extern void xc_raise(short *);
extern void exchange();
extern void elhflip(genericptr *);
extern void elvflip(genericptr *);
extern void objectflip();
extern void objectvflip();
#ifdef TCL_WRAPPER
extern xcTimeOutProc makepress(caddr_t);
#else
extern xcTimeOutProc makepress(caddr_t, xcIntervalId *);
#endif
extern void startrotate(xcWidget, pointertype, caddr_t);
extern void startcopy(xcWidget, caddr_t, caddr_t);
extern void startedit(xcWidget, caddr_t, caddr_t);
extern void startdelete(xcWidget, caddr_t, caddr_t);
extern void reviseselect(short *);
extern void objectdelete(short);
extern void deletebutton(XButtonEvent *);
extern short xc_undelete(xcWidget, pointertype, XButtonEvent *);
extern void printname(objectptr);
extern Boolean checkname(objectptr);
extern objectptr finddot();
extern void movepoints(genericptr *, short, short);
extern void domakeobject(xcWidget, caddr_t);
extern void selectsave(xcWidget, caddr_t, caddr_t);
extern void arceditpush(arcptr);
extern void splineeditpush(splineptr);
extern void polyeditpush(polyptr);
extern void arccopy(arcptr, arcptr);
extern void polycopy(polyptr, polyptr);
extern void splinecopy(splineptr, splineptr);
extern void instcopy(objinstptr, objinstptr);
extern void copybutton(XButtonEvent *);
extern void selectbutton(XButtonEvent *);
extern void releasebutton(XButtonEvent *);
extern void pathbutton(genericptr *, XButtonEvent *);
extern void resizearea(xcWidget, caddr_t, caddr_t);
extern void drawarea(xcWidget, caddr_t, caddr_t);

/* from filelist.c: */

extern int fcompare(const void *, const void *);
extern void dragfilebox(xcWidget, caddr_t, XMotionEvent *);
extern void startfiletrack(xcWidget, caddr_t, XCrossingEvent *);
extern void endfiletrack(xcWidget, caddr_t, XCrossingEvent *);
extern char *getcrashfilename();
extern void crashrecover();
extern void findcrashfiles();
extern void listfiles(xcWidget, popupstruct *, caddr_t);
extern void newfilelist(xcWidget, popupstruct *);
extern void fileselect(xcWidget, popupstruct *, XButtonEvent *);
extern void showlscroll(xcWidget, caddr_t, caddr_t);
extern void draglscroll(xcWidget, popupstruct *, XButtonEvent *);
extern void genfilelist(xcWidget, popupstruct *, Dimension);
extern int lookdirectory(char *);

/* from files.c: */

extern void ridnewline(char *);
extern void free_single(genericptr *);
extern void reset(objectptr, short);
extern void pagereset(short);
extern void initmem(objectptr);
extern void freelabel(stringpart *);
extern Boolean compare_single(genericptr *, genericptr *);
extern Boolean elemcompare(genericptr *, genericptr *);
extern short objcompare(objectptr, objectptr);
extern float getpsscale(float, short);
extern void dostcount(FILE *, short *, short);
extern short printparams(FILE *, objinstptr, short);
extern void varcheck(FILE *, short, objectptr, short *, genericptr, u_char);
extern void varfcheck(FILE *, float, objectptr, short *, genericptr, u_char);
extern void varpcheck(FILE *, short, objectptr, int, short *, genericptr, u_char);
extern void getfile(xcWidget, pointertype, caddr_t);
extern Boolean nextfilename();
extern void loadfontlib();
extern void loadglib(Boolean, short, short);
extern void loadulib();
extern void loadblib();
extern void getlib(xcWidget, caddr_t, caddr_t);
extern void getuserlib(xcWidget, caddr_t, caddr_t);
extern void loadlibrary(short);
extern void startloadfile();
extern void importfile();
extern void loadfile(short);
extern void readlabel(objectptr, char *, stringpart **);
extern u_char *find_match(u_char *);
extern char *advancetoken(char *);
extern char *varpscan(objectptr, char *, short *, genericptr, int, int, u_char);
extern char *varscan(objectptr, char *, short *, genericptr, u_char);
extern char *varfscan(objectptr, char *, float *, genericptr, u_char);
extern objinstptr addtoinstlist(int, objectptr, Boolean);
extern Boolean objectread(FILE *, objectptr, short, short, short, char *, int);
#ifdef TCL_WRAPPER
void setfile(char *, int);
extern xcTimeOutProc savetemp(caddr_t);
#else
extern void setfile(xcWidget, xcWidget, caddr_t);
extern xcTimeOutProc savetemp(caddr_t, xcIntervalId *);
#endif
extern void savelibpopup(xcWidget, pointertype, caddr_t);
extern void savelibrary(xcWidget, int);
extern void findfonts(objectptr, short *);
extern void savefile(short);
extern int printRGBvalues(char *, int, const char *);
extern char *nosprint(char *);
extern Boolean xc_tilde_expand(char *);
extern short writelabel(FILE *, stringpart *, short *);
extern char *writesegment(stringpart *, float *, int *);
extern void writelabelsegs(FILE *, short *, stringpart *);
extern void printobjects(FILE *, objectptr, objectptr **, short *, int);
extern void printrefobjects(FILE *, objectptr, objectptr **, short *);
extern void printpageobject(FILE *, objectptr, short, short);


/* from fontfile.c: */

extern FILE *findfontfile(char *);
extern int loadfontfile(char *);

/* from formats.c: */

extern void loadlgf(int);
extern void loadmat4(caddr_t);

/* from functions.c: */

extern long sqwirelen(XPoint *, XPoint *);
extern float fsqwirelen(XfPoint *, XfPoint *);
extern int wirelength(XPoint *, XPoint *);
extern long finddist(XPoint *,XPoint *, XPoint *);
extern void calcarc(arcptr);
extern void initsplines();
extern void computecoeffs(splineptr, float *, float *, float *, float *,
                          float *, float *);
extern void calcspline(splineptr);
extern void findsplinepos(splineptr, float, XPoint *, int *);
extern void ffindsplinepos(splineptr, float, XfPoint *);
extern float findsplinemin(splineptr, XPoint *);
extern short closepoint(polyptr, XPoint *);
extern short checkbounds();
extern void window_to_user(short, short, XPoint *);
extern void user_to_window(XPoint, XPoint *);
extern float UTopScale();
extern short UTopTransScale(float);
extern XPoint UGetCursor();
extern XPoint UGetCursorPos();
extern void u2u_snap(XPoint *);
extern void snap(short, short, XPoint *);
extern void UResetCTM(Matrix *);
extern void InvertCTM(Matrix *);
extern void UCopyCTM(Matrix *, Matrix *);
extern void UMakeWCTM(Matrix *);
extern void UMultCTM(Matrix *, XPoint, float, short);
extern void USlantCTM(Matrix *, float);
extern void UPreScaleCTM(Matrix *);
extern short flipadjust(short);
extern void UPreMultCTM(Matrix *, XPoint, float, short);
extern void UTransformbyCTM(Matrix *, XPoint *, XPoint *, short);
extern void UfTransformbyCTM(Matrix *, XfPoint *, XPoint *, short);
extern void UPopCTM(void);
extern void UPushCTM(void);
extern void UTransformPoints(XPoint *, XPoint *, short, XPoint, float,
                             short);
extern void InvTransformPoints(XPoint *, XPoint *, short, XPoint, float,
                             short);
extern void manhattanize(XPoint *, polyptr);
extern void bboxcalc(short, short *, short *);
extern void calcextents(genericptr *, short *, short *, short *, short *);
extern void objinstbbox(objinstptr, XPoint *);
extern void labelbbox(labelptr, XPoint *, objinstptr);
extern void calcbboxsingle(genericptr *, objinstptr, short *, short *, short *, short *);
extern Boolean object_in_library(short, objectptr);
extern short find_object(objectptr, objectptr);
extern void updatepagebounds(objectptr);
extern void calcbbox(objinstptr);
extern void calcbboxparam(objectptr, int);
extern void singlebbox(genericptr *);
extern void calcbboxselect();
extern void calcbboxvalues(objinstptr, genericptr *);
extern void centerview(objinstptr);
extern void refresh(xcWidget, caddr_t, caddr_t);
extern void zoomview(xcWidget, caddr_t, caddr_t);
extern void UDrawSimpleLine(XPoint *, XPoint *);
extern void UDrawLine(XPoint *, XPoint *);
extern void UDrawCircle(XPoint *, u_char);
extern void UDrawX(labelptr);
#ifdef SCHEMA
extern void UDrawXDown(labelptr);
extern int  toplevelwidth(objinstptr, short *);
extern int  toplevelheight(objinstptr, short *);
extern void extendschembbox(objinstptr, XPoint *, XPoint *);
#endif
extern void pinadjust(short, short *, short *, short);
extern void UDrawTextLine(labelptr, short);
extern void UDrawTLine(labelptr);
extern void UDrawXLine(XPoint, XPoint);
extern void UDrawBox(XPoint, XPoint);
extern void UDrawBBox();
extern void strokepath(XPoint *, short, short, float);
extern void makesplinepath(splineptr, XPoint *);
extern void UDrawSpline(splineptr);
extern void UDrawEditSpline(splineptr);
extern void UDrawPolygon(polyptr);
extern void UDrawArc(arcptr);
extern void UDrawPath(pathptr);
extern void UDrawObject(objinstptr, short, int, pushlistptr *);

/* from help.c: */

extern void showhsb(xcWidget, caddr_t, caddr_t);
extern void printhelppix();
extern void starthelp(xcWidget, caddr_t, caddr_t);
extern void simplescroll(xcWidget, xcWidget, XPointerMovedEvent *);
extern void exposehelp(xcWidget, caddr_t, caddr_t);
extern void printhelp(xcWidget);

/* from keybindings.c */

extern int firstbinding(int);
extern Boolean ismacro(int);
extern Boolean isbound(int, int);
extern Boolean isnbound(int, int, short *);
extern int string_to_func(const char *, short *);
extern int string_to_key(const char *);
extern char *binding_to_string(int, int);
extern char *func_to_string(int);
extern char *key_to_string(int);
extern void printeditbindings();
extern int add_vbinding(int, int, short);
extern int add_binding(int, int);
extern int add_keybinding(const char *, const char *);
extern void default_keybindings();
extern int remove_binding(int, int);
extern void remove_keybinding(const char *, const char *);

/* from libraries.c: */

extern short findhelvetica();
extern void catreturn();
extern int pageposition(short, XButtonEvent *, int);
extern short pagelinks();
extern short *pagetotals(int, short);
extern int is_page(objectptr);
extern int is_library(objectptr);
extern void pagecatbutton(XButtonEvent *);
extern void pageinstpos(short, short, objinstptr, int, int, int, int);
extern objinstptr newpageinst(objectptr);
extern void computespacing(short, int *, int *, int *, int *);
extern void composepagelib(short);
extern void updatepagelib(short, short);
extern void pagecatmove(XKeyEvent *);
extern void composelib(short);
extern short finddepend(objinstptr, objectptr **);
extern void cathide();
extern void catvirtualcopy();
extern void catdelete();
extern void catmove(XKeyEvent *);
extern void copycat();
extern void catbutton(u_int, XButtonEvent *);
extern void changecat();
extern void startcatalog(xcWidget, pointertype, caddr_t);

/* from menucalls.c: */

extern void dotoolbar(xcWidget, caddr_t, caddr_t);
extern void overdrawpixmap(xcWidget);
extern void getgeneric(buttonsave *, xcWidget, void (*getfunction)(), void *);
extern void setgrid(xcWidget, float *);
extern void measurestr(float, char *);
extern void getsnapspace(xcWidget, caddr_t, caddr_t);
extern void getgridspace(xcWidget, caddr_t, caddr_t);
extern void setfloat(xcWidget, float *);
extern void setwidth(xcWidget, float *);
extern void settsize(xcWidget, labelptr);
extern void autoset(xcWidget, xcWidgetList, caddr_t);
extern void autostop(xcWidget, caddr_t, caddr_t);
extern void autoscale(int);
extern void setscaley(xcWidget, float *);
extern void setscalex(xcWidget, float *);
extern void setorient(xcWidget, short *);
extern void setpmode(xcWidget, short *);
extern void setpagesize(xcWidget, XPoint *);
extern void getkern(xcWidget, caddr_t, caddr_t);
extern void setkern(xcWidget, stringpart *);
extern void getdscale(xcWidget, caddr_t, caddr_t);
extern void setdscale(xcWidget, XPoint *);
extern labelptr gettextsize(float **);
extern void gettsize(xcWidget, caddr_t, caddr_t);
extern void setosize(xcWidget, objinstptr);
extern void getosize(xcWidget, caddr_t, caddr_t);
extern void getwirewidth(xcWidget, caddr_t, caddr_t);
extern void setwwidth(xcWidget, void *);
extern void getwwidth(xcWidget, caddr_t, caddr_t);
extern void getfloat(xcWidget, float *, caddr_t);
extern void setfilename(xcWidget, char **);
extern void setpagelabel(xcWidget, char *);
extern void makenewfontbutton();
extern void makenewencodingbutton(char *, char);
extern void togglefontmark(int);
#ifndef TCL_WRAPPER
extern void toggleexcl(xcWidget, menuptr, int);
extern void promptparam(xcWidget, caddr_t, caddr_t);
#endif
extern void stringparam(xcWidget, caddr_t, caddr_t);
extern void toggle(xcWidget, Boolean *, caddr_t);
extern void setcolorscheme(Boolean);
extern void inversecolor(xcWidget, Boolean *, caddr_t);
extern void togglegrid(u_short);
extern float parseunits(char *);
extern void setgridtype(char *);
extern void getgridtype(xcWidget, pointertype, caddr_t);
extern void newlibrary(xcWidget, caddr_t, caddr_t);
extern int findemptylib();
extern int createlibrary();
extern void newpagemenu(xcWidget, pointertype, caddr_t);
extern void makepagebutton();
extern void renamepage(short);
extern void renamelib(short);
extern void setcolormark(int);
extern void setallstylemarks(u_short);
extern polyptr checkforbbox(objectptr);
extern void setfill(xcWidget, pointertype, caddr_t);
extern void makebbox(xcWidget, pointertype, caddr_t);
extern void setclosure(xcWidget, pointertype, caddr_t);
extern void setline(xcWidget, pointertype, caddr_t);
extern void setopaque(xcWidget, pointertype, caddr_t);
#ifdef TCL_WRAPPER
extern void setcolor(xcWidget, int);
#else
extern void setcolor(xcWidget, pointertype, caddr_t);
#endif
extern void setnewcolor(xcWidget, caddr_t);
extern void addnewcolor(xcWidget, caddr_t, caddr_t);
extern void setfontmarks(short, short);
extern void startparam(xcWidget, pointertype, caddr_t);
extern void startunparam(xcWidget, pointertype, caddr_t);
extern void setdefaultfontmarks();
extern void dopinvisible(xcWidget, labelptr);
extern void doflipflip(xcWidget, labelptr);
extern void setjust(xcWidget, pointertype, labelptr, short);
extern void setvjust(xcWidget, pointertype, caddr_t);
extern void sethjust(xcWidget, pointertype, caddr_t);
extern void setflipinv(xcWidget, pointertype, caddr_t);
extern void setpinvisible(xcWidget, pointertype, caddr_t);
extern void boxedit(xcWidget, pointertype, caddr_t);
extern void locloadfont(xcWidget, char *);
extern void addnewfont(xcWidget, caddr_t, caddr_t);
extern short findbestfont(short, short, short, short);
extern void setfontval(xcWidget, pointertype, labelptr);
extern void setfont(xcWidget, pointertype, caddr_t);
extern void setfontstyle(xcWidget, pointertype, labelptr);
extern void fontstyle(xcWidget, pointertype, caddr_t);
extern void setfontencoding(xcWidget, pointertype, labelptr);
extern void fontencoding(xcWidget, pointertype, caddr_t);
extern void addtotext(xcWidget, pointertype, caddr_t);
extern void position_popup(xcWidget, xcWidget);
extern void border_popup(xcWidget, caddr_t, caddr_t);
extern void color_popup(xcWidget, caddr_t, caddr_t);
extern void fill_popup(xcWidget, caddr_t, caddr_t);
extern void param_popup(xcWidget, caddr_t, caddr_t);
extern void dospecial(void);

/* from netlist.c: */

#ifdef SCHEMA
extern void createnets(objinstptr);
extern void destroynets();
extern void gennet(char *, char *);
extern Boolean nonnetwork(polyptr);
extern int globalmax();
extern void gennetlist(objectptr, objinstptr);
extern void gencalllist(objectptr);
extern void search_on_siblings(objinstptr, objinstptr, pushlistptr,
		short, short, short, short);
extern int is_resolved(genericptr *, pushlistptr, objectptr *);
extern Boolean highlightnet(objectptr, objinstptr, int, u_char);
extern int pushnetwork(pushlistptr, objectptr);
extern int onsegment(XPoint *, XPoint *, XPoint *);
extern Boolean neardist(long);
extern Boolean nearpoint(XPoint *, XPoint *);
extern int make_tmp_pin(objectptr, XPoint *);
extern Boolean searchconnect(XPoint *, int, objinstptr);
extern int translateup(int, objectptr, objectptr, objinstptr);
extern void addpoly(objectptr, polyptr, int);
extern long zsign(long, long);
extern void mergecleanup(objectptr);
extern void mergenets(objectptr, int, int);
extern void removecall(objectptr, CalllistPtr);
extern void addpin(objectptr, labelptr, int);
extern void addglobal(labelptr, int);
extern void addcall(objectptr, objectptr, objinstptr);
extern Boolean addport(objectptr, int);
extern void addportcall(objectptr, objinstptr, objectptr, int, int);
extern void makelocalpins(objectptr, CalllistPtr, char *);
extern int porttonet(objectptr, int);
extern int pointtonet(objectptr, XPoint *);
extern stringpart *nettopin(int, objectptr, char *);
extern int pintonet(objectptr, objinstptr, labelptr);
extern int nametonet(objectptr, objinstptr, char *);
extern char *parseinfo(objectptr, CalllistPtr, char *, char *, Boolean);
extern int writedevice(FILE *, char *, objectptr, CalllistPtr, char *);
extern void writeflat(objectptr, CalllistPtr, char *, FILE *, char *);
extern void writeglobals(objectptr, FILE *);
extern void writehierarchy(objectptr, CalllistPtr, FILE *);
extern void writenet(objectptr, char *, char *);
extern void writepcb(objectptr, CalllistPtr, char *, char *);
extern void outputpcb(objectptr, FILE *);
extern void freepcb();
extern void freenets(objectptr);
extern void freetemplabels(objectptr);
extern void freeglobals();
extern int cleartraversed(objectptr, int);
extern int checkvalid(objectptr);
extern void clearpins(objectptr);
#endif

/* from parameter.c: */ 

extern oparamptr match_param(objectptr, char *);
extern oparamptr match_instance_param(objinstptr, char *);
extern oparamptr find_param(objinstptr, char *);
extern int get_num_params(objectptr);
extern void free_object_param(objectptr, oparamptr);
extern void free_instance_param(objinstptr, oparamptr);
extern void free_element_param(genericptr, eparamptr);

extern oparamptr make_new_parameter(char *);
extern eparamptr make_new_eparam(char *);

extern void indicateparams(genericptr);
extern void makenumericalp(genericptr *, u_int, char *);
extern void noparmstrcpy(u_char *, u_char *);
extern void insertparam();
extern void makeparam(labelptr, char *);
extern void searchinst(objectptr, objectptr, char *);
extern stringpart *searchparam(stringpart *);
extern void unmakeparam(labelptr, stringpart *);
extern void unmakenumericalp(genericptr *, u_int);         
extern void unparameterize(int);
extern void parameterize(int, char *);
extern genericptr findparam(objectptr, void *, u_char);
extern Boolean paramcross(objectptr, labelptr);
extern oparamptr parampos(objectptr, labelptr, char *, short *, short *);
extern int opsubstitute(objectptr, objinstptr);
extern int psubstitute(objinstptr);
extern oparamptr copyparameter(oparamptr);
extern void pwriteback(objinstptr);
extern short paramlen(u_char *);
extern int natstrlen(u_char *);
extern int natstrcmp(u_char *, u_char *);
extern void curtail(u_char *);
extern int checklibtop();
extern void removeinst(objinstptr);
extern void removeparams(objectptr);
extern void resolveparams(objinstptr);

/* from python.c: */

#ifdef HAVE_PYTHON
extern void init_interpreter();
extern void exit_interpreter();
#endif

#ifdef HAVE_XPM
extern xcWidget *pytoolbuttons(int *);
#endif

/* from rcfile.c: */

extern short execcommand(short, char *);
extern void defaultscript();
extern void execscript();
extern void loadrcfile();
#ifndef HAVE_PYTHON
extern short readcommand(short, FILE *);
#endif

/* from render.c: */

extern void ghostinit();
extern void send_client(Atom);
extern void ask_for_next();
extern void wait_for_page();
extern void wait_for_done();
extern void start_gs();
extern void parse_bg(FILE *, FILE *);
extern void bg_get_bbox();
extern void backgroundbbox(int);
extern void readbackground(FILE *);
extern void savebackground(FILE *, char *);
extern void call_loadbg(char *);
extern void loadbackground();
extern void send_to_gs(char *);
extern int renderbackground();
extern int copybackground();
extern int exit_gs();
extern int reset_gs();

/* from schema.c: */

extern objectptr NameToObject(char *, objinstptr *, Boolean);
extern void callgennet(xcWidget, pointertype, caddr_t);
extern void doxschema(xcWidget, pointertype, caddr_t);
extern void startconnect(xcWidget, caddr_t, caddr_t);
extern int connectivity(xcWidget, caddr_t, caddr_t);
extern Boolean setobjecttype(objectptr);
extern void pinconvert(labelptr, pointertype);
extern void dopintype(xcWidget, pointertype, caddr_t);
extern void setsymschem();
extern int findpageobj(objectptr);
extern void collectsubschems(int);
extern int findsubschems(int, objectptr, int, short *);
extern void copypinlabel(labelptr);
extern int checkschem(objectptr, char *);
extern int checksym(objectptr, char *);
extern void changeotherpins(labelptr, stringpart *);
extern void swapschem(xcWidget, pointertype, caddr_t);
extern void dobeforeswap(xcWidget, caddr_t, caddr_t);
extern void schemdisassoc();
extern void startschemassoc(xcWidget, pointertype, caddr_t);
extern Boolean schemassoc(objectptr, objectptr);

/* from selection.c: */

extern void selectfilter(xcWidget, pointertype, caddr_t);
extern Boolean checkselect(short);
extern void geneasydraw(short, short, objectptr, objinstptr);
extern void gendrawselected(short *, objectptr, objinstptr);
extern short *genobjectselect(short, objectptr, objinstptr);
extern short *allocselect();
extern void setoptionmenu();
extern int test_insideness(int, int, XPoint *);
extern Boolean pathselect(genericptr *, short);
extern Boolean areaelement(genericptr *);
extern void selectarea();
extern void startdesel(xcWidget, caddr_t, caddr_t);
extern void deselect(xcWidget, caddr_t, caddr_t);
extern void drawselects();
extern void clearselects();
extern void objectdeselect();
extern genericptr recurselect(short, pushlistptr *);
#ifdef TCL_WRAPPER
extern xcTimeOutProc startselect(caddr_t);
#else
extern xcTimeOutProc startselect(caddr_t, xcIntervalId *);
#endif
extern void trackselarea();

/* from text.c: */

extern Boolean hasparameter(labelptr);
extern void drawparamlabels(labelptr, short);
extern stringpart *nextstringpart(stringpart *, objinstptr);
extern stringpart *makesegment(stringpart **, stringpart *);
extern stringpart *splitstring(int, stringpart **, objinstptr);
extern stringpart *mergestring(stringpart *);
extern stringpart *linkstring(objinstptr, stringpart *);
extern int findcurfont(int, stringpart *, objinstptr);
extern stringpart *findstringpart(int, int *, stringpart *, objinstptr);
extern void charprint(char *, stringpart *, int);
extern char *stringprint(stringpart *, objinstptr);
extern char *textprint(stringpart *, objinstptr);
extern int textcomp(stringpart *, char *, objinstptr);
extern int textncomp(stringpart *, char *, objinstptr);
extern int stringcomp(stringpart *, stringpart *);
extern int stringcomprelaxed(stringpart *, stringpart *, objinstptr);
extern int stringparts(stringpart *);
extern int stringlength(stringpart *, Boolean, objinstptr);
extern stringpart *stringcopy(stringpart *);
extern stringpart *stringcopyall(stringpart *, objinstptr);
extern stringpart *stringcopyback(stringpart *, objinstptr);
extern stringpart *deletestring(stringpart *, stringpart **, objinstptr);

extern short UDrawChar(u_char, short, short, int, int);
extern void UDrawString(labelptr, int, objinstptr);
extern TextExtents ULength(stringpart *, objinstptr, float, short, XPoint *);
extern void undrawtext(labelptr);
extern void redrawtext(labelptr);
extern void composefontlib(short);
extern void fontcatbutton(XButtonEvent *);

/* from xcircuit.c: */

extern void printeventmode();
extern void Wprintf(char *);
extern void popupprompt(xcWidget, char *, char *, void (*function)(),
                        buttonsave *, const char *);
extern void getproptext(xcWidget, propstruct *, caddr_t);
extern int rgb_alloccolor(int, int, int);
extern void addtocolorlist(xcWidget, int);
extern void addnewcolorentry(int);
extern int xc_getlayoutcolor(int);
extern void outputpopup(xcWidget, caddr_t, caddr_t);
extern void docommand();
extern void W1printf(char *);
extern void W2printf(char *);
extern void destroypopup(xcWidget, popupstruct *, caddr_t);
extern int xc_alloccolor(char *);
extern void dointr(int);
extern void DoNothing(xcWidget, caddr_t, caddr_t);
extern u_short countchanges(char **);
extern void quitcheck(xcWidget, caddr_t, caddr_t);
extern void quit(xcWidget, caddr_t);
extern void resizetoolbar();
extern void writescalevalues(char *, char *, char *);
#ifdef TCL_WRAPPER
extern int Tcl_GetHandleFromObj(Tcl_Interp *, Tcl_Obj *, void **);
#else
extern void updatetext(xcWidget, xcWidgetList, caddr_t);
extern void delwin(xcWidget, popupstruct *, XClientMessageEvent *);
#endif

extern void makecursors();
