# Wishrc startup for ToolScript (xcircuit)
#
# load /usr/local/share/xcircuit-3.0/xcircuit.so

set path [lindex [array get env "XCIRCUIT_LIB_DIR"] 1]
if {[catch [load ${path}/xcircuit.so]]} {load ${path}/tcl/xcircuit.so}

package require Xcircuit

# It is important to make sure no magic commands overlap with Tcl built-in
# commands, because otherwise the namespace import will fail.

proc pushnamespace { name } {

   set y [namespace eval ${name} info commands ::${name}::*]
   set z [info commands]

# Watch especially for magic "wizard" commands, as we don't want to confuse
# the literal "*" with a regular expression *.  "regsub" below takes care of it.

   foreach v $y {
      regsub -all {\*} $v {\\*} i
      set x [namespace tail $i]
      if {[lsearch $z $x] < 0} { 
	 namespace import $i                       
      } else {
	 puts "Warning: ${name} command '$x' use fully-qualified name '$v'"
      }
   }
}

proc popnamespace { name } {
   set z [info commands]
   set l [expr [string length ${name}] + 5]

   while {[set v [lsearch $z ${name}_tcl_*]] >= 0} {
      set y [lindex $z $v]
      set w [string range $y $l end]
      interp alias {} ::$w {}
      rename ::$y ::$w
      puts "Info: replacing ::$w with ::$y"
   }
   namespace forget ::${name}::*
}

set auto_noexec 1	;# don't EVER call UNIX commands w/o "shell" in front

# Have we called xcircuit from tkcon?

if {[lsearch [interp aliases] tkcon] != -1} {
   set XcConsole tkcon
   wm withdraw .

# Rename conflicting TkCon commands before pushing xcircuit's namespace
   rename ::edit ::tkedit
   rename ::label ::tklabel
}

# Allow commands in the xcircuit namespace to be called from the toplevel namespace

pushnamespace xcircuit

# Overwrite Tk's bgerror procedure with our own (this just qualifies some
# Tk commands with the tk namespace so they don't try to call xcircuit commands)

source ${path}/bgerror.tcl

# Source the GUI-generating script

source ${path}/wrapper.tcl

# Run the xcircuit start function

set argv [string range $argv 1 [string length $argv]]
if {[string length $argv] == 0} {
   xcircuit::start
} else {
   xcircuit::start ${argv}
}

# Xcircuit start function drops back to interpreter after initialization & setup

if {[string range [wm title .] 0 3] == "wish"} {
   wm withdraw .
}
