#!/bin/sh
#
# This script starts xcircuit under the Tcl interpreter,
# reading commands from a special .wishrc script which
# launches magic and retains the Tcl interactive interpreter.
#

TKCON=true

for i in $@ ; do
   case $i in
      -noc*) TKCON=;;
   esac
done

loclibdir=${XCIRCUIT_LIB_DIR:="/usr/local/lib/xcircuit-3.2"}
export XCIRCUIT_LIB_DIR

if [ $TKCON ]; then

   exec ${loclibdir}/"tkcon.tcl" \
	-eval "source ${XCIRCUIT_LIB_DIR}/"console.tcl"" \
        -slave "package require Tk; set argc $#; set argv [list $*]; \
        source ${XCIRCUIT_LIB_DIR}/"xcircuit.tcl""

else

   export HOME=${loclibdir}
   if [ ! -f ${HOME}/.wishrc ]; then
      export HOME=${HOME}/tcl
   fi
   if [ ! -f ${HOME}/.wishrc ]; then
      echo "Error: no .wishrc startup file.  Check xcircuit installation"
      echo "or setenv XCIRCUIT_LIB_DIR (default ${loclibdir}) appropriately."
   fi 
#
# Make sure that the following points to your current wish
# executable, whereever it may be (this version assumes that
# "wish" is in the current search path).
#
   exec wish -- $@

fi
