//-----------------------------------------------------------------------------
// COPYRIGHT  (c)  1997 
// THE REGENTS OF THE UNIVERSITY OF MICHIGAN
// ALL RIGHTS RESERVED
// 
// PERMISSION IS GRANTED TO USE, COPY, CREATE DERIVATIVE WORKS 
// AND REDISTRIBUTE THIS SOFTWARE AND SUCH DERIVATIVE WORKS FOR 
// ANY PURPOSE, SO LONG AS NO FEE IS CHARGED, AND SO LONG AS 
// THE COPYRIGHT NOTICE ABOVE, THIS GRANT OF PERMISSION, AND 
// THE DISCLAIMER BELOW APPEAR IN ALL COPIES MADE; AND SO LONG 
// AS THE NAME OF THE UNIVERSITY OF MICHIGAN IS NOT USED IN ANY 
// ADVERTISING OR PUBLICITY PERTAINING TO THE USE OR 
// DISTRIBUTION OF THIS SOFTWARE WITHOUT SPECIFIC, WRITTEN 
// PRIOR AUTHORIZATION.
// 
// THIS SOFTWARE IS PROVIDED AS IS, WITHOUT REPRESENTATION 
// FROM THE UNIVERSITY OF MICHIGAN AS TO ITS FITNESS 
// FOR ANY PURPOSE, AND WITHOUT WARRANTY BY THE 
// UNIVERSITY OF MICHIGAN OF ANY KIND, EITHER EXPRESS OR 
// IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES 
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE 
// REGENTS OF THE UNIVERSITY OF MICHIGAN SHALL NOT BE LIABLE 
// FOR ANY DAMAGES, INCLUDING SPECIAL, INDIRECT, INCIDENTAL, OR 
// CONSEQUENTIAL DAMAGES, WITH RESPECT TO ANY CLAIM ARISING OUT 
// HAS BEEN OR IS HEREAFTER ADVISED OF THE POSSIBILITY OF SUCH 
// DAMAGES.
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// File: argument.cc
//
// Purpose: 
//
// Remarks: 
//
// History: 03/15/97 - MAR - created.
//
// Copyright (c) 1997 Michael A. Riepe
//
// RCS Version:
//     $Id: argument.cc,v 1.1.1.1 2002/05/01 14:23:27 mguthaus Exp $
//-----------------------------------------------------------------------------

#include "argument.hh"
#include <map>
#include <list>
#include <vector>
using namespace std;
// ****************************************************************************
// class: Argument
// ****************************************************************************

//-----------------------------------------------------------------------------
// Function: Argument()
//
// Purpose: Constructor.
//
// Side-effects: 
//
// Notes: 
//-----------------------------------------------------------------------------

Argument::Argument() {}


//-----------------------------------------------------------------------------
// Function: ~Argument
//
// Purpose: Destructor.
//
// Side-effects: 
//
// Notes: 
//-----------------------------------------------------------------------------

Argument::~Argument() {}


//-----------------------------------------------------------------------------
// Function: Dump
//
// Purpose: Dumps the class members to the given stream for debugging.
//
// Side-effects: 
//
// Notes: 
//-----------------------------------------------------------------------------

void Argument::dump(ostream &os) {
}


// ****************************************************************************
// class: RecursiveArgument
// ****************************************************************************

//-----------------------------------------------------------------------------
// Function: RecursiveArgument()
//
// Purpose: Constructor.  Can take either void, or a vector of recursive
//          argument members.
//
// Side-effects: 
//
// Notes: 
//-----------------------------------------------------------------------------
RecursiveArgument::RecursiveArgument() : Argument() {}

RecursiveArgument::RecursiveArgument(ArgumentVec *args) : Argument() {
    _arguments = args;
}

//-----------------------------------------------------------------------------
// Function: ~RecursiveArgument
//
// Purpose: Destructor.
//
// Side-effects: 
//
// Notes: 
//-----------------------------------------------------------------------------
RecursiveArgument::~RecursiveArgument() {
    for (int i=0; i<_arguments->size(); i++) {
        delete (*_arguments)[i];
    }
    delete _arguments;
}

//-----------------------------------------------------------------------------
// Function: Dump
//
// Purpose: Dumps the class members to the given stream for debugging.
//
// Side-effects: 
//
// Notes: 
//-----------------------------------------------------------------------------

void RecursiveArgument::dump(ostream &os) {
    for_each(arguments().begin(), arguments().end(), G_dump<Argument *>(os));
}


// ****************************************************************************
// class: IntegerArgument
// ****************************************************************************

//-----------------------------------------------------------------------------
// Function: IntegerArgument()
//
// Purpose: Constructor.  Takes an integer to add to the data field.
//
// Side-effects: 
//
// Notes: 
//-----------------------------------------------------------------------------

IntegerArgument::IntegerArgument(int data) : Argument() { _data = data; }


//-----------------------------------------------------------------------------
// Function: ~IntegerArgument
//
// Purpose: Destructor.
//
// Side-effects: 
//
// Notes: 
//-----------------------------------------------------------------------------

IntegerArgument::~IntegerArgument() {}


//-----------------------------------------------------------------------------
// Function: Dump
//
// Purpose: Dumps the class members to the given stream for debugging.
//
// Side-effects: 
//
// Notes: 
//-----------------------------------------------------------------------------

void IntegerArgument::dump(ostream &os) {
    os << _data;
}


// ****************************************************************************
// class: DoubleArgument
// ****************************************************************************

//-----------------------------------------------------------------------------
// Function: DoubleArgument()
//
// Purpose: Constructor.  Takes a double to add to the data field.
//
// Side-effects: 
//
// Notes: 
//-----------------------------------------------------------------------------

DoubleArgument::DoubleArgument(double data) : Argument() { _data = data; }


//-----------------------------------------------------------------------------
// Function: ~DoubleArgument
//
// Purpose: Destructor.
//
// Side-effects: 
//
// Notes: 
//-----------------------------------------------------------------------------

DoubleArgument::~DoubleArgument() {}


//-----------------------------------------------------------------------------
// Function: Dump
//
// Purpose: Dumps the class members to the given stream for debugging.
//
// Side-effects: 
//
// Notes: 
//-----------------------------------------------------------------------------

void DoubleArgument::dump(ostream &os) {
    os << _data;
}


// ****************************************************************************
// class: StringArgument
// ****************************************************************************

//-----------------------------------------------------------------------------
// Function: StringArgument()
//
// Purpose: Constructor.
//
// Side-effects: 
//
// Notes: 
//-----------------------------------------------------------------------------

StringArgument::StringArgument(char *data) : Argument() { _data = data; }


//-----------------------------------------------------------------------------
// Function: ~StringArgument
//
// Purpose: Destructor.
//
// Side-effects: 
//
// Notes: 
//-----------------------------------------------------------------------------

StringArgument::~StringArgument() {
    free (_data);
}


//-----------------------------------------------------------------------------
// Function: Dump
//
// Purpose: Dumps the class members to the given stream for debugging.
//
// Side-effects: 
//
// Notes: 
//-----------------------------------------------------------------------------

void StringArgument::dump(ostream &os) {
    os << _data;
}


// ****************************************************************************
// class: FunctionArgument
// ****************************************************************************

//-----------------------------------------------------------------------------
// Function: FunctionArgument()
//
// Purpose: Constructor.  Takes a string representing the function name,
//          and an optional vector of left-hand-side arguments.
//    
//
// Side-effects: 
//
// Notes: 
//-----------------------------------------------------------------------------

FunctionArgument::FunctionArgument(char* name) : RecursiveArgument() {_name = name;}
FunctionArgument::FunctionArgument(char* name, ArgumentVec *args) : RecursiveArgument(args) {
    _name = name;
}


//-----------------------------------------------------------------------------
// Function: ~FunctionArgument
//
// Purpose: Destructor.
//
// Side-effects: 
//
// Notes: 
//-----------------------------------------------------------------------------

FunctionArgument::~FunctionArgument() {
    free (_name);
}


//-----------------------------------------------------------------------------
// Function: Dump
//
// Purpose: Dumps the class members to the given stream for debugging.
//
// Side-effects: 
//
// Notes: 
//-----------------------------------------------------------------------------

void FunctionArgument::dump(ostream &os) {
    os << _name << "(";
    for_each(arguments().begin(), arguments().end(), G_dump<Argument *>(os));
    os << ")";
}


// ****************************************************************************
// class: ParameterArgument
// ****************************************************************************

//-----------------------------------------------------------------------------
// Function: ParameterArgument()
//
// Purpose: Constructor.  Takes a string representing the left-hand-side
//          (name) of the parameter, and an optional vector of right-hand-side
//          arguments.
//
// Side-effects: 
//
// Notes: 
//-----------------------------------------------------------------------------

ParameterArgument::ParameterArgument(char *lhs) : RecursiveArgument() {_lhs = lhs;}
ParameterArgument::ParameterArgument(char *lhs, ArgumentVec *args) : RecursiveArgument(args) {
    _lhs = lhs;
}


//-----------------------------------------------------------------------------
// Function: ~ParameterArgument
//
// Purpose: Destructor.
//
// Side-effects: 
//
// Notes: 
//-----------------------------------------------------------------------------
ParameterArgument::~ParameterArgument() {
    free (_lhs);
}

//-----------------------------------------------------------------------------
// Function: Dump
//
// Purpose: Dumps the class members to the given stream for debugging.
//
// Side-effects: 
//
// Notes: 
//-----------------------------------------------------------------------------

void ParameterArgument::dump(ostream &os) {
    os << _lhs<< "=";
    for_each(arguments().begin(), arguments().end(), G_dump<Argument *>(os));
}


// ****************************************************************************
// class: NodeAssignmentArgument
// ****************************************************************************

//-----------------------------------------------------------------------------
// Function: NodeAssignmentArgument()
//
// Purpose: Constructor.  Takes a left-hand-side argument and an optional
//          vector of right-hand-side arguments.
//
// Side-effects: 
//
// Notes: 
//-----------------------------------------------------------------------------

NodeAssignmentArgument::NodeAssignmentArgument(Argument *lhs) : RecursiveArgument() {
    _lhs = (FunctionArgument *)lhs;
}
NodeAssignmentArgument::NodeAssignmentArgument(Argument *lhs, ArgumentVec *args) : RecursiveArgument(args) {
    _lhs = (FunctionArgument *)lhs;
}


//-----------------------------------------------------------------------------
// Function: ~NodeAssignmentArgument
//
// Purpose: Destructor.
//
// Side-effects: 
//
// Notes: 
//-----------------------------------------------------------------------------

NodeAssignmentArgument::~NodeAssignmentArgument() {
    delete _lhs;
}


//-----------------------------------------------------------------------------
// Function: Dump
//
// Purpose: Dumps the class members to the given stream for debugging.
//
// Side-effects: 
//
// Notes: 
//-----------------------------------------------------------------------------

void NodeAssignmentArgument::dump(ostream &os) {
    _lhs->dump(os);
    os << "=";
    for_each(arguments().begin(), arguments().end(), G_dump<Argument *>(os));
}

/*****************************************************************************/
