//-----------------------------------------------------------------------------
// COPYRIGHT  (c)  1997 
// THE REGENTS OF THE UNIVERSITY OF MICHIGAN
// ALL RIGHTS RESERVED
// 
// PERMISSION IS GRANTED TO USE, COPY, CREATE DERIVATIVE WORKS 
// AND REDISTRIBUTE THIS SOFTWARE AND SUCH DERIVATIVE WORKS FOR 
// ANY PURPOSE, SO LONG AS NO FEE IS CHARGED, AND SO LONG AS 
// THE COPYRIGHT NOTICE ABOVE, THIS GRANT OF PERMISSION, AND 
// THE DISCLAIMER BELOW APPEAR IN ALL COPIES MADE; AND SO LONG 
// AS THE NAME OF THE UNIVERSITY OF MICHIGAN IS NOT USED IN ANY 
// ADVERTISING OR PUBLICITY PERTAINING TO THE USE OR 
// DISTRIBUTION OF THIS SOFTWARE WITHOUT SPECIFIC, WRITTEN 
// PRIOR AUTHORIZATION.
// 
// THIS SOFTWARE IS PROVIDED AS IS, WITHOUT REPRESENTATION 
// FROM THE UNIVERSITY OF MICHIGAN AS TO ITS FITNESS 
// FOR ANY PURPOSE, AND WITHOUT WARRANTY BY THE 
// UNIVERSITY OF MICHIGAN OF ANY KIND, EITHER EXPRESS OR 
// IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES 
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE 
// REGENTS OF THE UNIVERSITY OF MICHIGAN SHALL NOT BE LIABLE 
// FOR ANY DAMAGES, INCLUDING SPECIAL, INDIRECT, INCIDENTAL, OR 
// CONSEQUENTIAL DAMAGES, WITH RESPECT TO ANY CLAIM ARISING OUT 
// HAS BEEN OR IS HEREAFTER ADVISED OF THE POSSIBILITY OF SUCH 
// DAMAGES.
//-----------------------------------------------------------------------------

//
// file:      cmdArg.h
// purpose:   header for command argument class
// history:   7/12/94 - JPMS - Modified from the MooCAF code (by Tim Burks).
//            3/18/97 - MAR - adapted for use in cellsyn
//
// RCS Version:
//     $Id: cmdArg.hh,v 1.1.1.1 2002/05/01 14:23:27 mguthaus Exp $
//
#ifndef _CMDARG
#define _CMDARG

#include <string.h>


//
// argument class
//
class cmdArg {
public:

    // constructors

    cmdArg (void) {}
    cmdArg (char *str) { define_arg(str); }

    // destructor

    virtual ~cmdArg (void) { delete[] _ref_ptr; }

    // assignment operators

    // these seem to cause the STL vector class to break
    // cmdArg &operator= (cmdArg &arg);
    // cmdArg &operator= (char *arg);

    // data access operators

    operator char*();
    operator int();
    operator long();
    operator float();
    operator double();

    // character shifting operator

    cmdArg &operator>> (int pos);

    int isEmpty() { return(strlen(_string) == 0); }

    //-------------------------------------------------------------------------
    // used to test string values
    //-------------------------------------------------------------------------

    int matches (char *str);

    //-------------------------------------------------------------------------
    // returns original string.
    //-------------------------------------------------------------------------

    char *string();

protected:
    char *_string;
    char *_ref_ptr;

    //-------------------------------------------------------------------------
    // allocates space for string.
    //-------------------------------------------------------------------------

    void define_arg(char *str);
};

#endif









