//-----------------------------------------------------------------------------
// COPYRIGHT  (c)  1997 
// THE REGENTS OF THE UNIVERSITY OF MICHIGAN
// ALL RIGHTS RESERVED
// 
// PERMISSION IS GRANTED TO USE, COPY, CREATE DERIVATIVE WORKS 
// AND REDISTRIBUTE THIS SOFTWARE AND SUCH DERIVATIVE WORKS FOR 
// ANY PURPOSE, SO LONG AS NO FEE IS CHARGED, AND SO LONG AS 
// THE COPYRIGHT NOTICE ABOVE, THIS GRANT OF PERMISSION, AND 
// THE DISCLAIMER BELOW APPEAR IN ALL COPIES MADE; AND SO LONG 
// AS THE NAME OF THE UNIVERSITY OF MICHIGAN IS NOT USED IN ANY 
// ADVERTISING OR PUBLICITY PERTAINING TO THE USE OR 
// DISTRIBUTION OF THIS SOFTWARE WITHOUT SPECIFIC, WRITTEN 
// PRIOR AUTHORIZATION.
// 
// THIS SOFTWARE IS PROVIDED AS IS, WITHOUT REPRESENTATION 
// FROM THE UNIVERSITY OF MICHIGAN AS TO ITS FITNESS 
// FOR ANY PURPOSE, AND WITHOUT WARRANTY BY THE 
// UNIVERSITY OF MICHIGAN OF ANY KIND, EITHER EXPRESS OR 
// IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES 
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE 
// REGENTS OF THE UNIVERSITY OF MICHIGAN SHALL NOT BE LIABLE 
// FOR ANY DAMAGES, INCLUDING SPECIAL, INDIRECT, INCIDENTAL, OR 
// CONSEQUENTIAL DAMAGES, WITH RESPECT TO ANY CLAIM ARISING OUT 
// HAS BEEN OR IS HEREAFTER ADVISED OF THE POSSIBILITY OF SUCH 
// DAMAGES.
//-----------------------------------------------------------------------------

//
// file:      cmdLine.h
// purpose:   declarations for command line class
//
// Author: Joao Paulo Silva
//
// RCS Version:
//     $Id: cmdLine.hh,v 1.1.1.1 2002/05/01 14:23:27 mguthaus Exp $
//
#ifndef _CMDLINE
#define _CMDLINE

#include <iostream.h>

#include <stl.h>
#include "cmdArg.hh"

//
// command line class -- a primitive command parser
//
class cmdLine { 
    enum {MAXARGS = 100};	      // maximum number of cmd arguments
    int _size;			      // actual number of arguments
    vector<cmdArg *> args;              // vector of arguments
    static const int commandBufferSize;   // size of command text buffer
    static cmdArg dummy;              // used for out-of-range accesses
public:
    //
    // parse a command
    //
    void parse (char *str);
    // 
    // constructors
    //
    cmdLine (int argc, char *argv[]); 
    cmdLine (char *a) : args (MAXARGS), _size (0) {parse (a);}
    cmdLine (void) : args (MAXARGS) , _size (0) {}
    cmdLine (const cmdLine& cmd) : args (cmd.args), _size (cmd._size) {}
    cmdLine& operator= (const cmdLine& cmd) {
	args = cmd.args; _size = cmd._size; return *this;}
    //
    // destructor
    //
    virtual ~cmdLine (void) { for (int i=0; i<args.size(); i++) delete args[i]; }
    //
    // access command arguments
    //
    cmdArg& operator[] (int index);
    int size (void) const {return _size;}
    //
    // stream i/o methods
    //
    friend ostream& operator<< (ostream& stream, cmdLine &command);
    friend istream& operator>> (istream& stream, cmdLine &command);
};

#endif

