//-----------------------------------------------------------------------------
// COPYRIGHT  (c)  1997 
// THE REGENTS OF THE UNIVERSITY OF MICHIGAN
// ALL RIGHTS RESERVED
// 
// PERMISSION IS GRANTED TO USE, COPY, CREATE DERIVATIVE WORKS 
// AND REDISTRIBUTE THIS SOFTWARE AND SUCH DERIVATIVE WORKS FOR 
// ANY PURPOSE, SO LONG AS NO FEE IS CHARGED, AND SO LONG AS 
// THE COPYRIGHT NOTICE ABOVE, THIS GRANT OF PERMISSION, AND 
// THE DISCLAIMER BELOW APPEAR IN ALL COPIES MADE; AND SO LONG 
// AS THE NAME OF THE UNIVERSITY OF MICHIGAN IS NOT USED IN ANY 
// ADVERTISING OR PUBLICITY PERTAINING TO THE USE OR 
// DISTRIBUTION OF THIS SOFTWARE WITHOUT SPECIFIC, WRITTEN 
// PRIOR AUTHORIZATION.
// 
// THIS SOFTWARE IS PROVIDED AS IS, WITHOUT REPRESENTATION 
// FROM THE UNIVERSITY OF MICHIGAN AS TO ITS FITNESS 
// FOR ANY PURPOSE, AND WITHOUT WARRANTY BY THE 
// UNIVERSITY OF MICHIGAN OF ANY KIND, EITHER EXPRESS OR 
// IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES 
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE 
// REGENTS OF THE UNIVERSITY OF MICHIGAN SHALL NOT BE LIABLE 
// FOR ANY DAMAGES, INCLUDING SPECIAL, INDIRECT, INCIDENTAL, OR 
// CONSEQUENTIAL DAMAGES, WITH RESPECT TO ANY CLAIM ARISING OUT 
// HAS BEEN OR IS HEREAFTER ADVISED OF THE POSSIBILITY OF SUCH 
// DAMAGES.
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// File: hparse.cc
//
// Purpose: 
//
// Remarks: 
//
// History: 03/18/97 - MAR - created.
//          05/06/02 - MRG - modified.
//
// Copyright (c) 1997 Michael A. Riepe
// Copyright (c) 2002 Matthew R. Guthaus
//
// RCS Version:
//     $Id: hparse.cc,v 1.2 2002/05/06 12:55:45 mguthaus Exp $
//-----------------------------------------------------------------------------

#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <fstream.h>
#include <vector>
#include <map>
#include <list>
using namespace std;

#include "defs.hh"
#include "utils.hh"
#include "time.hh"
#include "appMode.hh"
#include "appCmds.hh"
#include "circuit.hh"
#include "hspice_parser.hh"
#include "hparse.hh"

//-----------------------------------------------------------------------------
// Definition of keyword string to allow use of rcs keyword substitution.
// This will embed rcs ID string in the binary.  The RCS 'ident' command, and
// the SCCS 'what' command can be used to extract this from the binary.
//-----------------------------------------------------------------------------

static char *rcsid="@(#) $Id: hparse.cc,v 1.2 2002/05/06 12:55:45 mguthaus Exp $";

// The following lines will prevent `gcc' version 2.X
// from issuing an "unused variable" warning.

#if __GNUC__ == 2
#define USE(var) static void *use_##var = (&use_##var, (void *) &var)
USE (rcsid);
#endif

//-----------------------------------------------------------------------------
// Function: main
//
// Purpose: Top-level actions of hparse
//-----------------------------------------------------------------------------

main(int argc, char **argv)
{
    DBG1(cout << "-> Entering ::main()." << endl;);
    setTrailString("hparse");

    char *fname;
    char *files;
    Timer *time;
    appMode *mode;
    appCmds *cmd;
    circuit *netlist;
    hspice_parser *nlParser;

    time = new Timer;
    mode = new appMode;         
    mode->setup();
    cmd = new appCmds(*mode);

    // parse command line options
    if (!(fname = cmd->cmdLineParse (argc, argv))) {
	Abort("No file name specified, type 'hparse -h' for usage");
    }

    // initialize component classes
    netlist = new circuit(fname);
    nlParser = new hspice_parser(*netlist);

    // parse the input spice netlist
    // files.push_back(fname);
    // if (!nlParser->parse(&files)) {
    //    cout << "\n    File name: " << fname << endl;
    //    Abort("Cannot open input file");
    // }

    ofstream netout("netlist.sp");
    netout << *netlist;
    netout.close();

    printTime ("Finished parsing input", time->elapsedTime(), "Elapsed");
    if (mode->int_mode(_DEBUG_) >= 1) netlist->dump(cout);
    delete time;
    time = new Timer;

    // flatten the spice netlist

    circuit *flatnetlist=new circuit;
    flatnetlist->flatten(netlist);

    // ofstream flatout("netlist-flat.sp");
    // flatout << *flatnetlist;
    // flatout.close();

    // printTime ("Finished flattening netlist", time->elapsedTime(), "Elapsed");
    // clean up

    delete nlParser;
    delete netlist;
    delete cmd;
    delete mode;
    delete time;
    delete flatnetlist;

    exit(0);
}

/*****************************************************************************/
