#ifndef lint
static char const 
yyrcsid[] = "$FreeBSD: src/usr.bin/yacc/skeleton.c,v 1.28 2000/01/17 02:04:06 bde Exp $";
#endif
#include <stdlib.h>
#define YYBYACC 1
#define YYMAJOR 1
#define YYMINOR 9
#define YYLEX yylex()
#define YYEMPTY -1
#define yyclearin (yychar=(YYEMPTY))
#define yyerrok (yyerrflag=0)
#define YYRECOVERING() (yyerrflag!=0)
static int yygrowstack();
#define YYPREFIX "yy"
#line 2 "spice.y"
/* -----------------------------------------------------------------------------
* COPYRIGHT  (c)  1997 
* THE REGENTS OF THE UNIVERSITY OF MICHIGAN
* ALL RIGHTS RESERVED
* 
* PERMISSION IS GRANTED TO USE, COPY, CREATE DERIVATIVE WORKS 
* AND REDISTRIBUTE THIS SOFTWARE AND SUCH DERIVATIVE WORKS FOR 
* ANY PURPOSE, SO LONG AS NO FEE IS CHARGED, AND SO LONG AS 
* THE COPYRIGHT NOTICE ABOVE, THIS GRANT OF PERMISSION, AND 
* THE DISCLAIMER BELOW APPEAR IN ALL COPIES MADE; AND SO LONG 
* AS THE NAME OF THE UNIVERSITY OF MICHIGAN IS NOT USED IN ANY 
* ADVERTISING OR PUBLICITY PERTAINING TO THE USE OR 
* DISTRIBUTION OF THIS SOFTWARE WITHOUT SPECIFIC, WRITTEN 
* PRIOR AUTHORIZATION.
* 
* THIS SOFTWARE IS PROVIDED AS IS, WITHOUT REPRESENTATION 
* FROM THE UNIVERSITY OF MICHIGAN AS TO ITS FITNESS 
* FOR ANY PURPOSE, AND WITHOUT WARRANTY BY THE 
* UNIVERSITY OF MICHIGAN OF ANY KIND, EITHER EXPRESS OR 
* IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE 
* REGENTS OF THE UNIVERSITY OF MICHIGAN SHALL NOT BE LIABLE 
* FOR ANY DAMAGES, INCLUDING SPECIAL, INDIRECT, INCIDENTAL, OR 
* CONSEQUENTIAL DAMAGES, WITH RESPECT TO ANY CLAIM ARISING OUT 
* HAS BEEN OR IS HEREAFTER ADVISED OF THE POSSIBILITY OF SUCH 
* DAMAGES.
----------------------------------------------------------------------------- */

/**************************************************************************************
 * File: spice.y
 *
 * Purpose: parser for spicedeck, intended to gnu bison.
 *
 * Author: Michael A Riepe
 *	   Stephen T. Frezza (STF)
 *
 * RCS Version:
 *     $Id: spice.y,v 1.1.1.1 2002/05/01 14:23:27 mguthaus Exp $
 **************************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <strings.h>
#include <stream.h>
#include <stl>		/* Modified to support g++-3 instalations*/
#include "defs.hh"
#include "utils.hh"
#include "macros.hh"
#include "argument.hh"
#include "circuit.hh"
#include "hspice_parser.hh"
    
/* externs*/
extern FILE *yyin;

/* forward declarations*/
double adjust_number (double arg, char *unit);
void yyerror(char *s);
int yywrap();
extern int yylex();
extern int yy_flex_debug; 

/* global variables*/
static unsigned currentFile;
static vector<char*> *fileList;
static unsigned nFiles;
static circuit *yyCircuit;

#line 73 "spice.y"
typedef union {
    int dval;
    double rval;
    char *sval;
    char cval;
    Argument *aval;
    ArgumentVec *av_val;
} YYSTYPE;
#line 96 "y.tab.c"
#define YYERRCODE 256
#define TITLE 257
#define COMMENT 258
#define CAPACITOR 259
#define DIODE 260
#define ISOURCE 261
#define JFET 262
#define INDUCTOR 263
#define MOSFET 264
#define BJT 265
#define COUPLING 266
#define RESISTOR 267
#define VSOURCE 268
#define SUBCKTINST 269
#define SUBCKT 270
#define ALTER 271
#define CONTROL 272
#define DATA 273
#define DCVOLT 274
#define DELLIB 275
#define END 276
#define ENDDATA 277
#define ENDL 278
#define ENDS 279
#define GLOBAL 280
#define ICVOLT 281
#define LIB 282
#define MODEL 283
#define NODESET 284
#define OPTIONS 285
#define PARAM 286
#define PC 287
#define PROTECT 288
#define SYSTEM 289
#define UNPROTECT 290
#define WIDTH 291
#define ACSWEEP 292
#define DCSWEEP 293
#define FOURIER 294
#define NET 295
#define DISTORTION 296
#define NOISE 297
#define OPPOINT 298
#define POLEZERO 299
#define SAMPLE 300
#define SENS 301
#define TEMP 302
#define TRANSFER 303
#define TRAN 304
#define MEASURE 305
#define GRAPH 306
#define PLOT 307
#define PRINT 308
#define ARGIDENT 309
#define ARGINT 310
#define ARGDECIMAL 311
#define ARGFLOAT 312
#define ARGUNIT 313
#define ARGSEND 314
#define OPENQUOTE 315
#define CLOSEQUOTE 316
#define QUOTESTRING 317
const short yylhs[] = {                                        -1,
    0,    0,   14,   14,   14,   14,   14,   14,   15,   15,
   15,   15,   15,   15,   15,   15,   15,   15,   15,   16,
   17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
   17,   17,   17,   17,   17,   17,   17,   17,   17,   17,
   18,   18,   18,   18,   18,   18,   18,   18,   18,   18,
   18,   18,   18,   19,   19,   19,   19,   20,   20,   21,
   22,   23,   24,   31,   25,   26,   27,   28,   29,   30,
   32,   33,   34,   35,   36,   37,   38,   38,   39,   40,
   41,   42,   43,   44,   44,   44,   45,   46,   47,   48,
   49,   50,   51,   52,   53,   54,   55,   56,   57,   58,
   59,   59,   60,   61,   62,   63,   64,   65,   66,   67,
   68,   69,   70,   71,    1,    1,    2,    2,    2,    3,
    3,    4,    4,    5,    5,    5,    5,    5,    5,    5,
    5,    6,    6,    6,    7,    8,    9,   10,   11,   11,
   12,   13,   13,
};
const short yylen[] = {                                         2,
    1,    2,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    3,
    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
    3,    1,    3,    3,    3,    3,    3,    2,    3,    3,
    3,    3,    3,    4,    5,    7,    3,    3,    3,    3,
    1,    3,    1,    3,    3,    3,    3,    3,    3,    3,
    2,    3,    3,    3,    3,    3,    3,    3,    3,    3,
    3,    3,    1,    1,    1,    2,    1,    2,    3,    1,
    2,    1,    1,    1,    2,    1,    2,    2,    1,    1,
    1,    1,    1,    1,    4,    3,    3,    3,    1,    3,
    1,    0,    1,
};
const short yydefred[] = {                                      0,
  113,  114,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   72,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   91,    0,   93,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    1,    3,    4,    5,    6,    7,    8,    9,
   10,   11,   12,   13,   14,   15,   16,   17,   18,   19,
   20,   21,   22,   23,   24,   25,   26,   27,   28,   29,
   30,   31,   32,   33,   34,   35,   36,   37,   38,   39,
   40,   41,   42,   43,   44,   45,   46,   47,   48,   49,
   50,   51,   52,   53,   54,   55,   56,   57,   58,   59,
    0,    0,    0,  130,    0,    0,  115,  122,  123,    0,
  133,  134,  131,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   78,    0,
    0,  143,    0,    0,    0,    0,  124,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  101,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    2,    0,    0,  125,  127,  128,    0,   61,
  116,    0,   62,   65,   66,   63,   67,   60,   64,   68,
   70,   69,   71,   73,   74,   75,   76,   77,   79,   80,
   81,   82,   83,    0,   87,   88,   89,   90,   92,   94,
   95,   96,   97,   98,   99,  100,  102,  103,  104,  105,
  106,  107,  108,  109,  110,  111,  112,    0,  117,  141,
    0,  139,  138,    0,    0,   84,    0,    0,  120,  135,
    0,  118,    0,    0,   85,  121,  119,  140,    0,   86,
};
const short yydgoto[] = {                                      52,
  116,  228,  238,  117,  118,  119,  120,  121,  122,  123,
  231,  232,  143,   53,   54,   55,   56,   57,   58,   59,
   60,   61,   62,   63,   64,   65,   66,   67,   68,   69,
   70,   71,   72,   73,   74,   75,   76,   77,   78,   79,
   80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
   90,   91,   92,   93,   94,   95,   96,   97,   98,   99,
  100,  101,  102,  103,  104,  105,  106,  107,  108,  109,
  110,
};
const short yysindex[] = {                                     44,
    0,    0, -155, -155, -155, -155, -155, -155, -155, -155,
 -155, -155, -155, -155,    0, -155, -155, -155, -155, -165,
 -155, -303, -155, -155, -155,  283, -155, -155, -155, -155,
    0, -155,    0, -155, -155, -155, -155, -155, -155, -155,
 -129, -155, -155, -155, -155, -155, -155, -155, -155, -155,
 -155,   44,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  -16,  -56, -301,    0, -307, -122,    0,    0,    0,  -48,
    0,    0,    0, -115, -108, -101,  -88,  -81,  -69,  -62,
  -51,   45,   52,   59,   66, -136,   73,   80,    0,   87,
   94,    0, -298,  101,  108,  115,    0,  283,  122,  129,
  136,  143,  150,  157,  164,  171,  178,  185,  192,  199,
    0,  206,  213,  220,  227,  234,  241,  248,  255,  262,
  269,  276,    0,  283,  283,    0,    0,    0, -299,    0,
    0,  283,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  -14,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  -19,    0,    0,
  -24,    0,    0,  -24,  -43,    0, -288, -300,    0,    0,
  283,    0,  283,  -36,    0,    0,    0,    0, -291,    0,
};
const short yyrindex[] = {                                      0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, -272,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 -179,  -40,  -33,    0,    0,    0,    0,    0,    0, -172,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  -26,    0,    0, -148,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
};
const short yygindex[] = {                                      0,
   72,    0, -191,  -97,  -23,    0,    0, -110,    0,    0,
 -132, -192,    0,   12,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,
};
#define YYTABLESIZE 598
const short yytable[] = {                                     126,
  126,  177,  148,  126,  249,  142,  129,  129,  235,  179,
  129,  178,  182,  245,  136,  200,  233,  175,  181,  243,
  235,  240,  250,  174,  241,  237,  181,  181,  181,  181,
  181,  181,  181,  181,  181,  181,  181,  181,  181,  181,
  181,  142,  181,  181,  175,  244,  181,  181,  181,  234,
  248,  181,  181,  181,  181,  181,  181,  181,  181,  181,
  181,  181,  181,  173,  181,  181,  181,  181,  181,  181,
  181,  181,  181,  181,  181,  124,  125,  126,  127,  128,
  129,  130,  131,  132,  133,  134,    0,  135,  136,  137,
  138,  140,  141,  239,  144,  145,  146,  124,  149,  150,
  151,  152,    0,  153,  132,  154,  155,  156,  157,  158,
  159,  160,  162,  163,  164,  165,  166,  167,  168,  169,
  170,  171,  172,    0,  204,    0,  239,  246,  137,  124,
  124,  124,  124,  246,  124,  124,  132,  132,  132,  132,
  195,  132,  132,  111,  112,  113,  114,    0,  139,  115,
  229,  230,    0,  111,  112,  113,  114,    0,  230,  115,
  137,  137,  137,  137,    0,  137,  137,    0,    0,    0,
    0,    0,  111,  112,  113,  114,    0,    0,  115,  111,
  112,  113,  114,    0,  161,  115,  111,  112,  113,  114,
    0,  180,  115,  111,  112,  113,  114,    0,  183,  115,
  111,  112,  113,  114,  242,  184,  115,  111,  112,  113,
  114,    0,  185,  115,    0,    0,    0,  247,    0,  230,
  111,  112,  113,  114,    0,  186,  115,  111,  112,  113,
  114,    0,  187,  115,    0,    0,  126,    0,    0,  111,
  112,  113,  114,  129,  188,  115,  111,  112,  113,  114,
  136,  189,  115,    0,    0,    0,  176,  111,  112,  113,
  114,    0,  190,  115,    0,    0,    0,    0,  126,  126,
  126,  126,  235,  126,  126,  129,  129,  129,  129,    0,
  129,  129,  136,  136,  136,  136,    0,  136,  136,  147,
  112,  113,  114,    0,  235,  115,    0,    0,    0,  236,
    1,    2,    3,    4,    5,    6,    7,    8,    9,   10,
   11,   12,   13,   14,   15,   16,   17,   18,   19,   20,
    0,   21,   22,   23,   24,   25,   26,   27,   28,   29,
   30,   31,   32,   33,   34,   35,   36,   37,   38,   39,
   40,   41,   42,   43,   44,   45,   46,   47,   48,   49,
   50,   51,    0,  111,  112,  113,  114,    0,  191,  115,
  111,  112,  113,  114,    0,  192,  115,  111,  112,  113,
  114,    0,  193,  115,  111,  112,  113,  114,    0,  194,
  115,  111,  112,  113,  114,    0,  196,  115,  111,  112,
  113,  114,    0,  197,  115,  111,  112,  113,  114,    0,
  198,  115,  111,  112,  113,  114,    0,  199,  115,  111,
  112,  113,  114,    0,  201,  115,  111,  112,  113,  114,
    0,  202,  115,  111,  112,  113,  114,    0,  203,  115,
  111,  112,  113,  114,    0,  205,  115,  111,  112,  113,
  114,    0,  206,  115,  111,  112,  113,  114,    0,  207,
  115,  111,  112,  113,  114,    0,  208,  115,  111,  112,
  113,  114,    0,  209,  115,  111,  112,  113,  114,    0,
  210,  115,  111,  112,  113,  114,    0,  211,  115,  111,
  112,  113,  114,    0,  212,  115,  111,  112,  113,  114,
    0,  213,  115,  111,  112,  113,  114,    0,  214,  115,
  111,  112,  113,  114,    0,  215,  115,  111,  112,  113,
  114,    0,  216,  115,  111,  112,  113,  114,    0,  217,
  115,  111,  112,  113,  114,    0,  218,  115,  111,  112,
  113,  114,    0,  219,  115,  111,  112,  113,  114,    0,
  220,  115,  111,  112,  113,  114,    0,  221,  115,  111,
  112,  113,  114,    0,  222,  115,  111,  112,  113,  114,
    0,  223,  115,  111,  112,  113,  114,    0,  224,  115,
  111,  112,  113,  114,    0,  225,  115,  111,  112,  113,
  114,    0,  226,  115,  111,  112,  113,  114,    0,  227,
  115,  147,  112,  113,  114,    0,    0,  115,
};
const short yycheck[] = {                                      40,
   41,   58,   26,   44,   41,  309,   40,   41,  309,  317,
   44,  313,   61,  314,   41,  314,  316,   61,  116,   44,
  309,   41,  314,   40,   44,   40,  124,  125,  126,  127,
  128,  129,  130,  131,  132,  133,  134,  135,  136,  137,
  138,  314,  140,  141,   61,  237,  144,  145,  146,  182,
  243,  149,  150,  151,  152,  153,  154,  155,  156,  157,
  158,  159,  160,   52,  162,  163,  164,  165,  166,  167,
  168,  169,  170,  171,  172,    4,    5,    6,    7,    8,
    9,   10,   11,   12,   13,   14,   -1,   16,   17,   18,
   19,   20,   21,  204,   23,   24,   25,  277,   27,   28,
   29,   30,   -1,   32,  277,   34,   35,   36,   37,   38,
   39,   40,   41,   42,   43,   44,   45,   46,   47,   48,
   49,   50,   51,   -1,  148,   -1,  237,  238,  277,  309,
  310,  311,  312,  244,  314,  315,  309,  310,  311,  312,
  277,  314,  315,  309,  310,  311,  312,   -1,  314,  315,
  174,  175,   -1,  309,  310,  311,  312,   -1,  182,  315,
  309,  310,  311,  312,   -1,  314,  315,   -1,   -1,   -1,
   -1,   -1,  309,  310,  311,  312,   -1,   -1,  315,  309,
  310,  311,  312,   -1,  314,  315,  309,  310,  311,  312,
   -1,  314,  315,  309,  310,  311,  312,   -1,  314,  315,
  309,  310,  311,  312,  228,  314,  315,  309,  310,  311,
  312,   -1,  314,  315,   -1,   -1,   -1,  241,   -1,  243,
  309,  310,  311,  312,   -1,  314,  315,  309,  310,  311,
  312,   -1,  314,  315,   -1,   -1,  277,   -1,   -1,  309,
  310,  311,  312,  277,  314,  315,  309,  310,  311,  312,
  277,  314,  315,   -1,   -1,   -1,  313,  309,  310,  311,
  312,   -1,  314,  315,   -1,   -1,   -1,   -1,  309,  310,
  311,  312,  309,  314,  315,  309,  310,  311,  312,   -1,
  314,  315,  309,  310,  311,  312,   -1,  314,  315,  309,
  310,  311,  312,   -1,  309,  315,   -1,   -1,   -1,  314,
  257,  258,  259,  260,  261,  262,  263,  264,  265,  266,
  267,  268,  269,  270,  271,  272,  273,  274,  275,  276,
   -1,  278,  279,  280,  281,  282,  283,  284,  285,  286,
  287,  288,  289,  290,  291,  292,  293,  294,  295,  296,
  297,  298,  299,  300,  301,  302,  303,  304,  305,  306,
  307,  308,   -1,  309,  310,  311,  312,   -1,  314,  315,
  309,  310,  311,  312,   -1,  314,  315,  309,  310,  311,
  312,   -1,  314,  315,  309,  310,  311,  312,   -1,  314,
  315,  309,  310,  311,  312,   -1,  314,  315,  309,  310,
  311,  312,   -1,  314,  315,  309,  310,  311,  312,   -1,
  314,  315,  309,  310,  311,  312,   -1,  314,  315,  309,
  310,  311,  312,   -1,  314,  315,  309,  310,  311,  312,
   -1,  314,  315,  309,  310,  311,  312,   -1,  314,  315,
  309,  310,  311,  312,   -1,  314,  315,  309,  310,  311,
  312,   -1,  314,  315,  309,  310,  311,  312,   -1,  314,
  315,  309,  310,  311,  312,   -1,  314,  315,  309,  310,
  311,  312,   -1,  314,  315,  309,  310,  311,  312,   -1,
  314,  315,  309,  310,  311,  312,   -1,  314,  315,  309,
  310,  311,  312,   -1,  314,  315,  309,  310,  311,  312,
   -1,  314,  315,  309,  310,  311,  312,   -1,  314,  315,
  309,  310,  311,  312,   -1,  314,  315,  309,  310,  311,
  312,   -1,  314,  315,  309,  310,  311,  312,   -1,  314,
  315,  309,  310,  311,  312,   -1,  314,  315,  309,  310,
  311,  312,   -1,  314,  315,  309,  310,  311,  312,   -1,
  314,  315,  309,  310,  311,  312,   -1,  314,  315,  309,
  310,  311,  312,   -1,  314,  315,  309,  310,  311,  312,
   -1,  314,  315,  309,  310,  311,  312,   -1,  314,  315,
  309,  310,  311,  312,   -1,  314,  315,  309,  310,  311,
  312,   -1,  314,  315,  309,  310,  311,  312,   -1,  314,
  315,  309,  310,  311,  312,   -1,   -1,  315,
};
#define YYFINAL 52
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 317
#if YYDEBUG
const char * const yyname[] = {
"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,"'('","')'","'*'","'+'","','","'-'",0,"'/'",0,0,0,0,0,0,0,0,0,0,
"':'",0,0,"'='",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,"TITLE","COMMENT","CAPACITOR","DIODE","ISOURCE","JFET","INDUCTOR",
"MOSFET","BJT","COUPLING","RESISTOR","VSOURCE","SUBCKTINST","SUBCKT","ALTER",
"CONTROL","DATA","DCVOLT","DELLIB","END","ENDDATA","ENDL","ENDS","GLOBAL",
"ICVOLT","LIB","MODEL","NODESET","OPTIONS","PARAM","PC","PROTECT","SYSTEM",
"UNPROTECT","WIDTH","ACSWEEP","DCSWEEP","FOURIER","NET","DISTORTION","NOISE",
"OPPOINT","POLEZERO","SAMPLE","SENS","TEMP","TRANSFER","TRAN","MEASURE","GRAPH",
"PLOT","PRINT","ARGIDENT","ARGINT","ARGDECIMAL","ARGFLOAT","ARGUNIT","ARGSEND",
"OPENQUOTE","CLOSEQUOTE","QUOTESTRING",
};
const char * const yyrule[] = {
"$accept : statement_list",
"statement_list : statement",
"statement_list : statement_list statement",
"statement : device",
"statement : subcircuit",
"statement : control_card",
"statement : analysis_card",
"statement : output_card",
"statement : other",
"device : bjt",
"device : capacitor",
"device : diode",
"device : inductor",
"device : isource",
"device : jfet",
"device : mosfet",
"device : resistor",
"device : subcktinst",
"device : vsource",
"device : coupling",
"subcircuit : subckt",
"control_card : alter",
"control_card : control",
"control_card : data",
"control_card : dcvolt",
"control_card : dellib",
"control_card : end",
"control_card : endl",
"control_card : ends",
"control_card : global",
"control_card : icvolt",
"control_card : lib",
"control_card : model",
"control_card : nodeset",
"control_card : options",
"control_card : param",
"control_card : pc",
"control_card : protect",
"control_card : system",
"control_card : unprotect",
"control_card : width",
"analysis_card : acsweep",
"analysis_card : dcsweep",
"analysis_card : fourier",
"analysis_card : net",
"analysis_card : distortion",
"analysis_card : noise",
"analysis_card : oppoint",
"analysis_card : polezero",
"analysis_card : sample",
"analysis_card : sens",
"analysis_card : temp",
"analysis_card : transfer",
"analysis_card : tran",
"output_card : measure",
"output_card : graph",
"output_card : plot",
"output_card : print",
"other : title",
"other : comment",
"bjt : BJT argument_list ARGSEND",
"capacitor : CAPACITOR argument_list ARGSEND",
"diode : DIODE argument_list ARGSEND",
"inductor : INDUCTOR argument_list ARGSEND",
"coupling : COUPLING argument_list ARGSEND",
"isource : ISOURCE argument_list ARGSEND",
"jfet : JFET argument_list ARGSEND",
"mosfet : MOSFET argument_list ARGSEND",
"resistor : RESISTOR argument_list ARGSEND",
"subcktinst : SUBCKTINST argument_list ARGSEND",
"vsource : VSOURCE argument_list ARGSEND",
"subckt : SUBCKT argument_list ARGSEND",
"alter : ALTER",
"control : CONTROL argument_list ARGSEND",
"data : DATA argument_list ENDDATA",
"dcvolt : DCVOLT argument_list ARGSEND",
"dellib : DELLIB argument_list ARGSEND",
"end : END argument_list ARGSEND",
"end : END ARGSEND",
"endl : ENDL argument_list ARGSEND",
"ends : ENDS ends_arg ARGSEND",
"global : GLOBAL argument_list ARGSEND",
"icvolt : ICVOLT argument_list ARGSEND",
"lib : LIB argument_list ARGSEND",
"model : MODEL simple_arg simple_arg ARGSEND",
"model : MODEL simple_arg simple_arg parameter_list ARGSEND",
"model : MODEL simple_arg simple_arg '(' parameter_list ')' ARGSEND",
"nodeset : NODESET argument_list ARGSEND",
"options : OPTIONS argument_list ARGSEND",
"param : PARAM argument_list ARGSEND",
"pc : PC argument_list ARGSEND",
"protect : PROTECT",
"system : SYSTEM argument_list ARGSEND",
"unprotect : UNPROTECT",
"width : WIDTH argument_list ARGSEND",
"acsweep : ACSWEEP argument_list ARGSEND",
"dcsweep : DCSWEEP argument_list ARGSEND",
"fourier : FOURIER argument_list ARGSEND",
"net : NET argument_list ARGSEND",
"distortion : DISTORTION argument_list ARGSEND",
"noise : NOISE argument_list ARGSEND",
"oppoint : OPPOINT ARGSEND",
"oppoint : OPPOINT argument_list ARGSEND",
"polezero : POLEZERO argument_list ARGSEND",
"sample : SAMPLE argument_list ARGSEND",
"sens : SENS argument_list ARGSEND",
"temp : TEMP argument_list ARGSEND",
"transfer : TRANSFER argument_list ARGSEND",
"tran : TRAN argument_list ARGSEND",
"measure : MEASURE argument_list ARGSEND",
"graph : GRAPH argument_list ARGSEND",
"plot : PLOT argument_list ARGSEND",
"print : PRINT argument_list ARGSEND",
"title : TITLE",
"comment : COMMENT",
"argument_list : argument",
"argument_list : argument_list argument",
"simple_argument_list : simple_arg",
"simple_argument_list : simple_argument_list simple_arg",
"simple_argument_list : simple_argument_list ',' simple_arg",
"parameter_list : parameter",
"parameter_list : parameter_list parameter",
"argument : simple_arg",
"argument : complex_arg",
"simple_arg : ARGIDENT",
"simple_arg : ARGINT ARGUNIT",
"simple_arg : ARGINT",
"simple_arg : ARGINT ':'",
"simple_arg : ARGDECIMAL ARGUNIT",
"simple_arg : ARGDECIMAL",
"simple_arg : ARGFLOAT",
"simple_arg : quoted_string",
"complex_arg : function",
"complex_arg : parameter",
"complex_arg : node_assignment",
"function : ARGIDENT '(' simple_argument_list ')'",
"parameter : ARGIDENT '=' param_list",
"node_assignment : function '=' param_list",
"quoted_string : OPENQUOTE QUOTESTRING CLOSEQUOTE",
"param_list : param_val",
"param_list : param_list ',' param_val",
"param_val : simple_arg",
"ends_arg :",
"ends_arg : ARGIDENT",
};
#endif
#if YYDEBUG
#include <stdio.h>
#endif
#ifdef YYSTACKSIZE
#undef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 10000
#define YYMAXDEPTH 10000
#endif
#endif
#define YYINITSTACKSIZE 200
int yydebug;
int yynerrs;
int yyerrflag;
int yychar;
short *yyssp;
YYSTYPE *yyvsp;
YYSTYPE yyval;
YYSTYPE yylval;
short *yyss;
short *yysslim;
YYSTYPE *yyvs;
int yystacksize;
#line 1098 "spice.y"

//
// global functions for yacc and flex generated code
//

// takes a double number and multiplies it by an appropriate
// scaling factor specified by the "unit" sting
double adjust_number (double num, char *unit) {

    if (!strncmp("MEG",unit,3)) {
        num *= pow(10.0,6.0);
    }
    else if (!strncmp("MI",unit,2)) {
        num *= (25.40 * pow(10,6.0));
    }
    else {
        switch(unit[0]) {
            case 'F':
            case 'f':
                num *= pow(10.0,-15.0);
                break;
            case 'P':
            case 'p':
                num *= pow(10.0,-12.0);
                break;
            case 'N':
            case 'n':
                num *= pow(10.0,-9.0);
                break;
            case 'U':
            case 'u':
                num *= pow(10.0,-6.0);
                break;
            case 'M':
            case 'm':
                num *= pow(10.0,-3.0);
                break;
            case 'K':
            case 'k':
                num *= pow(10.0,3.0);
                break;
            case 'G':
            case 'g':
                num *= pow(10.0,9.0);
                break;
            default:
                break;
        }
    }
    return num;
}        

// override default error reporting
void yyerror(char *msg) {
    extern int lineno;   // from flex lexer
    extern char *yytext; // from flex lexer

    fprintf(stderr, "line #%d: %s at '%s'\n",lineno,msg,yytext);
}

// override default yyin file
int yywrap() {

    FILE *file = 0;

    if ((currentFile != 0) && (nFiles > 1) && (currentFile < nFiles))
        fclose(yyin);

    while (currentFile < nFiles){
        file = fopen((*fileList)[currentFile++], "r");
        if (file != NULL) {
            yyin = file;
            break;
        }
        sprintf(error_msg, "could not open %s\n",(*fileList)[currentFile-1]);
        Abort(error_msg);
    }
    return (file ? 0 : 1);
}

// class method that calls the yacc parser
int hspice_parser::parse (vector<char*> *files) {

    currentFile = 0;
    fileList = files;
    nFiles = fileList->size();

    yyCircuit = &_circuit;
    
    // debugging
    yy_flex_debug = 0;   // enables debugging in flex when called with -d  flag
    yydebug = 0;         // enables debugging in yacc when called with -t flag
           
    if (nFiles < 1)
        return 0;

    yywrap();
    while (!feof(yyin)) {
        yyparse();
    }
    return 1;
}
#line 719 "y.tab.c"
/* allocate initial stack or double stack size, up to YYMAXDEPTH */
static int yygrowstack()
{
    int newsize, i;
    short *newss;
    YYSTYPE *newvs;

    if ((newsize = yystacksize) == 0)
        newsize = YYINITSTACKSIZE;
    else if (newsize >= YYMAXDEPTH)
        return -1;
    else if ((newsize *= 2) > YYMAXDEPTH)
        newsize = YYMAXDEPTH;
    i = yyssp - yyss;
    newss = yyss ? (short *)realloc(yyss, newsize * sizeof *newss) :
      (short *)malloc(newsize * sizeof *newss);
    if (newss == NULL)
        return -1;
    yyss = newss;
    yyssp = newss + i;
    newvs = yyvs ? (YYSTYPE *)realloc(yyvs, newsize * sizeof *newvs) :
      (YYSTYPE *)malloc(newsize * sizeof *newvs);
    if (newvs == NULL)
        return -1;
    yyvs = newvs;
    yyvsp = newvs + i;
    yystacksize = newsize;
    yysslim = yyss + newsize - 1;
    return 0;
}

#define YYABORT goto yyabort
#define YYREJECT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR goto yyerrlab

#ifndef YYPARSE_PARAM
#if defined(__cplusplus) || __STDC__
#define YYPARSE_PARAM_ARG void
#define YYPARSE_PARAM_DECL
#else	/* ! ANSI-C/C++ */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif	/* ANSI-C/C++ */
#else	/* YYPARSE_PARAM */
#ifndef YYPARSE_PARAM_TYPE
#define YYPARSE_PARAM_TYPE void *
#endif
#if defined(__cplusplus) || __STDC__
#define YYPARSE_PARAM_ARG YYPARSE_PARAM_TYPE YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else	/* ! ANSI-C/C++ */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL YYPARSE_PARAM_TYPE YYPARSE_PARAM;
#endif	/* ANSI-C/C++ */
#endif	/* ! YYPARSE_PARAM */

int
yyparse (YYPARSE_PARAM_ARG)
    YYPARSE_PARAM_DECL
{
    register int yym, yyn, yystate;
#if YYDEBUG
    register const char *yys;

    if ((yys = getenv("YYDEBUG")))
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    yynerrs = 0;
    yyerrflag = 0;
    yychar = (-1);

    if (yyss == NULL && yygrowstack()) goto yyoverflow;
    yyssp = yyss;
    yyvsp = yyvs;
    *yyssp = yystate = 0;

yyloop:
    if ((yyn = yydefred[yystate])) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, reading %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: state %d, shifting to state %d\n",
                    YYPREFIX, yystate, yytable[yyn]);
#endif
        if (yyssp >= yysslim && yygrowstack())
        {
            goto yyoverflow;
        }
        *++yyssp = yystate = yytable[yyn];
        *++yyvsp = yylval;
        yychar = (-1);
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
#if defined(lint) || defined(__GNUC__)
    goto yynewerror;
#endif
yynewerror:
    yyerror("syntax error");
#if defined(lint) || defined(__GNUC__)
    goto yyerrlab;
#endif
yyerrlab:
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: state %d, error recovery shifting\
 to state %d\n", YYPREFIX, *yyssp, yytable[yyn]);
#endif
                if (yyssp >= yysslim && yygrowstack())
                {
                    goto yyoverflow;
                }
                *++yyssp = yystate = yytable[yyn];
                *++yyvsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: error recovery discarding state %d\n",
                            YYPREFIX, *yyssp);
#endif
                if (yyssp <= yyss) goto yyabort;
                --yyssp;
                --yyvsp;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, error recovery discards token %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
        yychar = (-1);
        goto yyloop;
    }
yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: state %d, reducing by rule %d (%s)\n",
                YYPREFIX, yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    yyval = yyvsp[1-yym];
    switch (yyn)
    {
case 60:
#line 194 "spice.y"
{
            yyCircuit->add_bjt(yyvsp[-2].sval,yyvsp[-1].av_val);
            DBG1(printf("seen BJT: %s ",yyvsp[-2].sval);
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            free(yyvsp[-2].sval);
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 61:
#line 208 "spice.y"
{
            yyCircuit->add_capacitor(yyvsp[-2].sval,yyvsp[-1].av_val);
            DBG1(printf("seen CAPACITOR: %s ",yyvsp[-2].sval);
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            free(yyvsp[-2].sval);
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 62:
#line 222 "spice.y"
{
            yyCircuit->add_diode(yyvsp[-2].sval,yyvsp[-1].av_val);
            DBG1(printf("seen DIODE: %s ",yyvsp[-2].sval);
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            free(yyvsp[-2].sval);
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 63:
#line 236 "spice.y"
{
            yyCircuit->add_inductor(yyvsp[-2].sval,yyvsp[-1].av_val);
            DBG1(printf("seen INDUCTOR: %s ",yyvsp[-2].sval);
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            free(yyvsp[-2].sval);
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 64:
#line 249 "spice.y"
{
            yyCircuit->add_coupling(yyvsp[-2].sval,yyvsp[-1].av_val);
            DBG1(printf("seen COUPLING: %s ",yyvsp[-2].sval);
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            free(yyvsp[-2].sval);
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 65:
#line 263 "spice.y"
{
            yyCircuit->add_isource(yyvsp[-2].sval,yyvsp[-1].av_val);
            DBG1(printf("seen ISOURCE: %s ",yyvsp[-2].sval);
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            free(yyvsp[-2].sval);
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 66:
#line 277 "spice.y"
{
            yyCircuit->add_jfet(yyvsp[-2].sval,yyvsp[-1].av_val);
            DBG1(printf("seen JFET: %s ",yyvsp[-2].sval);
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            free(yyvsp[-2].sval);
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 67:
#line 291 "spice.y"
{
            yyCircuit->add_mosfet(yyvsp[-2].sval,yyvsp[-1].av_val);
            DBG1(printf("seen MOSFET: %s ",yyvsp[-2].sval);
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)
            
            /* delete the arguments */
            free(yyvsp[-2].sval);
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 68:
#line 305 "spice.y"
{
            yyCircuit->add_resistor(yyvsp[-2].sval,yyvsp[-1].av_val);
            DBG1(printf("seen RESISTOR: %s ",yyvsp[-2].sval);
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            free(yyvsp[-2].sval);
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 69:
#line 319 "spice.y"
{
            yyCircuit->add_subcktinst(yyvsp[-2].sval,yyvsp[-1].av_val);
            DBG1(printf("seen SUBCKTINST: %s ",yyvsp[-2].sval);
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            free(yyvsp[-2].sval);
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 70:
#line 333 "spice.y"
{
            yyCircuit->add_vsource(yyvsp[-2].sval,yyvsp[-1].av_val);
            DBG1(printf("seen VSOURCE: %s ",yyvsp[-2].sval);
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            free(yyvsp[-2].sval);
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 71:
#line 352 "spice.y"
{
            yyCircuit->begin_subckt(yyvsp[-1].av_val);
            DBG1(printf("seen SUBCKT: ");
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 72:
#line 370 "spice.y"
{
            /* unimplemented */
            DBG1(printf("seen .ALTER\n");)
        }
break;
case 73:
#line 376 "spice.y"
{
            /* unimplemented */
            DBG1(printf("seen .CONTROL: ");
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 74:
#line 389 "spice.y"
{
            /* unimplemented */
            DBG1(printf("seen .DATA: ");
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 75:
#line 402 "spice.y"
{
            /* unimplemented */
            DBG1(printf("seen .DCVOLT: ");
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 76:
#line 415 "spice.y"
{
            /* unimplemented */
            DBG1(printf("seen .DELLIB: ");
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 77:
#line 428 "spice.y"
{
            /* unimplemented */
            DBG1(printf("seen .END: ");
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 78:
#line 440 "spice.y"
{
            /* unimplemented */
            DBG1(printf("seen .END\n");)
        }
break;
case 79:
#line 446 "spice.y"
{
            /* unimplemented */
            DBG1(printf("seen .ENDL: ");
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 80:
#line 459 "spice.y"
{
            yyCircuit->end_subckt(yyvsp[-1].aval);
            DBG1(printf("seen .ENDS\n");)

            /* delete the arguments */
            delete yyvsp[-1].aval;
        }
break;
case 81:
#line 468 "spice.y"
{
            /* unimplemented */
            DBG1(printf("seen .GLOBAL: ");
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 82:
#line 481 "spice.y"
{
            /* unimplemented */
            DBG1(printf("seen .ICVOLT: ");
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 83:
#line 494 "spice.y"
{
            /* unimplemented */
            DBG1(printf("seen .LIB: ");
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 84:
#line 507 "spice.y"
{
            yyCircuit->add_model(yyvsp[-2].aval,yyvsp[-1].aval,NULL);
            DBG1(printf("seen .MODEL: ");
            yyvsp[-2].aval->dump(cout); cout<<" "; yyvsp[-1].aval->dump(cout); cout<<" ";);
            
            /* delete the arguments */
            delete yyvsp[-2].aval;
            delete yyvsp[-1].aval;
        }
break;
case 85:
#line 517 "spice.y"
{
            yyCircuit->add_model(yyvsp[-3].aval,yyvsp[-2].aval,yyvsp[-1].av_val);
            DBG1(printf("seen .MODEL: ");
            yyvsp[-3].aval->dump(cout); cout<<" "; yyvsp[-2].aval->dump(cout); cout<<" ";
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            delete yyvsp[-3].aval;
            delete yyvsp[-2].aval;
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 86:
#line 532 "spice.y"
{
            yyCircuit->add_model(yyvsp[-5].aval,yyvsp[-4].aval,yyvsp[-2].av_val);
            DBG1(printf("seen .MODEL: ");
            yyvsp[-5].aval->dump(cout); cout<<" "; yyvsp[-4].aval->dump(cout); cout<<" ";
            cout<<"(";
            for_each(yyvsp[-2].av_val->begin(), yyvsp[-2].av_val->end(), G_dump<Argument *>(cout));
            cout<<")";
            cout<<endl;)
            
            /* delete the arguments */
            delete yyvsp[-5].aval;
            delete yyvsp[-4].aval;
            for(int i=0; i<yyvsp[-2].av_val->size(); i++)
                delete (*yyvsp[-2].av_val)[i];
            delete yyvsp[-2].av_val;
        }
break;
case 87:
#line 550 "spice.y"
{
            /* unimplemented */
            DBG1(printf("seen .NODESET: ");
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 88:
#line 563 "spice.y"
{
            /* unimplemented */
            DBG1(printf("seen .OPTIONS: ");
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 89:
#line 576 "spice.y"
{
            /* unimplemented */
            DBG1(printf("seen .PARAM: ");
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 90:
#line 589 "spice.y"
{
            /* unimplemented */
            DBG1(printf("seen .PC: ");
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 91:
#line 602 "spice.y"
{
            /* unimplemented */
            DBG1(printf("seen .PROTECT\n");)
        }
break;
case 92:
#line 608 "spice.y"
{
            /* unimplemented */
            DBG1(printf("seen .SYSTEM: ");
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 93:
#line 621 "spice.y"
{
            /* unimplemented */
            DBG1(printf("seen .UNPROTECT\n");)
        }
break;
case 94:
#line 627 "spice.y"
{
            /* unimplemented */
            DBG1(printf("seen .WIDTH: ");
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 95:
#line 645 "spice.y"
{
            /* unimplemented */
            DBG1(printf("seen .ACSWEEP: ");
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 96:
#line 658 "spice.y"
{
            /* unimplemented */
            DBG1(printf("seen .DCSWEEP: ");
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 97:
#line 671 "spice.y"
{
            /* unimplemented */
            DBG1(printf("seen .FOURIER: ");
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 98:
#line 684 "spice.y"
{
            /* unimplemented */
            DBG1(printf("seen .NET: ");
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 99:
#line 697 "spice.y"
{
            /* unimplemented */
            DBG1(printf("seen .DISTORTION: ");
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 100:
#line 710 "spice.y"
{
            /* unimplemented */
            DBG1(printf("seen .NOISE: ");
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 101:
#line 723 "spice.y"
{
            /* unimplemented */
            DBG1(printf("seen .OPPOINT: ");
            cout<<endl;)
        }
break;
case 102:
#line 729 "spice.y"
{
            /* unimplemented */
            DBG1(printf("seen .OPPOINT: ");
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 103:
#line 742 "spice.y"
{
            /* unimplemented */
            DBG1(printf("seen .POLEZERO: ");
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 104:
#line 755 "spice.y"
{
            /* unimplemented */
            DBG1(printf("seen .SAMPLE: ");
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 105:
#line 768 "spice.y"
{
            /* unimplemented */
            DBG1(printf("seen .SENSE: ");
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 106:
#line 781 "spice.y"
{
            /* unimplemented */
            DBG1(printf("seen .TEMP: ");
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 107:
#line 794 "spice.y"
{
            /* unimplemented */
            DBG1(printf("seen .TRANSFER: ");
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 108:
#line 807 "spice.y"
{
            /* unimplemented */
            DBG1(printf("seen .TRAN: ");
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 109:
#line 825 "spice.y"
{
            /* unimplemented */
            DBG1(printf("seen .MEASURE: ");
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 110:
#line 838 "spice.y"
{
            /* unimplemented */
            DBG1(printf("seen .GRAPH: ");
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 111:
#line 851 "spice.y"
{
            /* unimplemented */
            DBG1(printf("seen .plot: ");
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 112:
#line 864 "spice.y"
{
            /* unimplemented */
            DBG1(printf("seen .PRINT: ");
            for_each(yyvsp[-1].av_val->begin(), yyvsp[-1].av_val->end(), G_dump<Argument *>(cout));
            cout<<endl;)

            /* delete the arguments */
            for(int i=0; i<yyvsp[-1].av_val->size(); i++)
                delete (*yyvsp[-1].av_val)[i];
            delete yyvsp[-1].av_val;
        }
break;
case 113:
#line 882 "spice.y"
{
            /* title */
            yyCircuit->name() = strdup(yyvsp[0].sval);
            DBG1(cout<<"title: "<<yyvsp[0].sval<<endl;)

            /* delete the arguments */
            free(yyvsp[0].sval);
        }
break;
case 114:
#line 892 "spice.y"
{
            /* comment */
            StringArgument *temp = new StringArgument(yyvsp[0].sval);
            yyCircuit->process_comment((StringArgument *)temp);
            DBG1(cout<<endl<<"comment: "; temp->dump(cout); cout<<endl<<endl;);

            /* delete the arguments */
            delete temp;
        }
break;
case 115:
#line 907 "spice.y"
{
            /* argument_list #1 */
            ArgumentVec *the_list = new ArgumentVec;
            the_list->push_back(yyvsp[0].aval);
            yyval.av_val = the_list;
        }
break;
case 116:
#line 914 "spice.y"
{
            /* argument_list #2 */
            yyvsp[-1].av_val->push_back(yyvsp[0].aval);
        }
break;
case 117:
#line 921 "spice.y"
{
            /* simple_argument_list #1 */
            ArgumentVec *the_list = new ArgumentVec;
            the_list->push_back(yyvsp[0].aval);
            yyval.av_val = the_list;
        }
break;
case 118:
#line 928 "spice.y"
{
            /* simple_argument_list #2 */
            yyvsp[-1].av_val->push_back(yyvsp[0].aval);
        }
break;
case 119:
#line 933 "spice.y"
{
            /* simple_argument_list #3 */
            yyvsp[-2].av_val->push_back(yyvsp[0].aval);
        }
break;
case 120:
#line 940 "spice.y"
{
            /* parameter_list #1 */
            ArgumentVec *the_list = new ArgumentVec;
            the_list->push_back(yyvsp[0].aval);
            yyval.av_val = the_list;
        }
break;
case 121:
#line 947 "spice.y"
{
            /* parameter_list #2 */
            yyvsp[-1].av_val->push_back(yyvsp[0].aval);
        }
break;
case 122:
#line 954 "spice.y"
{
            /* argument #1 */
            yyval.aval = yyvsp[0].aval;
        }
break;
case 123:
#line 959 "spice.y"
{
            /* argument #2 */
            yyval.aval = yyvsp[0].aval;
        }
break;
case 124:
#line 966 "spice.y"
{
            /* simple_arg #1 */
            yyval.aval = new StringArgument(yyvsp[0].sval);
        }
break;
case 125:
#line 971 "spice.y"
{
            /* simple_arg #2 */
            double num = atof(yyvsp[-1].sval);
            num = adjust_number(num,yyvsp[0].sval);
            yyval.aval = new DoubleArgument(num);
            free (yyvsp[-1].sval);
            free (yyvsp[0].sval);
        }
break;
case 126:
#line 980 "spice.y"
{
            /* simple_arg #3 */
            int num = atoi(yyvsp[0].sval);
            yyval.aval = new IntegerArgument(num);
            free (yyvsp[0].sval);
        }
break;
case 127:
#line 987 "spice.y"
{
            /* simple_arg #4 */
            int num = atoi(yyvsp[-1].sval);
            yyval.aval = new IntegerArgument(num);
            free (yyvsp[-1].sval);
        }
break;
case 128:
#line 994 "spice.y"
{
            /* simple_arg #5 */
            double num = atof(yyvsp[-1].sval);
            num = adjust_number(num,yyvsp[0].sval);
            yyval.aval = new DoubleArgument(num);
            free (yyvsp[-1].sval);
            free (yyvsp[0].sval);
        }
break;
case 129:
#line 1003 "spice.y"
{
            /* simple_arg #6 */
            double num = atof(yyvsp[0].sval);
            yyval.aval = new DoubleArgument(num);
            free (yyvsp[0].sval);
        }
break;
case 130:
#line 1010 "spice.y"
{ 
            /* simple_arg #7 */
            double num = atof(yyvsp[0].sval);
            yyval.aval = new DoubleArgument(num);
            free (yyvsp[0].sval);
        }
break;
case 131:
#line 1017 "spice.y"
{
            /* simple_arg #8 */
            yyval.aval = yyvsp[0].aval;
        }
break;
case 132:
#line 1024 "spice.y"
{
            /* complex_arg #1 */
            yyval.aval = yyvsp[0].aval;
        }
break;
case 133:
#line 1029 "spice.y"
{
            /* complex_arg #2 */
            yyval.aval = yyvsp[0].aval;
        }
break;
case 134:
#line 1034 "spice.y"
{
            /* complex_arg #3 */
            yyval.aval = yyvsp[0].aval;
        }
break;
case 135:
#line 1041 "spice.y"
{
            /* function */
            yyval.aval = new FunctionArgument(yyvsp[-3].sval,yyvsp[-1].av_val);
        }
break;
case 136:
#line 1048 "spice.y"
{
            /* parameter */
            yyval.aval = new ParameterArgument(yyvsp[-2].sval,yyvsp[0].av_val);
        }
break;
case 137:
#line 1055 "spice.y"
{
            /* node_assignment */
            yyval.aval = new NodeAssignmentArgument(yyvsp[-2].aval,yyvsp[0].av_val);
        }
break;
case 138:
#line 1062 "spice.y"
{
            /* quoted_string */
            yyval.aval = new StringArgument(yyvsp[-1].sval);
        }
break;
case 139:
#line 1068 "spice.y"
{
            /* param_list #1 */
            ArgumentVec *the_list = new ArgumentVec;
            the_list->push_back(yyvsp[0].aval);
            yyval.av_val = the_list;
        }
break;
case 140:
#line 1075 "spice.y"
{
            /* param_list #2 */
            yyvsp[-2].av_val->push_back(yyvsp[0].aval);
        }
break;
case 141:
#line 1081 "spice.y"
{yyval.aval = yyvsp[0].aval;}
break;
case 142:
#line 1085 "spice.y"
{
            /* ends_arg #1 */
            yyval.aval = NULL;
            DBG1(printf("Ending current subckt definition\n");)
        }
break;
case 143:
#line 1091 "spice.y"
{
            /* ends_arg #2 */
            yyval.aval = new StringArgument(yyvsp[0].sval);
            DBG1(printf("Ending subckt %s definition\n",yyvsp[0].sval);)
        }
break;
#line 1884 "y.tab.c"
    }
    yyssp -= yym;
    yystate = *yyssp;
    yyvsp -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: after reduction, shifting from state 0 to\
 state %d\n", YYPREFIX, YYFINAL);
#endif
        yystate = YYFINAL;
        *++yyssp = YYFINAL;
        *++yyvsp = yyval;
        if (yychar < 0)
        {
            if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("%sdebug: state %d, reading %d (%s)\n",
                        YYPREFIX, YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: after reduction, shifting from state %d \
to state %d\n", YYPREFIX, *yyssp, yystate);
#endif
    if (yyssp >= yysslim && yygrowstack())
    {
        goto yyoverflow;
    }
    *++yyssp = yystate;
    *++yyvsp = yyval;
    goto yyloop;
yyoverflow:
    yyerror("yacc stack overflow");
yyabort:
    return (1);
yyaccept:
    return (0);
}
