//-----------------------------------------------------------------------------
// COPYRIGHT  (c)  1997 
// THE REGENTS OF THE UNIVERSITY OF MICHIGAN
// ALL RIGHTS RESERVED
// 
// PERMISSION IS GRANTED TO USE, COPY, CREATE DERIVATIVE WORKS 
// AND REDISTRIBUTE THIS SOFTWARE AND SUCH DERIVATIVE WORKS FOR 
// ANY PURPOSE, SO LONG AS NO FEE IS CHARGED, AND SO LONG AS 
// THE COPYRIGHT NOTICE ABOVE, THIS GRANT OF PERMISSION, AND 
// THE DISCLAIMER BELOW APPEAR IN ALL COPIES MADE; AND SO LONG 
// AS THE NAME OF THE UNIVERSITY OF MICHIGAN IS NOT USED IN ANY 
// ADVERTISING OR PUBLICITY PERTAINING TO THE USE OR 
// DISTRIBUTION OF THIS SOFTWARE WITHOUT SPECIFIC, WRITTEN 
// PRIOR AUTHORIZATION.
// 
// THIS SOFTWARE IS PROVIDED AS IS, WITHOUT REPRESENTATION 
// FROM THE UNIVERSITY OF MICHIGAN AS TO ITS FITNESS 
// FOR ANY PURPOSE, AND WITHOUT WARRANTY BY THE 
// UNIVERSITY OF MICHIGAN OF ANY KIND, EITHER EXPRESS OR 
// IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES 
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE 
// REGENTS OF THE UNIVERSITY OF MICHIGAN SHALL NOT BE LIABLE 
// FOR ANY DAMAGES, INCLUDING SPECIAL, INDIRECT, INCIDENTAL, OR 
// CONSEQUENTIAL DAMAGES, WITH RESPECT TO ANY CLAIM ARISING OUT 
// HAS BEEN OR IS HEREAFTER ADVISED OF THE POSSIBILITY OF SUCH 
// DAMAGES.
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// File: appCmds.hh
//
// Purpose: Handles command line arguments for configuring the application
//
// Remarks: None.
//
// History: 06/21/95 - JPMS - created.
//          03/16/96 - JPMS - repackaged for new version.
//          12/06/96 - MAR - made _mode protected to enable derived classes
//          03/18/97 - MAR - modified for use in cellsyn
//
// RCS Version:
//     $Id: appCmds.hh,v 1.1.1.1 2002/05/01 14:23:27 mguthaus Exp $
//-----------------------------------------------------------------------------

#ifndef __APPCMDS
#define __APPCMDS

#include "cmdArg.hh"
#include "cmdLine.hh"

#include "appMode.hh"    // Only needs to be aware of the configuration modes


//-----------------------------------------------------------------------------
// Class: appCmds
//
// Purpose: Parser for command line options for batch execution.
//-----------------------------------------------------------------------------

class appCmds {
  public:

    //-------------------------------------------------------------------------
    // Constructor/destructor.
    //-------------------------------------------------------------------------
    
    appCmds (appMode &nmode);
    virtual ~appCmds();

    //-------------------------------------------------------------------------
    // Interface methods.
    //-------------------------------------------------------------------------

    virtual char *cmdLineParse (int argc, char *argv[]);

  protected:

    //-------------------------------------------------------------------------
    // Protected methods for configuring some options of GRASP.
    //-------------------------------------------------------------------------

    virtual int handlePlusOption (cmdArg &cmd);
    virtual int handleMinusOption (cmdArg &cmd);

    virtual void check_modes();
    virtual void help (ostream &outs);

    //-------------------------------------------------------------------------
    // Data structures for configuring the search engine.
    //-------------------------------------------------------------------------

    appMode &_mode;

  private:

};

#endif

/*****************************************************************************/
