//-----------------------------------------------------------------------------
// COPYRIGHT  (c)  1997 
// THE REGENTS OF THE UNIVERSITY OF MICHIGAN
// ALL RIGHTS RESERVED
// 
// PERMISSION IS GRANTED TO USE, COPY, CREATE DERIVATIVE WORKS 
// AND REDISTRIBUTE THIS SOFTWARE AND SUCH DERIVATIVE WORKS FOR 
// ANY PURPOSE, SO LONG AS NO FEE IS CHARGED, AND SO LONG AS 
// THE COPYRIGHT NOTICE ABOVE, THIS GRANT OF PERMISSION, AND 
// THE DISCLAIMER BELOW APPEAR IN ALL COPIES MADE; AND SO LONG 
// AS THE NAME OF THE UNIVERSITY OF MICHIGAN IS NOT USED IN ANY 
// ADVERTISING OR PUBLICITY PERTAINING TO THE USE OR 
// DISTRIBUTION OF THIS SOFTWARE WITHOUT SPECIFIC, WRITTEN 
// PRIOR AUTHORIZATION.
// 
// THIS SOFTWARE IS PROVIDED AS IS, WITHOUT REPRESENTATION 
// FROM THE UNIVERSITY OF MICHIGAN AS TO ITS FITNESS 
// FOR ANY PURPOSE, AND WITHOUT WARRANTY BY THE 
// UNIVERSITY OF MICHIGAN OF ANY KIND, EITHER EXPRESS OR 
// IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES 
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE 
// REGENTS OF THE UNIVERSITY OF MICHIGAN SHALL NOT BE LIABLE 
// FOR ANY DAMAGES, INCLUDING SPECIAL, INDIRECT, INCIDENTAL, OR 
// CONSEQUENTIAL DAMAGES, WITH RESPECT TO ANY CLAIM ARISING OUT 
// HAS BEEN OR IS HEREAFTER ADVISED OF THE POSSIBILITY OF SUCH 
// DAMAGES.
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// File: appMode.cc
//
// Purpose: Member functions of class appMode. Used for identifying default
//          mode options.
//
// Remarks: --
//
// History: 03/15/96 - JPMS - created.
//          03/18/97 - MAR - modified for use in cellsyn
//
// Copyright (c) 1996 Joao P. Marques Silva.
//
// RCS Version:
//     $Id: appMode.cc,v 1.1.1.1 2002/05/01 14:23:27 mguthaus Exp $
//-----------------------------------------------------------------------------

#include <stdio.h>
#include <stdlib.h>
#include <stream.h>
#include <values.h>

#include "defs.hh"
#include "utils.hh"
#include "appMode.hh"

//-----------------------------------------------------------------------------
// Constructor/destructor.
//-----------------------------------------------------------------------------
    
appMode::appMode() : _mode(APP_OPTION_NUMBER) {
}

appMode::~appMode() {
    while (!_defined_modes.empty()) {
        delete _defined_modes.front();
        _defined_modes.pop_front();
    }
}

//-----------------------------------------------------------------------------
// Function: setup()
//
// Purpose: 
//
// Side-effects: Internal structures are resized.
//
// Notes: This is necessary since it's the only way to overload the
//        function call. At construction time it was not possible.
//-----------------------------------------------------------------------------

void appMode::setup() {
    init_mode();
}


//-----------------------------------------------------------------------------
// Function: int_mode()
//
// Purpose: Return the mode stored at index 'idx' as an integer.  Does
//          run-time type checking to make sure that mode is in fact
//          an integer mode.
//
// Side-effects:
//
//-----------------------------------------------------------------------------

const int appMode::int_mode(const int idx) {
    if (! ((ModeStr*)_mode[idx])->is_a(ModeVal::_MODEINT_))
        Abort("appMode::int_mode() attempt to cast non-int mode to an integer");
    return ((ModeInt*)_mode[idx])->data();
}

//-----------------------------------------------------------------------------
// Function: float_mode()
//
// Purpose: Return the mode stored at index 'idx' as a double float.  Does
//          run-time type checking to make sure that mode is in fact
//          a float mode.
//
// Side-effects:
//
//-----------------------------------------------------------------------------

const double appMode::float_mode(const int idx) {
    if (! ((ModeStr*)_mode[idx])->is_a(ModeVal::_MODEFLOAT_))
        Abort("appMode::float_mode() attempt to cast non-float mode to an integer");
    return ((ModeFloat*)_mode[idx])->data();
}

//-----------------------------------------------------------------------------
// Function: str_mode()
//
// Purpose: Return the mode stored at index 'idx' as a string.  Does
//          run-time type checking to make sure that mode is in fact
//          a string mode.
//
// Side-effects:
//
//-----------------------------------------------------------------------------

const char *appMode::str_mode(const int idx) {
    if (! ((ModeStr*)_mode[idx])->is_a(ModeVal::_MODESTR_))
        Abort("appMode::str_mode() attempt to cast non-str mode to a string");
    return ((ModeStr*)_mode[idx])->data();
}

//-----------------------------------------------------------------------------
// Function: init_mode()
//
// Purpose: Specifies default values.
//-----------------------------------------------------------------------------

void appMode::init_mode()                             // Default configuration
{
    DBGn(cout<<"Initializing with mode array of size "<<_mode.size()<<endl;);
    _mode[_HELP_] = new_int_mode(FALSE);
    _mode[_DEBUG_] = new_int_mode(0);
    _mode[_VERBOSE_] = new_int_mode(0);
}

/*****************************************************************************/
